/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.spark;

import java.util.Arrays;
import java.util.List;
import net.hydromatic.linq4j.Enumerable;
import net.hydromatic.linq4j.Linq4j;
import net.hydromatic.linq4j.function.Function;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.impl.spark.SparkHandlerImpl;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SparkRuntime {
    private SparkRuntime() {
    }

    public static <T> JavaRDD<T> createRdd(JavaSparkContext sc, T[] ts) {
        List<T> list = Arrays.asList(ts);
        return sc.parallelize(list);
    }

    public static <T> JavaRDD<T> createRdd(JavaSparkContext sc, Enumerable<T> enumerable) {
        List list = enumerable.toList();
        return sc.parallelize(list);
    }

    public static <T> Enumerable<T> asEnumerable(JavaRDD<T> rdd) {
        return Linq4j.asEnumerable((List)rdd.collect());
    }

    public static JavaSparkContext getSparkContext(DataContext root) {
        return (JavaSparkContext)SparkHandlerImpl.instance().sparkContext();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class OptiqFlatMapFunction<T, R>
    extends FlatMapFunction<T, R>
    implements Function {
    }
}

