/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.mongodb;

import java.util.ArrayList;
import java.util.List;
import net.hydromatic.optiq.impl.mongodb.MongoRel;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelFieldCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.SortRel;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.util.Util;

public class MongoSortRel
extends SortRel
implements MongoRel {
    public MongoSortRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RelCollation collation, RexNode offset, RexNode fetch) {
        super(cluster, traitSet, child, collation, offset, fetch);
        assert (this.getConvention() == MongoRel.CONVENTION);
        assert (this.getConvention() == child.getConvention());
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        return super.computeSelfCost(planner).multiplyBy(0.05);
    }

    public SortRel copy(RelTraitSet traitSet, RelNode input, RelCollation newCollation, RexNode offset, RexNode fetch) {
        return new MongoSortRel(this.getCluster(), traitSet, input, this.collation, offset, fetch);
    }

    public void implement(MongoRel.Implementor implementor) {
        implementor.visitChild(0, this.getChild());
        if (!this.collation.getFieldCollations().isEmpty()) {
            ArrayList<String> keys = new ArrayList<String>();
            List fields = this.getRowType().getFieldList();
            for (RelFieldCollation fieldCollation : this.collation.getFieldCollations()) {
                String name = ((RelDataTypeField)fields.get(fieldCollation.getFieldIndex())).getName();
                keys.add(name + ": " + this.direction(fieldCollation));
            }
            implementor.add(null, "{$sort: " + Util.toString(keys, (String)"{", (String)", ", (String)"}") + "}");
        }
        if (this.offset != null) {
            implementor.add(null, "{$skip: " + ((RexLiteral)this.offset).getValue() + "}");
        }
        if (this.fetch != null) {
            implementor.add(null, "{$limit: " + ((RexLiteral)this.fetch).getValue() + "}");
        }
    }

    private int direction(RelFieldCollation fieldCollation) {
        switch (fieldCollation.getDirection()) {
            case DESCENDING: 
            case STRICTLY_DESCENDING: {
                return -1;
            }
        }
        return 1;
    }
}

