/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.mongodb;

import java.util.ArrayList;
import java.util.List;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.impl.mongodb.MongoRel;
import net.hydromatic.optiq.impl.mongodb.MongoRules;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexVisitor;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoProjectRel
extends ProjectRelBase
implements MongoRel {
    public MongoProjectRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, List<RexNode> exps, RelDataType rowType, int flags) {
        super(cluster, traitSet, child, exps, rowType, flags);
        assert (this.getConvention() == MongoRel.CONVENTION);
        assert (this.getConvention() == child.getConvention());
    }

    public ProjectRelBase copy(RelTraitSet traitSet, RelNode input, List<RexNode> exps, RelDataType rowType) {
        return new MongoProjectRel(this.getCluster(), traitSet, input, exps, rowType, this.flags);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        return super.computeSelfCost(planner).multiplyBy(0.1);
    }

    @Override
    public void implement(MongoRel.Implementor implementor) {
        implementor.visitChild(0, this.getChild());
        MongoRules.RexToMongoTranslator translator = new MongoRules.RexToMongoTranslator((JavaTypeFactory)this.getCluster().getTypeFactory(), MongoRules.mongoFieldNames(this.getChild().getRowType()));
        ArrayList<String> items = new ArrayList<String>();
        for (Pair pair : this.getNamedProjects()) {
            String name = (String)pair.right;
            String expr = (String)((RexNode)pair.left).accept((RexVisitor)translator);
            items.add(expr.equals("'$" + name + "'") ? MongoRules.maybeQuote(name) + ": 1" : MongoRules.maybeQuote(name) + ": " + expr);
        }
        String findString = Util.toString(items, (String)"{", (String)", ", (String)"}");
        String aggregateString = "{$project: " + findString + "}";
        Pair op = Pair.of((Object)findString, (Object)aggregateString);
        implementor.add((String)op.left, (String)op.right);
    }
}

