/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.mongodb;

import com.google.common.collect.ImmutableList;
import com.mongodb.AggregationOutput;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.hydromatic.linq4j.AbstractEnumerable;
import net.hydromatic.linq4j.Enumerable;
import net.hydromatic.linq4j.Enumerator;
import net.hydromatic.linq4j.QueryProvider;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.optiq.QueryableTable;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.TranslatableTable;
import net.hydromatic.optiq.impl.AbstractTableQueryable;
import net.hydromatic.optiq.impl.java.AbstractQueryableTable;
import net.hydromatic.optiq.impl.mongodb.MongoEnumerator;
import net.hydromatic.optiq.impl.mongodb.MongoRel;
import net.hydromatic.optiq.impl.mongodb.MongoSchema;
import net.hydromatic.optiq.impl.mongodb.MongoTableScan;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelTrait;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoTable
extends AbstractQueryableTable
implements TranslatableTable {
    protected final String collectionName;

    MongoTable(String collectionName) {
        super(Object[].class);
        this.collectionName = collectionName;
    }

    public String toString() {
        return "MongoTable {" + this.collectionName + "}";
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        RelDataType mapType = typeFactory.createMapType(typeFactory.createSqlType(SqlTypeName.VARCHAR), typeFactory.createSqlType(SqlTypeName.ANY));
        return typeFactory.builder().add("_MAP", mapType).build();
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new MongoQueryable(queryProvider, schema, this, tableName);
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        return new MongoTableScan(context.getCluster(), context.getCluster().traitSetOf(new RelTrait[]{MongoRel.CONVENTION}), relOptTable, this, null, (List<Pair<String, String>>)ImmutableList.of());
    }

    public Enumerable<Object> find(DB mongoDb, String filterJson, String projectJson, List<String> fields) {
        final DBCollection collection = mongoDb.getCollection(this.collectionName);
        final DBObject filter = filterJson == null ? null : (DBObject)JSON.parse((String)filterJson);
        final DBObject project = projectJson == null ? null : (DBObject)JSON.parse((String)projectJson);
        final Function1<DBObject, Object> getter = MongoEnumerator.getter(fields);
        return new AbstractEnumerable<Object>(){

            public Enumerator<Object> enumerator() {
                DBCursor cursor = collection.find(filter, project);
                return new MongoEnumerator((Iterator<DBObject>)cursor, (Function1<DBObject, Object>)getter);
            }
        };
    }

    public Enumerable<Object> aggregate(final DB mongoDb, List<String> fields, final List<String> operations) {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (String operation : operations) {
            list.add((DBObject)JSON.parse((String)operation));
        }
        final DBObject first = (DBObject)list.get(0);
        final List rest = Util.skip(list);
        final Function1<DBObject, Object> getter = MongoEnumerator.getter(fields);
        return new AbstractEnumerable<Object>(){

            public Enumerator<Object> enumerator() {
                AggregationOutput result;
                try {
                    result = mongoDb.getCollection(MongoTable.this.collectionName).aggregate(first, rest.toArray(new DBObject[rest.size()]));
                }
                catch (Exception e) {
                    throw new RuntimeException("While running MongoDB query " + Util.toString((Iterable)operations, (String)"[", (String)",\n", (String)"]"), e);
                }
                return new MongoEnumerator(result.results().iterator(), (Function1<DBObject, Object>)getter);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MongoQueryable<T>
    extends AbstractTableQueryable<T> {
        public MongoQueryable(QueryProvider queryProvider, SchemaPlus schema, MongoTable table, String tableName) {
            super(queryProvider, schema, (QueryableTable)table, tableName);
        }

        public Enumerator<T> enumerator() {
            Enumerable<Object> enumerable = this.getTable().find(this.getMongoDb(), null, null, null);
            return enumerable.enumerator();
        }

        private DB getMongoDb() {
            return ((MongoSchema)((Object)this.schema.unwrap(MongoSchema.class))).mongoDb;
        }

        private MongoTable getTable() {
            return (MongoTable)this.table;
        }

        public Enumerable<Object> aggregate(List<String> fields, List<String> operations) {
            return this.getTable().aggregate(this.getMongoDb(), fields, operations);
        }

        public Enumerable<Object> find(String filterJson, String projectJson, List<String> fields) {
            return this.getTable().find(this.getMongoDb(), filterJson, projectJson, fields);
        }
    }
}

