/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.mongodb;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import net.hydromatic.optiq.impl.mongodb.MongoRel;
import net.hydromatic.optiq.impl.mongodb.MongoRules;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.AggregateRelBase;
import org.eigenbase.rel.Aggregation;
import org.eigenbase.rel.InvalidRelException;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.fun.SqlSumAggFunction;
import org.eigenbase.sql.fun.SqlSumEmptyIsZeroAggFunction;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoAggregateRel
extends AggregateRelBase
implements MongoRel {
    public MongoAggregateRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, BitSet groupSet, List<AggregateCall> aggCalls) throws InvalidRelException {
        super(cluster, traitSet, child, groupSet, aggCalls);
        assert (this.getConvention() == MongoRel.CONVENTION);
        assert (this.getConvention() == child.getConvention());
        for (AggregateCall aggCall : aggCalls) {
            if (!aggCall.isDistinct()) continue;
            throw new InvalidRelException("distinct aggregation not supported");
        }
    }

    public AggregateRelBase copy(RelTraitSet traitSet, RelNode input, BitSet groupSet, List<AggregateCall> aggCalls) {
        try {
            return new MongoAggregateRel(this.getCluster(), traitSet, input, groupSet, aggCalls);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void implement(MongoRel.Implementor implementor) {
        AbstractList fixups;
        int group;
        Iterator<Object> i$;
        implementor.visitChild(0, this.getChild());
        ArrayList<String> list = new ArrayList<String>();
        List<String> inNames = MongoRules.mongoFieldNames(this.getChild().getRowType());
        final List<String> outNames = MongoRules.mongoFieldNames(this.getRowType());
        int i = 0;
        if (this.groupSet.cardinality() == 1) {
            String inName = inNames.get((Integer)BitSets.toList((BitSet)this.groupSet).get(0));
            list.add("_id: " + MongoRules.maybeQuote("$" + inName));
            ++i;
        } else {
            ArrayList<String> keys = new ArrayList<String>();
            i$ = BitSets.toIter((BitSet)this.groupSet).iterator();
            while (i$.hasNext()) {
                group = (Integer)i$.next();
                String inName = inNames.get(group);
                keys.add(inName + ": " + MongoRules.quote("$" + inName));
                ++i;
            }
            list.add("_id: " + Util.toString(keys, (String)"{", (String)", ", (String)"}"));
        }
        for (AggregateCall aggCall : this.aggCalls) {
            list.add(MongoRules.maybeQuote(outNames.get(i++)) + ": " + this.toMongo(aggCall.getAggregation(), inNames, aggCall.getArgList()));
        }
        implementor.add(null, "{$group: " + Util.toString(list, (String)"{", (String)", ", (String)"}") + "}");
        if (this.groupSet.cardinality() == 1) {
            fixups = new AbstractList<String>(){

                @Override
                public String get(int index) {
                    String outName = (String)outNames.get(index);
                    return MongoRules.maybeQuote(outName) + ": " + MongoRules.maybeQuote("$" + (index == 0 ? "_id" : outName));
                }

                @Override
                public int size() {
                    return outNames.size();
                }
            };
        } else {
            fixups = new ArrayList<String>();
            fixups.add("_id: 0");
            i = 0;
            i$ = BitSets.toIter((BitSet)this.groupSet).iterator();
            while (i$.hasNext()) {
                group = (Integer)i$.next();
                fixups.add(MongoRules.maybeQuote(outNames.get(group)) + ": " + MongoRules.maybeQuote("$_id." + outNames.get(group)));
                ++i;
            }
            for (AggregateCall ignored : this.aggCalls) {
                String outName = outNames.get(i++);
                fixups.add(MongoRules.maybeQuote(outName) + ": " + MongoRules.maybeQuote("$" + outName));
            }
        }
        if (!this.groupSet.isEmpty()) {
            implementor.add(null, "{$project: " + Util.toString(fixups, (String)"{", (String)", ", (String)"}") + "}");
        }
    }

    private String toMongo(Aggregation aggregation, List<String> inNames, List<Integer> args) {
        if (aggregation == SqlStdOperatorTable.COUNT) {
            if (args.size() == 0) {
                return "{$sum: 1}";
            }
            assert (args.size() == 1);
            String inName = inNames.get(args.get(0));
            return "{$sum: {$cond: [ {$eq: [" + MongoRules.quote(inName) + ", null]}, 0, 1]}}";
        }
        if (aggregation instanceof SqlSumAggFunction || aggregation instanceof SqlSumEmptyIsZeroAggFunction) {
            assert (args.size() == 1);
            String inName = inNames.get(args.get(0));
            return "{$sum: " + MongoRules.maybeQuote("$" + inName) + "}";
        }
        if (aggregation == SqlStdOperatorTable.MIN) {
            assert (args.size() == 1);
            String inName = inNames.get(args.get(0));
            return "{$min: " + MongoRules.maybeQuote("$" + inName) + "}";
        }
        if (aggregation == SqlStdOperatorTable.MAX) {
            assert (args.size() == 1);
            String inName = inNames.get(args.get(0));
            return "{$max: " + MongoRules.maybeQuote("$" + inName) + "}";
        }
        throw new AssertionError((Object)("unknown aggregate " + aggregation));
    }
}

