/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.mongodb;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.hydromatic.linq4j.Enumerator;
import net.hydromatic.linq4j.function.Function1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MongoEnumerator
implements Enumerator<Object> {
    private final Iterator<DBObject> cursor;
    private final Function1<DBObject, Object> getter;
    private Object current;

    public MongoEnumerator(Iterator<DBObject> cursor, Function1<DBObject, Object> getter) {
        this.cursor = cursor;
        this.getter = getter;
    }

    public Object current() {
        return this.current;
    }

    public boolean moveNext() {
        try {
            if (this.cursor.hasNext()) {
                DBObject map = this.cursor.next();
                this.current = this.getter.apply((Object)map);
                return true;
            }
            this.current = null;
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        if (this.cursor instanceof DBCursor) {
            ((DBCursor)this.cursor).close();
        }
    }

    static Function1<DBObject, Map> mapGetter() {
        return new Function1<DBObject, Map>(){

            public Map apply(DBObject a0) {
                return (Map)a0;
            }
        };
    }

    static Function1<DBObject, Object> singletonGetter(final String field) {
        return new Function1<DBObject, Object>(){

            public Object apply(DBObject a0) {
                return a0.get(field);
            }
        };
    }

    static Function1<DBObject, Object[]> listGetter(final List<String> fields) {
        return new Function1<DBObject, Object[]>(){

            public Object[] apply(DBObject a0) {
                Object[] objects = new Object[fields.size()];
                for (int i = 0; i < fields.size(); ++i) {
                    String s = (String)fields.get(i);
                    objects[i] = a0.get(s);
                }
                return objects;
            }
        };
    }

    static Function1<DBObject, Object> getter(List<String> fields) {
        return fields == null ? MongoEnumerator.mapGetter() : (fields.size() == 1 ? MongoEnumerator.singletonGetter(fields.get(0)) : MongoEnumerator.listGetter(fields));
    }
}

