/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.mongodb;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.List;
import net.hydromatic.linq4j.expressions.BlockBuilder;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.MethodCallExpression;
import net.hydromatic.linq4j.expressions.Statement;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.impl.mongodb.MongoMethod;
import net.hydromatic.optiq.impl.mongodb.MongoRel;
import net.hydromatic.optiq.impl.mongodb.MongoRules;
import net.hydromatic.optiq.impl.mongodb.MongoTable;
import net.hydromatic.optiq.prepare.OptiqPrepareImpl;
import net.hydromatic.optiq.rules.java.EnumerableRel;
import net.hydromatic.optiq.rules.java.EnumerableRelImplementor;
import net.hydromatic.optiq.rules.java.JavaRowFormat;
import net.hydromatic.optiq.rules.java.PhysType;
import net.hydromatic.optiq.rules.java.PhysTypeImpl;
import net.hydromatic.optiq.runtime.Hook;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.convert.ConverterRelImpl;
import org.eigenbase.relopt.ConventionTraitDef;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelTraitDef;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoToEnumerableConverter
extends ConverterRelImpl
implements EnumerableRel {
    protected MongoToEnumerableConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
        super(cluster, (RelTraitDef)ConventionTraitDef.INSTANCE, traits, input);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new MongoToEnumerableConverter(this.getCluster(), traitSet, (RelNode)MongoToEnumerableConverter.sole(inputs));
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        return super.computeSelfCost(planner).multiplyBy(0.1);
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder list = new BlockBuilder();
        MongoRel.Implementor mongoImplementor = new MongoRel.Implementor();
        mongoImplementor.visitChild(0, this.getChild());
        int aggCount = 0;
        int findCount = 0;
        String project = null;
        String filter = null;
        for (Pair<String, String> op : mongoImplementor.list) {
            if (op.left == null) {
                ++aggCount;
            }
            if (((String)op.right).startsWith("{$match:")) {
                filter = (String)op.left;
                ++findCount;
            }
            if (!((String)op.right).startsWith("{$project:")) continue;
            project = (String)op.left;
            ++findCount;
        }
        Expression fields = list.append("fields", (Expression)MongoToEnumerableConverter.constantArrayList(MongoRules.mongoFieldNames(this.getRowType())));
        Expression table = list.append("table", mongoImplementor.table.getExpression(MongoTable.MongoQueryable.class));
        List opList = Pair.right(mongoImplementor.list);
        Expression ops = list.append("ops", (Expression)MongoToEnumerableConverter.constantArrayList(opList));
        Expression enumerable = list.append("enumerable", (Expression)Expressions.call((Expression)table, (Method)MongoMethod.MONGO_QUERYABLE_AGGREGATE.method, (Expression[])new Expression[]{fields, ops}));
        if (OptiqPrepareImpl.DEBUG) {
            System.out.println("Mongo: " + opList);
        }
        Hook.QUERY_PLAN.run((Object)opList);
        list.add((Statement)Expressions.return_(null, (Expression)enumerable));
        PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)this.getRowType(), (JavaRowFormat)pref.prefer(JavaRowFormat.ARRAY));
        return implementor.result(physType, list.toBlock());
    }

    private static <T> MethodCallExpression constantArrayList(List<T> values) {
        return Expressions.call((Method)BuiltinMethod.ARRAYS_AS_LIST.method, (Expression[])new Expression[]{Expressions.newArrayInit(String.class, MongoToEnumerableConverter.constantList(values))});
    }

    private static <T> List<Expression> constantList(List<T> values) {
        return Lists.transform(values, (Function)new Function<T, Expression>(){

            public Expression apply(T a0) {
                return Expressions.constant(a0);
            }
        });
    }
}

