/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.mongodb;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.impl.mongodb.MongoAggregateRel;
import net.hydromatic.optiq.impl.mongodb.MongoFilterRel;
import net.hydromatic.optiq.impl.mongodb.MongoProjectRel;
import net.hydromatic.optiq.impl.mongodb.MongoRel;
import net.hydromatic.optiq.impl.mongodb.MongoSortRel;
import net.hydromatic.optiq.rules.java.RexImpTable;
import net.hydromatic.optiq.rules.java.RexToLixTranslator;
import org.eigenbase.rel.AggregateRel;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.InvalidRelException;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.RelCollationImpl;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.SortRel;
import org.eigenbase.rel.convert.ConverterRule;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelTrait;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexVisitor;
import org.eigenbase.rex.RexVisitorImpl;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.validate.SqlValidatorUtil;
import org.eigenbase.trace.EigenbaseTrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoRules {
    protected static final Logger LOGGER = EigenbaseTrace.getPlannerTracer();
    public static final RelOptRule[] RULES = new RelOptRule[]{MongoSortRule.INSTANCE, MongoFilterRule.access$000(), MongoProjectRule.access$100(), MongoAggregateRule.INSTANCE};

    private MongoRules() {
    }

    static String isItem(RexCall call) {
        if (call.getOperator() != SqlStdOperatorTable.ITEM) {
            return null;
        }
        RexNode op0 = (RexNode)call.operands.get(0);
        RexNode op1 = (RexNode)call.operands.get(1);
        if (op0 instanceof RexInputRef && ((RexInputRef)op0).getIndex() == 0 && op1 instanceof RexLiteral && ((RexLiteral)op1).getValue2() instanceof String) {
            return (String)((RexLiteral)op1).getValue2();
        }
        return null;
    }

    static List<String> mongoFieldNames(final RelDataType rowType) {
        return SqlValidatorUtil.uniquify((List)new AbstractList<String>(){

            @Override
            public String get(int index) {
                String name = ((RelDataTypeField)rowType.getFieldList().get(index)).getName();
                return name.startsWith("$") ? "_" + name.substring(2) : name;
            }

            @Override
            public int size() {
                return rowType.getFieldCount();
            }
        });
    }

    static String maybeQuote(String s) {
        if (!MongoRules.needsQuote(s)) {
            return s;
        }
        return MongoRules.quote(s);
    }

    static String quote(String s) {
        return "'" + s + "'";
    }

    private static boolean needsQuote(String s) {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (Character.isJavaIdentifierPart(c) && c != '$') continue;
            return true;
        }
        return false;
    }

    private static class MongoAggregateRule
    extends MongoConverterRule {
        public static final RelOptRule INSTANCE = new MongoAggregateRule();

        private MongoAggregateRule() {
            super(AggregateRel.class, (RelTrait)Convention.NONE, MongoRel.CONVENTION, "MongoAggregateRule");
        }

        public RelNode convert(RelNode rel) {
            AggregateRel agg = (AggregateRel)rel;
            RelTraitSet traitSet = agg.getTraitSet().replace((RelTrait)this.out);
            try {
                return new MongoAggregateRel(rel.getCluster(), traitSet, MongoAggregateRule.convert((RelNode)agg.getChild(), (RelTraitSet)traitSet), agg.getGroupSet(), agg.getAggCallList());
            }
            catch (InvalidRelException e) {
                LOGGER.warning(e.toString());
                return null;
            }
        }
    }

    private static class MongoProjectRule
    extends MongoConverterRule {
        private static final MongoProjectRule INSTANCE = new MongoProjectRule();

        private MongoProjectRule() {
            super(ProjectRel.class, (RelTrait)Convention.NONE, MongoRel.CONVENTION, "MongoProjectRule");
        }

        public RelNode convert(RelNode rel) {
            ProjectRel project = (ProjectRel)rel;
            RelTraitSet traitSet = project.getTraitSet().replace((RelTrait)this.out);
            return new MongoProjectRel(project.getCluster(), traitSet, MongoProjectRule.convert((RelNode)project.getChild(), (RelTraitSet)traitSet), project.getProjects(), project.getRowType(), 1);
        }

        static /* synthetic */ MongoProjectRule access$100() {
            return INSTANCE;
        }
    }

    private static class MongoFilterRule
    extends MongoConverterRule {
        private static final MongoFilterRule INSTANCE = new MongoFilterRule();

        private MongoFilterRule() {
            super(FilterRel.class, (RelTrait)Convention.NONE, MongoRel.CONVENTION, "MongoFilterRule");
        }

        public RelNode convert(RelNode rel) {
            FilterRel filter = (FilterRel)rel;
            RelTraitSet traitSet = filter.getTraitSet().replace((RelTrait)this.out);
            return new MongoFilterRel(rel.getCluster(), traitSet, MongoFilterRule.convert((RelNode)filter.getChild(), (RelTraitSet)traitSet), filter.getCondition());
        }

        static /* synthetic */ MongoFilterRule access$000() {
            return INSTANCE;
        }
    }

    private static class MongoSortRule
    extends MongoConverterRule {
        public static final MongoSortRule INSTANCE = new MongoSortRule();

        private MongoSortRule() {
            super(SortRel.class, (RelTrait)Convention.NONE, MongoRel.CONVENTION, "MongoSortRule");
        }

        public RelNode convert(RelNode rel) {
            SortRel sort = (SortRel)rel;
            RelTraitSet traitSet = sort.getTraitSet().replace((RelTrait)this.out).replace((RelTrait)sort.getCollation());
            return new MongoSortRel(rel.getCluster(), traitSet, MongoSortRule.convert((RelNode)sort.getChild(), (RelTraitSet)traitSet.replace((RelTrait)RelCollationImpl.EMPTY)), sort.getCollation(), sort.offset, sort.fetch);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class MongoConverterRule
    extends ConverterRule {
        protected final Convention out;

        public MongoConverterRule(Class<? extends RelNode> clazz, RelTrait in, Convention out, String description) {
            super(clazz, in, (RelTrait)out, description);
            this.out = out;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RexToMongoTranslator
    extends RexVisitorImpl<String> {
        private final JavaTypeFactory typeFactory;
        private final List<String> inFields;

        protected RexToMongoTranslator(JavaTypeFactory typeFactory, List<String> inFields) {
            super(true);
            this.typeFactory = typeFactory;
            this.inFields = inFields;
        }

        public String visitLiteral(RexLiteral literal) {
            return "{$ifNull: [null, " + RexToLixTranslator.translateLiteral((RexNode)literal, (RelDataType)literal.getType(), (JavaTypeFactory)this.typeFactory, (RexImpTable.NullAs)RexImpTable.NullAs.NOT_POSSIBLE) + "]}";
        }

        public String visitInputRef(RexInputRef inputRef) {
            return MongoRules.maybeQuote("$" + this.inFields.get(inputRef.getIndex()));
        }

        public String visitCall(RexCall call) {
            RexNode op1;
            String name = MongoRules.isItem(call);
            if (name != null) {
                return "'$" + name + "'";
            }
            List<String> strings = this.visitList((List<RexNode>)call.operands);
            if (call.getKind() == SqlKind.CAST) {
                return strings.get(0);
            }
            if (call.getOperator() == SqlStdOperatorTable.ITEM && (op1 = (RexNode)call.operands.get(1)) instanceof RexLiteral && op1.getType().getSqlTypeName() == SqlTypeName.INTEGER) {
                return "'" + this.stripQuotes(strings.get(0)) + "[" + ((RexLiteral)op1).getValue2() + "]'";
            }
            return (String)super.visitCall(call);
        }

        private String stripQuotes(String s) {
            return s.startsWith("'") && s.endsWith("'") ? s.substring(1, s.length() - 1) : s;
        }

        public List<String> visitList(List<RexNode> list) {
            ArrayList<String> strings = new ArrayList<String>();
            for (RexNode node : list) {
                strings.add((String)node.accept((RexVisitor)this));
            }
            return strings;
        }
    }
}

