/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import net.hydromatic.linq4j.function.Function0;
import net.hydromatic.linq4j.function.Function1;
import org.eigenbase.util.Benchmark;
import org.eigenbase.util.ChunkList;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkListTest {
    @Test
    public void testChunkList() {
        ChunkList list = new ChunkList();
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertTrue((boolean)list.isEmpty());
        Assert.assertEquals((Object)"[]", (Object)list.toString());
        try {
            list.remove(0);
            Assert.fail((String)"expected exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        list.add((Object)7);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)7L, (long)((Integer)list.get(0)).intValue());
        Assert.assertFalse((boolean)list.isEmpty());
        Assert.assertEquals((Object)"[7]", (Object)list.toString());
        list.add((Object)9);
        list.add(null);
        list.add((Object)11);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((long)7L, (long)((Integer)list.get(0)).intValue());
        Assert.assertEquals((long)9L, (long)((Integer)list.get(1)).intValue());
        Assert.assertNull((Object)list.get(2));
        Assert.assertEquals((long)11L, (long)((Integer)list.get(3)).intValue());
        Assert.assertFalse((boolean)list.isEmpty());
        Assert.assertEquals((Object)"[7, 9, null, 11]", (Object)list.toString());
        Assert.assertTrue((boolean)list.contains((Object)9));
        Assert.assertFalse((boolean)list.contains((Object)8));
        list.addAll(Collections.nCopies(40, 1));
        Assert.assertEquals((long)44L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Integer)list.get(40)).intValue());
        int n = 0;
        for (Integer integer : list) {
            Util.discard((Object)integer);
            ++n;
        }
        Assert.assertEquals((long)n, (long)list.size());
        int i = list.indexOf(null);
        Assert.assertEquals((long)2L, (long)i);
        list.set(2, (Object)123);
        i = list.indexOf(null);
        Assert.assertEquals((long)-1L, (long)i);
        Collections.sort(list);
        list.remove((Object)7);
        Collections.sort(list);
        Assert.assertEquals((long)1L, (long)((Integer)list.get(3)).intValue());
        boolean b = list.removeAll(Arrays.asList(9));
        Assert.assertTrue((boolean)b);
        b = list.removeAll(Arrays.asList(99));
        Assert.assertFalse((boolean)b);
        list.add((Object)12345);
        b = list.removeAll(Arrays.asList(12345));
        Assert.assertTrue((boolean)b);
        list.add((Object)12345);
        list.add((Object)123);
        b = list.removeAll(Arrays.asList(12345));
        Assert.assertTrue((boolean)b);
        Assert.assertEquals((long)1000L, (long)new ChunkList(Collections.nCopies(1000, 77)).size());
        ChunkList list2 = new ChunkList();
        list2.listIterator(0).add("x");
        Assert.assertEquals((Object)"[x]", (Object)list2.toString());
        list2.add(0, (Object)"y");
        Assert.assertEquals((Object)"[y, x]", (Object)list2.toString());
    }

    @Test
    public void testRandom() {
        int iterationCount = 10000;
        this.checkRandom(new Random(1L), (ChunkList<Integer>)new ChunkList(), 10000);
        Random random = new Random(2L);
        for (int j = 0; j < 10; ++j) {
            this.checkRandom(random, (ChunkList<Integer>)new ChunkList(), 10000);
        }
        this.checkRandom(new Random(3L), (ChunkList<Integer>)new ChunkList(Collections.nCopies(1000, 5)), 10000);
    }

    void checkRandom(Random random, ChunkList<Integer> list, int iterationCount) {
        int removeCount = 0;
        int addCount = 0;
        int initialCount = list.size();
        for (int i = 0; i < iterationCount; ++i) {
            assert (list.isValid(true));
            switch (random.nextInt(8)) {
                case 0: {
                    if (list.isEmpty()) break;
                    list.remove(list.size() - 1);
                    ++removeCount;
                    break;
                }
                case 1: {
                    list.add((Object)random.nextInt(1000));
                    ++addCount;
                    break;
                }
                case 2: {
                    int n = 0;
                    int size = list.size();
                    for (Integer integer : list) {
                        Util.discard((Object)integer);
                        Assert.assertTrue((n++ < size ? 1 : 0) != 0);
                    }
                    break;
                }
                case 3: {
                    int sizeBefore = list.size();
                    boolean b = list.removeAll(Collections.singletonList(random.nextInt(500)));
                    if (b) {
                        Assert.assertTrue((list.size() < sizeBefore ? 1 : 0) != 0);
                    } else {
                        Assert.assertTrue((list.size() == sizeBefore ? 1 : 0) != 0);
                    }
                    removeCount += sizeBefore - list.size();
                    break;
                }
                case 4: {
                    if (list.isEmpty()) break;
                    list.remove(random.nextInt(list.size()));
                    ++removeCount;
                    break;
                }
                case 5: {
                    int count = random.nextInt(list.size() + 1);
                    ListIterator it = list.listIterator();
                    for (int j = 0; j < count; ++j) {
                        it.next();
                    }
                    it.add(list.size());
                    ++addCount;
                    break;
                }
                default: {
                    list.add(random.nextInt(list.size() + 1), (Object)list.size());
                    ++addCount;
                }
            }
            Assert.assertEquals((long)list.size(), (long)(initialCount + addCount - removeCount));
        }
    }

    @Test
    public void testPerformance() {
        if (!Benchmark.enabled()) {
            return;
        }
        List factories0 = Pair.zip(Arrays.asList(new Function0<List<Integer>>(){

            public List<Integer> apply() {
                return new ArrayList<Integer>();
            }
        }, new Function0<List<Integer>>(){

            public List<Integer> apply() {
                return new LinkedList<Integer>();
            }
        }, new Function0<List<Integer>>(){

            public List<Integer> apply() {
                return new ChunkList();
            }
        }), Arrays.asList("ArrayList", "LinkedList", "ChunkList-64"));
        ArrayList<Pair> factories1 = new ArrayList<Pair>();
        for (Pair pair : factories0) {
            factories1.add(pair);
        }
        List factories = factories1.subList(2, 3);
        List sizes = Pair.zip(Arrays.asList(100000, 1000000, 10000000), Arrays.asList("100k", "1m", "10m"));
        for (final Pair pair : factories) {
            new Benchmark("add 10m values, " + (String)pair.right, (Function1)new Function1<Benchmark.Statistician, Void>(){

                public Void apply(Benchmark.Statistician statistician) {
                    List list = (List)((Function0)pair.left).apply();
                    long start = System.currentTimeMillis();
                    for (int i = 0; i < 10000000; ++i) {
                        list.add(1);
                    }
                    statistician.record(start);
                    return null;
                }
            }, 10).run();
        }
        for (final Pair pair : factories) {
            new Benchmark("iterate over 10m values, " + (String)pair.right, (Function1)new Function1<Benchmark.Statistician, Void>(){

                public Void apply(Benchmark.Statistician statistician) {
                    List list = (List)((Function0)pair.left).apply();
                    list.addAll(Collections.nCopies(10000000, 1));
                    long start = System.currentTimeMillis();
                    int count = 0;
                    for (Integer integer : list) {
                        count += integer.intValue();
                    }
                    statistician.record(start);
                    assert (count == 10000000);
                    return null;
                }
            }, 10).run();
        }
        for (final Pair pair : factories) {
            for (final Pair size : sizes) {
                if ((Integer)size.left > 1000000) continue;
                new Benchmark("delete 10% of " + (String)size.right + " values, " + (String)pair.right, (Function1)new Function1<Benchmark.Statistician, Void>(){

                    public Void apply(Benchmark.Statistician statistician) {
                        List list = (List)((Function0)pair.left).apply();
                        list.addAll(Collections.nCopies((Integer)size.left, 1));
                        long start = System.currentTimeMillis();
                        int n = 0;
                        Iterator it = list.iterator();
                        while (it.hasNext()) {
                            Integer integer = (Integer)it.next();
                            Util.discard((Object)integer);
                            if (n++ % 10 != 0) continue;
                            it.remove();
                        }
                        statistician.record(start);
                        return null;
                    }
                }, 10).run();
            }
        }
        for (final Pair pair : factories) {
            for (final Pair size : sizes) {
                if ((Integer)size.left > 1000000) continue;
                new Benchmark("get from " + (String)size.right + " values, " + (Integer)size.left / 1000 + " times, " + (String)pair.right, (Function1)new Function1<Benchmark.Statistician, Void>(){

                    public Void apply(Benchmark.Statistician statistician) {
                        List list = (List)((Function0)pair.left).apply();
                        list.addAll(Collections.nCopies((Integer)size.left, 1));
                        int probeCount = (Integer)size.left / 1000;
                        Random random = new Random(1L);
                        long start = System.currentTimeMillis();
                        int n = 0;
                        for (int i = 0; i < probeCount; ++i) {
                            n += ((Integer)list.get(random.nextInt(list.size()))).intValue();
                        }
                        assert (n == probeCount);
                        statistician.record(start);
                        return null;
                    }
                }, 10).run();
            }
        }
        for (final Pair pair : factories) {
            for (final Pair size : sizes) {
                if ((Integer)size.left > 1000000) continue;
                new Benchmark("add " + (String)size.right + " values, delete 10%, insert 20%, get 1%, using " + (String)pair.right, (Function1)new Function1<Benchmark.Statistician, Void>(){

                    public Void apply(Benchmark.Statistician statistician) {
                        Integer integer;
                        List list = (List)((Function0)pair.left).apply();
                        int probeCount = (Integer)size.left / 100;
                        long start = System.currentTimeMillis();
                        list.addAll(Collections.nCopies((Integer)size.left, 1));
                        Random random = new Random(1L);
                        Iterator<Integer> it = list.iterator();
                        while (it.hasNext()) {
                            integer = (Integer)it.next();
                            Util.discard((Object)integer);
                            if (random.nextInt(10) != 0) continue;
                            it.remove();
                        }
                        it = list.listIterator();
                        while (it.hasNext()) {
                            integer = (Integer)it.next();
                            Util.discard((Object)integer);
                            if (random.nextInt(5) != 0) continue;
                            it.add(2);
                        }
                        int n = 0;
                        for (int i = 0; i < probeCount; ++i) {
                            n += ((Integer)list.get(random.nextInt(list.size()))).intValue();
                        }
                        assert (n > probeCount);
                        statistician.record(start);
                        return null;
                    }
                }, 10).run();
            }
        }
    }
}

