/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.test;

import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.resource.Feature;
import org.eigenbase.sql.SqlOperatorTable;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.test.DefaultSqlTestFactory;
import org.eigenbase.sql.test.DelegatingSqlTestFactory;
import org.eigenbase.sql.test.SqlTestFactory;
import org.eigenbase.sql.test.SqlTester;
import org.eigenbase.sql.test.SqlTesterImpl;
import org.eigenbase.sql.type.SqlTypeFactoryImpl;
import org.eigenbase.sql.validate.SqlConformance;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorCatalogReader;
import org.eigenbase.sql.validate.SqlValidatorImpl;
import org.eigenbase.test.MockCatalogReader;
import org.eigenbase.test.SqlValidatorTestCase;
import org.eigenbase.util.EigenbaseContextException;
import org.eigenbase.util.EigenbaseException;
import org.eigenbase.util.Static;
import org.junit.Test;

public class SqlValidatorFeatureTest
extends SqlValidatorTestCase {
    private static final String FEATURE_DISABLED = "feature_disabled";
    private Feature disabledFeature;

    public SqlTester getTester() {
        return new SqlTesterImpl(new FeatureTesterFactory());
    }

    @Test
    public void testDistinct() {
        this.checkFeature("select ^distinct^ name from dept", Static.RESOURCE.sQLFeature_E051_01());
    }

    @Test
    public void testOrderByDesc() {
        this.checkFeature("select name from dept order by ^name desc^", Static.RESOURCE.sQLConformance_OrderByDesc());
    }

    @Test
    public void testIntersect() {
        this.checkFeature("^select name from dept intersect select name from dept^", Static.RESOURCE.sQLFeature_F302());
    }

    @Test
    public void testExcept() {
        this.checkFeature("^select name from dept except select name from dept^", Static.RESOURCE.sQLFeature_E071_03());
    }

    @Test
    public void testMultiset() {
        this.checkFeature("values ^multiset[1]^", Static.RESOURCE.sQLFeature_S271());
        this.checkFeature("values ^multiset(select * from dept)^", Static.RESOURCE.sQLFeature_S271());
    }

    @Test
    public void testTablesample() {
        this.checkFeature("select name from ^dept tablesample bernoulli(50)^", Static.RESOURCE.sQLFeature_T613());
        this.checkFeature("select name from ^dept tablesample substitute('sample_dept')^", Static.RESOURCE.sQLFeatureExt_T613_Substitution());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFeature(String sql, Feature feature) {
        this.check(sql);
        try {
            this.disabledFeature = feature;
            this.checkFails(sql, FEATURE_DISABLED);
        }
        finally {
            this.disabledFeature = null;
        }
    }

    private class FeatureValidator
    extends SqlValidatorImpl {
        protected FeatureValidator(SqlOperatorTable opTab, SqlValidatorCatalogReader catalogReader, RelDataTypeFactory typeFactory, SqlConformance conformance) {
            super(opTab, catalogReader, typeFactory, conformance);
        }

        protected void validateFeature(Feature feature, SqlParserPos context) {
            if (feature.equals((Object)SqlValidatorFeatureTest.this.disabledFeature)) {
                EigenbaseException ex = new EigenbaseException(SqlValidatorFeatureTest.FEATURE_DISABLED, null);
                if (context == null) {
                    throw ex;
                }
                throw new EigenbaseContextException("location", (Throwable)ex, context.getLineNum(), context.getColumnNum(), context.getEndLineNum(), context.getEndColumnNum());
            }
        }
    }

    private class FeatureTesterFactory
    extends DelegatingSqlTestFactory {
        public FeatureTesterFactory() {
            super(DefaultSqlTestFactory.INSTANCE);
        }

        public SqlValidator getValidator(SqlTestFactory factory) {
            SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl();
            SqlConformance conformance = (SqlConformance)this.get("conformance");
            boolean caseSensitive = (Boolean)this.get("caseSensitive");
            return new FeatureValidator(factory.createOperatorTable(), (SqlValidatorCatalogReader)new MockCatalogReader((RelDataTypeFactory)typeFactory, caseSensitive).init(), (RelDataTypeFactory)typeFactory, conformance);
        }
    }
}

