/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.test;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.SqlFunction;
import org.eigenbase.sql.SqlFunctionCategory;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlOperatorBinding;
import org.eigenbase.sql.SqlOperatorTable;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.sql.type.SqlOperandTypeChecker;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.util.ChainedSqlOperatorTable;
import org.eigenbase.sql.util.ListSqlOperatorTable;

public class MockSqlOperatorTable
extends ChainedSqlOperatorTable {
    private final ListSqlOperatorTable listOpTab;

    public MockSqlOperatorTable(SqlOperatorTable parentTable) {
        super((List)ImmutableList.of((Object)parentTable, (Object)new ListSqlOperatorTable()));
        this.listOpTab = (ListSqlOperatorTable)this.tableList.get(1);
    }

    public void addOperator(SqlOperator op) {
        this.listOpTab.add(op);
    }

    public static void addRamp(MockSqlOperatorTable opTab) {
        opTab.addOperator((SqlOperator)new RampFunction());
        opTab.addOperator((SqlOperator)new DedupFunction());
    }

    public static class DedupFunction
    extends SqlFunction {
        public DedupFunction() {
            super("DEDUP", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.VARIADIC, SqlFunctionCategory.USER_DEFINED_FUNCTION);
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.builder().add("NAME", SqlTypeName.VARCHAR, 1024).build();
        }
    }

    public static class RampFunction
    extends SqlFunction {
        public RampFunction() {
            super("RAMP", SqlKind.OTHER_FUNCTION, null, null, (SqlOperandTypeChecker)OperandTypes.NUMERIC, SqlFunctionCategory.USER_DEFINED_FUNCTION);
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.builder().add("I", SqlTypeName.INTEGER).build();
        }
    }
}

