/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.validate;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.validate.AbstractNamespace;
import org.eigenbase.sql.validate.SqlMonotonicity;
import org.eigenbase.sql.validate.SqlValidatorImpl;
import org.eigenbase.sql.validate.SqlValidatorNamespace;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.sql.validate.SqlValidatorTable;
import org.eigenbase.sql.validate.TableNamespace;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Static;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifierNamespace
extends AbstractNamespace {
    private final SqlIdentifier id;
    private final SqlValidatorScope parentScope;
    private SqlValidatorNamespace resolvedNamespace;
    private List<Pair<SqlNode, SqlMonotonicity>> monotonicExprs;

    IdentifierNamespace(SqlValidatorImpl validator, SqlIdentifier id, SqlNode enclosingNode, SqlValidatorScope parentScope) {
        super(validator, enclosingNode);
        this.id = id;
        this.parentScope = parentScope;
        assert (parentScope != null);
        assert (id != null);
    }

    @Override
    public RelDataType validateImpl() {
        this.resolvedNamespace = this.parentScope.getTableNamespace((List<String>)this.id.names);
        if (this.resolvedNamespace == null) {
            throw this.validator.newValidationError(this.id, Static.RESOURCE.tableNameNotFound(this.id.toString()));
        }
        if (this.resolvedNamespace instanceof TableNamespace) {
            List<String> qualifiedNames;
            SqlValidatorTable table = this.resolvedNamespace.getTable();
            if (this.validator.shouldExpandIdentifiers() && (qualifiedNames = table.getQualifiedName()) != null) {
                ArrayList<SqlParserPos> poses = new ArrayList<SqlParserPos>(Collections.nCopies(qualifiedNames.size(), this.id.getParserPosition()));
                int offset = qualifiedNames.size() - this.id.names.size();
                if (offset >= 0) {
                    for (int i = 0; i < this.id.names.size(); ++i) {
                        poses.set(i + offset, this.id.getComponentParserPosition(i));
                    }
                }
                this.id.setNames(qualifiedNames, poses);
            }
        }
        RelDataType rowType = this.resolvedNamespace.getRowType();
        ImmutableList.Builder builder = ImmutableList.builder();
        List<RelDataTypeField> fields = rowType.getFieldList();
        for (RelDataTypeField field : fields) {
            String fieldName = field.getName();
            SqlMonotonicity monotonicity = this.resolvedNamespace.getMonotonicity(fieldName);
            if (monotonicity == SqlMonotonicity.NOT_MONOTONIC) continue;
            builder.add(Pair.of(new SqlIdentifier(fieldName, SqlParserPos.ZERO), monotonicity));
        }
        this.monotonicExprs = builder.build();
        return rowType;
    }

    public SqlIdentifier getId() {
        return this.id;
    }

    @Override
    public SqlNode getNode() {
        return this.id;
    }

    @Override
    public SqlValidatorNamespace resolve() {
        assert (this.resolvedNamespace != null) : "must call validate first";
        return this.resolvedNamespace.resolve();
    }

    @Override
    public String translate(String name) {
        return this.resolvedNamespace.translate(name);
    }

    @Override
    public SqlValidatorTable getTable() {
        return this.resolve().getTable();
    }

    @Override
    public List<Pair<SqlNode, SqlMonotonicity>> getMonotonicExprs() {
        return this.monotonicExprs;
    }

    @Override
    public SqlMonotonicity getMonotonicity(String columnName) {
        SqlValidatorTable table = this.getTable();
        return table.getMonotonicity(columnName);
    }
}

