/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.util.ImmutableIntList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SemiJoinRel
extends JoinRelBase {
    private final ImmutableIntList leftKeys;
    private final ImmutableIntList rightKeys;

    public SemiJoinRel(RelOptCluster cluster, RelNode left, RelNode right, RexNode condition, List<Integer> leftKeys, List<Integer> rightKeys) {
        super(cluster, cluster.traitSetOf(Convention.NONE), left, right, condition, JoinRelType.INNER, (Set<String>)ImmutableSet.of());
        this.leftKeys = ImmutableIntList.copyOf(leftKeys);
        this.rightKeys = ImmutableIntList.copyOf(rightKeys);
    }

    @Override
    public SemiJoinRel copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        assert (joinType == JoinRelType.INNER);
        return new SemiJoinRel(this.getCluster(), left, right, conditionExpr, this.getLeftKeys(), this.getRightKeys());
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        return planner.getCostFactory().makeTinyCost();
    }

    @Override
    public double getRows() {
        return RelMetadataQuery.getRowCount(this.left) * RexUtil.getSelectivity(this.condition);
    }

    @Override
    public RelDataType deriveRowType() {
        return SemiJoinRel.deriveJoinRowType(this.left.getRowType(), null, JoinRelType.INNER, this.getCluster().getTypeFactory(), null, Collections.<RelDataTypeField>emptyList());
    }

    public List<Integer> getLeftKeys() {
        return this.leftKeys;
    }

    public List<Integer> getRightKeys() {
        return this.rightKeys;
    }
}

