/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelFactories;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexLocalRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.rex.RexProgramBuilder;
import org.eigenbase.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PullUpProjectsAboveJoinRule
extends RelOptRule {
    public static final PullUpProjectsAboveJoinRule BOTH_PROJECT = new PullUpProjectsAboveJoinRule(PullUpProjectsAboveJoinRule.operand(JoinRel.class, PullUpProjectsAboveJoinRule.operand(ProjectRel.class, PullUpProjectsAboveJoinRule.any()), PullUpProjectsAboveJoinRule.operand(ProjectRel.class, PullUpProjectsAboveJoinRule.any())), "PullUpProjectsAboveJoinRule: with two ProjectRel children");
    public static final PullUpProjectsAboveJoinRule LEFT_PROJECT = new PullUpProjectsAboveJoinRule(PullUpProjectsAboveJoinRule.operand(JoinRel.class, PullUpProjectsAboveJoinRule.some(PullUpProjectsAboveJoinRule.operand(ProjectRel.class, PullUpProjectsAboveJoinRule.any()), new RelOptRuleOperand[0])), "PullUpProjectsAboveJoinRule: with ProjectRel on left");
    public static final PullUpProjectsAboveJoinRule RIGHT_PROJECT = new PullUpProjectsAboveJoinRule(PullUpProjectsAboveJoinRule.operand(JoinRel.class, PullUpProjectsAboveJoinRule.operand(RelNode.class, PullUpProjectsAboveJoinRule.any()), PullUpProjectsAboveJoinRule.operand(ProjectRel.class, PullUpProjectsAboveJoinRule.any())), "PullUpProjectsAboveJoinRule: with ProjectRel on right");
    private final RelFactories.ProjectFactory projectFactory;

    public PullUpProjectsAboveJoinRule(RelOptRuleOperand operand, String description) {
        this(operand, description, RelFactories.DEFAULT_PROJECT_FACTORY);
    }

    public PullUpProjectsAboveJoinRule(RelOptRuleOperand operand, String description, RelFactories.ProjectFactory pFactory) {
        super(operand, description);
        this.projectFactory = pFactory;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode rightJoinChild;
        ProjectRelBase rightProj;
        Object leftJoinChild;
        ProjectRelBase leftProj;
        JoinRelBase joinRel = (JoinRelBase)call.rel(0);
        JoinRelType joinType = joinRel.getJoinType();
        if (this.hasLeftChild(call) && !joinType.generatesNullsOnLeft()) {
            leftProj = (ProjectRelBase)call.rel(1);
            leftJoinChild = this.getProjectChild(call, leftProj, true);
        } else {
            leftProj = null;
            leftJoinChild = call.rel(1);
        }
        if (this.hasRightChild(call) && !joinType.generatesNullsOnRight()) {
            rightProj = this.getRightChild(call);
            rightJoinChild = this.getProjectChild(call, rightProj, false);
        } else {
            rightProj = null;
            rightJoinChild = joinRel.getRight();
        }
        if (leftProj == null && rightProj == null) {
            return;
        }
        RelDataType joinChildrenRowType = JoinRelBase.deriveJoinRowType(leftJoinChild.getRowType(), rightJoinChild.getRowType(), JoinRelType.INNER, joinRel.getCluster().getTypeFactory(), null, Collections.<RelDataTypeField>emptyList());
        int nProjExprs = joinRel.getRowType().getFieldCount();
        ArrayList<Pair<RexNode, String>> projects = new ArrayList<Pair<RexNode, String>>();
        RexBuilder rexBuilder = joinRel.getCluster().getRexBuilder();
        this.createProjectExprs(leftProj, (RelNode)leftJoinChild, 0, rexBuilder, joinChildrenRowType.getFieldList(), projects);
        List<RelDataTypeField> leftFields = leftJoinChild.getRowType().getFieldList();
        int nFieldsLeft = leftFields.size();
        this.createProjectExprs(rightProj, rightJoinChild, nFieldsLeft, rexBuilder, joinChildrenRowType.getFieldList(), projects);
        ArrayList<RelDataType> projTypes = new ArrayList<RelDataType>();
        for (int i = 0; i < nProjExprs; ++i) {
            projTypes.add(((RexNode)((Pair)projects.get((int)i)).left).getType());
        }
        RelDataType projRowType = rexBuilder.getTypeFactory().createStructType(projTypes, Pair.right(projects));
        RexProgram bottomProgram = RexProgram.create(joinChildrenRowType, Pair.left(projects), null, projRowType, rexBuilder);
        RexProgramBuilder topProgramBuilder = new RexProgramBuilder(projRowType, rexBuilder);
        topProgramBuilder.addIdentity();
        topProgramBuilder.addCondition(joinRel.getCondition());
        RexProgram topProgram = topProgramBuilder.getProgram();
        RexProgram mergedProgram = RexProgramBuilder.mergePrograms(topProgram, bottomProgram, rexBuilder);
        RexNode newCondition = mergedProgram.expandLocalRef(mergedProgram.getCondition());
        JoinRelBase newJoinRel = joinRel.copy(joinRel.getTraitSet(), newCondition, (RelNode)leftJoinChild, rightJoinChild, joinRel.getJoinType(), joinRel.isSemiJoinDone());
        ArrayList<RexNode> newProjExprs = new ArrayList<RexNode>();
        List<RexLocalRef> projList = mergedProgram.getProjectList();
        List<RelDataTypeField> newJoinFields = newJoinRel.getRowType().getFieldList();
        int nJoinFields = newJoinFields.size();
        int[] adjustments = new int[nJoinFields];
        for (int i = 0; i < nProjExprs; ++i) {
            RexNode newExpr = mergedProgram.expandLocalRef(projList.get(i));
            if (joinType != JoinRelType.INNER) {
                newExpr = newExpr.accept(new RelOptUtil.RexInputConverter(rexBuilder, joinChildrenRowType.getFieldList(), newJoinFields, adjustments));
            }
            newProjExprs.add(newExpr);
        }
        RelNode newProjRel = this.projectFactory.createProject(newJoinRel, newProjExprs, joinRel.getRowType().getFieldNames());
        call.transformTo(newProjRel);
    }

    protected boolean hasLeftChild(RelOptRuleCall call) {
        return call.rel(1) instanceof ProjectRelBase;
    }

    protected boolean hasRightChild(RelOptRuleCall call) {
        return call.rels.length == 3;
    }

    protected ProjectRelBase getRightChild(RelOptRuleCall call) {
        return (ProjectRelBase)call.rel(2);
    }

    protected RelNode getProjectChild(RelOptRuleCall call, ProjectRelBase project, boolean leftChild) {
        return project.getChild();
    }

    private void createProjectExprs(ProjectRelBase projRel, RelNode joinChild, int adjustmentAmount, RexBuilder rexBuilder, List<RelDataTypeField> joinChildrenFields, List<Pair<RexNode, String>> projects) {
        List<RelDataTypeField> childFields = joinChild.getRowType().getFieldList();
        if (projRel != null) {
            List<Pair<RexNode, String>> namedProjects = projRel.getNamedProjects();
            int nChildFields = childFields.size();
            int[] adjustments = new int[nChildFields];
            for (int i = 0; i < nChildFields; ++i) {
                adjustments[i] = adjustmentAmount;
            }
            for (Pair<RexNode, String> pair : namedProjects) {
                RexNode e = (RexNode)pair.left;
                if (adjustmentAmount != 0) {
                    e = e.accept(new RelOptUtil.RexInputConverter(rexBuilder, childFields, joinChildrenFields, adjustments));
                }
                projects.add(Pair.of(e, pair.right));
            }
        } else {
            for (int i = 0; i < childFields.size(); ++i) {
                RelDataTypeField field = childFields.get(i);
                projects.add(Pair.of(rexBuilder.makeInputRef(field.getType(), i + adjustmentAmount), field.getName()));
            }
        }
    }
}

