/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.metadata.RelColumnOrigin;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.rel.rules.LoptJoinTree;
import org.eigenbase.rel.rules.MultiJoinRel;
import org.eigenbase.rel.rules.SemiJoinRel;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.util.IntList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoptMultiJoin {
    MultiJoinRel multiJoin;
    private List<RexNode> joinFilters;
    private List<RexNode> allJoinFilters;
    private int nJoinFactors;
    private int nTotalFields;
    private List<RelNode> joinFactors;
    private List<JoinRelType> joinTypes;
    private BitSet[] outerJoinFactors;
    private List<BitSet> projFields;
    private Map<Integer, int[]> joinFieldRefCountsMap;
    private Map<RexNode, BitSet> factorsRefByJoinFilter;
    private Map<RexNode, BitSet> fieldsRefByJoinFilter;
    int[] joinStart;
    int[] nFieldsInJoinFactor;
    BitSet[] factorsRefByFactor;
    int[][] factorWeights;
    RelDataTypeFactory factory;
    Integer[] joinRemovalFactors;
    SemiJoinRel[] joinRemovalSemiJoins;
    Set<Integer> removableOuterJoinFactors;
    Map<Integer, RemovableSelfJoin> removableSelfJoinPairs;

    public LoptMultiJoin(MultiJoinRel multiJoin) {
        this.multiJoin = multiJoin;
        this.joinFactors = multiJoin.getInputs();
        this.nJoinFactors = this.joinFactors.size();
        this.projFields = multiJoin.getProjFields();
        this.joinFieldRefCountsMap = multiJoin.getCopyJoinFieldRefCountsMap();
        this.joinFilters = new ArrayList<RexNode>();
        RelOptUtil.decomposeConjunction(multiJoin.getJoinFilter(), this.joinFilters);
        this.allJoinFilters = new ArrayList<RexNode>(this.joinFilters);
        List<RexNode> outerJoinFilters = multiJoin.getOuterJoinConditions();
        for (int i = 0; i < this.nJoinFactors; ++i) {
            ArrayList<RexNode> ojFilters = new ArrayList<RexNode>();
            RelOptUtil.decomposeConjunction(outerJoinFilters.get(i), ojFilters);
            this.allJoinFilters.addAll(ojFilters);
        }
        int start = 0;
        this.nTotalFields = multiJoin.getRowType().getFieldCount();
        this.joinStart = new int[this.nJoinFactors];
        this.nFieldsInJoinFactor = new int[this.nJoinFactors];
        for (int i = 0; i < this.nJoinFactors; ++i) {
            this.joinStart[i] = start;
            this.nFieldsInJoinFactor[i] = this.joinFactors.get(i).getRowType().getFieldCount();
            start += this.nFieldsInJoinFactor[i];
        }
        this.setOuterJoinInfo();
        this.setJoinFilterRefs();
        this.factory = multiJoin.getCluster().getTypeFactory();
        this.joinRemovalFactors = new Integer[this.nJoinFactors];
        this.joinRemovalSemiJoins = new SemiJoinRel[this.nJoinFactors];
        this.removableOuterJoinFactors = new HashSet<Integer>();
        this.removableSelfJoinPairs = new HashMap<Integer, RemovableSelfJoin>();
    }

    public MultiJoinRel getMultiJoinRel() {
        return this.multiJoin;
    }

    public int getNumJoinFactors() {
        return this.nJoinFactors;
    }

    public RelNode getJoinFactor(int factIdx) {
        return this.joinFactors.get(factIdx);
    }

    public int getNumTotalFields() {
        return this.nTotalFields;
    }

    public int getNumFieldsInJoinFactor(int factIdx) {
        return this.nFieldsInJoinFactor[factIdx];
    }

    public List<RexNode> getJoinFilters() {
        return this.joinFilters;
    }

    public BitSet getFactorsRefByJoinFilter(RexNode joinFilter) {
        return this.factorsRefByJoinFilter.get(joinFilter);
    }

    public List<RelDataTypeField> getMultiJoinFields() {
        return this.multiJoin.getRowType().getFieldList();
    }

    public BitSet getFieldsRefByJoinFilter(RexNode joinFilter) {
        return this.fieldsRefByJoinFilter.get(joinFilter);
    }

    public int[][] getFactorWeights() {
        return this.factorWeights;
    }

    public BitSet getFactorsRefByFactor(int factIdx) {
        return this.factorsRefByFactor[factIdx];
    }

    public int getJoinStart(int factIdx) {
        return this.joinStart[factIdx];
    }

    public boolean isNullGenerating(int factIdx) {
        return this.joinTypes.get(factIdx) != JoinRelType.INNER;
    }

    public BitSet getOuterJoinFactors(int factIdx) {
        return this.outerJoinFactors[factIdx];
    }

    public RexNode getOuterJoinCond(int factIdx) {
        return this.multiJoin.getOuterJoinConditions().get(factIdx);
    }

    public BitSet getProjFields(int factIdx) {
        return this.projFields.get(factIdx);
    }

    public int[] getJoinFieldRefCounts(int factIdx) {
        return this.joinFieldRefCountsMap.get(factIdx);
    }

    public Integer getJoinRemovalFactor(int dimIdx) {
        return this.joinRemovalFactors[dimIdx];
    }

    public SemiJoinRel getJoinRemovalSemiJoin(int dimIdx) {
        return this.joinRemovalSemiJoins[dimIdx];
    }

    public void setJoinRemovalFactor(int dimIdx, int factIdx) {
        this.joinRemovalFactors[dimIdx] = factIdx;
    }

    public void setJoinRemovalSemiJoin(int dimIdx, SemiJoinRel semiJoin) {
        this.joinRemovalSemiJoins[dimIdx] = semiJoin;
    }

    private void setOuterJoinInfo() {
        this.joinTypes = this.multiJoin.getJoinTypes();
        List<RexNode> outerJoinConds = this.multiJoin.getOuterJoinConditions();
        this.outerJoinFactors = new BitSet[this.nJoinFactors];
        for (int i = 0; i < this.nJoinFactors; ++i) {
            if (outerJoinConds.get(i) == null) continue;
            BitSet dependentFactors = this.getJoinFilterFactorBitmap(outerJoinConds.get(i), false);
            dependentFactors.clear(i);
            this.outerJoinFactors[i] = dependentFactors;
        }
    }

    private BitSet getJoinFilterFactorBitmap(RexNode joinFilter, boolean setFields) {
        BitSet fieldRefBitmap = new BitSet(this.nTotalFields);
        joinFilter.accept(new RelOptUtil.InputFinder(fieldRefBitmap));
        if (setFields) {
            this.fieldsRefByJoinFilter.put(joinFilter, fieldRefBitmap);
        }
        BitSet factorRefBitmap = new BitSet(this.nJoinFactors);
        this.setFactorBitmap(factorRefBitmap, fieldRefBitmap);
        return factorRefBitmap;
    }

    private void setJoinFilterRefs() {
        this.fieldsRefByJoinFilter = new HashMap<RexNode, BitSet>();
        this.factorsRefByJoinFilter = new HashMap<RexNode, BitSet>();
        ListIterator<RexNode> filterIter = this.allJoinFilters.listIterator();
        while (filterIter.hasNext()) {
            RexNode joinFilter = filterIter.next();
            if (joinFilter.isAlwaysTrue()) {
                filterIter.remove();
            }
            BitSet factorRefBitmap = this.getJoinFilterFactorBitmap(joinFilter, true);
            this.factorsRefByJoinFilter.put(joinFilter, factorRefBitmap);
        }
    }

    private void setFactorBitmap(BitSet factorRefBitmap, BitSet fieldRefBitmap) {
        for (int field : BitSets.toIter(fieldRefBitmap)) {
            int factor = this.findRef(field);
            factorRefBitmap.set(factor);
        }
    }

    public int findRef(int rexInputRef) {
        for (int i = 0; i < this.nJoinFactors; ++i) {
            if (rexInputRef < this.joinStart[i] || rexInputRef >= this.joinStart[i] + this.nFieldsInJoinFactor[i]) continue;
            return i;
        }
        throw new AssertionError();
    }

    public void setFactorWeights() {
        this.factorWeights = new int[this.nJoinFactors][this.nJoinFactors];
        this.factorsRefByFactor = new BitSet[this.nJoinFactors];
        for (int i = 0; i < this.nJoinFactors; ++i) {
            this.factorsRefByFactor[i] = new BitSet(this.nJoinFactors);
        }
        for (RexNode joinFilter : this.allJoinFilters) {
            BitSet factorRefs = this.factorsRefByJoinFilter.get(joinFilter);
            if (!(joinFilter instanceof RexCall) || !joinFilter.isA(SqlKind.COMPARISON)) continue;
            for (int factor : BitSets.toIter(factorRefs)) {
                this.factorsRefByFactor[factor].or(factorRefs);
                this.factorsRefByFactor[factor].clear(factor);
            }
            if (factorRefs.cardinality() == 2) {
                int weight;
                int leftFactor = factorRefs.nextSetBit(0);
                int rightFactor = factorRefs.nextSetBit(leftFactor + 1);
                BitSet leftFields = new BitSet(this.nTotalFields);
                List<RexNode> operands = ((RexCall)joinFilter).getOperands();
                operands.get(0).accept(new RelOptUtil.InputFinder(leftFields));
                BitSet leftBitmap = new BitSet(this.nJoinFactors);
                this.setFactorBitmap(leftBitmap, leftFields);
                if (leftBitmap.cardinality() == 1) {
                    switch (joinFilter.getKind()) {
                        case EQUALS: {
                            weight = 3;
                            break;
                        }
                        default: {
                            weight = 2;
                            break;
                        }
                    }
                } else {
                    weight = 1;
                }
                this.setFactorWeight(weight, leftFactor, rightFactor);
                continue;
            }
            IntList list = BitSets.toList(factorRefs);
            Iterator i$ = list.iterator();
            while (i$.hasNext()) {
                int outer = (Integer)i$.next();
                Iterator i$2 = list.iterator();
                while (i$2.hasNext()) {
                    int inner = (Integer)i$2.next();
                    if (outer == inner) continue;
                    this.setFactorWeight(1, outer, inner);
                }
            }
        }
    }

    private void setFactorWeight(int weight, int leftFactor, int rightFactor) {
        if (this.factorWeights[leftFactor][rightFactor] < weight) {
            this.factorWeights[leftFactor][rightFactor] = weight;
            this.factorWeights[rightFactor][leftFactor] = weight;
        }
    }

    public boolean hasAllFactors(LoptJoinTree joinTree, BitSet factorsNeeded) {
        BitSet childFactors = new BitSet(this.nJoinFactors);
        this.getChildFactors(joinTree, childFactors);
        return BitSets.contains(childFactors, factorsNeeded);
    }

    public void setFieldBitmap(LoptJoinTree rel, BitSet fields) {
        BitSet factors = new BitSet(this.nJoinFactors);
        this.getChildFactors(rel, factors);
        int factor = factors.nextSetBit(0);
        while (factor >= 0) {
            for (int i = 0; i < this.nFieldsInJoinFactor[factor]; ++i) {
                fields.set(this.joinStart[factor] + i);
            }
            factor = factors.nextSetBit(factor + 1);
        }
    }

    public void getChildFactors(LoptJoinTree joinTree, BitSet childFactors) {
        ArrayList<Integer> children = new ArrayList<Integer>();
        joinTree.getTreeOrder(children);
        Iterator i$ = children.iterator();
        while (i$.hasNext()) {
            int child = (Integer)i$.next();
            childFactors.set(child);
        }
    }

    public List<RelDataTypeField> getJoinFields(LoptJoinTree left, LoptJoinTree right) {
        RelDataType rowType = this.factory.createJoinType(left.getJoinTree().getRowType(), right.getJoinTree().getRowType());
        return rowType.getFieldList();
    }

    public void addRemovableOuterJoinFactor(int factIdx) {
        this.removableOuterJoinFactors.add(factIdx);
    }

    public boolean isRemovableOuterJoinFactor(int factIdx) {
        return this.removableOuterJoinFactors.contains(factIdx);
    }

    public void addRemovableSelfJoinPair(int factor1, int factor2) {
        int rightFactor;
        int leftFactor;
        if (this.getNumFieldsInJoinFactor(factor1) > this.getNumFieldsInJoinFactor(factor2)) {
            leftFactor = factor1;
            rightFactor = factor2;
        } else {
            leftFactor = factor2;
            rightFactor = factor1;
        }
        HashMap<Integer, Integer> columnMapping = new HashMap<Integer, Integer>();
        RelNode left = this.getJoinFactor(leftFactor);
        HashMap<Integer, Integer> leftFactorColMapping = new HashMap<Integer, Integer>();
        for (int i = 0; i < left.getRowType().getFieldCount(); ++i) {
            RelColumnOrigin colOrigin = RelMetadataQuery.getColumnOrigin(left, i);
            if (colOrigin == null) continue;
            leftFactorColMapping.put(colOrigin.getOriginColumnOrdinal(), i);
        }
        RelNode right = this.getJoinFactor(rightFactor);
        for (int i = 0; i < right.getRowType().getFieldCount(); ++i) {
            Integer leftOffset;
            RelColumnOrigin colOrigin = RelMetadataQuery.getColumnOrigin(right, i);
            if (colOrigin == null || (leftOffset = (Integer)leftFactorColMapping.get(colOrigin.getOriginColumnOrdinal())) == null) continue;
            columnMapping.put(i, leftOffset);
        }
        RemovableSelfJoin selfJoin = new RemovableSelfJoin(leftFactor, rightFactor, columnMapping);
        this.removableSelfJoinPairs.put(leftFactor, selfJoin);
        this.removableSelfJoinPairs.put(rightFactor, selfJoin);
    }

    public Integer getOtherSelfJoinFactor(int factIdx) {
        RemovableSelfJoin selfJoin = this.removableSelfJoinPairs.get(factIdx);
        if (selfJoin == null) {
            return null;
        }
        if (selfJoin.getRightFactor() == factIdx) {
            return selfJoin.getLeftFactor();
        }
        return selfJoin.getRightFactor();
    }

    public boolean isLeftFactorInRemovableSelfJoin(int factIdx) {
        RemovableSelfJoin selfJoin = this.removableSelfJoinPairs.get(factIdx);
        if (selfJoin == null) {
            return false;
        }
        return selfJoin.getLeftFactor() == factIdx;
    }

    public boolean isRightFactorInRemovableSelfJoin(int factIdx) {
        RemovableSelfJoin selfJoin = this.removableSelfJoinPairs.get(factIdx);
        if (selfJoin == null) {
            return false;
        }
        return selfJoin.getRightFactor() == factIdx;
    }

    public Integer getRightColumnMapping(int rightFactor, int rightOffset) {
        RemovableSelfJoin selfJoin = this.removableSelfJoinPairs.get(rightFactor);
        assert (selfJoin.getRightFactor() == rightFactor);
        return selfJoin.getColumnMapping().get(rightOffset);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RemovableSelfJoin {
        private int leftFactor;
        private int rightFactor;
        private Map<Integer, Integer> columnMapping;

        RemovableSelfJoin(int leftFactor, int rightFactor, Map<Integer, Integer> columnMapping) {
            this.leftFactor = leftFactor;
            this.rightFactor = rightFactor;
            this.columnMapping = columnMapping;
        }

        public int getLeftFactor() {
            return this.leftFactor;
        }

        public int getRightFactor() {
            return this.rightFactor;
        }

        public Map<Integer, Integer> getColumnMapping() {
            return this.columnMapping;
        }
    }
}

