/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import com.google.common.collect.ImmutableList;
import java.util.AbstractList;
import java.util.List;
import java.util.Set;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelFactories {
    public static final ProjectFactory DEFAULT_PROJECT_FACTORY = new ProjectFactoryImpl();
    public static final JoinFactory DEFAULT_JOIN_FACTORY = new JoinFactoryImpl();

    private RelFactories() {
    }

    public static RelNode createProject(ProjectFactory factory, final RelNode child, final List<Integer> posList) {
        if (RelFactories.isIdentity(posList, child.getRowType().getFieldCount())) {
            return child;
        }
        return factory.createProject(child, (List<RexNode>)new AbstractList<RexNode>(){

            @Override
            public int size() {
                return posList.size();
            }

            @Override
            public RexNode get(int index) {
                int pos = (Integer)posList.get(index);
                return child.getCluster().getRexBuilder().makeInputRef(child, pos);
            }
        }, null);
    }

    private static boolean isIdentity(List<Integer> list, int count) {
        if (list.size() != count) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            Integer o = list.get(i);
            if (o != null && o == i) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JoinFactoryImpl
    implements JoinFactory {
        private JoinFactoryImpl() {
        }

        @Override
        public RelNode createJoin(RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped, boolean semiJoinDone) {
            RelOptCluster cluster = left.getCluster();
            return new JoinRel(cluster, left, right, condition, joinType, variablesStopped, semiJoinDone, (List<RelDataTypeField>)ImmutableList.of());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface JoinFactory {
        public RelNode createJoin(RelNode var1, RelNode var2, RexNode var3, JoinRelType var4, Set<String> var5, boolean var6);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProjectFactoryImpl
    implements ProjectFactory {
        private ProjectFactoryImpl() {
        }

        @Override
        public RelNode createProject(RelNode child, List<RexNode> childExprs, List<String> fieldNames) {
            return CalcRel.createProject(child, childExprs, fieldNames);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ProjectFactory {
        public RelNode createProject(RelNode var1, List<RexNode> var2, List<String> var3);
    }
}

