/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.rules.java;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.hydromatic.linq4j.expressions.BlockBuilder;
import net.hydromatic.linq4j.expressions.BlockStatement;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.FunctionExpression;
import net.hydromatic.linq4j.expressions.MemberDeclaration;
import net.hydromatic.linq4j.expressions.MethodCallExpression;
import net.hydromatic.linq4j.expressions.Node;
import net.hydromatic.linq4j.expressions.ParameterExpression;
import net.hydromatic.linq4j.expressions.Primitive;
import net.hydromatic.linq4j.expressions.Statement;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.rules.java.JavaRowFormat;
import net.hydromatic.optiq.rules.java.JavaRules;
import net.hydromatic.optiq.rules.java.PhysType;
import net.hydromatic.optiq.runtime.Utilities;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelFieldCollation;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhysTypeImpl
implements PhysType {
    private final JavaTypeFactory typeFactory;
    private final RelDataType rowType;
    private final Type javaRowClass;
    private final List<Class> fieldClasses = new ArrayList<Class>();
    final JavaRowFormat format;

    PhysTypeImpl(JavaTypeFactory typeFactory, RelDataType rowType, Type javaRowClass, JavaRowFormat format) {
        this.typeFactory = typeFactory;
        this.rowType = rowType;
        this.javaRowClass = javaRowClass;
        this.format = format;
        for (RelDataTypeField field : rowType.getFieldList()) {
            this.fieldClasses.add(JavaRules.EnumUtil.javaRowClass(typeFactory, field.getType()));
        }
    }

    public static PhysType of(JavaTypeFactory typeFactory, RelDataType rowType, JavaRowFormat format) {
        JavaRowFormat format2 = format.optimize(rowType);
        Type javaRowClass = format2.javaRowClass(typeFactory, rowType);
        return new PhysTypeImpl(typeFactory, rowType, javaRowClass, format2);
    }

    static PhysType of(JavaTypeFactory typeFactory, Type javaRowClass) {
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        if (javaRowClass instanceof Types.RecordType) {
            Types.RecordType recordType = (Types.RecordType)javaRowClass;
            for (Types.RecordField field : recordType.getRecordFields()) {
                builder.add(field.getName(), typeFactory.createType(field.getType()));
            }
        }
        RelDataType rowType = builder.build();
        return new PhysTypeImpl(typeFactory, rowType, javaRowClass, JavaRowFormat.CUSTOM);
    }

    @Override
    public JavaRowFormat getFormat() {
        return this.format;
    }

    @Override
    public PhysType project(List<Integer> integers, JavaRowFormat format) {
        RelDataType projectedRowType = this.typeFactory.createStructType(Lists.transform(integers, (Function)new Function<Integer, RelDataTypeField>(){

            public RelDataTypeField apply(Integer index) {
                return PhysTypeImpl.this.rowType.getFieldList().get(index);
            }
        }));
        return PhysTypeImpl.of(this.typeFactory, projectedRowType, format.optimize(projectedRowType));
    }

    @Override
    public Expression generateSelector(ParameterExpression parameter, List<Integer> fields) {
        return this.generateSelector(parameter, fields, this.format);
    }

    @Override
    public Expression generateSelector(ParameterExpression parameter, List<Integer> fields, JavaRowFormat targetFormat) {
        switch (fields.size()) {
            case 0: {
                targetFormat = JavaRowFormat.LIST;
                break;
            }
            case 1: {
                targetFormat = JavaRowFormat.SCALAR;
            }
        }
        PhysType targetPhysType = this.project(fields, targetFormat);
        switch (this.format) {
            case SCALAR: {
                return Expressions.call((Method)BuiltinMethod.IDENTITY_SELECTOR.method, (Expression[])new Expression[0]);
            }
        }
        return Expressions.lambda(Function1.class, (Expression)targetPhysType.record(this.fieldReferences((Expression)parameter, fields)), (ParameterExpression[])new ParameterExpression[]{parameter});
    }

    @Override
    public Expression selector(ParameterExpression parameter, List<Integer> fields, JavaRowFormat targetFormat) {
        switch (fields.size()) {
            case 0: {
                targetFormat = JavaRowFormat.LIST;
                break;
            }
            case 1: {
                targetFormat = JavaRowFormat.SCALAR;
            }
        }
        PhysType targetPhysType = this.project(fields, targetFormat);
        switch (this.format) {
            case SCALAR: {
                return parameter;
            }
        }
        return targetPhysType.record(this.fieldReferences((Expression)parameter, fields));
    }

    @Override
    public List<Expression> accessors(Expression v1, List<Integer> argList) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        for (int field : argList) {
            expressions.add(Types.castIfNecessary((Type)this.fieldClass(field), (Expression)this.fieldReference(v1, field)));
        }
        return expressions;
    }

    @Override
    public PhysType makeNullable(boolean nullable) {
        if (!nullable) {
            return this;
        }
        return new PhysTypeImpl(this.typeFactory, this.typeFactory.createTypeWithNullability(this.rowType, true), Primitive.box((Type)this.javaRowClass), this.format);
    }

    @Override
    public Pair<Expression, Expression> generateCollationKey(List<RelFieldCollation> collations) {
        if (collations.size() == 1) {
            RelFieldCollation collation = collations.get(0);
            ParameterExpression parameter = Expressions.parameter((Type)this.javaRowClass, (String)"v");
            FunctionExpression selector = Expressions.lambda(Function1.class, (Expression)this.fieldReference((Expression)parameter, collation.getFieldIndex()), (ParameterExpression[])new ParameterExpression[]{parameter});
            return Pair.of(selector, Expressions.call((Method)BuiltinMethod.NULLS_COMPARATOR.method, (Expression[])new Expression[]{Expressions.constant((Object)(collation.nullDirection == RelFieldCollation.NullDirection.FIRST ? 1 : 0)), Expressions.constant((Object)(collation.getDirection() == RelFieldCollation.Direction.DESCENDING ? 1 : 0))}));
        }
        MethodCallExpression selector = Expressions.call((Method)BuiltinMethod.IDENTITY_SELECTOR.method, (Expression[])new Expression[0]);
        BlockBuilder body = new BlockBuilder();
        ParameterExpression parameterV0 = Expressions.parameter((Type)this.javaRowClass, (String)"v0");
        ParameterExpression parameterV1 = Expressions.parameter((Type)this.javaRowClass, (String)"v1");
        ParameterExpression parameterC = Expressions.parameter(Integer.TYPE, (String)"c");
        int mod = collations.size() == 1 ? 16 : 0;
        body.add((Statement)Expressions.declare((int)mod, (ParameterExpression)parameterC, null));
        for (RelFieldCollation collation : collations) {
            boolean descending;
            int index = collation.getFieldIndex();
            Expression arg0 = this.fieldReference((Expression)parameterV0, index);
            Expression arg1 = this.fieldReference((Expression)parameterV1, index);
            switch (Primitive.flavor((Type)this.fieldClass(index))) {
                case OBJECT: {
                    arg0 = Types.castIfNecessary(Comparable.class, (Expression)arg0);
                    arg1 = Types.castIfNecessary(Comparable.class, (Expression)arg1);
                }
            }
            boolean nullsFirst = collation.nullDirection == RelFieldCollation.NullDirection.FIRST;
            boolean bl = descending = collation.getDirection() == RelFieldCollation.Direction.DESCENDING;
            body.add(Expressions.statement((Expression)Expressions.assign((Expression)parameterC, (Expression)Expressions.call(Utilities.class, (String)(this.fieldNullable(index) ? (nullsFirst ? "compareNullsFirst" : "compareNullsLast") : "compare"), (Expression[])new Expression[]{arg0, arg1}))));
            body.add((Statement)Expressions.ifThen((Expression)Expressions.notEqual((Expression)parameterC, (Expression)Expressions.constant((Object)0)), (Node)Expressions.return_(null, (Expression)(descending ? Expressions.negate((Expression)parameterC) : parameterC))));
        }
        body.add((Statement)Expressions.return_(null, (Expression)Expressions.constant((Object)0)));
        Expressions.FluentList memberDeclarations = Expressions.list((Object[])new MemberDeclaration[]{Expressions.methodDecl((int)1, Integer.TYPE, (String)"compare", (Iterable)ImmutableList.of((Object)parameterV0, (Object)parameterV1), (BlockStatement)body.toBlock())});
        ParameterExpression parameterO0 = Expressions.parameter(Object.class, (String)"o0");
        ParameterExpression parameterO1 = Expressions.parameter(Object.class, (String)"o1");
        BlockBuilder bridgeBody = new BlockBuilder();
        bridgeBody.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Expression)Expressions.parameter(Comparable.class, (String)"this"), (Method)BuiltinMethod.COMPARATOR_COMPARE.method, (Expression[])new Expression[]{Expressions.convert_((Expression)parameterO0, (Type)this.javaRowClass), Expressions.convert_((Expression)parameterO1, (Type)this.javaRowClass)})));
        memberDeclarations.add(JavaRules.EnumUtil.overridingMethodDecl(BuiltinMethod.COMPARATOR_COMPARE.method, (Iterable<ParameterExpression>)ImmutableList.of((Object)parameterO0, (Object)parameterO1), bridgeBody.toBlock()));
        return Pair.of(selector, Expressions.new_(Comparator.class, Collections.emptyList(), (Iterable)memberDeclarations));
    }

    @Override
    public Expression generateComparator(RelCollation collation) {
        BlockBuilder body = new BlockBuilder();
        Type javaRowClass = Primitive.box((Type)this.javaRowClass);
        ParameterExpression parameterV0 = Expressions.parameter((Type)javaRowClass, (String)"v0");
        ParameterExpression parameterV1 = Expressions.parameter((Type)javaRowClass, (String)"v1");
        ParameterExpression parameterC = Expressions.parameter(Integer.TYPE, (String)"c");
        int mod = collation.getFieldCollations().size() == 1 ? 16 : 0;
        body.add((Statement)Expressions.declare((int)mod, (ParameterExpression)parameterC, null));
        for (RelFieldCollation fieldCollation : collation.getFieldCollations()) {
            boolean descending;
            int index = fieldCollation.getFieldIndex();
            Expression arg0 = this.fieldReference((Expression)parameterV0, index);
            Expression arg1 = this.fieldReference((Expression)parameterV1, index);
            switch (Primitive.flavor((Type)this.fieldClass(index))) {
                case OBJECT: {
                    arg0 = Types.castIfNecessary(Comparable.class, (Expression)arg0);
                    arg1 = Types.castIfNecessary(Comparable.class, (Expression)arg1);
                }
            }
            boolean nullsFirst = fieldCollation.nullDirection == RelFieldCollation.NullDirection.FIRST;
            boolean bl = descending = fieldCollation.getDirection() == RelFieldCollation.Direction.DESCENDING;
            body.add(Expressions.statement((Expression)Expressions.assign((Expression)parameterC, (Expression)Expressions.call(Utilities.class, (String)(this.fieldNullable(index) ? (nullsFirst != descending ? "compareNullsFirst" : "compareNullsLast") : "compare"), (Expression[])new Expression[]{arg0, arg1}))));
            body.add((Statement)Expressions.ifThen((Expression)Expressions.notEqual((Expression)parameterC, (Expression)Expressions.constant((Object)0)), (Node)Expressions.return_(null, (Expression)(descending ? Expressions.negate((Expression)parameterC) : parameterC))));
        }
        body.add((Statement)Expressions.return_(null, (Expression)Expressions.constant((Object)0)));
        Expressions.FluentList memberDeclarations = Expressions.list((Object[])new MemberDeclaration[]{Expressions.methodDecl((int)1, Integer.TYPE, (String)"compare", (Iterable)ImmutableList.of((Object)parameterV0, (Object)parameterV1), (BlockStatement)body.toBlock())});
        ParameterExpression parameterO0 = Expressions.parameter(Object.class, (String)"o0");
        ParameterExpression parameterO1 = Expressions.parameter(Object.class, (String)"o1");
        BlockBuilder bridgeBody = new BlockBuilder();
        bridgeBody.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Expression)Expressions.parameter(Comparable.class, (String)"this"), (Method)BuiltinMethod.COMPARATOR_COMPARE.method, (Expression[])new Expression[]{Expressions.convert_((Expression)parameterO0, (Type)javaRowClass), Expressions.convert_((Expression)parameterO1, (Type)javaRowClass)})));
        memberDeclarations.add(JavaRules.EnumUtil.overridingMethodDecl(BuiltinMethod.COMPARATOR_COMPARE.method, (Iterable<ParameterExpression>)ImmutableList.of((Object)parameterO0, (Object)parameterO1), bridgeBody.toBlock()));
        return Expressions.new_(Comparator.class, Collections.emptyList(), (Iterable)memberDeclarations);
    }

    @Override
    public RelDataType getRowType() {
        return this.rowType;
    }

    @Override
    public Expression record(List<Expression> expressions) {
        return this.format.record(this.javaRowClass, expressions);
    }

    @Override
    public Type getJavaRowType() {
        return this.javaRowClass;
    }

    @Override
    public Type getJavaFieldType(int index) {
        return this.format.javaFieldClass(this.typeFactory, this.rowType, index);
    }

    @Override
    public Expression comparer() {
        return this.format.comparer();
    }

    private List<Expression> fieldReferences(final Expression parameter, final List<Integer> fields) {
        return new AbstractList<Expression>(){

            @Override
            public Expression get(int index) {
                return PhysTypeImpl.this.fieldReference(parameter, (Integer)fields.get(index));
            }

            @Override
            public int size() {
                return fields.size();
            }
        };
    }

    @Override
    public Class fieldClass(int field) {
        return this.fieldClasses.get(field);
    }

    @Override
    public boolean fieldNullable(int field) {
        return this.rowType.getFieldList().get(field).getType().isNullable();
    }

    @Override
    public Expression generateAccessor(List<Integer> fields) {
        ParameterExpression v1 = Expressions.parameter((Type)this.javaRowClass, (String)"v1");
        switch (fields.size()) {
            case 0: {
                return Expressions.lambda(Function1.class, (Expression)Expressions.field(null, Collections.class, (String)"EMPTY_LIST"), (ParameterExpression[])new ParameterExpression[]{v1});
            }
            case 1: {
                int field0 = fields.get(0);
                Class returnType = this.fieldClasses.get(field0);
                Expression fieldReference = Types.castIfNecessary((Type)returnType, (Expression)this.fieldReference((Expression)v1, field0));
                return Expressions.lambda(Function1.class, (Expression)fieldReference, (ParameterExpression[])new ParameterExpression[]{v1});
            }
        }
        Expressions.FluentList list = Expressions.list();
        for (int field : fields) {
            list.add((Object)this.fieldReference((Expression)v1, field));
        }
        switch (list.size()) {
            case 2: {
                return Expressions.lambda(Function1.class, (Expression)Expressions.call(List.class, null, (Method)BuiltinMethod.LIST2.method, (Iterable)list), (ParameterExpression[])new ParameterExpression[]{v1});
            }
            case 3: {
                return Expressions.lambda(Function1.class, (Expression)Expressions.call(List.class, null, (Method)BuiltinMethod.LIST3.method, (Iterable)list), (ParameterExpression[])new ParameterExpression[]{v1});
            }
        }
        return Expressions.lambda(Function1.class, (Expression)Expressions.call(List.class, null, (Method)BuiltinMethod.ARRAYS_AS_LIST.method, (Expression[])new Expression[]{Expressions.newArrayInit(Object.class, (Iterable)list)}), (ParameterExpression[])new ParameterExpression[]{v1});
    }

    @Override
    public Expression fieldReference(Expression expression, int field) {
        return this.fieldReference(expression, field, null);
    }

    @Override
    public Expression fieldReference(Expression expression, int field, Type storageType) {
        if (storageType == null) {
            storageType = this.fieldClass(field);
        }
        return this.format.field(expression, field, storageType);
    }
}

