/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.jdbc;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.hydromatic.avatica.ByteString;
import net.hydromatic.linq4j.Ord;
import net.hydromatic.linq4j.expressions.Primitive;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.linq4j.function.Functions;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.jdbc.JavaRecordType;
import net.hydromatic.optiq.runtime.Unit;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactoryImpl;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.reltype.RelDataTypeFieldImpl;
import org.eigenbase.reltype.RelRecordType;
import org.eigenbase.sql.type.BasicSqlType;
import org.eigenbase.sql.type.IntervalSqlType;
import org.eigenbase.sql.type.JavaToSqlTypeConversionRules;
import org.eigenbase.sql.type.SqlTypeFactoryImpl;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTypeFactoryImpl
extends SqlTypeFactoryImpl
implements JavaTypeFactory {
    private final Map<List<Pair<Type, Boolean>>, SyntheticRecordType> syntheticTypes = new HashMap<List<Pair<Type, Boolean>>, SyntheticRecordType>();

    @Override
    public RelDataType createStructType(Class type) {
        ArrayList<RelDataTypeField> list = new ArrayList<RelDataTypeField>();
        for (Field field : type.getFields()) {
            if ((field.getModifiers() & 8) != 0) continue;
            list.add(new RelDataTypeFieldImpl(field.getName(), list.size(), this.createType(field.getType())));
        }
        return this.canonize(new JavaRecordType(list, type));
    }

    @Override
    public RelDataType createType(Type type) {
        if (type instanceof RelDataType) {
            return (RelDataType)((Object)type);
        }
        if (type instanceof SyntheticRecordType) {
            SyntheticRecordType syntheticRecordType = (SyntheticRecordType)((Object)type);
            return syntheticRecordType.relType;
        }
        if (!(type instanceof Class)) {
            throw new UnsupportedOperationException("TODO: implement " + type);
        }
        Class clazz = (Class)type;
        switch (Primitive.flavor((Type)clazz)) {
            case PRIMITIVE: {
                return this.createJavaType(clazz);
            }
            case BOX: {
                return this.createJavaType(Primitive.ofBox((Type)clazz).boxClass);
            }
        }
        if (JavaToSqlTypeConversionRules.instance().lookup(clazz) != null) {
            return this.createJavaType(clazz);
        }
        if (clazz.isArray()) {
            return this.createMultisetType(this.createType(clazz.getComponentType()), -1L);
        }
        if (List.class.isAssignableFrom(clazz)) {
            return this.createArrayType(this.createSqlType(SqlTypeName.ANY), -1L);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return this.createMapType(this.createSqlType(SqlTypeName.ANY), this.createSqlType(SqlTypeName.ANY));
        }
        return this.createStructType(clazz);
    }

    @Override
    public Type getJavaClass(RelDataType type) {
        if (type instanceof RelDataTypeFactoryImpl.JavaType) {
            RelDataTypeFactoryImpl.JavaType javaType = (RelDataTypeFactoryImpl.JavaType)type;
            return javaType.getJavaClass();
        }
        if (type.isStruct() && type.getFieldCount() == 1) {
            return this.getJavaClass(type.getFieldList().get(0).getType());
        }
        if (type instanceof BasicSqlType || type instanceof IntervalSqlType) {
            switch (type.getSqlTypeName()) {
                case VARCHAR: 
                case CHAR: {
                    return String.class;
                }
                case DATE: 
                case TIME: 
                case INTEGER: 
                case INTERVAL_YEAR_MONTH: {
                    return type.isNullable() ? Integer.class : Integer.TYPE;
                }
                case TIMESTAMP: 
                case BIGINT: 
                case INTERVAL_DAY_TIME: {
                    return type.isNullable() ? Long.class : Long.TYPE;
                }
                case SMALLINT: {
                    return type.isNullable() ? Short.class : Short.TYPE;
                }
                case TINYINT: {
                    return type.isNullable() ? Byte.class : Byte.TYPE;
                }
                case DECIMAL: {
                    return BigDecimal.class;
                }
                case BOOLEAN: {
                    return type.isNullable() ? Boolean.class : Boolean.TYPE;
                }
                case DOUBLE: {
                    return type.isNullable() ? Double.class : Double.TYPE;
                }
                case REAL: 
                case FLOAT: {
                    return type.isNullable() ? Float.class : Float.TYPE;
                }
                case BINARY: 
                case VARBINARY: {
                    return ByteString.class;
                }
                case ARRAY: {
                    return Array.class;
                }
                case ANY: {
                    return Object.class;
                }
            }
        }
        switch (type.getSqlTypeName()) {
            case ROW: {
                assert (type instanceof RelRecordType);
                if (type instanceof JavaRecordType) {
                    return ((JavaRecordType)type).clazz;
                }
                return this.createSyntheticType((RelRecordType)type);
            }
            case MAP: {
                return Map.class;
            }
            case ARRAY: 
            case MULTISET: {
                return List.class;
            }
        }
        return null;
    }

    @Override
    public RelDataType toSql(RelDataType type) {
        if (type instanceof RelRecordType) {
            return this.createStructType(Functions.adapt(type.getFieldList(), (Function1)new Function1<RelDataTypeField, RelDataType>(){

                public RelDataType apply(RelDataTypeField a0) {
                    return JavaTypeFactoryImpl.this.toSql(a0.getType());
                }
            }), type.getFieldNames());
        }
        if (type instanceof RelDataTypeFactoryImpl.JavaType) {
            return this.createTypeWithNullability(new BasicSqlType(type.getSqlTypeName()), type.isNullable());
        }
        return type;
    }

    @Override
    public Type createSyntheticType(List<Type> types) {
        if (types.isEmpty()) {
            return Unit.class;
        }
        String name = "Record" + types.size() + "_" + this.syntheticTypes.size();
        SyntheticRecordType syntheticType = new SyntheticRecordType(null, name);
        for (Ord ord : Ord.zip(types)) {
            syntheticType.fields.add(new RecordFieldImpl(syntheticType, "f" + ord.i, (Type)ord.e, !Primitive.is((Type)((Type)ord.e)), 1));
        }
        return this.register(syntheticType);
    }

    private SyntheticRecordType register(final SyntheticRecordType syntheticType) {
        AbstractList<Pair<Type, Boolean>> key = new AbstractList<Pair<Type, Boolean>>(){

            @Override
            public Pair<Type, Boolean> get(int index) {
                Types.RecordField field = syntheticType.getRecordFields().get(index);
                return Pair.of(field.getType(), field.nullable());
            }

            @Override
            public int size() {
                return syntheticType.getRecordFields().size();
            }
        };
        SyntheticRecordType syntheticType2 = this.syntheticTypes.get(key);
        if (syntheticType2 == null) {
            this.syntheticTypes.put((List<Pair<Type, Boolean>>)key, syntheticType);
            return syntheticType;
        }
        return syntheticType2;
    }

    private Type createSyntheticType(RelRecordType type) {
        String name = "Record" + type.getFieldCount() + "_" + this.syntheticTypes.size();
        SyntheticRecordType syntheticType = new SyntheticRecordType(type, name);
        for (RelDataTypeField recordField : type.getFieldList()) {
            Type javaClass = this.getJavaClass(recordField.getType());
            syntheticType.fields.add(new RecordFieldImpl(syntheticType, recordField.getName(), javaClass, recordField.getType().isNullable() && !Primitive.is((Type)javaClass), 1));
        }
        return this.register(syntheticType);
    }

    private static class RecordFieldImpl
    implements Types.RecordField {
        private final SyntheticRecordType syntheticType;
        private final String name;
        private final Type type;
        private final boolean nullable;
        private final int modifiers;

        public RecordFieldImpl(SyntheticRecordType syntheticType, String name, Type type, boolean nullable, int modifiers) {
            this.syntheticType = syntheticType;
            this.name = name;
            this.type = type;
            this.nullable = nullable;
            this.modifiers = modifiers;
            assert (syntheticType != null);
            assert (name != null);
            assert (type != null);
            assert (!nullable || !Primitive.is((Type)type)) : "type [" + type + "] can never be null";
        }

        public Type getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public boolean nullable() {
            return this.nullable;
        }

        public Object get(Object o) {
            throw new UnsupportedOperationException();
        }

        public Type getDeclaringClass() {
            return this.syntheticType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SyntheticRecordType
    implements Types.RecordType {
        final List<Types.RecordField> fields = new ArrayList<Types.RecordField>();
        final RelDataType relType;
        private final String name;

        private SyntheticRecordType(RelDataType relType, String name) {
            this.relType = relType;
            this.name = name;
            assert (relType == null || Util.isDistinct(relType.getFieldNames())) : "field names not distinct: " + relType;
        }

        public String getName() {
            return this.name;
        }

        public List<Types.RecordField> getRecordFields() {
            return this.fields;
        }

        public String toString() {
            return this.name;
        }
    }
}

