/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util;

import java.math.BigDecimal;
import org.eigenbase.util.ReflectUtil;
import org.eigenbase.util.ReflectiveVisitDispatcher;
import org.eigenbase.util.ReflectiveVisitor;
import org.junit.Assert;
import org.junit.Test;

public class ReflectVisitorTest {
    @Test
    public void testCarelessNegater() {
        CarelessNumberNegater negater = new CarelessNumberNegater();
        Number result = negater.negate(new Integer(5));
        Assert.assertEquals((long)-5L, (long)result.intValue());
    }

    @Test
    public void testCarefulNegater() {
        CarefulNumberNegater negater = new CarefulNumberNegater();
        Number result = negater.negate(new Integer(5));
        Assert.assertEquals((long)-5L, (long)result.intValue());
        Assert.assertTrue((boolean)(result instanceof Integer));
        result = negater.negate(new Long(5L));
        Assert.assertEquals((long)-5L, (long)result.longValue());
    }

    @Test
    public void testCluelessNegater() {
        CluelessNumberNegater negater = new CluelessNumberNegater();
        Number result = negater.negate(new Short(5));
        Assert.assertEquals((long)-5L, (long)result.shortValue());
        Assert.assertTrue((boolean)(result instanceof Short));
        result = negater.negate(new Integer(5));
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void testAmbiguity() {
        IndecisiveNumberNegater negater = new IndecisiveNumberNegater();
        try {
            Number result = negater.negate(new AmbiguousNumber());
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((ex.getMessage().indexOf("ambiguity") > -1 ? 1 : 0) != 0);
            return;
        }
        Assert.fail((String)"Expected failure due to ambiguity");
    }

    @Test
    public void testNonAmbiguity() {
        SomewhatIndecisiveNumberNegater negater = new SomewhatIndecisiveNumberNegater();
        Number result = negater.negate(new SomewhatAmbiguousNumber());
        Assert.assertEquals((double)0.0, (double)result.doubleValue(), (double)0.001);
    }

    public class SomewhatAmbiguousNumber
    extends AmbiguousNumber
    implements DiceyNumber {
    }

    public class AmbiguousNumber
    extends BigDecimal
    implements CrunchableNumber,
    FudgeableNumber {
        AmbiguousNumber() {
            super("0");
        }
    }

    public class SomewhatIndecisiveNumberNegater
    extends NumberNegater {
        public void visit(FudgeableNumber n) {
        }

        public void visit(AmbiguousNumber n) {
            this.result = new Double(-n.doubleValue());
        }
    }

    public class IndecisiveNumberNegater
    extends NumberNegater {
        public void visit(CrunchableNumber n) {
        }

        public void visit(FudgeableNumber n) {
        }
    }

    public class CluelessNumberNegater
    extends NumberNegater {
        public void visit(Object obj) {
            this.result = new Integer(42);
        }

        public void visit(Short s) {
            this.result = new Short(-s.shortValue());
        }
    }

    public class CarefulNumberNegater
    extends CarelessNumberNegater {
        public void visit(Integer i) {
            this.result = new Integer(-i.intValue());
        }

        public void visit(Short s) {
            this.result = new Short(-s.shortValue());
        }
    }

    public class CarelessNumberNegater
    extends NumberNegater {
        public void visit(Number n) {
            this.result = new Double(-n.doubleValue());
        }
    }

    public abstract class NumberNegater
    implements ReflectiveVisitor {
        protected Number result;
        private final ReflectiveVisitDispatcher<NumberNegater, Number> dispatcher = ReflectUtil.createDispatcher(NumberNegater.class, Number.class);

        public Number negate(Number n) {
            this.result = null;
            this.dispatcher.invokeVisitor((ReflectiveVisitor)this, (Object)n, "visit");
            return this.result;
        }

        public Number negateWithoutDispatcher(Number n) {
            this.result = null;
            ReflectUtil.invokeVisitor((ReflectiveVisitor)this, (Object)n, Number.class, (String)"visit");
            return this.result;
        }
    }

    public static interface DiceyNumber
    extends FudgeableNumber {
    }

    public static interface FudgeableNumber {
    }

    public static interface CrunchableNumber {
    }
}

