/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import org.eigenbase.rel.AggregateRel;
import org.eigenbase.rel.AggregateRelBase;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.metadata.CachingRelMetadataProvider;
import org.eigenbase.rel.metadata.ChainedRelMetadataProvider;
import org.eigenbase.rel.metadata.DefaultRelMetadataProvider;
import org.eigenbase.rel.metadata.Metadata;
import org.eigenbase.rel.metadata.ReflectiveRelMetadataProvider;
import org.eigenbase.rel.metadata.RelColumnOrigin;
import org.eigenbase.rel.metadata.RelMetadataProvider;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.test.MockRelOptPlanner;
import org.eigenbase.test.SqlToRelTestBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelMetadataTest
extends SqlToRelTestBase {
    private static final double EPSILON = 1.0E-5;
    private static final double DEFAULT_EQUAL_SELECTIVITY = 0.15;
    private static final double DEFAULT_EQUAL_SELECTIVITY_SQUARED = 0.0225;
    private static final double DEFAULT_COMP_SELECTIVITY = 0.5;
    private static final double DEFAULT_NOTNULL_SELECTIVITY = 0.9;
    private static final double DEFAULT_SELECTIVITY = 0.25;
    private static final double EMP_SIZE = 1000.0;
    private static final double DEPT_SIZE = 100.0;

    private static Matcher<? super Number> nearTo(Number v, Number epsilon) {
        return CoreMatchers.equalTo((Object)v);
    }

    private RelNode convertSql(String sql) {
        RelNode rel = this.tester.convertSqlToRel(sql);
        DefaultRelMetadataProvider provider = new DefaultRelMetadataProvider();
        rel.getCluster().setMetadataProvider((RelMetadataProvider)provider);
        return rel;
    }

    private void checkPercentageOriginalRows(String sql, double expected) {
        this.checkPercentageOriginalRows(sql, expected, 1.0E-5);
    }

    private void checkPercentageOriginalRows(String sql, double expected, double epsilon) {
        RelNode rel = this.convertSql(sql);
        Double result = RelMetadataQuery.getPercentageOriginalRows((RelNode)rel);
        Assert.assertTrue((result != null ? 1 : 0) != 0);
        Assert.assertEquals((double)expected, (double)result, (double)epsilon);
    }

    @Test
    public void testPercentageOriginalRowsTableOnly() {
        this.checkPercentageOriginalRows("select * from dept", 1.0);
    }

    @Test
    public void testPercentageOriginalRowsAgg() {
        this.checkPercentageOriginalRows("select deptno from dept group by deptno", 1.0);
    }

    @Ignore
    @Test
    public void testPercentageOriginalRowsOneFilter() {
        this.checkPercentageOriginalRows("select * from dept where deptno = 20", 0.15);
    }

    @Ignore
    @Test
    public void testPercentageOriginalRowsTwoFilters() {
        this.checkPercentageOriginalRows("select * from (select * from dept where name='X') where deptno = 20", 0.0225);
    }

    @Ignore
    @Test
    public void testPercentageOriginalRowsRedundantFilter() {
        this.checkPercentageOriginalRows("select * from (select * from dept where deptno=20) where deptno = 20", 0.15);
    }

    @Test
    public void testPercentageOriginalRowsJoin() {
        this.checkPercentageOriginalRows("select * from emp inner join dept on emp.deptno=dept.deptno", 1.0);
    }

    @Ignore
    @Test
    public void testPercentageOriginalRowsJoinTwoFilters() {
        this.checkPercentageOriginalRows("select * from (select * from emp where deptno=10) e inner join (select * from dept where deptno=10) d on e.deptno=d.deptno", 0.0225);
    }

    @Test
    public void testPercentageOriginalRowsUnionNoFilter() {
        this.checkPercentageOriginalRows("select name from dept union all select ename from emp", 1.0);
    }

    @Ignore
    @Test
    public void testPercentageOriginalRowsUnionLittleFilter() {
        this.checkPercentageOriginalRows("select name from dept where deptno=20 union all select ename from emp", 0.9227272727272727);
    }

    @Ignore
    @Test
    public void testPercentageOriginalRowsUnionBigFilter() {
        this.checkPercentageOriginalRows("select name from dept union all select ename from emp where deptno=20", 0.22727272727272727);
    }

    private Set<RelColumnOrigin> checkColumnOrigin(String sql) {
        RelNode rel = this.convertSql(sql);
        return RelMetadataQuery.getColumnOrigins((RelNode)rel, (int)0);
    }

    private void checkNoColumnOrigin(String sql) {
        Set<RelColumnOrigin> result = this.checkColumnOrigin(sql);
        Assert.assertTrue((result != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    public static void checkColumnOrigin(RelColumnOrigin rco, String expectedTableName, String expectedColumnName, boolean expectedDerived) {
        RelOptTable actualTable = rco.getOriginTable();
        List actualTableName = actualTable.getQualifiedName();
        Assert.assertEquals((Object)Iterables.getLast((Iterable)actualTableName), (Object)expectedTableName);
        Assert.assertEquals((Object)((RelDataTypeField)actualTable.getRowType().getFieldList().get(rco.getOriginColumnOrdinal())).getName(), (Object)expectedColumnName);
        Assert.assertEquals((Object)rco.isDerived(), (Object)expectedDerived);
    }

    private void checkSingleColumnOrigin(String sql, String expectedTableName, String expectedColumnName, boolean expectedDerived) {
        Set<RelColumnOrigin> result = this.checkColumnOrigin(sql);
        Assert.assertTrue((result != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)result.size());
        RelColumnOrigin rco = result.iterator().next();
        RelMetadataTest.checkColumnOrigin(rco, expectedTableName, expectedColumnName, expectedDerived);
    }

    private void checkTwoColumnOrigin(String sql, String expectedTableName1, String expectedColumnName1, String expectedTableName2, String expectedColumnName2, boolean expectedDerived) {
        Set<RelColumnOrigin> result = this.checkColumnOrigin(sql);
        Assert.assertTrue((result != null ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)result.size());
        for (RelColumnOrigin rco : result) {
            RelOptTable actualTable = rco.getOriginTable();
            List actualTableName = actualTable.getQualifiedName();
            String actualUnqualifiedName = (String)Iterables.getLast((Iterable)actualTableName);
            if (actualUnqualifiedName.equals(expectedTableName1)) {
                RelMetadataTest.checkColumnOrigin(rco, expectedTableName1, expectedColumnName1, expectedDerived);
                continue;
            }
            RelMetadataTest.checkColumnOrigin(rco, expectedTableName2, expectedColumnName2, expectedDerived);
        }
    }

    @Test
    public void testColumnOriginsTableOnly() {
        this.checkSingleColumnOrigin("select name as dname from dept", "DEPT", "NAME", false);
    }

    @Test
    public void testColumnOriginsExpression() {
        this.checkSingleColumnOrigin("select upper(name) as dname from dept", "DEPT", "NAME", true);
    }

    @Test
    public void testColumnOriginsDyadicExpression() {
        this.checkTwoColumnOrigin("select name||ename from dept,emp", "DEPT", "NAME", "EMP", "ENAME", true);
    }

    @Test
    public void testColumnOriginsConstant() {
        this.checkNoColumnOrigin("select 'Minstrelsy' as dname from dept");
    }

    @Test
    public void testColumnOriginsFilter() {
        this.checkSingleColumnOrigin("select name as dname from dept where deptno=10", "DEPT", "NAME", false);
    }

    @Test
    public void testColumnOriginsJoinLeft() {
        this.checkSingleColumnOrigin("select ename from emp,dept", "EMP", "ENAME", false);
    }

    @Test
    public void testColumnOriginsJoinRight() {
        this.checkSingleColumnOrigin("select name as dname from emp,dept", "DEPT", "NAME", false);
    }

    @Test
    public void testColumnOriginsJoinOuter() {
        this.checkSingleColumnOrigin("select name as dname from emp left outer join dept on emp.deptno = dept.deptno", "DEPT", "NAME", true);
    }

    @Test
    public void testColumnOriginsJoinFullOuter() {
        this.checkSingleColumnOrigin("select name as dname from emp full outer join dept on emp.deptno = dept.deptno", "DEPT", "NAME", true);
    }

    @Test
    public void testColumnOriginsAggKey() {
        this.checkSingleColumnOrigin("select name,count(deptno) from dept group by name", "DEPT", "NAME", false);
    }

    @Test
    public void testColumnOriginsAggReduced() {
        this.checkNoColumnOrigin("select count(deptno),name from dept group by name");
    }

    @Test
    public void testColumnOriginsAggCountNullable() {
        this.checkSingleColumnOrigin("select count(mgr),ename from emp group by ename", "EMP", "MGR", true);
    }

    @Test
    public void testColumnOriginsAggCountStar() {
        this.checkNoColumnOrigin("select count(*),name from dept group by name");
    }

    @Test
    public void testColumnOriginsValues() {
        this.checkNoColumnOrigin("values(1,2,3)");
    }

    @Test
    public void testColumnOriginsUnion() {
        this.checkTwoColumnOrigin("select name from dept union all select ename from emp", "DEPT", "NAME", "EMP", "ENAME", false);
    }

    @Test
    public void testColumnOriginsSelfUnion() {
        this.checkSingleColumnOrigin("select ename from emp union all select ename from emp", "EMP", "ENAME", false);
    }

    private void checkRowCount(String sql, double expected) {
        RelNode rel = this.convertSql(sql);
        Double result = RelMetadataQuery.getRowCount((RelNode)rel);
        Assert.assertTrue((result != null ? 1 : 0) != 0);
        Assert.assertEquals((double)expected, (double)result, (double)0.0);
    }

    @Ignore
    @Test
    public void testRowCountEmp() {
        this.checkRowCount("select * from emp", 1000.0);
    }

    @Ignore
    @Test
    public void testRowCountDept() {
        this.checkRowCount("select * from dept", 100.0);
    }

    @Ignore
    @Test
    public void testRowCountCartesian() {
        this.checkRowCount("select * from emp,dept", 100000.0);
    }

    @Ignore
    @Test
    public void testRowCountJoin() {
        this.checkRowCount("select * from emp inner join dept on emp.deptno = dept.deptno", 15000.0);
    }

    @Ignore
    @Test
    public void testRowCountUnion() {
        this.checkRowCount("select ename from emp union all select name from dept", 1100.0);
    }

    @Ignore
    @Test
    public void testRowCountFilter() {
        this.checkRowCount("select * from emp where ename='Mathilda'", 150.0);
    }

    @Ignore
    @Test
    public void testRowCountSort() {
        this.checkRowCount("select * from emp order by ename", 1000.0);
    }

    private void checkFilterSelectivity(String sql, double expected) {
        RelNode rel = this.convertSql(sql);
        Double result = RelMetadataQuery.getSelectivity((RelNode)rel, null);
        Assert.assertTrue((result != null ? 1 : 0) != 0);
        Assert.assertEquals((double)expected, (double)result, (double)1.0E-5);
    }

    @Test
    public void testSelectivityIsNotNullFilter() {
        this.checkFilterSelectivity("select * from emp where deptno is not null", 0.9);
    }

    @Test
    public void testSelectivityComparisonFilter() {
        this.checkFilterSelectivity("select * from emp where deptno > 10", 0.5);
    }

    @Test
    public void testSelectivityAndFilter() {
        this.checkFilterSelectivity("select * from emp where ename = 'foo' and deptno = 10", 0.0225);
    }

    @Test
    public void testSelectivityOrFilter() {
        this.checkFilterSelectivity("select * from emp where ename = 'foo' or deptno = 10", 0.25);
    }

    private void checkRelSelectivity(RelNode rel, double expected) {
        Double result = RelMetadataQuery.getSelectivity((RelNode)rel, null);
        Assert.assertTrue((result != null ? 1 : 0) != 0);
        Assert.assertEquals((double)expected, (double)result, (double)1.0E-5);
    }

    @Test
    public void testSelectivityRedundantFilter() {
        RelNode rel = this.convertSql("select * from emp where deptno = 10");
        this.checkRelSelectivity(rel, 0.15);
    }

    @Test
    public void testSelectivitySort() {
        RelNode rel = this.convertSql("select * from emp where deptno = 10order by ename");
        this.checkRelSelectivity(rel, 0.15);
    }

    @Test
    public void testSelectivityUnion() {
        RelNode rel = this.convertSql("select * from (select * from emp union all select * from emp) where deptno = 10");
        this.checkRelSelectivity(rel, 0.15);
    }

    @Test
    public void testSelectivityAgg() {
        RelNode rel = this.convertSql("select deptno, count(*) from emp where deptno > 10 group by deptno having count(*) = 0");
        this.checkRelSelectivity(rel, 0.075);
    }

    @Test
    public void testSelectivityAggCached() {
        RelNode rel = this.convertSql("select deptno, count(*) from emp where deptno > 10 group by deptno having count(*) = 0");
        rel.getCluster().setMetadataProvider((RelMetadataProvider)new CachingRelMetadataProvider(rel.getCluster().getMetadataProvider(), rel.getCluster().getPlanner()));
        Double result = RelMetadataQuery.getSelectivity((RelNode)rel, null);
        Assert.assertThat((Object)result, RelMetadataTest.nearTo(0.075, 1.0E-5));
    }

    @Test
    public void testDistinctRowCountTable() {
        BitSet groupKey;
        RelNode rel = this.convertSql("select * from emp where deptno = 10");
        Double result = RelMetadataQuery.getDistinctRowCount((RelNode)rel, (BitSet)(groupKey = new BitSet()), null);
        Assert.assertTrue((result == null ? 1 : 0) != 0);
    }

    @Test
    public void testCustomProvider() {
        ArrayList buf = new ArrayList();
        ColTypeImpl.THREAD_LIST.set(buf);
        RelNode rel = this.convertSql("select deptno, count(*) from emp where deptno > 10 group by deptno having count(*) = 0");
        rel.getCluster().setMetadataProvider(ChainedRelMetadataProvider.of((List)ImmutableList.of((Object)ColTypeImpl.SOURCE, (Object)rel.getCluster().getMetadataProvider())));
        Assert.assertThat((Object)rel, (Matcher)CoreMatchers.instanceOf(FilterRel.class));
        Assert.assertThat((Object)((ColType)rel.metadata(ColType.class)).getColType(0), (Matcher)CoreMatchers.equalTo((Object)"DEPTNO-rel"));
        Assert.assertThat((Object)((ColType)rel.metadata(ColType.class)).getColType(1), (Matcher)CoreMatchers.equalTo((Object)"EXPR$1-rel"));
        RelNode input = rel.getInput(0);
        Assert.assertThat((Object)input, (Matcher)CoreMatchers.instanceOf(AggregateRel.class));
        Assert.assertThat((Object)((ColType)input.metadata(ColType.class)).getColType(0), (Matcher)CoreMatchers.equalTo((Object)"DEPTNO-agg"));
        Assert.assertThat((Object)((Object)buf).toString(), (Matcher)CoreMatchers.equalTo((Object)"[DEPTNO-rel, EXPR$1-rel, DEPTNO-agg]"));
        Assert.assertThat((Object)buf.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        Assert.assertThat((Object)((ColType)input.metadata(ColType.class)).getColType(0), (Matcher)CoreMatchers.equalTo((Object)"DEPTNO-agg"));
        Assert.assertThat((Object)buf.size(), (Matcher)CoreMatchers.equalTo((Object)4));
        RelOptPlanner planner = rel.getCluster().getPlanner();
        rel.getCluster().setMetadataProvider((RelMetadataProvider)new CachingRelMetadataProvider(rel.getCluster().getMetadataProvider(), planner));
        Assert.assertThat((Object)((ColType)input.metadata(ColType.class)).getColType(0), (Matcher)CoreMatchers.equalTo((Object)"DEPTNO-agg"));
        Assert.assertThat((Object)buf.size(), (Matcher)CoreMatchers.equalTo((Object)5));
        Assert.assertThat((Object)((ColType)input.metadata(ColType.class)).getColType(0), (Matcher)CoreMatchers.equalTo((Object)"DEPTNO-agg"));
        Assert.assertThat((Object)buf.size(), (Matcher)CoreMatchers.equalTo((Object)5));
        Assert.assertThat((Object)((ColType)input.metadata(ColType.class)).getColType(1), (Matcher)CoreMatchers.equalTo((Object)"EXPR$1-agg"));
        Assert.assertThat((Object)buf.size(), (Matcher)CoreMatchers.equalTo((Object)6));
        Assert.assertThat((Object)((ColType)input.metadata(ColType.class)).getColType(1), (Matcher)CoreMatchers.equalTo((Object)"EXPR$1-agg"));
        Assert.assertThat((Object)buf.size(), (Matcher)CoreMatchers.equalTo((Object)6));
        Assert.assertThat((Object)((ColType)input.metadata(ColType.class)).getColType(0), (Matcher)CoreMatchers.equalTo((Object)"DEPTNO-agg"));
        Assert.assertThat((Object)buf.size(), (Matcher)CoreMatchers.equalTo((Object)6));
        long timestamp = planner.getRelMetadataTimestamp(rel);
        Assert.assertThat((Object)timestamp, (Matcher)CoreMatchers.equalTo((Object)0L));
        ((MockRelOptPlanner)planner).setRelMetadataTimestamp(timestamp + 1L);
        Assert.assertThat((Object)((ColType)input.metadata(ColType.class)).getColType(0), (Matcher)CoreMatchers.equalTo((Object)"DEPTNO-agg"));
        Assert.assertThat((Object)buf.size(), (Matcher)CoreMatchers.equalTo((Object)7));
        Assert.assertThat((Object)((ColType)input.metadata(ColType.class)).getColType(0), (Matcher)CoreMatchers.equalTo((Object)"DEPTNO-agg"));
        Assert.assertThat((Object)buf.size(), (Matcher)CoreMatchers.equalTo((Object)7));
    }

    public static class ColTypeImpl {
        static final ThreadLocal<List<String>> THREAD_LIST = new ThreadLocal();
        static final Method METHOD;
        public static final RelMetadataProvider SOURCE;

        public String getColType(AggregateRelBase rel, int column) {
            String name = ((RelDataTypeField)rel.getRowType().getFieldList().get(column)).getName() + "-agg";
            THREAD_LIST.get().add(name);
            return name;
        }

        public String getColType(RelNode rel, int column) {
            String name = ((RelDataTypeField)rel.getRowType().getFieldList().get(column)).getName() + "-rel";
            THREAD_LIST.get().add(name);
            return name;
        }

        static {
            try {
                METHOD = ColType.class.getMethod("getColType", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)METHOD, (Object)new ColTypeImpl());
        }
    }

    public static interface ColType
    extends Metadata {
        public String getColType(int var1);
    }
}

