/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;

public abstract class EigenbaseTestCase {
    protected EigenbaseTestCase() {
    }

    protected static void assertEqualsDeep(Object o, Object o2) {
        if (o instanceof Object[] && o2 instanceof Object[]) {
            Object[] a = (Object[])o;
            Object[] a2 = (Object[])o2;
            Assert.assertEquals((long)a.length, (long)a2.length);
            for (int i = 0; i < a.length; ++i) {
                EigenbaseTestCase.assertEqualsDeep(a[i], a2[i]);
            }
            return;
        }
        if (o != null && o2 != null && o.getClass().isArray() && o.getClass() == o2.getClass()) {
            boolean eq = o instanceof boolean[] ? Arrays.equals((boolean[])o, (boolean[])o2) : (o instanceof byte[] ? Arrays.equals((byte[])o, (byte[])o2) : (o instanceof char[] ? Arrays.equals((char[])o, (char[])o2) : (o instanceof short[] ? Arrays.equals((short[])o, (short[])o2) : (o instanceof int[] ? Arrays.equals((int[])o, (int[])o2) : (o instanceof long[] ? Arrays.equals((long[])o, (long[])o2) : (o instanceof float[] ? Arrays.equals((float[])o, (float[])o2) : (o instanceof double[] ? Arrays.equals((double[])o, (double[])o2) : false)))))));
            if (!eq) {
                Assert.fail((String)"arrays not equal");
            }
        } else {
            Assert.assertEquals((Object)o, (Object)o2);
        }
    }

    protected void assertThrowableContains(Throwable throwable, String pattern) {
        String message;
        if (throwable == null) {
            Assert.fail((String)("expected exception containing pattern <" + pattern + "> but got none"));
        }
        if ((message = throwable.getMessage()) == null || message.indexOf(pattern) < 0) {
            Assert.fail((String)("expected pattern <" + pattern + "> in exception <" + throwable + ">"));
        }
    }

    public static Iterator makeIterator(Object[] a) {
        return Arrays.asList(a).iterator();
    }

    protected void assertEquals(Iterator iterator, Object[] a) {
        ArrayList list = new ArrayList();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        this.assertEquals(list, a);
    }

    protected void assertEquals(List list, Object[] a) {
        Object[] b = list.toArray();
        this.assertEquals(a, b);
    }

    protected void assertEquals(Object[] expected, Object[] actual) {
        Assert.assertTrue((expected.length == actual.length ? 1 : 0) != 0);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)actual[i]);
        }
    }

    protected void assertEquals(Object[] expected, Object actual) {
        if (actual instanceof Object[]) {
            this.assertEquals(expected, (Object[])actual);
        } else {
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }
}

