/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.test;

import com.google.common.collect.ImmutableMap;
import net.hydromatic.avatica.Casing;
import net.hydromatic.avatica.Quoting;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.SqlOperatorTable;
import org.eigenbase.sql.advise.SqlAdvisor;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.parser.SqlParser;
import org.eigenbase.sql.parser.SqlParserImplFactory;
import org.eigenbase.sql.parser.impl.SqlParserImpl;
import org.eigenbase.sql.test.SqlTestFactory;
import org.eigenbase.sql.type.SqlTypeFactoryImpl;
import org.eigenbase.sql.validate.SqlConformance;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorCatalogReader;
import org.eigenbase.sql.validate.SqlValidatorUtil;
import org.eigenbase.sql.validate.SqlValidatorWithHints;
import org.eigenbase.test.MockCatalogReader;
import org.eigenbase.test.MockSqlOperatorTable;

public class DefaultSqlTestFactory
implements SqlTestFactory {
    public static final ImmutableMap<String, Object> DEFAULT_OPTIONS = ImmutableMap.of((Object)"quoting", (Object)Quoting.DOUBLE_QUOTE, (Object)"quotedCasing", (Object)Casing.UNCHANGED, (Object)"unquotedCasing", (Object)Casing.TO_UPPER, (Object)"caseSensitive", (Object)true, (Object)"conformance", (Object)SqlConformance.DEFAULT);
    public static final DefaultSqlTestFactory INSTANCE = new DefaultSqlTestFactory();

    private DefaultSqlTestFactory() {
    }

    public SqlOperatorTable createOperatorTable() {
        MockSqlOperatorTable opTab = new MockSqlOperatorTable((SqlOperatorTable)SqlStdOperatorTable.instance());
        MockSqlOperatorTable.addRamp(opTab);
        return opTab;
    }

    public SqlParser createParser(SqlTestFactory factory, String sql) {
        Quoting quoting = (Quoting)factory.get("quoting");
        Casing quotedCasing = (Casing)factory.get("quotedCasing");
        Casing unquotedCasing = (Casing)factory.get("unquotedCasing");
        return SqlParser.create((SqlParserImplFactory)SqlParserImpl.FACTORY, (String)sql, (Quoting)quoting, (Casing)unquotedCasing, (Casing)quotedCasing);
    }

    public SqlValidator getValidator(SqlTestFactory factory) {
        SqlOperatorTable operatorTable = factory.createOperatorTable();
        boolean caseSensitive = (Boolean)factory.get("caseSensitive");
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl();
        return SqlValidatorUtil.newValidator((SqlOperatorTable)operatorTable, (SqlValidatorCatalogReader)new MockCatalogReader((RelDataTypeFactory)typeFactory, caseSensitive).init(), (RelDataTypeFactory)typeFactory);
    }

    public SqlAdvisor createAdvisor(SqlValidatorWithHints validator) {
        throw new UnsupportedOperationException();
    }

    public Object get(String name) {
        return DEFAULT_OPTIONS.get((Object)name);
    }
}

