/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt.volcano;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.hydromatic.optiq.rules.java.EnumerableConvention;
import org.eigenbase.rel.AbstractRelNode;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.rel.SingleRel;
import org.eigenbase.rel.convert.ConverterRelImpl;
import org.eigenbase.rel.convert.ConverterRule;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.ConventionTraitDef;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperandChildren;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTrait;
import org.eigenbase.relopt.RelTraitDef;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.relopt.volcano.VolcanoPlanner;
import org.eigenbase.relopt.volcano.VolcanoPlannerTest;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.util.Pair;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class VolcanoPlannerTraitTest {
    private static final Convention PHYS_CALLING_CONVENTION = new Convention.Impl("PHYS", RelNode.class);
    private static final AltTraitDef ALT_TRAIT_DEF = new AltTraitDef();
    private static final AltTrait ALT_TRAIT = new AltTrait(ALT_TRAIT_DEF, "ALT");
    private static final AltTrait ALT_TRAIT2 = new AltTrait(ALT_TRAIT_DEF, "ALT2");
    private static int altTraitOrdinal = 0;

    @Ignore
    @Test
    public void testDoubleConversion() {
        VolcanoPlanner planner = new VolcanoPlanner();
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRelTraitDef((RelTraitDef)ALT_TRAIT_DEF);
        planner.addRule((RelOptRule)new PhysToIteratorConverterRule());
        planner.addRule((RelOptRule)new AltTraitConverterRule(ALT_TRAIT, ALT_TRAIT2, "AltToAlt2ConverterRule"));
        planner.addRule((RelOptRule)new PhysLeafRule());
        planner.addRule((RelOptRule)new IterSingleRule());
        RelOptCluster cluster = VolcanoPlannerTest.newCluster(planner);
        NoneLeafRel noneLeafRel = (NoneLeafRel)RelOptUtil.addTrait((RelNode)new NoneLeafRel(cluster, "noneLeafRel"), (RelTrait)ALT_TRAIT);
        NoneSingleRel noneRel = (NoneSingleRel)RelOptUtil.addTrait((RelNode)new NoneSingleRel(cluster, (RelNode)noneLeafRel), (RelTrait)ALT_TRAIT2);
        RelNode convertedRel = planner.changeTraits((RelNode)noneRel, cluster.traitSetOf(new RelTrait[]{EnumerableConvention.INSTANCE, ALT_TRAIT2}));
        planner.setRoot(convertedRel);
        RelNode result = planner.chooseDelegate().findBestExp();
        Assert.assertTrue((boolean)(result instanceof IterSingleRel));
        Assert.assertEquals((Object)EnumerableConvention.INSTANCE, (Object)result.getTraitSet().getTrait((RelTraitDef)ConventionTraitDef.INSTANCE));
        Assert.assertEquals((Object)ALT_TRAIT2, (Object)result.getTraitSet().getTrait((RelTraitDef)ALT_TRAIT_DEF));
        RelNode child = (RelNode)result.getInputs().get(0);
        Assert.assertTrue((child instanceof AltTraitConverter || child instanceof PhysToIteratorConverter ? 1 : 0) != 0);
        child = (RelNode)child.getInputs().get(0);
        Assert.assertTrue((child instanceof AltTraitConverter || child instanceof PhysToIteratorConverter ? 1 : 0) != 0);
        child = (RelNode)child.getInputs().get(0);
        Assert.assertTrue((boolean)(child instanceof PhysLeafRel));
    }

    @Ignore
    @Test
    public void testTraitPropagation() {
        VolcanoPlanner planner = new VolcanoPlanner();
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRelTraitDef((RelTraitDef)ALT_TRAIT_DEF);
        planner.addRule((RelOptRule)new PhysToIteratorConverterRule());
        planner.addRule((RelOptRule)new AltTraitConverterRule(ALT_TRAIT, ALT_TRAIT2, "AltToAlt2ConverterRule"));
        planner.addRule((RelOptRule)new PhysLeafRule());
        planner.addRule((RelOptRule)new IterSingleRule2());
        RelOptCluster cluster = VolcanoPlannerTest.newCluster(planner);
        NoneLeafRel noneLeafRel = (NoneLeafRel)RelOptUtil.addTrait((RelNode)new NoneLeafRel(cluster, "noneLeafRel"), (RelTrait)ALT_TRAIT);
        NoneSingleRel noneRel = (NoneSingleRel)RelOptUtil.addTrait((RelNode)new NoneSingleRel(cluster, (RelNode)noneLeafRel), (RelTrait)ALT_TRAIT2);
        RelNode convertedRel = planner.changeTraits((RelNode)noneRel, cluster.traitSetOf(new RelTrait[]{EnumerableConvention.INSTANCE, ALT_TRAIT2}));
        planner.setRoot(convertedRel);
        RelNode result = planner.chooseDelegate().findBestExp();
        Assert.assertTrue((boolean)(result instanceof IterSingleRel));
        Assert.assertEquals((Object)EnumerableConvention.INSTANCE, (Object)result.getTraitSet().getTrait((RelTraitDef)ConventionTraitDef.INSTANCE));
        Assert.assertEquals((Object)ALT_TRAIT2, (Object)result.getTraitSet().getTrait((RelTraitDef)ALT_TRAIT_DEF));
        RelNode child = (RelNode)result.getInputs().get(0);
        Assert.assertTrue((boolean)(child instanceof IterSingleRel));
        Assert.assertEquals((Object)EnumerableConvention.INSTANCE, (Object)child.getTraitSet().getTrait((RelTraitDef)ConventionTraitDef.INSTANCE));
        Assert.assertEquals((Object)ALT_TRAIT2, (Object)child.getTraitSet().getTrait((RelTraitDef)ALT_TRAIT_DEF));
        child = (RelNode)child.getInputs().get(0);
        Assert.assertTrue((child instanceof AltTraitConverter || child instanceof PhysToIteratorConverter ? 1 : 0) != 0);
        child = (RelNode)child.getInputs().get(0);
        Assert.assertTrue((child instanceof AltTraitConverter || child instanceof PhysToIteratorConverter ? 1 : 0) != 0);
        child = (RelNode)child.getInputs().get(0);
        Assert.assertTrue((boolean)(child instanceof PhysLeafRel));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PhysToIteratorConverter
    extends ConverterRelImpl {
        public PhysToIteratorConverter(RelOptCluster cluster, RelNode child) {
            super(cluster, (RelTraitDef)ConventionTraitDef.INSTANCE, child.getTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE), child);
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new PhysToIteratorConverter(this.getCluster(), (RelNode)PhysToIteratorConverter.sole(inputs));
        }
    }

    private static class PhysToIteratorConverterRule
    extends ConverterRule {
        public PhysToIteratorConverterRule() {
            super(RelNode.class, (RelTrait)PHYS_CALLING_CONVENTION, (RelTrait)EnumerableConvention.INSTANCE, "PhysToIteratorRule");
        }

        public RelNode convert(RelNode rel) {
            return new PhysToIteratorConverter(rel.getCluster(), rel);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AltTraitConverter
    extends ConverterRelImpl {
        private final RelTrait toTrait;

        private AltTraitConverter(RelOptCluster cluster, RelNode child, RelTrait toTrait) {
            super(cluster, toTrait.getTraitDef(), child.getTraitSet().replace(toTrait), child);
            this.toTrait = toTrait;
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new AltTraitConverter(this.getCluster(), (RelNode)AltTraitConverter.sole(inputs), this.toTrait);
        }
    }

    private static class AltTraitConverterRule
    extends ConverterRule {
        private final RelTrait toTrait;

        private AltTraitConverterRule(AltTrait fromTrait, AltTrait toTrait, String description) {
            super(RelNode.class, (RelTrait)fromTrait, (RelTrait)toTrait, description);
            this.toTrait = toTrait;
        }

        public RelNode convert(RelNode rel) {
            return new AltTraitConverter(rel.getCluster(), rel, this.toTrait);
        }

        public boolean isGuaranteed() {
            return true;
        }
    }

    private static class IterSingleRule2
    extends RelOptRule {
        IterSingleRule2() {
            super(IterSingleRule2.operand(NoneSingleRel.class, (RelOptRuleOperandChildren)IterSingleRule2.any()));
        }

        public Convention getOutConvention() {
            return EnumerableConvention.INSTANCE;
        }

        public RelTrait getOutTrait() {
            return this.getOutConvention();
        }

        public void onMatch(RelOptRuleCall call) {
            NoneSingleRel rel = (NoneSingleRel)call.rel(0);
            RelNode converted = IterSingleRule2.convert((RelNode)rel.getInput(0), (RelTraitSet)rel.getTraitSet().replace(this.getOutTrait()));
            IterSingleRel child = new IterSingleRel(rel.getCluster(), converted);
            call.transformTo((RelNode)new IterSingleRel(rel.getCluster(), (RelNode)child));
        }
    }

    private static class IterSingleRule
    extends RelOptRule {
        IterSingleRule() {
            super(IterSingleRule.operand(NoneSingleRel.class, (RelOptRuleOperandChildren)IterSingleRule.any()));
        }

        public Convention getOutConvention() {
            return EnumerableConvention.INSTANCE;
        }

        public RelTrait getOutTrait() {
            return this.getOutConvention();
        }

        public void onMatch(RelOptRuleCall call) {
            NoneSingleRel rel = (NoneSingleRel)call.rel(0);
            RelNode converted = IterSingleRule.convert((RelNode)rel.getInput(0), (RelTraitSet)rel.getTraitSet().replace(this.getOutTrait()));
            call.transformTo((RelNode)new IterSingleRel(rel.getCluster(), converted));
        }
    }

    private static class PhysLeafRule
    extends RelOptRule {
        PhysLeafRule() {
            super(PhysLeafRule.operand(NoneLeafRel.class, (RelOptRuleOperandChildren)PhysLeafRule.any()));
        }

        public Convention getOutConvention() {
            return PHYS_CALLING_CONVENTION;
        }

        public void onMatch(RelOptRuleCall call) {
            NoneLeafRel leafRel = (NoneLeafRel)call.rel(0);
            call.transformTo((RelNode)new PhysLeafRel(leafRel.getCluster(), leafRel.getLabel()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IterSingleRel
    extends TestSingleRel
    implements FooRel {
        public IterSingleRel(RelOptCluster cluster, RelNode child) {
            super(cluster, cluster.traitSetOf(new RelTrait[]{EnumerableConvention.INSTANCE}), child);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner) {
            return planner.getCostFactory().makeTinyCost();
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (traitSet.comprises(new RelTrait[]{EnumerableConvention.INSTANCE}));
            return new IterSingleRel(this.getCluster(), (RelNode)IterSingleRel.sole(inputs));
        }

        @Override
        public String implement(FooRelImplementor implementor) {
            return null;
        }
    }

    static interface FooRelImplementor {
    }

    static interface FooRel {
        public String implement(FooRelImplementor var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoneSingleRel
    extends TestSingleRel {
        protected NoneSingleRel(RelOptCluster cluster, RelNode child) {
            this(cluster, cluster.traitSetOf(new RelTrait[]{Convention.NONE}), child);
        }

        protected NoneSingleRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child) {
            super(cluster, traitSet, child);
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new NoneSingleRel(this.getCluster(), traitSet, (RelNode)NoneSingleRel.sole(inputs));
        }
    }

    private static abstract class TestSingleRel
    extends SingleRel {
        protected TestSingleRel(RelOptCluster cluster, RelTraitSet traits, RelNode child) {
            super(cluster, traits, child);
        }

        public RelOptCost computeSelfCost(RelOptPlanner planner) {
            return planner.getCostFactory().makeInfiniteCost();
        }

        protected RelDataType deriveRowType() {
            return this.getChild().getRowType();
        }
    }

    private static class PhysLeafRel
    extends TestLeafRel {
        PhysLeafRel(RelOptCluster cluster, String label) {
            super(cluster, cluster.traitSetOf(new RelTrait[]{PHYS_CALLING_CONVENTION}), label);
        }

        public RelOptCost computeSelfCost(RelOptPlanner planner) {
            return planner.getCostFactory().makeTinyCost();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoneLeafRel
    extends TestLeafRel {
        protected NoneLeafRel(RelOptCluster cluster, String label) {
            super(cluster, cluster.traitSetOf(new RelTrait[]{Convention.NONE}), label);
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new NoneLeafRel(this.getCluster(), this.getLabel());
        }
    }

    private static abstract class TestLeafRel
    extends AbstractRelNode {
        private String label;

        protected TestLeafRel(RelOptCluster cluster, RelTraitSet traits, String label) {
            super(cluster, traits);
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public RelOptCost computeSelfCost(RelOptPlanner planner) {
            return planner.getCostFactory().makeInfiniteCost();
        }

        protected RelDataType deriveRowType() {
            RelDataTypeFactory typeFactory = this.getCluster().getTypeFactory();
            return typeFactory.builder().add("this", typeFactory.createJavaType(Void.TYPE)).build();
        }

        public RelWriter explainTerms(RelWriter pw) {
            return super.explainTerms(pw).item("label", (Object)this.label);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AltTraitDef
    extends RelTraitDef<AltTrait> {
        private Multimap<RelTrait, Pair<RelTrait, ConverterRule>> conversionMap = HashMultimap.create();

        private AltTraitDef() {
        }

        public Class<AltTrait> getTraitClass() {
            return AltTrait.class;
        }

        public String getSimpleName() {
            return "alt_phys";
        }

        public AltTrait getDefault() {
            return ALT_TRAIT;
        }

        public RelNode convert(RelOptPlanner planner, RelNode rel, AltTrait toTrait, boolean allowInfiniteCostConverters) {
            RelTrait fromTrait = rel.getTraitSet().getTrait((RelTraitDef)this);
            if (this.conversionMap.containsKey((Object)fromTrait)) {
                for (Pair traitAndRule : this.conversionMap.get((Object)fromTrait)) {
                    RelNode converted;
                    RelTrait trait = (RelTrait)traitAndRule.left;
                    ConverterRule rule = (ConverterRule)traitAndRule.right;
                    if (trait != toTrait || (converted = rule.convert(rel)) == null || planner.getCost(converted).isInfinite() && !allowInfiniteCostConverters) continue;
                    return converted;
                }
            }
            return null;
        }

        public boolean canConvert(RelOptPlanner planner, AltTrait fromTrait, AltTrait toTrait) {
            if (this.conversionMap.containsKey((Object)fromTrait)) {
                for (Pair traitAndRule : this.conversionMap.get((Object)fromTrait)) {
                    if (traitAndRule.left != toTrait) continue;
                    return true;
                }
            }
            return false;
        }

        public void registerConverterRule(RelOptPlanner planner, ConverterRule converterRule) {
            if (!converterRule.isGuaranteed()) {
                return;
            }
            RelTrait fromTrait = converterRule.getInTrait();
            RelTrait toTrait = converterRule.getOutTrait();
            this.conversionMap.put((Object)fromTrait, (Object)new Pair((Object)toTrait, (Object)converterRule));
        }
    }

    private static class AltTrait
    implements RelTrait {
        private final AltTraitDef traitDef;
        private final int ordinal;
        private final String description;

        private AltTrait(AltTraitDef traitDef, String description) {
            this.traitDef = traitDef;
            this.description = description;
            this.ordinal = altTraitOrdinal++;
        }

        public void register(RelOptPlanner planner) {
        }

        public RelTraitDef getTraitDef() {
            return this.traitDef;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof AltTrait)) {
                return false;
            }
            AltTrait that = (AltTrait)other;
            return this.ordinal == that.ordinal;
        }

        public int hashCode() {
            return this.ordinal;
        }

        public boolean subsumes(RelTrait trait) {
            return this.equals(trait);
        }

        public String toString() {
            return this.description;
        }
    }
}

