/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt.volcano;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.hydromatic.optiq.rules.java.EnumerableConvention;
import org.eigenbase.rel.AbstractRelNode;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.rel.SingleRel;
import org.eigenbase.rel.convert.ConverterRelImpl;
import org.eigenbase.rel.convert.ConverterRule;
import org.eigenbase.rel.rules.RemoveTrivialProjectRule;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.ConventionTraitDef;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptListener;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptQuery;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelOptRuleOperandChildren;
import org.eigenbase.relopt.RelTrait;
import org.eigenbase.relopt.RelTraitDef;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.relopt.volcano.RelSubset;
import org.eigenbase.relopt.volcano.VolcanoPlanner;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.sql.type.SqlTypeFactoryImpl;
import org.eigenbase.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VolcanoPlannerTest {
    private static final Convention PHYS_CALLING_CONVENTION = new Convention.Impl("PHYS", RelNode.class);

    static RelOptCluster newCluster(VolcanoPlanner planner) {
        RelOptQuery query = new RelOptQuery((RelOptPlanner)planner);
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl();
        return query.createCluster((RelDataTypeFactory)typeFactory, new RexBuilder((RelDataTypeFactory)typeFactory));
    }

    @Test
    public void testTransformLeaf() {
        VolcanoPlanner planner = new VolcanoPlanner();
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRule((RelOptRule)new PhysLeafRule());
        RelOptCluster cluster = VolcanoPlannerTest.newCluster(planner);
        NoneLeafRel leafRel = new NoneLeafRel(cluster, "a");
        RelNode convertedRel = planner.changeTraits((RelNode)leafRel, cluster.traitSetOf(new RelTrait[]{PHYS_CALLING_CONVENTION}));
        planner.setRoot(convertedRel);
        RelNode result = planner.chooseDelegate().findBestExp();
        Assert.assertTrue((boolean)(result instanceof PhysLeafRel));
    }

    @Test
    public void testTransformSingleGood() {
        VolcanoPlanner planner = new VolcanoPlanner();
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRule((RelOptRule)new PhysLeafRule());
        planner.addRule((RelOptRule)new GoodSingleRule());
        RelOptCluster cluster = VolcanoPlannerTest.newCluster(planner);
        NoneLeafRel leafRel = new NoneLeafRel(cluster, "a");
        NoneSingleRel singleRel = new NoneSingleRel(cluster, (RelNode)leafRel);
        RelNode convertedRel = planner.changeTraits((RelNode)singleRel, cluster.traitSetOf(new RelTrait[]{PHYS_CALLING_CONVENTION}));
        planner.setRoot(convertedRel);
        RelNode result = planner.chooseDelegate().findBestExp();
        Assert.assertTrue((boolean)(result instanceof PhysSingleRel));
    }

    @Test
    public void testSubsetRule() {
        VolcanoPlanner planner = new VolcanoPlanner();
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRule((RelOptRule)new PhysLeafRule());
        planner.addRule((RelOptRule)new GoodSingleRule());
        ArrayList<String> buf = new ArrayList<String>();
        planner.addRule((RelOptRule)new SubsetRule(buf));
        RelOptCluster cluster = VolcanoPlannerTest.newCluster(planner);
        NoneLeafRel leafRel = new NoneLeafRel(cluster, "a");
        NoneSingleRel singleRel = new NoneSingleRel(cluster, (RelNode)leafRel);
        RelNode convertedRel = planner.changeTraits((RelNode)singleRel, cluster.traitSetOf(new RelTrait[]{PHYS_CALLING_CONVENTION}));
        planner.setRoot(convertedRel);
        RelNode result = planner.chooseDelegate().findBestExp();
        Assert.assertTrue((boolean)(result instanceof PhysSingleRel));
        Assert.assertThat(VolcanoPlannerTest.sort(buf), (Matcher)CoreMatchers.equalTo((Object)VolcanoPlannerTest.sort((Comparable[])new String[]{"NoneSingleRel:Subset#0.NONE", "PhysSingleRel:Subset#0.NONE", "PhysSingleRel:Subset#0.PHYS"})));
    }

    private static <E extends Comparable> List<E> sort(List<E> list) {
        ArrayList<E> list2 = new ArrayList<E>(list);
        Collections.sort(list2);
        return list2;
    }

    private static <E extends Comparable> List<E> sort(E ... es) {
        return VolcanoPlannerTest.sort(Arrays.asList(es));
    }

    @Ignore
    @Test
    public void testTransformSingleReformed() {
        VolcanoPlanner planner = new VolcanoPlanner();
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRule((RelOptRule)new PhysLeafRule());
        planner.addRule((RelOptRule)new ReformedSingleRule());
        RelOptCluster cluster = VolcanoPlannerTest.newCluster(planner);
        NoneLeafRel leafRel = new NoneLeafRel(cluster, "a");
        NoneSingleRel singleRel = new NoneSingleRel(cluster, (RelNode)leafRel);
        RelNode convertedRel = planner.changeTraits((RelNode)singleRel, cluster.traitSetOf(new RelTrait[]{PHYS_CALLING_CONVENTION}));
        planner.setRoot(convertedRel);
        RelNode result = planner.chooseDelegate().findBestExp();
        Assert.assertTrue((boolean)(result instanceof PhysSingleRel));
    }

    private void removeTrivialProject(boolean useRule) {
        VolcanoPlanner planner = new VolcanoPlanner();
        planner.ambitious = true;
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        if (useRule) {
            planner.addRule((RelOptRule)RemoveTrivialProjectRule.INSTANCE);
        }
        planner.addRule((RelOptRule)new PhysLeafRule());
        planner.addRule((RelOptRule)new GoodSingleRule());
        planner.addRule((RelOptRule)new PhysProjectRule());
        planner.addRule((RelOptRule)new ConverterRule(RelNode.class, (RelTrait)PHYS_CALLING_CONVENTION, (RelTrait)EnumerableConvention.INSTANCE, "PhysToIteratorRule"){

            public RelNode convert(RelNode rel) {
                return new PhysToIteratorConverter(rel.getCluster(), rel);
            }
        });
        RelOptCluster cluster = VolcanoPlannerTest.newCluster(planner);
        PhysLeafRel leafRel = new PhysLeafRel(cluster, "a");
        RexInputRef inputRef = RexInputRef.of((int)0, (RelDataType)leafRel.getRowType());
        RelNode projectRel = CalcRel.createProject((RelNode)leafRel, Collections.singletonList(inputRef), Collections.singletonList("this"));
        NoneSingleRel singleRel = new NoneSingleRel(cluster, projectRel);
        RelNode convertedRel = planner.changeTraits((RelNode)singleRel, cluster.traitSetOf(new RelTrait[]{EnumerableConvention.INSTANCE}));
        planner.setRoot(convertedRel);
        RelNode result = planner.chooseDelegate().findBestExp();
        Assert.assertTrue((boolean)(result instanceof PhysToIteratorConverter));
    }

    @Test
    public void testWithRemoveTrivialProject() {
        this.removeTrivialProject(true);
    }

    @Test
    public void testWithoutRemoveTrivialProject() {
        this.removeTrivialProject(false);
    }

    @Ignore
    @Test
    public void testRemoveSingleReformed() {
        VolcanoPlanner planner = new VolcanoPlanner();
        planner.ambitious = true;
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRule((RelOptRule)new PhysLeafRule());
        planner.addRule((RelOptRule)new ReformedRemoveSingleRule());
        RelOptCluster cluster = VolcanoPlannerTest.newCluster(planner);
        NoneLeafRel leafRel = new NoneLeafRel(cluster, "a");
        NoneSingleRel singleRel = new NoneSingleRel(cluster, (RelNode)leafRel);
        RelNode convertedRel = planner.changeTraits((RelNode)singleRel, cluster.traitSetOf(new RelTrait[]{PHYS_CALLING_CONVENTION}));
        planner.setRoot(convertedRel);
        RelNode result = planner.chooseDelegate().findBestExp();
        Assert.assertTrue((boolean)(result instanceof PhysLeafRel));
        PhysLeafRel resultLeaf = (PhysLeafRel)result;
        Assert.assertEquals((Object)"c", (Object)resultLeaf.getLabel());
    }

    @Test
    public void testRemoveSingleGood() {
        VolcanoPlanner planner = new VolcanoPlanner();
        planner.ambitious = true;
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRule((RelOptRule)new PhysLeafRule());
        planner.addRule((RelOptRule)new GoodSingleRule());
        planner.addRule((RelOptRule)new GoodRemoveSingleRule());
        RelOptCluster cluster = VolcanoPlannerTest.newCluster(planner);
        NoneLeafRel leafRel = new NoneLeafRel(cluster, "a");
        NoneSingleRel singleRel = new NoneSingleRel(cluster, (RelNode)leafRel);
        RelNode convertedRel = planner.changeTraits((RelNode)singleRel, cluster.traitSetOf(new RelTrait[]{PHYS_CALLING_CONVENTION}));
        planner.setRoot(convertedRel);
        RelNode result = planner.chooseDelegate().findBestExp();
        Assert.assertTrue((boolean)(result instanceof PhysLeafRel));
        PhysLeafRel resultLeaf = (PhysLeafRel)result;
        Assert.assertEquals((Object)"c", (Object)resultLeaf.getLabel());
    }

    @Ignore
    @Test
    public void testListener() {
        TestListener listener = new TestListener();
        VolcanoPlanner planner = new VolcanoPlanner();
        planner.addListener((RelOptListener)listener);
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRule((RelOptRule)new PhysLeafRule());
        RelOptCluster cluster = VolcanoPlannerTest.newCluster(planner);
        NoneLeafRel leafRel = new NoneLeafRel(cluster, "a");
        RelNode convertedRel = planner.changeTraits((RelNode)leafRel, cluster.traitSetOf(new RelTrait[]{PHYS_CALLING_CONVENTION}));
        planner.setRoot(convertedRel);
        RelNode result = planner.chooseDelegate().findBestExp();
        Assert.assertTrue((boolean)(result instanceof PhysLeafRel));
        List<RelOptListener.RelEvent> eventList = listener.getEventList();
        this.checkEvent(eventList, 0, RelOptListener.RelEquivalenceEvent.class, (RelNode)leafRel, null);
        this.checkEvent(eventList, 1, RelOptListener.RelEquivalenceEvent.class, null, null);
        this.checkEvent(eventList, 2, RelOptListener.RuleAttemptedEvent.class, (RelNode)leafRel, PhysLeafRule.class);
        this.checkEvent(eventList, 3, RelOptListener.RuleProductionEvent.class, result, PhysLeafRule.class);
        this.checkEvent(eventList, 4, RelOptListener.RelEquivalenceEvent.class, result, null);
        this.checkEvent(eventList, 5, RelOptListener.RuleProductionEvent.class, result, PhysLeafRule.class);
        this.checkEvent(eventList, 6, RelOptListener.RuleAttemptedEvent.class, (RelNode)leafRel, PhysLeafRule.class);
        this.checkEvent(eventList, 7, RelOptListener.RelChosenEvent.class, result, null);
        this.checkEvent(eventList, 8, RelOptListener.RelChosenEvent.class, null, null);
    }

    private void checkEvent(List<RelOptListener.RelEvent> eventList, int iEvent, Class expectedEventClass, RelNode expectedRel, Class<? extends RelOptRule> expectedRuleClass) {
        Assert.assertTrue((iEvent < eventList.size() ? 1 : 0) != 0);
        RelOptListener.RelEvent event = eventList.get(iEvent);
        Assert.assertSame((Object)expectedEventClass, event.getClass());
        if (expectedRel != null) {
            Assert.assertSame((Object)expectedRel, (Object)event.getRel());
        }
        if (expectedRuleClass != null) {
            RelOptListener.RuleEvent ruleEvent = (RelOptListener.RuleEvent)event;
            Assert.assertSame(expectedRuleClass, ruleEvent.getRuleCall().getRule().getClass());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestListener
    implements RelOptListener {
        private List<RelOptListener.RelEvent> eventList = new ArrayList<RelOptListener.RelEvent>();

        TestListener() {
        }

        List<RelOptListener.RelEvent> getEventList() {
            return this.eventList;
        }

        private void recordEvent(RelOptListener.RelEvent event) {
            this.eventList.add(event);
        }

        public void relChosen(RelOptListener.RelChosenEvent event) {
            this.recordEvent((RelOptListener.RelEvent)event);
        }

        public void relDiscarded(RelOptListener.RelDiscardedEvent event) {
            throw Util.newInternal((String)event.toString());
        }

        public void relEquivalenceFound(RelOptListener.RelEquivalenceEvent event) {
            if (!event.isPhysical()) {
                return;
            }
            this.recordEvent((RelOptListener.RelEvent)event);
        }

        public void ruleAttempted(RelOptListener.RuleAttemptedEvent event) {
            this.recordEvent((RelOptListener.RelEvent)event);
        }

        public void ruleProductionSucceeded(RelOptListener.RuleProductionEvent event) {
            this.recordEvent((RelOptListener.RelEvent)event);
        }
    }

    private static class ReformedRemoveSingleRule
    extends RelOptRule {
        ReformedRemoveSingleRule() {
            super(ReformedRemoveSingleRule.operand(NoneSingleRel.class, (RelOptRuleOperand)ReformedRemoveSingleRule.operand(PhysLeafRel.class, (RelOptRuleOperandChildren)ReformedRemoveSingleRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
        }

        public Convention getOutConvention() {
            return PHYS_CALLING_CONVENTION;
        }

        public void onMatch(RelOptRuleCall call) {
            NoneSingleRel singleRel = (NoneSingleRel)call.rel(0);
            PhysLeafRel leafRel = (PhysLeafRel)call.rel(1);
            call.transformTo((RelNode)new PhysLeafRel(singleRel.getCluster(), "c"));
        }
    }

    private static class GoodRemoveSingleRule
    extends RelOptRule {
        GoodRemoveSingleRule() {
            super(GoodRemoveSingleRule.operand(PhysSingleRel.class, (RelOptRuleOperand)GoodRemoveSingleRule.operand(PhysLeafRel.class, (RelOptRuleOperandChildren)GoodRemoveSingleRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
        }

        public Convention getOutConvention() {
            return PHYS_CALLING_CONVENTION;
        }

        public void onMatch(RelOptRuleCall call) {
            PhysSingleRel singleRel = (PhysSingleRel)call.rel(0);
            PhysLeafRel leafRel = (PhysLeafRel)call.rel(1);
            call.transformTo((RelNode)new PhysLeafRel(singleRel.getCluster(), "c"));
        }
    }

    private static class PhysProjectRule
    extends RelOptRule {
        PhysProjectRule() {
            super(PhysProjectRule.operand(ProjectRel.class, (RelOptRuleOperandChildren)PhysProjectRule.any()));
        }

        public Convention getOutConvention() {
            return PHYS_CALLING_CONVENTION;
        }

        public void onMatch(RelOptRuleCall call) {
            ProjectRel project = (ProjectRel)call.rel(0);
            RelNode childRel = project.getChild();
            call.transformTo((RelNode)new PhysLeafRel(childRel.getCluster(), "b"));
        }
    }

    private static class ReformedSingleRule
    extends RelOptRule {
        ReformedSingleRule() {
            super(ReformedSingleRule.operand(NoneSingleRel.class, (RelOptRuleOperand)ReformedSingleRule.operand(PhysLeafRel.class, (RelOptRuleOperandChildren)ReformedSingleRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
        }

        public Convention getOutConvention() {
            return PHYS_CALLING_CONVENTION;
        }

        public void onMatch(RelOptRuleCall call) {
            NoneSingleRel singleRel = (NoneSingleRel)call.rel(0);
            RelNode childRel = call.rel(1);
            RelNode physInput = ReformedSingleRule.convert((RelNode)childRel, (RelTraitSet)singleRel.getTraitSet().replace((RelTrait)PHYS_CALLING_CONVENTION));
            call.transformTo((RelNode)new PhysSingleRel(singleRel.getCluster(), physInput));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubsetRule
    extends RelOptRule {
        private final List<String> buf;

        SubsetRule(List<String> buf) {
            super(SubsetRule.operand(TestSingleRel.class, (RelOptRuleOperand)SubsetRule.operand(RelSubset.class, (RelOptRuleOperandChildren)SubsetRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
            this.buf = buf;
        }

        public Convention getOutConvention() {
            return PHYS_CALLING_CONVENTION;
        }

        public void onMatch(RelOptRuleCall call) {
            TestSingleRel singleRel = (TestSingleRel)call.rel(0);
            RelSubset childRel = (RelSubset)call.rel(1);
            Assert.assertThat((Object)call.rels.length, (Matcher)CoreMatchers.equalTo((Object)2));
            this.buf.add(((Object)((Object)singleRel)).getClass().getSimpleName() + ":" + childRel.getDigest());
        }
    }

    private static class GoodSingleRule
    extends RelOptRule {
        GoodSingleRule() {
            super(GoodSingleRule.operand(NoneSingleRel.class, (RelOptRuleOperandChildren)GoodSingleRule.any()));
        }

        public Convention getOutConvention() {
            return PHYS_CALLING_CONVENTION;
        }

        public void onMatch(RelOptRuleCall call) {
            NoneSingleRel singleRel = (NoneSingleRel)call.rel(0);
            RelNode childRel = singleRel.getChild();
            RelNode physInput = GoodSingleRule.convert((RelNode)childRel, (RelTraitSet)singleRel.getTraitSet().replace((RelTrait)PHYS_CALLING_CONVENTION));
            call.transformTo((RelNode)new PhysSingleRel(singleRel.getCluster(), physInput));
        }
    }

    private static class PhysLeafRule
    extends RelOptRule {
        PhysLeafRule() {
            super(PhysLeafRule.operand(NoneLeafRel.class, (RelOptRuleOperandChildren)PhysLeafRule.any()));
        }

        public Convention getOutConvention() {
            return PHYS_CALLING_CONVENTION;
        }

        public void onMatch(RelOptRuleCall call) {
            NoneLeafRel leafRel = (NoneLeafRel)call.rel(0);
            call.transformTo((RelNode)new PhysLeafRel(leafRel.getCluster(), leafRel.getLabel()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PhysToIteratorConverter
    extends ConverterRelImpl {
        public PhysToIteratorConverter(RelOptCluster cluster, RelNode child) {
            super(cluster, (RelTraitDef)ConventionTraitDef.INSTANCE, cluster.traitSetOf(new RelTrait[]{EnumerableConvention.INSTANCE}), child);
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (traitSet.comprises(new RelTrait[]{EnumerableConvention.INSTANCE}));
            return new PhysToIteratorConverter(this.getCluster(), (RelNode)PhysToIteratorConverter.sole(inputs));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PhysSingleRel
    extends TestSingleRel {
        PhysSingleRel(RelOptCluster cluster, RelNode child) {
            super(cluster, cluster.traitSetOf(new RelTrait[]{PHYS_CALLING_CONVENTION}), child);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner) {
            return planner.getCostFactory().makeTinyCost();
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (traitSet.comprises(new RelTrait[]{PHYS_CALLING_CONVENTION}));
            return new PhysSingleRel(this.getCluster(), (RelNode)PhysSingleRel.sole(inputs));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PhysLeafRel
    extends TestLeafRel {
        PhysLeafRel(RelOptCluster cluster, String label) {
            super(cluster, cluster.traitSetOf(new RelTrait[]{PHYS_CALLING_CONVENTION}), label);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner) {
            return planner.getCostFactory().makeTinyCost();
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (traitSet.comprises(new RelTrait[]{PHYS_CALLING_CONVENTION}));
            assert (inputs.isEmpty());
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoneLeafRel
    extends TestLeafRel {
        protected NoneLeafRel(RelOptCluster cluster, String label) {
            super(cluster, cluster.traitSetOf(new RelTrait[]{Convention.NONE}), label);
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (traitSet.comprises(new RelTrait[]{Convention.NONE}));
            assert (inputs.isEmpty());
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoneSingleRel
    extends TestSingleRel {
        protected NoneSingleRel(RelOptCluster cluster, RelNode child) {
            super(cluster, cluster.traitSetOf(new RelTrait[]{Convention.NONE}), child);
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (traitSet.comprises(new RelTrait[]{Convention.NONE}));
            return new NoneSingleRel(this.getCluster(), (RelNode)NoneSingleRel.sole(inputs));
        }
    }

    private static abstract class TestSingleRel
    extends SingleRel {
        protected TestSingleRel(RelOptCluster cluster, RelTraitSet traits, RelNode child) {
            super(cluster, traits, child);
        }

        public RelOptCost computeSelfCost(RelOptPlanner planner) {
            return planner.getCostFactory().makeInfiniteCost();
        }

        protected RelDataType deriveRowType() {
            return this.getChild().getRowType();
        }
    }

    private static abstract class TestLeafRel
    extends AbstractRelNode {
        private String label;

        protected TestLeafRel(RelOptCluster cluster, RelTraitSet traits, String label) {
            super(cluster, traits);
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public RelOptCost computeSelfCost(RelOptPlanner planner) {
            return planner.getCostFactory().makeInfiniteCost();
        }

        protected RelDataType deriveRowType() {
            RelDataTypeFactory typeFactory = this.getCluster().getTypeFactory();
            return typeFactory.builder().add("this", typeFactory.createJavaType(Void.TYPE)).build();
        }

        public RelWriter explainTerms(RelWriter pw) {
            return super.explainTerms(pw).item("label", (Object)this.label);
        }
    }
}

