/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.tools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.config.Lex;
import net.hydromatic.optiq.impl.java.ReflectiveSchema;
import net.hydromatic.optiq.impl.jdbc.JdbcConvention;
import net.hydromatic.optiq.impl.jdbc.JdbcImplementor;
import net.hydromatic.optiq.impl.jdbc.JdbcRel;
import net.hydromatic.optiq.impl.jdbc.JdbcRules;
import net.hydromatic.optiq.rules.java.EnumerableConvention;
import net.hydromatic.optiq.rules.java.JavaRules;
import net.hydromatic.optiq.test.JdbcTest;
import net.hydromatic.optiq.test.OptiqAssert;
import net.hydromatic.optiq.tools.FrameworkConfig;
import net.hydromatic.optiq.tools.Frameworks;
import net.hydromatic.optiq.tools.Planner;
import net.hydromatic.optiq.tools.Program;
import net.hydromatic.optiq.tools.Programs;
import net.hydromatic.optiq.tools.RuleSet;
import net.hydromatic.optiq.tools.RuleSets;
import net.hydromatic.optiq.tools.TpchSchema;
import net.hydromatic.optiq.tools.ValidationException;
import org.eigenbase.rel.RelCollationTraitDef;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.TableAccessRelBase;
import org.eigenbase.rel.convert.ConverterRule;
import org.eigenbase.rel.rules.MergeFilterRule;
import org.eigenbase.rel.rules.MergeProjectRule;
import org.eigenbase.rel.rules.PushFilterPastJoinRule;
import org.eigenbase.rel.rules.PushFilterPastProjectRule;
import org.eigenbase.rel.rules.PushJoinThroughJoinRule;
import org.eigenbase.rel.rules.PushSortPastProjectRule;
import org.eigenbase.rel.rules.ReduceAggregatesRule;
import org.eigenbase.rel.rules.RemoveDistinctAggregateRule;
import org.eigenbase.rel.rules.RemoveSortRule;
import org.eigenbase.rel.rules.SwapJoinRule;
import org.eigenbase.rel.rules.TableAccessRule;
import org.eigenbase.relopt.ConventionTraitDef;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTrait;
import org.eigenbase.relopt.RelTraitDef;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.SqlAggFunction;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlDialect;
import org.eigenbase.sql.SqlExplainLevel;
import org.eigenbase.sql.SqlFunctionCategory;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperatorTable;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.parser.SqlParseException;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.sql.type.ReturnTypes;
import org.eigenbase.sql.type.SqlOperandTypeChecker;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.util.ChainedSqlOperatorTable;
import org.eigenbase.sql.util.ListSqlOperatorTable;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlannerTest {
    private static final ImmutableSet<RelOptRule> RULE_SET = ImmutableSet.of((Object)JavaRules.ENUMERABLE_JOIN_RULE, (Object)JavaRules.ENUMERABLE_PROJECT_RULE, (Object)JavaRules.ENUMERABLE_FILTER_RULE, (Object)JavaRules.ENUMERABLE_AGGREGATE_RULE, (Object)JavaRules.ENUMERABLE_SORT_RULE, (Object)JavaRules.ENUMERABLE_LIMIT_RULE, (Object[])new RelOptRule[]{JavaRules.ENUMERABLE_UNION_RULE, JavaRules.ENUMERABLE_INTERSECT_RULE, JavaRules.ENUMERABLE_MINUS_RULE, JavaRules.ENUMERABLE_TABLE_MODIFICATION_RULE, JavaRules.ENUMERABLE_VALUES_RULE, JavaRules.ENUMERABLE_WINDOW_RULE, JavaRules.ENUMERABLE_ONE_ROW_RULE, JavaRules.ENUMERABLE_EMPTY_RULE, TableAccessRule.INSTANCE, MergeProjectRule.INSTANCE, PushFilterPastProjectRule.INSTANCE, PushFilterPastJoinRule.FILTER_ON_JOIN, RemoveDistinctAggregateRule.INSTANCE, ReduceAggregatesRule.INSTANCE, SwapJoinRule.INSTANCE, PushJoinThroughJoinRule.RIGHT, PushJoinThroughJoinRule.LEFT, PushSortPastProjectRule.INSTANCE});

    private void checkParseAndConvert(String query, String queryFromParseTree, String expectedRelExpr) throws Exception {
        Planner planner = this.getPlanner(null, new Program[0]);
        SqlNode parse = planner.parse(query);
        Assert.assertThat((Object)Util.toLinux((String)parse.toString()), (Matcher)CoreMatchers.equalTo((Object)queryFromParseTree));
        SqlNode validate = planner.validate(parse);
        RelNode rel = planner.convert(validate);
        Assert.assertThat((Object)this.toString(rel), (Matcher)CoreMatchers.equalTo((Object)expectedRelExpr));
    }

    @Test
    public void testParseAndConvert() throws Exception {
        this.checkParseAndConvert("select * from \"emps\" where \"name\" like '%e%'", "SELECT *\nFROM `emps`\nWHERE `name` LIKE '%e%'", "ProjectRel(empid=[$0], deptno=[$1], name=[$2], salary=[$3], commission=[$4])\n  FilterRel(condition=[LIKE($2, '%e%')])\n    EnumerableTableAccessRel(table=[[hr, emps]])\n");
    }

    @Test
    public void testParseAndConvertWithOrderByAndOffset() throws Exception {
        this.checkParseAndConvert("select * from \"emps\" order by \"emps\".\"deptno\" offset 10", "SELECT *\nFROM `emps`\nORDER BY `emps`.`deptno`\nOFFSET 10 ROWS", "SortRel(sort0=[$1], dir0=[ASC], offset=[10])\n  ProjectRel(empid=[$0], deptno=[$1], name=[$2], salary=[$3], commission=[$4])\n    EnumerableTableAccessRel(table=[[hr, emps]])\n");
    }

    private String toString(RelNode rel) {
        return Util.toLinux((String)RelOptUtil.dumpPlan((String)"", (RelNode)rel, (boolean)false, (SqlExplainLevel)SqlExplainLevel.DIGEST_ATTRIBUTES));
    }

    @Test
    public void testParseFails() throws SqlParseException {
        Planner planner = this.getPlanner(null, new Program[0]);
        try {
            SqlNode parse = planner.parse("select * * from \"emps\"");
            Assert.fail((String)("expected error, got " + parse));
        }
        catch (SqlParseException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Encountered \"*\" at line 1, column 10."));
        }
    }

    @Test
    public void testValidateFails() throws SqlParseException {
        Planner planner = this.getPlanner(null, new Program[0]);
        SqlNode parse = planner.parse("select * from \"emps\" where \"Xname\" like '%e%'");
        Assert.assertThat((Object)Util.toLinux((String)parse.toString()), (Matcher)CoreMatchers.equalTo((Object)"SELECT *\nFROM `emps`\nWHERE `Xname` LIKE '%e%'"));
        try {
            SqlNode validate = planner.validate(parse);
            Assert.fail((String)("expected error, got " + validate));
        }
        catch (ValidationException e) {
            Assert.assertThat((Object)Util.getStackTrace((Throwable)e), (Matcher)CoreMatchers.containsString((String)"Column 'Xname' not found in any table"));
        }
    }

    @Test
    public void testValidateUserDefinedAggregate() throws Exception {
        SqlStdOperatorTable stdOpTab = SqlStdOperatorTable.instance();
        ChainedSqlOperatorTable opTab = new ChainedSqlOperatorTable((List)ImmutableList.of((Object)stdOpTab, (Object)new ListSqlOperatorTable((List)ImmutableList.of((Object)((Object)new MyCountAggFunction())))));
        Planner planner = Frameworks.getPlanner((FrameworkConfig)Frameworks.newConfigBuilder().defaultSchema(this.createHrSchema()).operatorTable((SqlOperatorTable)opTab).build());
        SqlNode parse = planner.parse("select \"deptno\", my_count(\"empid\") from \"emps\"\ngroup by \"deptno\"");
        Assert.assertThat((Object)Util.toLinux((String)parse.toString()), (Matcher)CoreMatchers.equalTo((Object)"SELECT `deptno`, `MY_COUNT`(`empid`)\nFROM `emps`\nGROUP BY `deptno`"));
        SqlNode validate = planner.validate(parse);
        Assert.assertThat((Object)validate, (Matcher)CoreMatchers.notNullValue());
        planner.close();
        planner.reset();
        parse = planner.parse("select \"deptno\", count(1) from \"emps\"");
        try {
            validate = planner.validate(parse);
            Assert.fail((String)("expected exception, got " + validate));
        }
        catch (ValidationException e) {
            Assert.assertThat((Object)e.getCause().getCause().getMessage(), (Matcher)CoreMatchers.containsString((String)"Expression 'deptno' is not being grouped"));
        }
    }

    private SchemaPlus createHrSchema() {
        return Frameworks.createRootSchema((boolean)true).add("hr", (Schema)new ReflectiveSchema((Object)new JdbcTest.HrSchema()));
    }

    private Planner getPlanner(List<RelTraitDef> traitDefs, Program ... programs) {
        return Frameworks.getPlanner((FrameworkConfig)Frameworks.newConfigBuilder().lex(Lex.ORACLE).defaultSchema(this.createHrSchema()).traitDefs(traitDefs).programs(programs).build());
    }

    @Test
    public void testConvertWithoutValidateFails() throws Exception {
        Planner planner = this.getPlanner(null, new Program[0]);
        SqlNode parse = planner.parse("select * from \"emps\"");
        try {
            RelNode rel = planner.convert(parse);
            Assert.fail((String)("expected error, got " + rel));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"cannot move from STATE_3_PARSED to STATE_4_VALIDATED"));
        }
    }

    @Test
    public void testPlan() throws Exception {
        Program program = Programs.ofRules((RelOptRule[])new RelOptRule[]{MergeFilterRule.INSTANCE, JavaRules.ENUMERABLE_FILTER_RULE, JavaRules.ENUMERABLE_PROJECT_RULE});
        Planner planner = this.getPlanner(null, program);
        SqlNode parse = planner.parse("select * from \"emps\"");
        SqlNode validate = planner.validate(parse);
        RelNode convert = planner.convert(validate);
        RelTraitSet traitSet = planner.getEmptyTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        RelNode transform = planner.transform(0, traitSet, convert);
        Assert.assertThat((Object)this.toString(transform), (Matcher)CoreMatchers.equalTo((Object)"EnumerableProjectRel(empid=[$0], deptno=[$1], name=[$2], salary=[$3], commission=[$4])\n  EnumerableTableAccessRel(table=[[hr, emps]])\n"));
    }

    @Test
    public void testSortPlan() throws Exception {
        RuleSet ruleSet = RuleSets.ofList((RelOptRule[])new RelOptRule[]{RemoveSortRule.INSTANCE, JavaRules.ENUMERABLE_PROJECT_RULE, JavaRules.ENUMERABLE_SORT_RULE});
        Planner planner = this.getPlanner(null, Programs.of((RuleSet)ruleSet));
        SqlNode parse = planner.parse("select * from \"emps\" order by \"emps\".\"deptno\"");
        SqlNode validate = planner.validate(parse);
        RelNode convert = planner.convert(validate);
        RelTraitSet traitSet = convert.getTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        RelNode transform = planner.transform(0, traitSet, convert);
        Assert.assertThat((Object)this.toString(transform), (Matcher)CoreMatchers.equalTo((Object)"EnumerableSortRel(sort0=[$1], dir0=[ASC])\n  EnumerableProjectRel(empid=[$0], deptno=[$1], name=[$2], salary=[$3], commission=[$4])\n    EnumerableTableAccessRel(table=[[hr, emps]])\n"));
    }

    @Test
    public void testDuplicateSortPlan() throws Exception {
        RuleSet ruleSet = RuleSets.ofList((RelOptRule[])new RelOptRule[]{RemoveSortRule.INSTANCE, JavaRules.ENUMERABLE_PROJECT_RULE, JavaRules.ENUMERABLE_SORT_RULE});
        Planner planner = this.getPlanner(null, Programs.of((RuleSet)ruleSet));
        SqlNode parse = planner.parse("select \"empid\" from ( select * from \"emps\" order by \"emps\".\"deptno\") order by \"deptno\"");
        SqlNode validate = planner.validate(parse);
        RelNode convert = planner.convert(validate);
        RelTraitSet traitSet = planner.getEmptyTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        RelNode transform = planner.transform(0, traitSet, convert);
        Assert.assertThat((Object)this.toString(transform), (Matcher)CoreMatchers.equalTo((Object)"EnumerableProjectRel(empid=[$0])\n  EnumerableProjectRel(empid=[$0], deptno=[$1])\n    EnumerableSortRel(sort0=[$1], dir0=[ASC])\n      EnumerableProjectRel(empid=[$0], deptno=[$1], name=[$2], salary=[$3], commission=[$4])\n        EnumerableTableAccessRel(table=[[hr, emps]])\n"));
    }

    @Test
    public void testDuplicateSortPlanWORemoveSortRule() throws Exception {
        RuleSet ruleSet = RuleSets.ofList((RelOptRule[])new RelOptRule[]{JavaRules.ENUMERABLE_PROJECT_RULE, JavaRules.ENUMERABLE_SORT_RULE});
        Planner planner = this.getPlanner(null, Programs.of((RuleSet)ruleSet));
        SqlNode parse = planner.parse("select \"empid\" from ( select * from \"emps\" order by \"emps\".\"deptno\") order by \"deptno\"");
        SqlNode validate = planner.validate(parse);
        RelNode convert = planner.convert(validate);
        RelTraitSet traitSet = planner.getEmptyTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        RelNode transform = planner.transform(0, traitSet, convert);
        Assert.assertThat((Object)this.toString(transform), (Matcher)CoreMatchers.equalTo((Object)"EnumerableProjectRel(empid=[$0])\n  EnumerableSortRel(sort0=[$1], dir0=[ASC])\n    EnumerableProjectRel(empid=[$0], deptno=[$1])\n      EnumerableSortRel(sort0=[$1], dir0=[ASC])\n        EnumerableProjectRel(empid=[$0], deptno=[$1], name=[$2], salary=[$3], commission=[$4])\n          EnumerableTableAccessRel(table=[[hr, emps]])\n"));
    }

    @Test
    public void testPlanWithExplicitTraitDefs() throws Exception {
        RuleSet ruleSet = RuleSets.ofList((RelOptRule[])new RelOptRule[]{MergeFilterRule.INSTANCE, JavaRules.ENUMERABLE_FILTER_RULE, JavaRules.ENUMERABLE_PROJECT_RULE});
        ArrayList<RelTraitDef> traitDefs = new ArrayList<RelTraitDef>();
        traitDefs.add((RelTraitDef)ConventionTraitDef.INSTANCE);
        traitDefs.add((RelTraitDef)RelCollationTraitDef.INSTANCE);
        Planner planner = this.getPlanner(traitDefs, Programs.of((RuleSet)ruleSet));
        SqlNode parse = planner.parse("select * from \"emps\"");
        SqlNode validate = planner.validate(parse);
        RelNode convert = planner.convert(validate);
        RelTraitSet traitSet = planner.getEmptyTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        RelNode transform = planner.transform(0, traitSet, convert);
        Assert.assertThat((Object)this.toString(transform), (Matcher)CoreMatchers.equalTo((Object)"EnumerableProjectRel(empid=[$0], deptno=[$1], name=[$2], salary=[$3], commission=[$4])\n  EnumerableTableAccessRel(table=[[hr, emps]])\n"));
    }

    @Test
    public void testPlanTransformTwice() throws Exception {
        RuleSet ruleSet = RuleSets.ofList((RelOptRule[])new RelOptRule[]{MergeFilterRule.INSTANCE, JavaRules.ENUMERABLE_FILTER_RULE, JavaRules.ENUMERABLE_PROJECT_RULE});
        Planner planner = this.getPlanner(null, Programs.of((RuleSet)ruleSet));
        SqlNode parse = planner.parse("select * from \"emps\"");
        SqlNode validate = planner.validate(parse);
        RelNode convert = planner.convert(validate);
        RelTraitSet traitSet = planner.getEmptyTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        RelNode transform = planner.transform(0, traitSet, convert);
        RelNode transform2 = planner.transform(0, traitSet, transform);
        Assert.assertThat((Object)this.toString(transform2), (Matcher)CoreMatchers.equalTo((Object)"EnumerableProjectRel(empid=[$0], deptno=[$1], name=[$2], salary=[$3], commission=[$4])\n  EnumerableTableAccessRel(table=[[hr, emps]])\n"));
    }

    @Test
    public void testHiveDialect() throws SqlParseException {
        Planner planner = this.getPlanner(null, new Program[0]);
        SqlNode parse = planner.parse("select * from (select * from \"emps\") as t\nwhere \"name\" like '%e%'");
        SqlDialect hiveDialect = new SqlDialect(SqlDialect.DatabaseProduct.HIVE, "Hive", null);
        Assert.assertThat((Object)Util.toLinux((String)parse.toSqlString(hiveDialect).getSql()), (Matcher)CoreMatchers.equalTo((Object)"SELECT *\nFROM (SELECT *\nFROM emps) T\nWHERE name LIKE '%e%'"));
    }

    @Test
    public void testPlanTransformWithDiffRuleSetAndConvention() throws Exception {
        Program program0 = Programs.ofRules((RelOptRule[])new RelOptRule[]{MergeFilterRule.INSTANCE, JavaRules.ENUMERABLE_FILTER_RULE, JavaRules.ENUMERABLE_PROJECT_RULE});
        JdbcConvention out = new JdbcConvention(null, null, "myjdbc");
        Program program1 = Programs.ofRules((RelOptRule[])new RelOptRule[]{new MockJdbcProjectRule(out), new MockJdbcTableRule(out)});
        Planner planner = this.getPlanner(null, program0, program1);
        SqlNode parse = planner.parse("select T1.\"name\" from \"emps\" as T1 ");
        SqlNode validate = planner.validate(parse);
        RelNode convert = planner.convert(validate);
        RelTraitSet traitSet0 = planner.getEmptyTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        RelTraitSet traitSet1 = planner.getEmptyTraitSet().replace((RelTrait)out);
        RelNode transform = planner.transform(0, traitSet0, convert);
        RelNode transform2 = planner.transform(1, traitSet1, transform);
        Assert.assertThat((Object)this.toString(transform2), (Matcher)CoreMatchers.equalTo((Object)"JdbcProjectRel(name=[$2])\n  MockJdbcTableScan(table=[[hr, emps]])\n"));
    }

    @Test
    public void testPlanNWayJoin() throws Exception {
        this.checkJoinNWay(5);
        this.checkJoinNWay(9);
        this.checkJoinNWay(35);
        if (OptiqAssert.ENABLE_SLOW) {
            this.checkJoinNWay(60);
        }
    }

    private void checkJoinNWay(int n) throws Exception {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("select *");
        for (i = 0; i < n; ++i) {
            buf.append(i == 0 ? "\nfrom " : ",\n ").append("\"depts\" as d").append(i);
        }
        for (i = 1; i < n; ++i) {
            buf.append(i == 1 ? "\nwhere" : "\nand").append(" d").append(i).append(".\"deptno\" = d").append(i - 1).append(".\"deptno\"");
        }
        Planner planner = this.getPlanner(null, Programs.heuristicJoinOrder(RULE_SET));
        SqlNode parse = planner.parse(buf.toString());
        SqlNode validate = planner.validate(parse);
        RelNode convert = planner.convert(validate);
        RelTraitSet traitSet = planner.getEmptyTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        RelNode transform = planner.transform(0, traitSet, convert);
        Assert.assertThat((Object)this.toString(transform), (Matcher)CoreMatchers.containsString((String)"EnumerableJoinRel(condition=[=($3, $0)], joinType=[inner])"));
    }

    @Test
    public void testOldJoinStyleDeCorrelation() throws Exception {
        Assert.assertFalse((boolean)this.checkTpchQuery("select\n p.`pPartkey`\nfrom\n  `tpch`.`part` p,\n  `tpch`.`partsupp` ps1\nwhere\n  p.`pPartkey` = ps1.`psPartkey`\n  and ps1.`psSupplyCost` = (\n    select\n      min(ps.`psSupplyCost`)\n    from\n      `tpch`.`partsupp` ps\n    where\n      p.`pPartkey` = ps.`psPartkey`\n  )\n").contains("CorrelatorRel"));
    }

    public String checkTpchQuery(String tpchTestQuery) throws Exception {
        SchemaPlus schema = Frameworks.createRootSchema((boolean)true).add("tpch", (Schema)new ReflectiveSchema((Object)new TpchSchema()));
        Planner p = Frameworks.getPlanner((FrameworkConfig)Frameworks.newConfigBuilder().lex(Lex.MYSQL).defaultSchema(schema).programs(new Program[]{Programs.ofRules(RULE_SET)}).build());
        SqlNode n = p.parse(tpchTestQuery);
        n = p.validate(n);
        RelNode r = p.convert(n);
        String plan = RelOptUtil.toString((RelNode)r);
        p.close();
        return plan;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MyCountAggFunction
    extends SqlAggFunction {
        public MyCountAggFunction() {
            super("MY_COUNT", SqlKind.OTHER_FUNCTION, ReturnTypes.BIGINT, null, (SqlOperandTypeChecker)OperandTypes.ANY, SqlFunctionCategory.NUMERIC);
        }

        public List<RelDataType> getParameterTypes(RelDataTypeFactory typeFactory) {
            return ImmutableList.of((Object)typeFactory.createSqlType(SqlTypeName.ANY));
        }

        public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
            return typeFactory.createSqlType(SqlTypeName.BIGINT);
        }

        public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
            if (call.isCountStar()) {
                return validator.getTypeFactory().createSqlType(SqlTypeName.BIGINT);
            }
            return super.deriveType(validator, scope, call);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MockJdbcTableScan
    extends TableAccessRelBase
    implements JdbcRel {
        public MockJdbcTableScan(RelOptCluster cluster, RelOptTable table, JdbcConvention jdbcConvention) {
            super(cluster, cluster.traitSetOf(new RelTrait[]{jdbcConvention}), table);
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new MockJdbcTableScan(this.getCluster(), this.table, (JdbcConvention)this.getConvention());
        }

        public void register(RelOptPlanner planner) {
            JdbcConvention out = (JdbcConvention)this.getConvention();
            for (RelOptRule rule : JdbcRules.rules((JdbcConvention)out)) {
                planner.addRule(rule);
            }
        }

        public JdbcImplementor.Result implement(JdbcImplementor implementor) {
            return null;
        }
    }

    private class MockJdbcTableRule
    extends ConverterRule {
        private MockJdbcTableRule(JdbcConvention out) {
            super(JavaRules.EnumerableTableAccessRel.class, (RelTrait)EnumerableConvention.INSTANCE, (RelTrait)out, "MockJdbcTableRule");
        }

        public RelNode convert(RelNode rel) {
            JavaRules.EnumerableTableAccessRel scan = (JavaRules.EnumerableTableAccessRel)rel;
            return new MockJdbcTableScan(scan.getCluster(), scan.getTable(), (JdbcConvention)this.getOutConvention());
        }
    }

    private class MockJdbcProjectRule
    extends ConverterRule {
        private MockJdbcProjectRule(JdbcConvention out) {
            super(JavaRules.EnumerableProjectRel.class, (RelTrait)EnumerableConvention.INSTANCE, (RelTrait)out, "MockJdbcProjectRule");
        }

        public RelNode convert(RelNode rel) {
            JavaRules.EnumerableProjectRel project = (JavaRules.EnumerableProjectRel)rel;
            return new JdbcRules.JdbcProjectRel(rel.getCluster(), rel.getTraitSet().replace((RelTrait)this.getOutConvention()), MockJdbcProjectRule.convert((RelNode)project.getChild(), (RelTraitSet)project.getChild().getTraitSet().replace((RelTrait)this.getOutConvention())), project.getProjects(), project.getRowType(), 1);
        }
    }
}

