/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.test;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import net.hydromatic.linq4j.Enumerable;
import net.hydromatic.linq4j.Linq4j;
import net.hydromatic.linq4j.QueryProvider;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.ParameterExpression;
import net.hydromatic.linq4j.expressions.Primitive;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.linq4j.function.Functions;
import net.hydromatic.linq4j.function.Predicate1;
import net.hydromatic.optiq.Function;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.impl.AbstractSchema;
import net.hydromatic.optiq.impl.TableMacroImpl;
import net.hydromatic.optiq.impl.ViewTable;
import net.hydromatic.optiq.impl.java.ReflectiveSchema;
import net.hydromatic.optiq.jdbc.OptiqConnection;
import net.hydromatic.optiq.test.JdbcTest;
import net.hydromatic.optiq.test.OptiqAssert;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ReflectiveSchemaTest {
    public static final Method LINQ4J_AS_ENUMERABLE_METHOD = Types.lookupMethod(Linq4j.class, (String)"asEnumerable", (Class[])new Class[]{Object[].class});

    @Test
    public void testQueryProvider() throws Exception {
        OptiqConnection connection = OptiqAssert.getConnection("hr", "foodmart");
        QueryProvider queryProvider = connection.unwrap(QueryProvider.class);
        ParameterExpression e = Expressions.parameter(JdbcTest.Employee.class, (String)"e");
        List list = queryProvider.createQuery((Expression)Expressions.call((Expression)Expressions.call((Type)Types.of(Enumerable.class, (Type[])new Type[]{JdbcTest.Employee.class}), null, (Method)LINQ4J_AS_ENUMERABLE_METHOD, (Expression[])new Expression[]{Expressions.constant((Object)new JdbcTest.HrSchema().emps)}), (String)"asQueryable", (Expression[])new Expression[0]), JdbcTest.Employee.class).where(Expressions.lambda((Expression)Expressions.lessThan((Expression)Expressions.field((Expression)e, (String)"empid"), (Expression)Expressions.constant((Object)160)), (ParameterExpression[])new ParameterExpression[]{e})).where(Expressions.lambda((Expression)Expressions.greaterThan((Expression)Expressions.field((Expression)e, (String)"empid"), (Expression)Expressions.constant((Object)140)), (ParameterExpression[])new ParameterExpression[]{e})).select(Expressions.lambda((Expression)Expressions.new_(Object[].class, (Expression[])new Expression[]{Expressions.field((Expression)e, (String)"empid"), Expressions.call((Expression)Expressions.field((Expression)e, (String)"name"), (String)"toUpperCase", (Expression[])new Expression[0])}), (ParameterExpression[])new ParameterExpression[]{e})).toList();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)150, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)"SEBASTIAN", (Object)((Object[])list.get(0))[1]);
    }

    @Test
    public void testQueryProviderSingleColumn() throws Exception {
        OptiqConnection connection = OptiqAssert.getConnection("hr", "foodmart");
        QueryProvider queryProvider = connection.unwrap(QueryProvider.class);
        ParameterExpression e = Expressions.parameter(JdbcTest.Employee.class, (String)"e");
        List list = queryProvider.createQuery((Expression)Expressions.call((Expression)Expressions.call((Type)Types.of(Enumerable.class, (Type[])new Type[]{JdbcTest.Employee.class}), null, (Method)LINQ4J_AS_ENUMERABLE_METHOD, Arrays.asList(Expressions.constant((Object)new JdbcTest.HrSchema().emps))), (String)"asQueryable", (Expression[])new Expression[0]), JdbcTest.Employee.class).select(Expressions.lambda((Expression)Expressions.field((Expression)e, (String)"empid"), (ParameterExpression[])new ParameterExpression[]{e})).toList();
        Assert.assertEquals(Arrays.asList(100, 200, 150, 110), (Object)list);
    }

    @Ignore
    @Test
    public void testOperator() throws SQLException, ClassNotFoundException {
        Class.forName("net.hydromatic.optiq.jdbc.Driver");
        Connection connection = DriverManager.getConnection("jdbc:optiq:");
        OptiqConnection optiqConnection = connection.unwrap(OptiqConnection.class);
        SchemaPlus rootSchema = optiqConnection.getRootSchema();
        SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
        schema.add("GenerateStrings", (Function)TableMacroImpl.create((Method)JdbcTest.GENERATE_STRINGS_METHOD));
        schema.add("StringUnion", (Function)TableMacroImpl.create((Method)JdbcTest.STRING_UNION_METHOD));
        rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new JdbcTest.HrSchema()));
        ResultSet resultSet = connection.createStatement().executeQuery("select *\nfrom table(s.StringUnion(\n  GenerateStrings(5),\n  cursor (select name from emps)))\nwhere char_length(s) > 3");
        Assert.assertTrue((boolean)resultSet.next());
    }

    @Test
    public void testView() throws SQLException, ClassNotFoundException {
        Class.forName("net.hydromatic.optiq.jdbc.Driver");
        Connection connection = DriverManager.getConnection("jdbc:optiq:");
        OptiqConnection optiqConnection = connection.unwrap(OptiqConnection.class);
        SchemaPlus rootSchema = optiqConnection.getRootSchema();
        SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
        schema.add("emps_view", (Function)ViewTable.viewMacro((SchemaPlus)schema, (String)"select * from \"hr\".\"emps\" where \"deptno\" = 10", null));
        rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new JdbcTest.HrSchema()));
        ResultSet resultSet = connection.createStatement().executeQuery("select *\nfrom \"s\".\"emps_view\"\nwhere \"empid\" < 120");
        Assert.assertEquals((Object)"empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\nempid=110; deptno=10; name=Theodore; salary=11500.0; commission=250\n", (Object)OptiqAssert.toString(resultSet));
    }

    @Test
    public void testViewPath() throws SQLException, ClassNotFoundException {
        Class.forName("net.hydromatic.optiq.jdbc.Driver");
        Connection connection = DriverManager.getConnection("jdbc:optiq:");
        OptiqConnection optiqConnection = connection.unwrap(OptiqConnection.class);
        SchemaPlus rootSchema = optiqConnection.getRootSchema();
        SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
        schema.add("emps", (Function)ViewTable.viewMacro((SchemaPlus)schema, (String)"select * from \"emps\" where \"deptno\" = 10", Collections.singletonList("hr")));
        schema.add("hr_emps", (Function)ViewTable.viewMacro((SchemaPlus)schema, (String)"select * from \"emps\"", Collections.singletonList("hr")));
        schema.add("s_emps", (Function)ViewTable.viewMacro((SchemaPlus)schema, (String)"select * from \"emps\"", Collections.singletonList("s")));
        schema.add("null_emps", (Function)ViewTable.viewMacro((SchemaPlus)schema, (String)"select * from \"emps\"", null));
        rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new JdbcTest.HrSchema()));
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from \"s\".\"hr_emps\"");
        Assert.assertEquals((long)4L, (long)this.count(resultSet));
        resultSet = statement.executeQuery("select * from \"s\".\"s_emps\"");
        Assert.assertEquals((long)3L, (long)this.count(resultSet));
        resultSet = statement.executeQuery("select * from \"s\".\"null_emps\"");
        Assert.assertEquals((long)3L, (long)this.count(resultSet));
        statement.close();
    }

    private int count(ResultSet resultSet) throws SQLException {
        int i = 0;
        while (resultSet.next()) {
            ++i;
        }
        resultSet.close();
        return i;
    }

    @Test
    public void testDateColumn() throws Exception {
        OptiqAssert.that().with("s", new DateColumnSchema()).query("select * from \"s\".\"emps\"").returns("hireDate=1970-01-01; empid=10; deptno=20; name=fred; salary=0.0; commission=null\nhireDate=1970-04-11; empid=10; deptno=20; name=bill; salary=0.0; commission=null\n");
    }

    @Test
    public void testNoPublicFields() throws Exception {
        OptiqAssert.AssertThat with = OptiqAssert.that().with("s", new CatchallSchema());
        with.query("select 1 from \"s\".\"allPrivates\"").returns("EXPR$0=1\n");
        with.query("select \"x\" from \"s\".\"allPrivates\"").throws_("Column 'x' not found in any table");
    }

    @Test
    public void testColumnTypes() throws Exception {
        OptiqAssert.AssertThat with = OptiqAssert.that().with("s", new CatchallSchema());
        with.query("select \"primitiveBoolean\" from \"s\".\"everyTypes\"").returns("primitiveBoolean=false\nprimitiveBoolean=true\n");
        with.query("select * from \"s\".\"everyTypes\"").returns("primitiveBoolean=false; primitiveByte=0; primitiveChar=\u0000; primitiveShort=0; primitiveInt=0; primitiveLong=0; primitiveFloat=0.0; primitiveDouble=0.0; wrapperBoolean=false; wrapperByte=0; wrapperCharacter=\u0000; wrapperShort=0; wrapperInteger=0; wrapperLong=0; wrapperFloat=0.0; wrapperDouble=0.0; sqlDate=1970-01-01; sqlTime=00:00:00; sqlTimestamp=1970-01-01 00:00:00; utilDate=1970-01-01 00:00:00; string=1\nprimitiveBoolean=true; primitiveByte=127; primitiveChar=\uffff; primitiveShort=32767; primitiveInt=2147483647; primitiveLong=9223372036854775807; primitiveFloat=3.4028235E38; primitiveDouble=1.7976931348623157E308; wrapperBoolean=null; wrapperByte=null; wrapperCharacter=null; wrapperShort=null; wrapperInteger=null; wrapperLong=null; wrapperFloat=null; wrapperDouble=null; sqlDate=null; sqlTime=null; sqlTimestamp=null; utilDate=null; string=null\n");
    }

    @Test
    public void testAggregateFunctions() throws Exception {
        OptiqAssert.AssertThat with = OptiqAssert.that().with("s", new CatchallSchema());
        this.checkAgg(with, "min");
        this.checkAgg(with, "max");
        this.checkAgg(with, "avg");
        this.checkAgg(with, "count");
    }

    private void checkAgg(OptiqAssert.AssertThat with, String fn) {
        for (Field field : fn.equals("avg") ? EveryType.numericFields() : EveryType.fields()) {
            with.query("select " + fn + "(\"" + field.getName() + "\") as c\n" + "from \"s\".\"everyTypes\"").returns((Function1<ResultSet, Void>)Functions.constantNull());
        }
    }

    @Test
    public void testJavaBoolean() throws Exception {
        OptiqAssert.AssertThat with = OptiqAssert.that().with("s", new CatchallSchema());
        with.query("select count(*) as c from \"s\".\"everyTypes\"\nwhere \"primitiveBoolean\"").returns("C=1\n");
        with.query("select count(*) as c from \"s\".\"everyTypes\"\nwhere \"wrapperBoolean\"").returns("C=0\n");
        with.query("select count(*) as c from \"s\".\"everyTypes\"\nwhere \"wrapperBoolean\" is not true").returns("C=2\n");
        with.query("select count(*) as c from \"s\".\"everyTypes\"\nwhere \"primitiveInt\" > 0").returns("C=1\n");
    }

    @Test
    public void testCompareJavaAndSqlTypes() throws Exception {
        OptiqAssert.AssertThat with = OptiqAssert.that().with("s", new CatchallSchema());
        with.query("select \"primitiveLong\" as c from \"s\".\"everyTypes\"\nwhere \"primitiveLong\" > 0").returns("C=9223372036854775807\n");
        with.query("select count(\"primitiveBoolean\") as p,\n  count(\"wrapperBoolean\") as w,\n  count(nullif(\"primitiveShort\" >= 0, false)) as sp,\n  count(nullif(\"wrapperShort\" >= 0, false)) as sw,\n  count(nullif(\"primitiveInt\" >= 0, false)) as ip,\n  count(nullif(\"wrapperInteger\" >= 0, false)) as iw,\n  count(nullif(\"primitiveLong\" >= 0, false)) as lp,\n  count(nullif(\"wrapperLong\" >= 0, false)) as lw\nfrom \"s\".\"everyTypes\"").returns("P=2; W=1; SP=2; SW=1; IP=2; IW=1; LP=2; LW=1\n");
    }

    @Test
    public void testDivideWraperPrimitive() throws Exception {
        OptiqAssert.AssertThat with = OptiqAssert.that().with("s", new CatchallSchema());
        with.query("select \"wrapperLong\" / \"primitiveLong\" as c\n from \"s\".\"everyTypes\" where \"primitiveLong\" <> 0").planContains("final Long inp13_ = current.wrapperLong;").planContains("return inp13_ == null ? (Long) null : Long.valueOf(inp13_.longValue() / current.primitiveLong);").returns("C=null\n");
    }

    @Test
    public void testDivideWraperWrapper() throws Exception {
        OptiqAssert.AssertThat with = OptiqAssert.that().with("s", new CatchallSchema());
        with.query("select \"wrapperLong\" / \"wrapperLong\" as c\n from \"s\".\"everyTypes\" where \"primitiveLong\" <> 0").planContains("final Long inp13_ = ((net.hydromatic.optiq.test.ReflectiveSchemaTest.EveryType) inputEnumerator.current()).wrapperLong;").planContains("return inp13_ == null ? (Long) null : Long.valueOf(inp13_.longValue() / inp13_.longValue());").returns("C=null\n");
    }

    @Test
    public void testDivideWraperWrapperMultipleTimes() throws Exception {
        OptiqAssert.AssertThat with = OptiqAssert.that().with("s", new CatchallSchema());
        with.query("select \"wrapperLong\" / \"wrapperLong\"\n+ \"wrapperLong\" / \"wrapperLong\" as c\n from \"s\".\"everyTypes\" where \"primitiveLong\" <> 0").planContains("final Long inp13_ = ((net.hydromatic.optiq.test.ReflectiveSchemaTest.EveryType) inputEnumerator.current()).wrapperLong;").planContains("return inp13_ == null ? (Long) null : Long.valueOf(inp13_.longValue() / inp13_.longValue() + inp13_.longValue() / inp13_.longValue());").returns("C=null\n");
    }

    @Test
    public void testOp() throws Exception {
        OptiqAssert.AssertThat with = OptiqAssert.that().with("s", new CatchallSchema());
        this.checkOp(with, "+");
        this.checkOp(with, "-");
        this.checkOp(with, "*");
        this.checkOp(with, "/");
    }

    private void checkOp(OptiqAssert.AssertThat with, String fn) {
        for (Field field : EveryType.numericFields()) {
            for (Field field2 : EveryType.numericFields()) {
                String name = "\"" + field.getName() + "\"";
                String name2 = "\"" + field2.getName() + "\"";
                with.query("select " + name + "\n" + " " + fn + " " + name2 + " as c\n" + "from \"s\".\"everyTypes\"\n" + "where " + name + " <> 0").returns((Function1<ResultSet, Void>)Functions.constantNull());
            }
        }
    }

    @Test
    public void testCastFromString() {
        OptiqAssert.that().with("s", new CatchallSchema()).query("select cast(\"string\" as int) as c from \"s\".\"everyTypes\"").returns("C=1\nC=null\n");
    }

    private static boolean isNumeric(Class type) {
        switch (Primitive.flavor((Type)type)) {
            case BOX: {
                return Primitive.ofBox((Type)type).isNumeric();
            }
            case PRIMITIVE: {
                return Primitive.of((Type)type).isNumeric();
            }
        }
        return Number.class.isAssignableFrom(type);
    }

    @Test
    public void testTableFieldHasBadType() throws Exception {
        OptiqAssert.that().with("s", new CatchallSchema()).query("select * from \"s\".\"badTypes\"").returns("integer=0; bitSet={}\n");
    }

    @Test
    public void testSchemaFieldHasBadType() throws Exception {
        OptiqAssert.AssertThat with = OptiqAssert.that().with("s", new CatchallSchema());
        with.query("select * from \"s\".\"bitSet\"").throws_("Table 's.bitSet' not found");
        with.query("select * from \"s\".\"enumerable\"").returns("\n\n\n\n");
        with.query("select * from \"s\".\"list\"").returns("\n\n\n\n");
    }

    @Test
    public void testPrefix() throws Exception {
        OptiqAssert.that().with("s", new CatchallSchema()).query("select * from \"s\".\"prefixEmps\" where \"name\" in ('Ab', 'Abd')").returns("empid=2; deptno=10; name=Ab; salary=0.0; commission=null\nempid=4; deptno=10; name=Abd; salary=0.0; commission=null\n");
    }

    @Ignore
    @Test
    public void testTableMacroIsView() throws Exception {
        OptiqAssert.that().with("s", new JdbcTest.HrSchema()).query("select * from table(\"s\".\"view\"('abc'))").returns("empid=2; deptno=10; name=Ab; salary=0.0; commission=null\nempid=4; deptno=10; name=Abd; salary=0.0; commission=null\n");
    }

    @Ignore
    @Test
    public void testTableMacro() throws Exception {
        OptiqAssert.that().with("s", new JdbcTest.HrSchema()).query("select * from table(\"s\".\"foo\"(3))").returns("empid=2; deptno=10; name=Ab; salary=0.0; commission=null\nempid=4; deptno=10; name=Abd; salary=0.0; commission=null\n");
    }

    public static class DateColumnSchema {
        public final EmployeeWithHireDate[] emps = new EmployeeWithHireDate[]{new EmployeeWithHireDate(10, 20, "fred", 0.0f, null, new Date(0L)), new EmployeeWithHireDate(10, 20, "bill", 0.0f, null, new Date(8640000000L))};
    }

    public static class CatchallSchema {
        public final Enumerable<JdbcTest.Employee> enumerable;
        public final List<JdbcTest.Employee> list;
        public final BitSet bitSet;
        public final EveryType[] everyTypes;
        public final AllPrivate[] allPrivates;
        public final BadType[] badTypes;
        public final JdbcTest.Employee[] prefixEmps;

        public CatchallSchema() {
            this.enumerable = Linq4j.asEnumerable(Arrays.asList(new JdbcTest.HrSchema().emps));
            this.list = Arrays.asList(new JdbcTest.HrSchema().emps);
            this.bitSet = new BitSet(1);
            this.everyTypes = new EveryType[]{new EveryType(false, 0, '\u0000', 0, 0, 0L, 0.0f, 0.0, false, (byte)0, Character.valueOf('\u0000'), (short)0, 0, 0L, Float.valueOf(0.0f), 0.0, new Date(0L), new Time(0L), new Timestamp(0L), new java.util.Date(0L), "1"), new EveryType(true, 127, '\uffff', Short.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE, Float.MAX_VALUE, Double.MAX_VALUE, null, null, null, null, null, null, null, null, null, null, null, null, null)};
            this.allPrivates = new AllPrivate[]{new AllPrivate()};
            this.badTypes = new BadType[]{new BadType()};
            this.prefixEmps = new JdbcTest.Employee[]{new JdbcTest.Employee(1, 10, "A", 0.0f, null), new JdbcTest.Employee(2, 10, "Ab", 0.0f, null), new JdbcTest.Employee(3, 10, "Abc", 0.0f, null), new JdbcTest.Employee(4, 10, "Abd", 0.0f, null)};
        }
    }

    public static class BadType {
        public final int integer = 0;
        public final BitSet bitSet = new BitSet(0);
    }

    public static class AllPrivate {
        private final int x = 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EveryType {
        public final boolean primitiveBoolean;
        public final byte primitiveByte;
        public final char primitiveChar;
        public final short primitiveShort;
        public final int primitiveInt;
        public final long primitiveLong;
        public final float primitiveFloat;
        public final double primitiveDouble;
        public final Boolean wrapperBoolean;
        public final Byte wrapperByte;
        public final Character wrapperCharacter;
        public final Short wrapperShort;
        public final Integer wrapperInteger;
        public final Long wrapperLong;
        public final Float wrapperFloat;
        public final Double wrapperDouble;
        public final Date sqlDate;
        public final Time sqlTime;
        public final Timestamp sqlTimestamp;
        public final java.util.Date utilDate;
        public final String string;

        public EveryType(boolean primitiveBoolean, byte primitiveByte, char primitiveChar, short primitiveShort, int primitiveInt, long primitiveLong, float primitiveFloat, double primitiveDouble, Boolean wrapperBoolean, Byte wrapperByte, Character wrapperCharacter, Short wrapperShort, Integer wrapperInteger, Long wrapperLong, Float wrapperFloat, Double wrapperDouble, Date sqlDate, Time sqlTime, Timestamp sqlTimestamp, java.util.Date utilDate, String string) {
            this.primitiveBoolean = primitiveBoolean;
            this.primitiveByte = primitiveByte;
            this.primitiveChar = primitiveChar;
            this.primitiveShort = primitiveShort;
            this.primitiveInt = primitiveInt;
            this.primitiveLong = primitiveLong;
            this.primitiveFloat = primitiveFloat;
            this.primitiveDouble = primitiveDouble;
            this.wrapperBoolean = wrapperBoolean;
            this.wrapperByte = wrapperByte;
            this.wrapperCharacter = wrapperCharacter;
            this.wrapperShort = wrapperShort;
            this.wrapperInteger = wrapperInteger;
            this.wrapperLong = wrapperLong;
            this.wrapperFloat = wrapperFloat;
            this.wrapperDouble = wrapperDouble;
            this.sqlDate = sqlDate;
            this.sqlTime = sqlTime;
            this.sqlTimestamp = sqlTimestamp;
            this.utilDate = utilDate;
            this.string = string;
        }

        static Enumerable<Field> fields() {
            return Linq4j.asEnumerable((Object[])EveryType.class.getFields());
        }

        static Enumerable<Field> numericFields() {
            return EveryType.fields().where((Predicate1)new Predicate1<Field>(){

                public boolean apply(Field v1) {
                    return ReflectiveSchemaTest.isNumeric(v1.getType());
                }
            });
        }
    }

    public static class EmployeeWithHireDate
    extends JdbcTest.Employee {
        public final Date hireDate;

        public EmployeeWithHireDate(int empid, int deptno, String name, float salary, Integer commission, Date hireDate) {
            super(empid, deptno, name, salary, commission);
            this.hireDate = hireDate;
        }
    }
}

