/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.runtime;

import com.google.common.collect.Ordering;
import java.util.Arrays;
import java.util.Comparator;
import net.hydromatic.optiq.runtime.BinarySearch;
import org.junit.Assert;
import org.junit.Test;

public class BinarySearchTest {
    private void search(int key, int lower, int upper, Integer ... array) {
        Assert.assertEquals((String)("lower bound of " + key + " in " + Arrays.toString((Object[])array)), (long)lower, (long)BinarySearch.lowerBound((Object[])array, (Object)key, (Comparator)Ordering.natural()));
        Assert.assertEquals((String)("upper bound of " + key + " in " + Arrays.toString((Object[])array)), (long)upper, (long)BinarySearch.upperBound((Object[])array, (Object)key, (Comparator)Ordering.natural()));
    }

    @Test
    public void testSimple() {
        this.search(1, 0, 0, 1, 2, 3);
        this.search(2, 1, 1, 1, 2, 3);
        this.search(3, 2, 2, 1, 2, 3);
    }

    @Test
    public void testRepeated() {
        this.search(1, 0, 1, 1, 1, 2, 2, 3, 3);
        this.search(2, 2, 3, 1, 1, 2, 2, 3, 3);
        this.search(3, 4, 5, 1, 1, 2, 2, 3, 3);
    }

    @Test
    public void testMissing() {
        this.search(0, -1, -1, 1, 2, 4);
        this.search(3, 2, 1, 1, 2, 4);
        this.search(5, 3, 3, 1, 2, 4);
    }

    @Test
    public void testEmpty() {
        this.search(42, -1, -1, new Integer[0]);
    }

    @Test
    public void testSingle() {
        this.search(41, -1, -1, 42);
        this.search(42, 0, 0, 42);
        this.search(43, 1, 1, 42);
    }

    @Test
    public void testAllTheSame() {
        this.search(1, 0, 3, 1, 1, 1, 1);
        this.search(0, -1, -1, 1, 1, 1, 1);
        this.search(2, 4, 4, 1, 1, 1, 1);
    }
}

