/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eigenbase.util.Stacks;

public class StackWriter
extends FilterWriter {
    public static final int INDENT = -268435455;
    public static final int OUTDENT = -268435454;
    public static final int OPEN_SQL_STRING_LITERAL = -268435453;
    public static final int CLOSE_SQL_STRING_LITERAL = -268435452;
    public static final int OPEN_SQL_IDENTIFIER = -268435451;
    public static final int CLOSE_SQL_IDENTIFIER = -268435450;
    public static final String INDENT_TAB = "\t";
    public static final String INDENT_SPACE4 = "    ";
    private static final Character SINGLE_QUOTE = Character.valueOf('\'');
    private static final Character DOUBLE_QUOTE = Character.valueOf('\"');
    private int indentationDepth;
    private String indentation;
    private boolean needIndent;
    private final List<Character> quoteStack = new ArrayList<Character>();

    public StackWriter(Writer writer, String indentation) {
        super(writer);
        this.indentation = indentation;
    }

    private void indentIfNeeded() throws IOException {
        if (this.needIndent) {
            int i = 0;
            while (i < this.indentationDepth) {
                this.out.write(this.indentation);
                ++i;
            }
            this.needIndent = false;
        }
    }

    private void writeQuote(Character quoteChar) throws IOException {
        this.indentIfNeeded();
        int n = 1;
        for (Character quote : this.quoteStack) {
            if (!quote.equals(quoteChar)) continue;
            n *= 2;
        }
        int i = 0;
        while (i < n) {
            this.out.write(quoteChar.charValue());
            ++i;
        }
    }

    private void pushQuote(Character quoteChar) throws IOException {
        this.writeQuote(quoteChar);
        Stacks.push(this.quoteStack, quoteChar);
    }

    private void popQuote(Character quoteChar) throws IOException {
        Stacks.pop(this.quoteStack, quoteChar);
        this.writeQuote(quoteChar);
    }

    public void write(int c) throws IOException {
        switch (c) {
            case -268435455: {
                ++this.indentationDepth;
                break;
            }
            case -268435454: {
                --this.indentationDepth;
                break;
            }
            case -268435453: {
                this.pushQuote(SINGLE_QUOTE);
                break;
            }
            case -268435452: {
                this.popQuote(SINGLE_QUOTE);
                break;
            }
            case -268435451: {
                this.pushQuote(DOUBLE_QUOTE);
                break;
            }
            case -268435450: {
                this.popQuote(DOUBLE_QUOTE);
                break;
            }
            case 10: {
                this.out.write(c);
                this.needIndent = true;
                break;
            }
            case 13: {
                this.out.write(c);
                break;
            }
            case 39: {
                this.writeQuote(SINGLE_QUOTE);
                break;
            }
            case 34: {
                this.writeQuote(DOUBLE_QUOTE);
                break;
            }
            default: {
                this.indentIfNeeded();
                this.out.write(c);
            }
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        int i = off;
        while (i < off + len) {
            this.write(cbuf[i]);
            ++i;
        }
    }

    public void write(String str, int off, int len) throws IOException {
        int i = off;
        while (i < off + len) {
            this.write(str.charAt(i));
            ++i;
        }
    }

    public static void printSqlStringLiteral(PrintWriter pw, String s) {
        pw.write(-268435453);
        pw.print(s);
        pw.write(-268435452);
    }

    public static void printSqlIdentifier(PrintWriter pw, String s) {
        pw.write(-268435451);
        pw.print(s);
        pw.write(-268435450);
    }
}

