/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;

public class SerializableCharset
implements Serializable {
    private Charset charset;
    private String charsetName;

    private SerializableCharset(Charset charset) {
        assert (charset != null);
        this.charset = charset;
        this.charsetName = charset.name();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.charset.name());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.charsetName = (String)in.readObject();
        this.charset = (Charset)Charset.availableCharsets().get(this.charsetName);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public static SerializableCharset forCharset(Charset charset) {
        if (charset == null) {
            return null;
        }
        return new SerializableCharset(charset);
    }
}

