/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eigenbase.util.ReflectiveVisitDispatcher;
import org.eigenbase.util.ReflectiveVisitor;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectUtil {
    private static Map<Class, Class> primitiveToBoxingMap = new HashMap<Class, Class>();
    private static Map<Class, Method> primitiveToByteBufferReadMethod;
    private static Map<Class, Method> primitiveToByteBufferWriteMethod;

    static {
        primitiveToBoxingMap.put(Boolean.TYPE, Boolean.class);
        primitiveToBoxingMap.put(Byte.TYPE, Byte.class);
        primitiveToBoxingMap.put(Character.TYPE, Character.class);
        primitiveToBoxingMap.put(Double.TYPE, Double.class);
        primitiveToBoxingMap.put(Float.TYPE, Float.class);
        primitiveToBoxingMap.put(Integer.TYPE, Integer.class);
        primitiveToBoxingMap.put(Long.TYPE, Long.class);
        primitiveToBoxingMap.put(Short.TYPE, Short.class);
        primitiveToByteBufferReadMethod = new HashMap<Class, Method>();
        primitiveToByteBufferWriteMethod = new HashMap<Class, Method>();
        Method[] methods = ByteBuffer.class.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            Class<?>[] paramTypes = method.getParameterTypes();
            if (method.getName().startsWith("get")) {
                if (method.getReturnType().isPrimitive() && paramTypes.length == 1) {
                    primitiveToByteBufferReadMethod.put(method.getReturnType(), method);
                    if (method.getReturnType().equals(Byte.TYPE)) {
                        primitiveToByteBufferReadMethod.put(Boolean.TYPE, method);
                    }
                }
            } else if (method.getName().startsWith("put") && paramTypes.length == 2 && paramTypes[1].isPrimitive()) {
                primitiveToByteBufferWriteMethod.put(paramTypes[1], method);
                if (paramTypes[1].equals(Byte.TYPE)) {
                    primitiveToByteBufferWriteMethod.put(Boolean.TYPE, method);
                }
            }
            ++i;
        }
    }

    public static Method getByteBufferReadMethod(Class clazz) {
        assert (clazz.isPrimitive());
        return primitiveToByteBufferReadMethod.get(clazz);
    }

    public static Method getByteBufferWriteMethod(Class clazz) {
        assert (clazz.isPrimitive());
        return primitiveToByteBufferWriteMethod.get(clazz);
    }

    public static Class getBoxingClass(Class primitiveClass) {
        assert (primitiveClass.isPrimitive());
        return primitiveToBoxingMap.get(primitiveClass);
    }

    public static String getUnqualifiedClassName(Class c) {
        String className = c.getName();
        int lastDot = className.lastIndexOf(46);
        if (lastDot < 0) {
            return className;
        }
        return className.substring(lastDot + 1);
    }

    public static String getUnmangledMethodName(Class declaringClass, String methodName, Class[] paramTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append(declaringClass.getName());
        sb.append(".");
        sb.append(methodName);
        sb.append("(");
        int i = 0;
        while (i < paramTypes.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(paramTypes[i].getName());
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public static String getUnmangledMethodName(Method method) {
        return ReflectUtil.getUnmangledMethodName(method.getDeclaringClass(), method.getName(), method.getParameterTypes());
    }

    public static boolean invokeVisitor(ReflectiveVisitor visitor, Object visitee, Class hierarchyRoot, String visitMethodName) {
        return ReflectUtil.invokeVisitorInternal(visitor, visitee, hierarchyRoot, visitMethodName);
    }

    private static boolean invokeVisitorInternal(Object visitor, Object visitee, Class hierarchyRoot, String visitMethodName) {
        Class<?> paramType;
        Class<?> visiteeClass;
        Class<?> visitorClass = visitor.getClass();
        Method method = ReflectUtil.lookupVisitMethod(visitorClass, visiteeClass = visitee.getClass(), visitMethodName);
        if (method == null) {
            return false;
        }
        if (hierarchyRoot != null && !hierarchyRoot.isAssignableFrom(paramType = method.getParameterTypes()[0])) {
            return false;
        }
        try {
            method.invoke(visitor, visitee);
        }
        catch (IllegalAccessException ex) {
            throw Util.newInternal(ex);
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new AssertionError((Object)t.getClass().getName());
        }
        return true;
    }

    public static Method lookupVisitMethod(Class<?> visitorClass, Class<?> visiteeClass, String visitMethodName) {
        return ReflectUtil.lookupVisitMethod(visitorClass, visiteeClass, visitMethodName, Collections.<Class>emptyList());
    }

    public static Method lookupVisitMethod(Class<?> visitorClass, Class<?> visiteeClass, String visitMethodName, List<Class> additionalParameterTypes) {
        Class[] paramTypes = new Class[1 + additionalParameterTypes.size()];
        int iParam = 0;
        paramTypes[iParam++] = null;
        for (Class paramType : additionalParameterTypes) {
            paramTypes[iParam++] = paramType;
        }
        HashMap cache = new HashMap();
        return ReflectUtil.lookupVisitMethod(visitorClass, visiteeClass, visitMethodName, paramTypes, cache);
    }

    /*
     * Unable to fully structure code
     */
    private static Method lookupVisitMethod(Class<?> visitorClass, Class<?> visiteeClass, String visitMethodName, Class<?>[] paramTypes, Map<Class<?>, Method> cache) {
        if (cache.containsKey(visiteeClass)) {
            return cache.get(visiteeClass);
        }
        candidateMethod = null;
        paramTypes[0] = visiteeClass;
        try {
            candidateMethod = visitorClass.getMethod(visitMethodName, paramTypes);
            cache.put(visiteeClass, candidateMethod);
            return candidateMethod;
        }
        catch (NoSuchMethodException var6_6) {
            superClass = visiteeClass.getSuperclass();
            if (superClass != null) {
                candidateMethod = ReflectUtil.lookupVisitMethod(visitorClass, superClass, visitMethodName, paramTypes, cache);
            }
            interfaces = visiteeClass.getInterfaces();
            i = 0;
            ** while (i < interfaces.length)
        }
lbl-1000:
        // 1 sources

        {
            method = ReflectUtil.lookupVisitMethod(visitorClass, interfaces[i], visitMethodName, paramTypes, cache);
            if (method != null) {
                if (candidateMethod != null && !method.equals(candidateMethod)) {
                    c1 = method.getParameterTypes()[0];
                    if (!c1.isAssignableFrom(c2 = candidateMethod.getParameterTypes()[0])) {
                        if (!c2.isAssignableFrom(c1)) {
                            throw new IllegalArgumentException("dispatch ambiguity between " + candidateMethod + " and " + method);
                        } else {
                            ** GOTO lbl-1000
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    candidateMethod = method;
                }
            }
            ++i;
            continue;
        }
lbl28:
        // 1 sources

        cache.put(visiteeClass, candidateMethod);
        return candidateMethod;
    }

    public static <R extends ReflectiveVisitor, E> ReflectiveVisitDispatcher<R, E> createDispatcher(Class<R> visitorBaseClazz, final Class<E> visiteeBaseClazz) {
        assert (ReflectiveVisitor.class.isAssignableFrom(visitorBaseClazz));
        assert (Object.class.isAssignableFrom(visiteeBaseClazz));
        return new ReflectiveVisitDispatcher<R, E>(){
            final Map<List<Object>, Method> map = new HashMap<List<Object>, Method>();

            @Override
            public Method lookupVisitMethod(Class<? extends R> visitorClass, Class<? extends E> visiteeClass, String visitMethodName) {
                return this.lookupVisitMethod(visitorClass, visiteeClass, visitMethodName, Collections.<Class>emptyList());
            }

            @Override
            public Method lookupVisitMethod(Class<? extends R> visitorClass, Class<? extends E> visiteeClass, String visitMethodName, List<Class> additionalParameterTypes) {
                ImmutableList key = ImmutableList.of(visitorClass, visiteeClass, (Object)visitMethodName, additionalParameterTypes);
                Method method = this.map.get(key);
                if (method == null && !this.map.containsKey(key)) {
                    method = ReflectUtil.lookupVisitMethod(visitorClass, visiteeClass, visitMethodName, additionalParameterTypes);
                    this.map.put((List<Object>)key, method);
                }
                return method;
            }

            @Override
            public boolean invokeVisitor(R visitor, E visitee, String visitMethodName) {
                return ReflectUtil.invokeVisitor(visitor, visitee, visiteeBaseClazz, visitMethodName);
            }
        };
    }

    public static <E, T> MethodDispatcher<T> createMethodDispatcher(final Class<T> returnClazz, final ReflectiveVisitor visitor, final String methodName, final Class<E> arg0Clazz, Class ... otherArgClasses) {
        ImmutableList otherArgClassList = ImmutableList.copyOf((Object[])otherArgClasses);
        final ReflectiveVisitDispatcher<?, E> dispatcher = ReflectUtil.createDispatcher(visitor.getClass(), arg0Clazz);
        return new MethodDispatcher<T>((List)otherArgClassList){
            private final /* synthetic */ List val$otherArgClassList;
            {
                this.val$otherArgClassList = list;
            }

            @Override
            public T invoke(Object ... args) {
                Method method = this.lookupMethod(args[0]);
                try {
                    Object o = method.invoke((Object)visitor, args);
                    return returnClazz.cast(o);
                }
                catch (IllegalAccessException e) {
                    throw Util.newInternal(e, "While invoking method '" + method + "'");
                }
                catch (InvocationTargetException e) {
                    throw Util.newInternal(e, "While invoking method '" + method + "'");
                }
            }

            private Method lookupMethod(Object arg0) {
                if (!arg0Clazz.isInstance(arg0)) {
                    throw new IllegalArgumentException();
                }
                Method method = dispatcher.lookupVisitMethod(visitor.getClass(), arg0.getClass(), methodName, this.val$otherArgClassList);
                if (method == null) {
                    ArrayList<Class> classList = new ArrayList<Class>();
                    classList.add(arg0Clazz);
                    classList.addAll(this.val$otherArgClassList);
                    throw new IllegalArgumentException("Method not found: " + methodName + "(" + classList + ")");
                }
                return method;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MethodDispatcher<T> {
        public T invoke(Object ... var1);
    }
}

