/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeFamily;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.reltype.RelDataTypeFieldImpl;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlCallBinding;
import org.eigenbase.sql.SqlCollation;
import org.eigenbase.sql.SqlDataTypeSpec;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.IntervalSqlType;
import org.eigenbase.sql.type.SqlTypeAssignmentRules;
import org.eigenbase.sql.type.SqlTypeFamily;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.sql.validate.SqlValidatorUtil;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Static;
import org.eigenbase.util.Util;
import org.eigenbase.util14.NumberUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SqlTypeUtil {
    public static boolean isCharTypeComparable(List<RelDataType> argTypes) {
        assert (argTypes != null);
        assert (argTypes.size() >= 2);
        ArrayList argTypes2 = Lists.newArrayList();
        for (RelDataType relDataType : argTypes) {
            if (SqlTypeUtil.isAny(relDataType)) continue;
            argTypes2.add(relDataType);
        }
        for (Pair pair : Pair.adjacents(argTypes2)) {
            RelDataType t0 = (RelDataType)pair.left;
            RelDataType t1 = (RelDataType)pair.right;
            if (!SqlTypeUtil.inCharFamily(t0) || !SqlTypeUtil.inCharFamily(t1)) {
                return false;
            }
            if (t0.getCharset() == null) {
                throw Util.newInternal("RelDataType object should have been assigned a (default) charset when calling deriveType");
            }
            if (!t0.getCharset().equals(t1.getCharset())) {
                return false;
            }
            if (t0.getCollation() == null) {
                throw Util.newInternal("RelDataType object should have been assigned a (default) collation when calling deriveType");
            }
            if (t0.getCollation().getCharset().equals(t1.getCollation().getCharset())) continue;
            return false;
        }
        return true;
    }

    public static boolean isCharTypeComparable(SqlCallBinding binding, List<SqlNode> operands, boolean throwOnFailure) {
        SqlValidator validator = binding.getValidator();
        SqlValidatorScope scope = binding.getScope();
        assert (operands != null);
        assert (operands.size() >= 2);
        if (!SqlTypeUtil.isCharTypeComparable(SqlTypeUtil.deriveAndCollectTypes(validator, scope, operands))) {
            if (throwOnFailure) {
                String msg = "";
                int i = 0;
                while (i < operands.size()) {
                    if (i > 0) {
                        msg = String.valueOf(msg) + ", ";
                    }
                    msg = String.valueOf(msg) + operands.get(i).toString();
                    ++i;
                }
                throw binding.newError(Static.RESOURCE.operandNotComparable(msg));
            }
            return false;
        }
        return true;
    }

    public static List<RelDataType> deriveAndCollectTypes(SqlValidator validator, SqlValidatorScope scope, List<SqlNode> operands) {
        ArrayList<RelDataType> types = new ArrayList<RelDataType>();
        for (SqlNode operand : operands) {
            types.add(validator.deriveType(scope, operand));
        }
        return types;
    }

    public static RelDataType promoteToRowType(RelDataTypeFactory typeFactory, RelDataType type, String fieldName) {
        if (!type.isStruct()) {
            if (fieldName == null) {
                fieldName = "ROW_VALUE";
            }
            type = typeFactory.builder().add(fieldName, type).build();
        }
        return type;
    }

    public static RelDataType makeNullableIfOperandsAre(SqlValidator validator, SqlValidatorScope scope, SqlCall call, RelDataType type) {
        for (SqlNode operand : call.getOperandList()) {
            RelDataType operandType = validator.deriveType(scope, operand);
            if (!SqlTypeUtil.containsNullable(operandType)) continue;
            RelDataTypeFactory typeFactory = validator.getTypeFactory();
            type = typeFactory.createTypeWithNullability(type, true);
            break;
        }
        return type;
    }

    public static RelDataType makeNullableIfOperandsAre(RelDataTypeFactory typeFactory, List<RelDataType> argTypes, RelDataType type) {
        Preconditions.checkNotNull((Object)type);
        if (SqlTypeUtil.containsNullable(argTypes)) {
            type = typeFactory.createTypeWithNullability(type, true);
        }
        return type;
    }

    public static boolean containsNullable(List<RelDataType> types) {
        for (RelDataType type : types) {
            if (!SqlTypeUtil.containsNullable(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsNullable(RelDataType type) {
        if (type.isNullable()) {
            return true;
        }
        if (!type.isStruct()) {
            return false;
        }
        for (RelDataTypeField field : type.getFieldList()) {
            if (!SqlTypeUtil.containsNullable(field.getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean isOfSameTypeName(SqlTypeName typeName, RelDataType type) {
        return SqlTypeName.ANY.equals((Object)typeName) || typeName.equals((Object)type.getSqlTypeName());
    }

    public static boolean isOfSameTypeName(List<SqlTypeName> typeNames, RelDataType type) {
        for (SqlTypeName typeName : typeNames) {
            if (!SqlTypeUtil.isOfSameTypeName(typeName, type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDatetime(RelDataType type) {
        return SqlTypeFamily.DATETIME.contains(type);
    }

    public static boolean isInterval(RelDataType type) {
        return SqlTypeFamily.DATETIME_INTERVAL.contains(type);
    }

    public static boolean inCharFamily(RelDataType type) {
        return type.getFamily() == SqlTypeFamily.CHARACTER;
    }

    public static boolean inCharFamily(SqlTypeName typeName) {
        return typeName.getFamily() == SqlTypeFamily.CHARACTER;
    }

    public static boolean inBooleanFamily(RelDataType type) {
        return type.getFamily() == SqlTypeFamily.BOOLEAN;
    }

    public static boolean inSameFamily(RelDataType t1, RelDataType t2) {
        return t1.getFamily() == t2.getFamily();
    }

    public static boolean inSameFamilyOrNull(RelDataType t1, RelDataType t2) {
        return t1.getSqlTypeName() == SqlTypeName.NULL || t2.getSqlTypeName() == SqlTypeName.NULL || t1.getFamily() == t2.getFamily();
    }

    public static boolean inCharOrBinaryFamilies(RelDataType type) {
        return type.getFamily() == SqlTypeFamily.CHARACTER || type.getFamily() == SqlTypeFamily.BINARY;
    }

    public static boolean isLob(RelDataType type) {
        return false;
    }

    public static boolean isBoundedVariableWidth(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        switch (typeName) {
            case VARCHAR: 
            case VARBINARY: 
            case MULTISET: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIntType(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        switch (typeName) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDecimal(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return typeName == SqlTypeName.DECIMAL;
    }

    public static boolean isBigint(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return typeName == SqlTypeName.BIGINT;
    }

    public static boolean isExactNumeric(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        switch (typeName) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DECIMAL: {
                return true;
            }
        }
        return false;
    }

    public static long maxValue(RelDataType type) {
        assert (SqlTypeUtil.isIntType(type));
        switch (type.getSqlTypeName()) {
            case TINYINT: {
                return 127L;
            }
            case SMALLINT: {
                return 32767L;
            }
            case INTEGER: {
                return Integer.MAX_VALUE;
            }
            case BIGINT: {
                return Long.MAX_VALUE;
            }
        }
        throw Util.unexpected(type.getSqlTypeName());
    }

    public static boolean isApproximateNumeric(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        switch (typeName) {
            case FLOAT: 
            case REAL: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNumeric(RelDataType type) {
        return SqlTypeUtil.isExactNumeric(type) || SqlTypeUtil.isApproximateNumeric(type);
    }

    public static boolean sameNamedType(RelDataType t1, RelDataType t2) {
        if (t1.isStruct() || t2.isStruct()) {
            if (!t1.isStruct() || !t2.isStruct()) {
                return false;
            }
            if (t1.getFieldCount() != t2.getFieldCount()) {
                return false;
            }
            List<RelDataTypeField> fields1 = t1.getFieldList();
            List<RelDataTypeField> fields2 = t2.getFieldList();
            int i = 0;
            while (i < fields1.size()) {
                if (!SqlTypeUtil.sameNamedType(fields1.get(i).getType(), fields2.get(i).getType())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        RelDataType comp1 = t1.getComponentType();
        RelDataType comp2 = t2.getComponentType();
        if (comp1 != null || comp2 != null) {
            if (comp1 == null || comp2 == null) {
                return false;
            }
            if (!SqlTypeUtil.sameNamedType(comp1, comp2)) {
                return false;
            }
        }
        return t1.getSqlTypeName() == t2.getSqlTypeName();
    }

    public static int getMaxByteSize(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return 0;
        }
        switch (typeName) {
            case CHAR: 
            case VARCHAR: {
                return (int)Math.ceil((double)type.getPrecision() * (double)type.getCharset().newEncoder().maxBytesPerChar());
            }
            case BINARY: 
            case VARBINARY: {
                return type.getPrecision();
            }
            case MULTISET: {
                return 4096;
            }
        }
        return 0;
    }

    public static long getMinValue(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        switch (typeName) {
            case TINYINT: {
                return -128L;
            }
            case SMALLINT: {
                return -32768L;
            }
            case INTEGER: {
                return Integer.MIN_VALUE;
            }
            case BIGINT: 
            case DECIMAL: {
                return NumberUtil.getMinUnscaled(type.getPrecision()).longValue();
            }
        }
        throw Util.newInternal("getMinValue(" + (Object)((Object)typeName) + ")");
    }

    public static long getMaxValue(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        switch (typeName) {
            case TINYINT: {
                return 127L;
            }
            case SMALLINT: {
                return 32767L;
            }
            case INTEGER: {
                return Integer.MAX_VALUE;
            }
            case BIGINT: 
            case DECIMAL: {
                return NumberUtil.getMaxUnscaled(type.getPrecision()).longValue();
            }
        }
        throw Util.newInternal("getMaxValue(" + (Object)((Object)typeName) + ")");
    }

    public static boolean isJavaPrimitive(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        switch (typeName) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case REAL: 
            case DOUBLE: 
            case SYMBOL: {
                return true;
            }
        }
        return false;
    }

    public static String getPrimitiveWrapperJavaClassName(RelDataType type) {
        if (type == null) {
            return null;
        }
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return null;
        }
        switch (typeName) {
            case BOOLEAN: {
                return "Boolean";
            }
        }
        return SqlTypeUtil.getNumericJavaClassName(type);
    }

    public static String getNumericJavaClassName(RelDataType type) {
        if (type == null) {
            return null;
        }
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return null;
        }
        switch (typeName) {
            case TINYINT: {
                return "Byte";
            }
            case SMALLINT: {
                return "Short";
            }
            case INTEGER: {
                return "Integer";
            }
            case BIGINT: {
                return "Long";
            }
            case REAL: {
                return "Float";
            }
            case DECIMAL: 
            case FLOAT: 
            case DOUBLE: {
                return "Double";
            }
        }
        return null;
    }

    private static boolean isAny(RelDataType t) {
        return t.getFamily() == SqlTypeFamily.ANY;
    }

    public static boolean canAssignFrom(RelDataType toType, RelDataType fromType) {
        if (SqlTypeUtil.isAny(toType) || SqlTypeUtil.isAny(fromType)) {
            return true;
        }
        if (fromType.getSqlTypeName() == SqlTypeName.NULL) {
            return true;
        }
        if (SqlTypeUtil.areCharacterSetsMismatched(toType, fromType)) {
            return false;
        }
        return toType.getFamily() == fromType.getFamily();
    }

    public static boolean areCharacterSetsMismatched(RelDataType t1, RelDataType t2) {
        if (SqlTypeUtil.isAny(t1) || SqlTypeUtil.isAny(t2)) {
            return false;
        }
        Charset cs1 = t1.getCharset();
        Charset cs2 = t2.getCharset();
        return cs1 != null && cs2 != null && !cs1.equals(cs2);
    }

    public static boolean canCastFrom(RelDataType toType, RelDataType fromType, boolean coerce) {
        IntervalSqlType intervalType;
        if (toType == fromType) {
            return true;
        }
        if (SqlTypeUtil.isAny(toType) || SqlTypeUtil.isAny(fromType)) {
            return true;
        }
        SqlTypeName fromTypeName = fromType.getSqlTypeName();
        SqlTypeName toTypeName = toType.getSqlTypeName();
        if (toType.isStruct() || fromType.isStruct()) {
            if (toTypeName == SqlTypeName.DISTINCT) {
                if (fromTypeName == SqlTypeName.DISTINCT) {
                    return false;
                }
                return SqlTypeUtil.canCastFrom(toType.getFieldList().get(0).getType(), fromType, coerce);
            }
            if (fromTypeName == SqlTypeName.DISTINCT) {
                return SqlTypeUtil.canCastFrom(toType, fromType.getFieldList().get(0).getType(), coerce);
            }
            if (toTypeName == SqlTypeName.ROW) {
                if (fromTypeName != SqlTypeName.ROW) {
                    return false;
                }
                int n = toType.getFieldCount();
                if (fromType.getFieldCount() != n) {
                    return false;
                }
                int i = 0;
                while (i < n) {
                    RelDataTypeField toField = toType.getFieldList().get(i);
                    RelDataTypeField fromField = fromType.getFieldList().get(i);
                    if (!SqlTypeUtil.canCastFrom(toField.getType(), fromField.getType(), coerce)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            if (toTypeName == SqlTypeName.MULTISET) {
                if (!fromType.isStruct()) {
                    return false;
                }
                if (fromTypeName != SqlTypeName.MULTISET) {
                    return false;
                }
                return SqlTypeUtil.canCastFrom(toType.getComponentType(), fromType.getComponentType(), coerce);
            }
            if (fromTypeName == SqlTypeName.MULTISET) {
                return false;
            }
            return toType.getFamily() == fromType.getFamily();
        }
        RelDataType c1 = toType.getComponentType();
        if (c1 != null) {
            RelDataType c2 = fromType.getComponentType();
            if (c2 == null) {
                return false;
            }
            return SqlTypeUtil.canCastFrom(c1, c2, coerce);
        }
        if ((SqlTypeUtil.isInterval(fromType) && SqlTypeUtil.isExactNumeric(toType) || SqlTypeUtil.isInterval(toType) && SqlTypeUtil.isExactNumeric(fromType)) && !(intervalType = (IntervalSqlType)(SqlTypeUtil.isInterval(fromType) ? fromType : toType)).getIntervalQualifier().isSingleDatetimeField()) {
            return false;
        }
        if (toTypeName == null || fromTypeName == null) {
            return false;
        }
        SqlTypeAssignmentRules rules = SqlTypeAssignmentRules.instance();
        return rules.canCastFrom(toTypeName, fromTypeName, coerce);
    }

    public static RelDataType flattenRecordType(RelDataTypeFactory typeFactory, RelDataType recordType, int[] flatteningMap) {
        if (!recordType.isStruct()) {
            return recordType;
        }
        ArrayList<RelDataTypeField> fieldList = new ArrayList<RelDataTypeField>();
        boolean nested = SqlTypeUtil.flattenFields(typeFactory, recordType, fieldList, flatteningMap);
        if (!nested) {
            return recordType;
        }
        ArrayList<RelDataType> types = new ArrayList<RelDataType>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        int i = -1;
        for (RelDataTypeField field : fieldList) {
            types.add(field.getType());
            fieldNames.add(String.valueOf(field.getName()) + "_" + ++i);
        }
        return typeFactory.createStructType(types, fieldNames);
    }

    public static boolean needsNullIndicator(RelDataType recordType) {
        return recordType.getSqlTypeName() == SqlTypeName.STRUCTURED;
    }

    private static boolean flattenFields(RelDataTypeFactory typeFactory, RelDataType type, List<RelDataTypeField> list, int[] flatteningMap) {
        boolean nested = false;
        if (SqlTypeUtil.needsNullIndicator(type)) {
            RelDataType indicatorType = typeFactory.createSqlType(SqlTypeName.BOOLEAN);
            if (type.isNullable()) {
                indicatorType = typeFactory.createTypeWithNullability(indicatorType, true);
            }
            RelDataTypeFieldImpl nullIndicatorField = new RelDataTypeFieldImpl("NULL_VALUE", 0, indicatorType);
            list.add(nullIndicatorField);
            nested = true;
        }
        for (RelDataTypeField field : type.getFieldList()) {
            if (flatteningMap != null) {
                flatteningMap[field.getIndex()] = list.size();
            }
            if (field.getType().isStruct()) {
                nested = true;
                SqlTypeUtil.flattenFields(typeFactory, field.getType(), list, null);
                continue;
            }
            if (field.getType().getComponentType() != null) {
                nested = true;
                RelDataType flattenedCollectionType = typeFactory.createMultisetType(SqlTypeUtil.flattenRecordType(typeFactory, field.getType().getComponentType(), null), -1L);
                field = new RelDataTypeFieldImpl(field.getName(), field.getIndex(), flattenedCollectionType);
                list.add(field);
                continue;
            }
            list.add(field);
        }
        return nested;
    }

    public static SqlDataTypeSpec convertTypeToSpec(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        assert (typeName != null);
        SqlIdentifier typeIdentifier = new SqlIdentifier(typeName.name(), SqlParserPos.ZERO);
        String charSetName = null;
        if (SqlTypeUtil.inCharFamily(type)) {
            charSetName = type.getCharset().name();
        }
        if (typeName.allowsScale()) {
            return new SqlDataTypeSpec(typeIdentifier, type.getPrecision(), type.getScale(), charSetName, null, SqlParserPos.ZERO);
        }
        if (typeName.allowsPrec()) {
            return new SqlDataTypeSpec(typeIdentifier, type.getPrecision(), -1, charSetName, null, SqlParserPos.ZERO);
        }
        return new SqlDataTypeSpec(typeIdentifier, -1, -1, charSetName, null, SqlParserPos.ZERO);
    }

    public static RelDataType createMultisetType(RelDataTypeFactory typeFactory, RelDataType type, boolean nullable) {
        RelDataType ret = typeFactory.createMultisetType(type, -1L);
        return typeFactory.createTypeWithNullability(ret, nullable);
    }

    public static RelDataType createArrayType(RelDataTypeFactory typeFactory, RelDataType type, boolean nullable) {
        RelDataType ret = typeFactory.createArrayType(type, -1L);
        return typeFactory.createTypeWithNullability(ret, nullable);
    }

    public static RelDataType createMapType(RelDataTypeFactory typeFactory, RelDataType keyType, RelDataType valueType, boolean nullable) {
        RelDataType ret = typeFactory.createMapType(keyType, valueType);
        return typeFactory.createTypeWithNullability(ret, nullable);
    }

    public static RelDataType addCharsetAndCollation(RelDataType type, RelDataTypeFactory typeFactory) {
        SqlCollation collation;
        if (!SqlTypeUtil.inCharFamily(type)) {
            return type;
        }
        Charset charset = type.getCharset();
        if (charset == null) {
            charset = typeFactory.getDefaultCharset();
        }
        if ((collation = type.getCollation()) == null) {
            collation = SqlCollation.IMPLICIT;
        }
        type = typeFactory.createTypeWithCharsetAndCollation(type, charset, collation);
        SqlValidatorUtil.checkCharsetAndCollateConsistentIfCharType(type);
        return type;
    }

    public static boolean equalSansNullability(RelDataTypeFactory factory, RelDataType type1, RelDataType type2) {
        if (type1.equals(type2)) {
            return true;
        }
        if (SqlTypeUtil.isAny(type1) || SqlTypeUtil.isAny(type2)) {
            return true;
        }
        if (type1.isNullable() == type2.isNullable()) {
            return false;
        }
        return type1.equals(factory.createTypeWithNullability(type2, type1.isNullable()));
    }

    public static int findField(RelDataType type, String fieldName) {
        List<RelDataTypeField> fields = type.getFieldList();
        int i = 0;
        while (i < fields.size()) {
            RelDataTypeField field = fields.get(i);
            if (field.getName().equals(fieldName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static List<RelDataType> projectTypes(RelDataType rowType, final List<? extends Number> requiredFields) {
        final List<RelDataTypeField> fields = rowType.getFieldList();
        return new AbstractList<RelDataType>(){

            @Override
            public RelDataType get(int index) {
                return ((RelDataTypeField)fields.get(((Number)requiredFields.get(index)).intValue())).getType();
            }

            @Override
            public int size() {
                return requiredFields.size();
            }
        };
    }

    public static RelDataType createEmptyStructType(RelDataTypeFactory typeFactory) {
        return typeFactory.createStructType((List<RelDataType>)ImmutableList.of(), (List<String>)ImmutableList.of());
    }

    public static boolean isComparable(RelDataType type1, RelDataType type2) {
        if (type1.isStruct() != type2.isStruct()) {
            return false;
        }
        if (type1.isStruct()) {
            int n = type1.getFieldCount();
            if (n != type2.getFieldCount()) {
                return false;
            }
            for (Pair<RelDataTypeField, RelDataTypeField> pair : Pair.zip(type1.getFieldList(), type2.getFieldList())) {
                if (SqlTypeUtil.isComparable(((RelDataTypeField)pair.left).getType(), ((RelDataTypeField)pair.right).getType())) continue;
                return false;
            }
            return true;
        }
        RelDataTypeFamily family1 = null;
        RelDataTypeFamily family2 = null;
        if (type1.getSqlTypeName() != null) {
            family1 = type1.getSqlTypeName().getFamily();
        }
        if (type2.getSqlTypeName() != null) {
            family2 = type2.getSqlTypeName().getFamily();
        }
        if (family1 == null) {
            family1 = type1.getFamily();
        }
        if (family2 == null) {
            family2 = type2.getFamily();
        }
        if (family1 == family2) {
            return true;
        }
        return family1 == SqlTypeFamily.ANY || family2 == SqlTypeFamily.ANY;
    }

    public static boolean isUnicode(RelDataType type) {
        Charset charset = type.getCharset();
        if (charset == null) {
            return false;
        }
        return charset.name().startsWith("UTF");
    }
}

