/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.type;

import com.google.common.base.Preconditions;
import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.sql.SqlOperatorBinding;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.type.SqlTypeTransform;
import org.eigenbase.sql.type.SqlTypeUtil;
import org.eigenbase.util.Util;

public abstract class SqlTypeTransforms {
    public static final SqlTypeTransform TO_NULLABLE = new SqlTypeTransform(){

        public RelDataType transformType(SqlOperatorBinding opBinding, RelDataType typeToTransform) {
            return SqlTypeUtil.makeNullableIfOperandsAre(opBinding.getTypeFactory(), opBinding.collectOperandTypes(), (RelDataType)Preconditions.checkNotNull((Object)typeToTransform));
        }
    };
    public static final SqlTypeTransform TO_NOT_NULLABLE = new SqlTypeTransform(){

        public RelDataType transformType(SqlOperatorBinding opBinding, RelDataType typeToTransform) {
            return opBinding.getTypeFactory().createTypeWithNullability((RelDataType)Preconditions.checkNotNull((Object)typeToTransform), false);
        }
    };
    public static final SqlTypeTransform FORCE_NULLABLE = new SqlTypeTransform(){

        public RelDataType transformType(SqlOperatorBinding opBinding, RelDataType typeToTransform) {
            return opBinding.getTypeFactory().createTypeWithNullability((RelDataType)Preconditions.checkNotNull((Object)typeToTransform), true);
        }
    };
    public static final SqlTypeTransform TO_VARYING = new SqlTypeTransform(){

        public RelDataType transformType(SqlOperatorBinding opBinding, RelDataType typeToTransform) {
            switch (typeToTransform.getSqlTypeName()) {
                case VARCHAR: 
                case VARBINARY: {
                    return typeToTransform;
                }
            }
            SqlTypeName retTypeName = this.toVar(typeToTransform);
            RelDataType ret = opBinding.getTypeFactory().createSqlType(retTypeName, typeToTransform.getPrecision());
            if (SqlTypeUtil.inCharFamily(typeToTransform)) {
                ret = opBinding.getTypeFactory().createTypeWithCharsetAndCollation(ret, typeToTransform.getCharset(), typeToTransform.getCollation());
            }
            return opBinding.getTypeFactory().createTypeWithNullability(ret, typeToTransform.isNullable());
        }

        private SqlTypeName toVar(RelDataType type) {
            SqlTypeName sqlTypeName = type.getSqlTypeName();
            switch (sqlTypeName) {
                case CHAR: {
                    return SqlTypeName.VARCHAR;
                }
                case BINARY: {
                    return SqlTypeName.VARBINARY;
                }
                case ANY: {
                    return SqlTypeName.ANY;
                }
            }
            throw Util.unexpected(sqlTypeName);
        }
    };
    public static final SqlTypeTransform TO_MULTISET_ELEMENT_TYPE = new SqlTypeTransform(){

        public RelDataType transformType(SqlOperatorBinding opBinding, RelDataType typeToTransform) {
            return typeToTransform.getComponentType();
        }
    };
    public static final SqlTypeTransform ONLY_COLUMN = new SqlTypeTransform(){

        public RelDataType transformType(SqlOperatorBinding opBinding, RelDataType typeToTransform) {
            List<RelDataTypeField> fields = typeToTransform.getFieldList();
            if (!$assertionsDisabled && fields.size() != 1) {
                throw new AssertionError();
            }
            return fields.get(0).getType();
        }
    };
}

