/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.type;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlOperatorBinding;
import org.eigenbase.sql.type.SqlReturnTypeInference;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.type.SqlTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchReturnTypeInference
implements SqlReturnTypeInference {
    private final int start;
    private final List<SqlTypeName> typeNames;

    public MatchReturnTypeInference(int start, SqlTypeName ... typeNames) {
        this(start, (List<SqlTypeName>)ImmutableList.copyOf((Object[])typeNames));
    }

    public MatchReturnTypeInference(int start, List<SqlTypeName> typeNames) {
        assert (start >= 0);
        assert (typeNames != null);
        assert (typeNames.size() > 0);
        this.start = start;
        this.typeNames = ImmutableList.copyOf(typeNames);
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        int i = this.start;
        while (i < opBinding.getOperandCount()) {
            RelDataType argType = opBinding.getOperandType(i);
            if (SqlTypeUtil.isOfSameTypeName(this.typeNames, argType)) {
                return argType;
            }
            ++i;
        }
        return null;
    }
}

