/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.fun;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.ExplicitOperatorBinding;
import org.eigenbase.sql.SqlBinaryOperator;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlCallBinding;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.type.ComparableOperandTypeChecker;
import org.eigenbase.sql.type.InferTypes;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.sql.type.ReturnTypes;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.type.SqlTypeUtil;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.util.Static;

public class SqlInOperator
extends SqlBinaryOperator {
    private final boolean isNotIn;

    SqlInOperator(boolean isNotIn) {
        super(isNotIn ? "NOT IN" : "IN", SqlKind.IN, 30, true, ReturnTypes.BOOLEAN_NULLABLE, InferTypes.FIRST_KNOWN, null);
        this.isNotIn = isNotIn;
    }

    public boolean isNotIn() {
        return this.isNotIn;
    }

    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        RelDataType rightType;
        List<SqlNode> operands = call.getOperandList();
        assert (operands.size() == 2);
        SqlNode left = operands.get(0);
        SqlNode right = operands.get(1);
        RelDataTypeFactory typeFactory = validator.getTypeFactory();
        RelDataType leftType = validator.deriveType(scope, left);
        if (right instanceof SqlNodeList) {
            ArrayList<RelDataType> rightTypeList = new ArrayList<RelDataType>();
            SqlNodeList nodeList = (SqlNodeList)right;
            int i = 0;
            while (i < nodeList.size()) {
                SqlNode node = nodeList.get(i);
                RelDataType nodeType = validator.deriveType(scope, node);
                rightTypeList.add(nodeType);
                ++i;
            }
            rightType = typeFactory.leastRestrictive(rightTypeList);
            if (rightType == null) {
                throw validator.newValidationError(right, Static.RESOURCE.incompatibleTypesInList());
            }
            validator.setValidatedNodeType(nodeList, rightType);
        } else {
            rightType = validator.deriveType(scope, right);
        }
        RelDataType leftRowType = SqlTypeUtil.promoteToRowType(typeFactory, leftType, null);
        RelDataType rightRowType = SqlTypeUtil.promoteToRowType(typeFactory, rightType, null);
        ComparableOperandTypeChecker checker = (ComparableOperandTypeChecker)OperandTypes.COMPARABLE_UNORDERED_COMPARABLE_UNORDERED;
        if (!checker.checkOperandTypes(new ExplicitOperatorBinding(new SqlCallBinding(validator, scope, call), (List<RelDataType>)ImmutableList.of((Object)leftRowType, (Object)rightRowType)))) {
            throw validator.newValidationError(call, Static.RESOURCE.incompatibleValueType(SqlStdOperatorTable.IN.getName()));
        }
        RelDataType type = typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        if (leftType.isNullable() || rightType.isNullable()) {
            type = typeFactory.createTypeWithNullability(type, true);
        }
        return type;
    }

    public boolean argumentMustBeScalar(int ordinal) {
        return ordinal == 0;
    }
}

