/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlCollation;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlSyntax;
import org.eigenbase.sql.type.SqlOperandTypeChecker;
import org.eigenbase.sql.type.SqlOperandTypeInference;
import org.eigenbase.sql.type.SqlReturnTypeInference;
import org.eigenbase.sql.type.SqlTypeUtil;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.util.Util;

public class SqlPostfixOperator
extends SqlOperator {
    public SqlPostfixOperator(String name, SqlKind kind, int prec, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        super(name, kind, SqlPostfixOperator.leftPrec(prec, true), SqlPostfixOperator.rightPrec(prec, true), returnTypeInference, operandTypeInference, operandTypeChecker);
    }

    public SqlSyntax getSyntax() {
        return SqlSyntax.POSTFIX;
    }

    public String getSignatureTemplate(int operandsCount) {
        Util.discard(operandsCount);
        return "{1} {0}";
    }

    protected RelDataType adjustType(SqlValidator validator, SqlCall call, RelDataType type) {
        if (SqlTypeUtil.inCharFamily(type)) {
            RelDataType operandType = validator.getValidatedNodeType((SqlNode)call.operand(0));
            if (operandType == null) {
                throw Util.newInternal("operand's type should have been derived");
            }
            if (SqlTypeUtil.inCharFamily(operandType)) {
                SqlCollation collation = operandType.getCollation();
                assert (collation != null) : "An implicit or explicit collation should have been set";
                type = validator.getTypeFactory().createTypeWithCharsetAndCollation(type, type.getCharset(), new SqlCollation(collation.getCollationName(), collation.getCoercibility()));
            }
        }
        return type;
    }

    public boolean validRexOperands(int count, boolean fail) {
        if (count != 1) {
            assert (!fail) : "wrong operand count " + count + " for " + this;
            return false;
        }
        return true;
    }
}

