/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rex;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexDynamicParam;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.type.SqlTypeUtil;

public class RexTransformer {
    private RexNode root;
    private final RexBuilder rexBuilder;
    private int isParentsCount;
    private final Set<SqlOperator> transformableOperators = new HashSet<SqlOperator>();

    public RexTransformer(RexNode root, RexBuilder rexBuilder) {
        this.root = root;
        this.rexBuilder = rexBuilder;
        this.isParentsCount = 0;
        this.transformableOperators.add(SqlStdOperatorTable.AND);
        this.transformableOperators.add(SqlStdOperatorTable.EQUALS);
        this.transformableOperators.add(SqlStdOperatorTable.NOT_EQUALS);
        this.transformableOperators.add(SqlStdOperatorTable.GREATER_THAN);
        this.transformableOperators.add(SqlStdOperatorTable.GREATER_THAN_OR_EQUAL);
        this.transformableOperators.add(SqlStdOperatorTable.LESS_THAN);
        this.transformableOperators.add(SqlStdOperatorTable.LESS_THAN_OR_EQUAL);
    }

    private boolean isBoolean(RexNode node) {
        RelDataType type = node.getType();
        return SqlTypeUtil.inBooleanFamily(type);
    }

    private boolean isNullable(RexNode node) {
        return node.getType().isNullable();
    }

    private boolean isTransformable(RexNode node) {
        if (this.isParentsCount == 0) {
            return false;
        }
        if (node instanceof RexCall) {
            RexCall call = (RexCall)node;
            return !this.transformableOperators.contains(call.getOperator()) && this.isNullable(node);
        }
        return this.isNullable(node);
    }

    public RexNode transformNullSemantics() {
        this.root = this.transformNullSemantics(this.root);
        return this.root;
    }

    private RexNode transformNullSemantics(RexNode node) {
        RexCall call;
        assert (this.isParentsCount >= 0) : "Cannot be negative";
        if (!this.isBoolean(node)) {
            return node;
        }
        Boolean directlyUnderIs = null;
        if (node.isA(SqlKind.IS_TRUE)) {
            directlyUnderIs = Boolean.TRUE;
            ++this.isParentsCount;
        } else if (node.isA(SqlKind.IS_FALSE)) {
            directlyUnderIs = Boolean.FALSE;
            ++this.isParentsCount;
        }
        if (directlyUnderIs != null) {
            call = (RexCall)node;
            assert (this.isParentsCount > 0) : "Stack should not be empty";
            assert (1 == call.operands.size());
            RexNode operand = (RexNode)call.operands.get(0);
            if (operand instanceof RexLiteral || operand instanceof RexInputRef || operand instanceof RexDynamicParam) {
                if (this.isNullable(node)) {
                    RexNode notNullNode = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, operand);
                    RexLiteral boolNode = this.rexBuilder.makeLiteral(directlyUnderIs);
                    RexNode eqNode = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, operand, boolNode);
                    RexNode andBoolNode = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, notNullNode, eqNode);
                    return andBoolNode;
                }
                RexLiteral boolNode = this.rexBuilder.makeLiteral(directlyUnderIs);
                RexNode andBoolNode = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, node, boolNode);
                return andBoolNode;
            }
        }
        if (node instanceof RexCall) {
            call = (RexCall)node;
            ArrayList<RexNode> operands = new ArrayList<RexNode>();
            for (RexNode operand : call.operands) {
                operands.add(this.transformNullSemantics(operand));
            }
            if (directlyUnderIs != null) {
                --this.isParentsCount;
                directlyUnderIs = null;
                return (RexNode)operands.get(0);
            }
            if (this.transformableOperators.contains(call.getOperator())) {
                assert (2 == operands.size());
                RexNode isNotNullOne = this.isTransformable((RexNode)operands.get(0)) ? this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, operands.get(0)) : null;
                RexNode isNotNullTwo = this.isTransformable(operands.get(1)) ? this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, operands.get(1)) : null;
                RexNode intoFinalAnd = null;
                if (isNotNullOne != null && isNotNullTwo != null) {
                    intoFinalAnd = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, isNotNullOne, isNotNullTwo);
                } else if (isNotNullOne != null) {
                    intoFinalAnd = isNotNullOne;
                } else if (isNotNullTwo != null) {
                    intoFinalAnd = isNotNullTwo;
                }
                if (intoFinalAnd != null) {
                    RexNode andNullAndCheckNode = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, intoFinalAnd, call.clone(call.getType(), operands));
                    return andNullAndCheckNode;
                }
            }
            if (!operands.equals(call.operands)) {
                return call.clone(call.getType(), operands);
            }
        }
        return node;
    }
}

