/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rex;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexCorrelVariable;
import org.eigenbase.rex.RexDynamicParam;
import org.eigenbase.rex.RexFieldAccess;
import org.eigenbase.rex.RexFieldCollation;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexLocalRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexOver;
import org.eigenbase.rex.RexRangeRef;
import org.eigenbase.rex.RexVisitor;
import org.eigenbase.rex.RexWindow;
import org.eigenbase.rex.RexWindowBound;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RexShuttle
implements RexVisitor<RexNode> {
    @Override
    public RexNode visitOver(RexOver over) {
        boolean[] update = new boolean[1];
        List<RexNode> clonedOperands = this.visitList((List<? extends RexNode>)over.operands, update);
        RexWindow window = this.visitWindow(over.getWindow());
        if (update[0] || window != over.getWindow()) {
            return new RexOver(over.getType(), over.getAggOperator(), clonedOperands, window);
        }
        return over;
    }

    public RexWindow visitWindow(RexWindow window) {
        boolean[] update = new boolean[1];
        List<RexFieldCollation> clonedOrderKeys = this.visitFieldCollations((List<RexFieldCollation>)window.orderKeys, update);
        List<RexNode> clonedPartitionKeys = this.visitList((List<? extends RexNode>)window.partitionKeys, update);
        RexWindowBound lowerBound = window.getLowerBound().accept(this);
        RexWindowBound upperBound = window.getUpperBound().accept(this);
        if (update[0] || lowerBound != window.getLowerBound() && lowerBound != null || upperBound != window.getUpperBound() && upperBound != null) {
            return new RexWindow(clonedPartitionKeys, clonedOrderKeys, lowerBound, upperBound, window.isRows());
        }
        return window;
    }

    @Override
    public RexNode visitCall(RexCall call) {
        boolean[] update = new boolean[1];
        List<RexNode> clonedOperands = this.visitList((List<? extends RexNode>)call.operands, update);
        if (update[0]) {
            return new RexCall(call.getType(), call.getOperator(), clonedOperands);
        }
        return call;
    }

    protected RexNode[] visitArray(RexNode[] exprs, boolean[] update) {
        RexNode[] clonedOperands = new RexNode[exprs.length];
        int i = 0;
        while (i < exprs.length) {
            RexNode operand = exprs[i];
            RexNode clonedOperand = operand.accept(this);
            if (clonedOperand != operand && update != null) {
                update[0] = true;
            }
            clonedOperands[i] = clonedOperand;
            ++i;
        }
        return clonedOperands;
    }

    protected List<RexNode> visitList(List<? extends RexNode> exprs, boolean[] update) {
        ImmutableList.Builder clonedOperands = ImmutableList.builder();
        for (RexNode rexNode : exprs) {
            RexNode clonedOperand = rexNode.accept(this);
            if (clonedOperand != rexNode && update != null) {
                update[0] = true;
            }
            clonedOperands.add((Object)clonedOperand);
        }
        return clonedOperands.build();
    }

    public void visitList(List<? extends RexNode> exprs, List<RexNode> outExprs) {
        for (RexNode rexNode : exprs) {
            outExprs.add(rexNode.accept(this));
        }
    }

    protected List<RexFieldCollation> visitFieldCollations(List<RexFieldCollation> collations, boolean[] update) {
        ImmutableList.Builder clonedOperands = ImmutableList.builder();
        for (RexFieldCollation collation : collations) {
            RexNode clonedOperand = ((RexNode)collation.left).accept(this);
            if (clonedOperand != collation.left && update != null) {
                update[0] = true;
                collation = new RexFieldCollation(clonedOperand, (Set)collation.right);
            }
            clonedOperands.add((Object)collation);
        }
        return clonedOperands.build();
    }

    @Override
    public RexNode visitCorrelVariable(RexCorrelVariable variable) {
        return variable;
    }

    @Override
    public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
        RexNode after;
        RexNode before = fieldAccess.getReferenceExpr();
        if (before == (after = before.accept(this))) {
            return fieldAccess;
        }
        return new RexFieldAccess(after, fieldAccess.getField());
    }

    @Override
    public RexNode visitInputRef(RexInputRef inputRef) {
        return inputRef;
    }

    @Override
    public RexNode visitLocalRef(RexLocalRef localRef) {
        return localRef;
    }

    @Override
    public RexNode visitLiteral(RexLiteral literal) {
        return literal;
    }

    @Override
    public RexNode visitDynamicParam(RexDynamicParam dynamicParam) {
        return dynamicParam;
    }

    @Override
    public RexNode visitRangeRef(RexRangeRef rangeRef) {
        return rangeRef;
    }

    public final <T extends RexNode> boolean mutate(List<T> exprList) {
        int changeCount = 0;
        int i = 0;
        while (i < exprList.size()) {
            RexNode expr2;
            RexNode expr = (RexNode)exprList.get(i);
            if (expr != (expr2 = expr.accept(this))) {
                ++changeCount;
                exprList.set(i, expr2);
            }
            ++i;
        }
        return changeCount > 0;
    }

    public final <T extends RexNode> List<T> apply(List<T> exprList) {
        ArrayList<T> list2 = new ArrayList<T>(exprList);
        if (this.mutate(list2)) {
            return list2;
        }
        return exprList;
    }

    public final RexNode apply(RexNode expr) {
        return expr == null ? null : expr.accept(this);
    }
}

