/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rex;

import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexVisitor;
import org.eigenbase.sql.SqlKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RexFieldAccess
extends RexNode {
    private final RexNode expr;
    private final RelDataTypeField field;

    RexFieldAccess(RexNode expr, RelDataTypeField field) {
        this.expr = expr;
        this.field = field;
        this.digest = expr + "." + field.getName();
        assert (expr.getType().getFieldList().get(field.getIndex()) == field);
    }

    public RelDataTypeField getField() {
        return this.field;
    }

    @Override
    public RelDataType getType() {
        return this.field.getType();
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.FIELD_ACCESS;
    }

    @Override
    public <R> R accept(RexVisitor<R> visitor) {
        return visitor.visitFieldAccess(this);
    }

    public RexNode getReferenceExpr() {
        return this.expr;
    }
}

