/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt;

import org.eigenbase.rel.metadata.DefaultRelMetadataProvider;
import org.eigenbase.rel.metadata.MetadataFactory;
import org.eigenbase.rel.metadata.MetadataFactoryImpl;
import org.eigenbase.rel.metadata.RelMetadataProvider;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptQuery;
import org.eigenbase.relopt.RelTrait;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexNode;

public class RelOptCluster {
    private final RelDataTypeFactory typeFactory;
    private final RelOptQuery query;
    private final RelOptPlanner planner;
    private RexNode originalExpression;
    private final RexBuilder rexBuilder;
    private RelMetadataProvider metadataProvider;
    private MetadataFactory metadataFactory;
    private final RelTraitSet emptyTraitSet;

    RelOptCluster(RelOptQuery query, RelOptPlanner planner, RelDataTypeFactory typeFactory, RexBuilder rexBuilder) {
        assert (planner != null);
        assert (typeFactory != null);
        this.query = query;
        this.planner = planner;
        this.typeFactory = typeFactory;
        this.rexBuilder = rexBuilder;
        this.originalExpression = rexBuilder.makeLiteral("?");
        this.setMetadataProvider(new DefaultRelMetadataProvider());
        this.emptyTraitSet = planner.emptyTraitSet();
    }

    public RelOptQuery getQuery() {
        return this.query;
    }

    public RexNode getOriginalExpression() {
        return this.originalExpression;
    }

    public void setOriginalExpression(RexNode originalExpression) {
        this.originalExpression = originalExpression;
    }

    public RelOptPlanner getPlanner() {
        return this.planner;
    }

    public RelDataTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public RexBuilder getRexBuilder() {
        return this.rexBuilder;
    }

    public RelMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public void setMetadataProvider(RelMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
        this.metadataFactory = new MetadataFactoryImpl(metadataProvider);
    }

    public MetadataFactory getMetadataFactory() {
        return this.metadataFactory;
    }

    public RelTraitSet traitSetOf(RelTrait ... traits) {
        RelTraitSet traitSet = this.emptyTraitSet;
        assert (traitSet.size() == this.planner.getRelTraitDefs().size());
        RelTrait[] relTraitArray = traits;
        int n = traits.length;
        int n2 = 0;
        while (n2 < n) {
            RelTrait trait = relTraitArray[n2];
            traitSet = traitSet.replace(trait);
            ++n2;
        }
        return traitSet;
    }
}

