/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.CalcRelBase;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.WindowRel;
import org.eigenbase.rel.rules.CalcRelSplitter;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexDynamicParam;
import org.eigenbase.rex.RexFieldAccess;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexLocalRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexOver;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.rex.RexProgramBuilder;
import org.eigenbase.util.Util;

public abstract class WindowedAggSplitterRule
extends RelOptRule {
    public static final WindowedAggSplitterRule INSTANCE = new WindowedAggSplitterRule(new RelOptRuleOperand(CalcRelBase.class, null, WindowedAggSplitterRule.any()){

        public boolean matches(RelNode rel) {
            return super.matches(rel) && RexOver.containsOver(((CalcRelBase)rel).getProgram());
        }
    }, "WindowedAggSplitterRule"){

        public void onMatch(RelOptRuleCall call) {
            CalcRelBase calc = (CalcRelBase)call.rel(0);
            if (!$assertionsDisabled && !RexOver.containsOver(calc.getProgram())) {
                throw new AssertionError();
            }
            WindowedAggRelSplitter transform = new WindowedAggRelSplitter(calc);
            RelNode newRel = transform.execute();
            call.transformTo(newRel);
        }
    };
    public static final WindowedAggSplitterRule PROJECT = new WindowedAggSplitterRule(new RelOptRuleOperand(ProjectRelBase.class, null, WindowedAggSplitterRule.any()){

        public boolean matches(RelNode rel) {
            return super.matches(rel) && RexOver.containsOver(((ProjectRelBase)rel).getProjects(), null);
        }
    }, "WindowedAggSplitterRule:project"){

        public void onMatch(RelOptRuleCall call) {
            ProjectRelBase project = (ProjectRelBase)call.rel(0);
            if (!$assertionsDisabled && !RexOver.containsOver(project.getProjects(), null)) {
                throw new AssertionError();
            }
            RelNode child = project.getChild();
            RelDataType rowType = project.getRowType();
            RexProgram program = RexProgram.create(child.getRowType(), project.getProjects(), null, project.getRowType(), project.getCluster().getRexBuilder());
            CalcRel calc = new CalcRel(project.getCluster(), project.getTraitSet(), child, rowType, program, (List<RelCollation>)ImmutableList.of());
            WindowedAggRelSplitter transform = new WindowedAggRelSplitter(calc){

                protected RelNode handle(RelNode rel) {
                    if (rel instanceof CalcRel) {
                        CalcRel calc = (CalcRel)rel;
                        final RexProgram program = calc.getProgram();
                        rel = calc.getChild();
                        if (program.getCondition() != null) {
                            rel = new FilterRel(calc.getCluster(), rel, program.expandLocalRef(program.getCondition()));
                        }
                        if (!program.projectsOnlyIdentity()) {
                            rel = CalcRel.createProject(rel, Lists.transform(program.getProjectList(), (Function)new Function<RexLocalRef, RexNode>(){

                                public RexNode apply(RexLocalRef a0) {
                                    return program.expandLocalRef(a0);
                                }
                            }), calc.getRowType().getFieldNames());
                        }
                    }
                    return rel;
                }
            };
            RelNode newRel = transform.execute();
            call.transformTo(newRel);
        }
    };

    private WindowedAggSplitterRule(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    /* synthetic */ WindowedAggSplitterRule(RelOptRuleOperand relOptRuleOperand, String string, WindowedAggSplitterRule windowedAggSplitterRule) {
        this(relOptRuleOperand, string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WindowedAggRelSplitter
    extends CalcRelSplitter {
        WindowedAggRelSplitter(CalcRelBase calc) {
            super(calc, new CalcRelSplitter.RelType[]{new CalcRelSplitter.RelType("CalcRelType"){

                protected boolean canImplement(RexFieldAccess field) {
                    return true;
                }

                protected boolean canImplement(RexDynamicParam param) {
                    return true;
                }

                protected boolean canImplement(RexLiteral literal) {
                    return true;
                }

                protected boolean canImplement(RexCall call) {
                    return !(call instanceof RexOver);
                }

                protected RelNode makeRel(RelOptCluster cluster, RelTraitSet traits, RelDataType rowType, RelNode child, RexProgram program) {
                    if (!$assertionsDisabled && program.containsAggs()) {
                        throw new AssertionError();
                    }
                    program = RexProgramBuilder.normalize(cluster.getRexBuilder(), program);
                    return super.makeRel(cluster, traits, rowType, child, program);
                }
            }, new CalcRelSplitter.RelType("WinAggRelType"){

                protected boolean canImplement(RexFieldAccess field) {
                    return false;
                }

                protected boolean canImplement(RexDynamicParam param) {
                    return false;
                }

                protected boolean canImplement(RexLiteral literal) {
                    return false;
                }

                protected boolean canImplement(RexCall call) {
                    return call instanceof RexOver;
                }

                protected boolean supportsCondition() {
                    return false;
                }

                protected RelNode makeRel(RelOptCluster cluster, RelTraitSet traits, RelDataType rowType, RelNode child, RexProgram program) {
                    Util.permAssert(program.getCondition() == null, "WindowedAggregateRel cannot accept a condition");
                    return WindowRel.create(cluster, traits, child, program, rowType);
                }
            }});
        }

        @Override
        protected List<Set<Integer>> getCohorts() {
            return Collections.emptyList();
        }
    }
}

