/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.RelFactories;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.metadata.RelColumnOrigin;
import org.eigenbase.rel.metadata.RelMdUtil;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.rel.rules.LoptJoinTree;
import org.eigenbase.rel.rules.LoptMultiJoin;
import org.eigenbase.rel.rules.LoptSemiJoinOptimizer;
import org.eigenbase.rel.rules.MultiJoinRel;
import org.eigenbase.rel.rules.SemiJoinRel;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.util.Pair;
import org.eigenbase.util.mapping.IntPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoptOptimizeJoinRule
extends RelOptRule {
    public static final LoptOptimizeJoinRule INSTANCE = new LoptOptimizeJoinRule(RelFactories.DEFAULT_JOIN_FACTORY);
    private final RelFactories.JoinFactory joinFactory;

    public LoptOptimizeJoinRule(RelFactories.JoinFactory joinFactory) {
        super(LoptOptimizeJoinRule.operand(MultiJoinRel.class, LoptOptimizeJoinRule.any()));
        this.joinFactory = joinFactory;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        MultiJoinRel multiJoinRel = (MultiJoinRel)call.rels[0];
        LoptMultiJoin multiJoin = new LoptMultiJoin(multiJoinRel);
        this.findRemovableOuterJoins(multiJoin);
        RexBuilder rexBuilder = multiJoinRel.getCluster().getRexBuilder();
        LoptSemiJoinOptimizer semiJoinOpt = new LoptSemiJoinOptimizer(multiJoin, rexBuilder);
        semiJoinOpt.makePossibleSemiJoins(multiJoin);
        int iterations = 0;
        while (semiJoinOpt.chooseBestSemiJoin(multiJoin) && iterations++ <= 10) {
        }
        multiJoin.setFactorWeights();
        this.findRemovableSelfJoins(multiJoin);
        this.findBestOrderings(multiJoin, semiJoinOpt, call);
    }

    private void findRemovableOuterJoins(LoptMultiJoin multiJoin) {
        ArrayList<Integer> removalCandidates = new ArrayList<Integer>();
        int factIdx = 0;
        while (factIdx < multiJoin.getNumJoinFactors()) {
            if (multiJoin.isNullGenerating(factIdx)) {
                removalCandidates.add(factIdx);
            }
            ++factIdx;
        }
        while (!removalCandidates.isEmpty()) {
            HashSet<Integer> retryCandidates = new HashSet<Integer>();
            Iterator iterator = removalCandidates.iterator();
            block2: while (iterator.hasNext()) {
                int factIdx2 = (Integer)iterator.next();
                BitSet projFields = multiJoin.getProjFields(factIdx2);
                if (projFields == null || projFields.cardinality() > 0) continue;
                RexNode outerJoinCond = multiJoin.getOuterJoinCond(factIdx2);
                ArrayList<RexNode> ojFilters = new ArrayList<RexNode>();
                RelOptUtil.decomposeConjunction(outerJoinCond, ojFilters);
                int numFields = multiJoin.getNumFieldsInJoinFactor(factIdx2);
                BitSet joinKeys = new BitSet(numFields);
                BitSet otherJoinKeys = new BitSet(multiJoin.getNumTotalFields());
                int firstFieldNum = multiJoin.getJoinStart(factIdx2);
                int lastFieldNum = firstFieldNum + numFields;
                for (RexNode filter : ojFilters) {
                    RexCall filterCall;
                    if (!(filter instanceof RexCall) || (filterCall = (RexCall)filter).getOperator() != SqlStdOperatorTable.EQUALS || !(filterCall.getOperands().get(0) instanceof RexInputRef) || !(filterCall.getOperands().get(1) instanceof RexInputRef)) continue;
                    int leftRef = ((RexInputRef)filterCall.getOperands().get(0)).getIndex();
                    int rightRef = ((RexInputRef)filterCall.getOperands().get(1)).getIndex();
                    this.setJoinKey(joinKeys, otherJoinKeys, leftRef, rightRef, firstFieldNum, lastFieldNum, true);
                }
                if (joinKeys.cardinality() == 0) continue;
                int[] joinFieldRefCounts = multiJoin.getJoinFieldRefCounts(factIdx2);
                int i = 0;
                while (i < joinFieldRefCounts.length) {
                    if (joinFieldRefCounts[i] > 1 || !joinKeys.get(i) && joinFieldRefCounts[i] == 1) continue block2;
                    ++i;
                }
                if (!RelMdUtil.areColumnsDefinitelyUniqueWhenNullsFiltered(multiJoin.getJoinFactor(factIdx2), joinKeys)) continue;
                multiJoin.addRemovableOuterJoinFactor(factIdx2);
                for (int otherKey : BitSets.toIter(otherJoinKeys)) {
                    int otherFactor = multiJoin.findRef(otherKey);
                    if (multiJoin.isNullGenerating(otherFactor)) {
                        retryCandidates.add(otherFactor);
                    }
                    int[] otherJoinFieldRefCounts = multiJoin.getJoinFieldRefCounts(otherFactor);
                    int offset = multiJoin.getJoinStart(otherFactor);
                    int n = otherKey - offset;
                    otherJoinFieldRefCounts[n] = otherJoinFieldRefCounts[n] - 1;
                }
            }
            removalCandidates.clear();
            removalCandidates.addAll(retryCandidates);
        }
    }

    private void setJoinKey(BitSet joinKeys, BitSet otherJoinKeys, int ref1, int ref2, int firstFieldNum, int lastFieldNum, boolean swap) {
        if (ref1 >= firstFieldNum && ref1 < lastFieldNum) {
            if (ref2 < firstFieldNum || ref2 >= lastFieldNum) {
                joinKeys.set(ref1 - firstFieldNum);
                otherJoinKeys.set(ref2);
            }
            return;
        }
        if (swap) {
            this.setJoinKey(joinKeys, otherJoinKeys, ref2, ref1, firstFieldNum, lastFieldNum, false);
        }
    }

    private void findRemovableSelfJoins(LoptMultiJoin multiJoin) {
        Map<Integer, RelOptTable> simpleFactors = this.getSimpleFactors(multiJoin);
        ArrayList<RelOptTable> repeatedTables = new ArrayList<RelOptTable>();
        TreeSet<Integer> sortedFactors = new TreeSet<Integer>();
        sortedFactors.addAll(simpleFactors.keySet());
        HashMap<Integer, Integer> selfJoinPairs = new HashMap<Integer, Integer>();
        Integer[] factors = sortedFactors.toArray(new Integer[sortedFactors.size()]);
        int i = 0;
        while (i < factors.length) {
            if (!repeatedTables.contains(simpleFactors.get(factors[i]))) {
                int j = i + 1;
                while (j < factors.length) {
                    int leftFactor = factors[i];
                    int rightFactor = factors[j];
                    if (simpleFactors.get(leftFactor).getQualifiedName().equals(simpleFactors.get(rightFactor).getQualifiedName())) {
                        selfJoinPairs.put(leftFactor, rightFactor);
                        repeatedTables.add(simpleFactors.get(leftFactor));
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        for (Integer factor1 : selfJoinPairs.keySet()) {
            int factor2 = (Integer)selfJoinPairs.get(factor1);
            ArrayList<RexNode> selfJoinFilters = new ArrayList<RexNode>();
            for (RexNode filter : multiJoin.getJoinFilters()) {
                BitSet joinFactors = multiJoin.getFactorsRefByJoinFilter(filter);
                if (joinFactors.cardinality() != 2 || !joinFactors.get(factor1) || !joinFactors.get(factor2)) continue;
                selfJoinFilters.add(filter);
            }
            if (selfJoinFilters.size() <= 0 || !this.isSelfJoinFilterUnique(multiJoin, factor1, factor2, selfJoinFilters)) continue;
            multiJoin.addRemovableSelfJoinPair(factor1, factor2);
        }
    }

    private Map<Integer, RelOptTable> getSimpleFactors(LoptMultiJoin multiJoin) {
        HashMap<Integer, RelOptTable> returnList = new HashMap<Integer, RelOptTable>();
        if (multiJoin.getMultiJoinRel().isFullOuterJoin()) {
            return returnList;
        }
        int factIdx = 0;
        while (factIdx < multiJoin.getNumJoinFactors()) {
            RelNode rel;
            RelOptTable table;
            if (!multiJoin.isNullGenerating(factIdx) && multiJoin.getJoinRemovalFactor(factIdx) == null && (table = RelMetadataQuery.getTableOrigin(rel = multiJoin.getJoinFactor(factIdx))) != null) {
                returnList.put(factIdx, table);
            }
            ++factIdx;
        }
        return returnList;
    }

    private boolean isSelfJoinFilterUnique(LoptMultiJoin multiJoin, int leftFactor, int rightFactor, List<RexNode> joinFilterList) {
        RexBuilder rexBuilder = multiJoin.getMultiJoinRel().getCluster().getRexBuilder();
        RelNode leftRel = multiJoin.getJoinFactor(leftFactor);
        RelNode rightRel = multiJoin.getJoinFactor(rightFactor);
        RexNode joinFilters = RexUtil.composeConjunction(rexBuilder, joinFilterList, true);
        int[] adjustments = new int[multiJoin.getNumTotalFields()];
        int leftAdjust = multiJoin.getJoinStart(leftFactor);
        int nLeftFields = leftRel.getRowType().getFieldCount();
        int i = 0;
        while (i < nLeftFields) {
            adjustments[leftAdjust + i] = -leftAdjust;
            ++i;
        }
        int rightAdjust = multiJoin.getJoinStart(rightFactor);
        int i2 = 0;
        while (i2 < rightRel.getRowType().getFieldCount()) {
            adjustments[rightAdjust + i2] = -rightAdjust + nLeftFields;
            ++i2;
        }
        joinFilters = joinFilters.accept(new RelOptUtil.RexInputConverter(rexBuilder, multiJoin.getMultiJoinFields(), leftRel.getRowType().getFieldList(), rightRel.getRowType().getFieldList(), adjustments));
        return LoptOptimizeJoinRule.areSelfJoinKeysUnique(leftRel, rightRel, joinFilters);
    }

    private void findBestOrderings(LoptMultiJoin multiJoin, LoptSemiJoinOptimizer semiJoinOpt, RelOptRuleCall call) {
        ArrayList<RelNode> plans = new ArrayList<RelNode>();
        List<String> fieldNames = multiJoin.getMultiJoinRel().getRowType().getFieldNames();
        int i = 0;
        while (i < multiJoin.getNumJoinFactors()) {
            LoptJoinTree joinTree;
            if (!multiJoin.isNullGenerating(i) && (joinTree = this.createOrdering(multiJoin, semiJoinOpt, i)) != null) {
                RelNode newProject = this.createTopProject(multiJoin, joinTree, fieldNames);
                plans.add(newProject);
            }
            ++i;
        }
        for (RelNode plan : plans) {
            call.transformTo(plan);
        }
    }

    private RelNode createTopProject(LoptMultiJoin multiJoin, LoptJoinTree joinTree, List<String> fieldNames) {
        ArrayList newProjExprs = Lists.newArrayList();
        RexBuilder rexBuilder = multiJoin.getMultiJoinRel().getCluster().getRexBuilder();
        ArrayList<Integer> newJoinOrder = new ArrayList<Integer>();
        joinTree.getTreeOrder(newJoinOrder);
        int nJoinFactors = multiJoin.getNumJoinFactors();
        List<RelDataTypeField> fields = multiJoin.getMultiJoinFields();
        HashMap<Integer, Integer> factorToOffsetMap = new HashMap<Integer, Integer>();
        int pos = 0;
        int fieldStart = 0;
        while (pos < nJoinFactors) {
            factorToOffsetMap.put((Integer)newJoinOrder.get(pos), fieldStart);
            fieldStart += multiJoin.getNumFieldsInJoinFactor((Integer)newJoinOrder.get(pos));
            ++pos;
        }
        int currFactor = 0;
        while (currFactor < nJoinFactors) {
            Integer leftFactor = null;
            if (multiJoin.isRightFactorInRemovableSelfJoin(currFactor)) {
                leftFactor = multiJoin.getOtherSelfJoinFactor(currFactor);
            }
            int fieldPos = 0;
            while (fieldPos < multiJoin.getNumFieldsInJoinFactor(currFactor)) {
                Integer leftOffset;
                int newOffset = (Integer)factorToOffsetMap.get(currFactor) + fieldPos;
                if (leftFactor != null && (leftOffset = multiJoin.getRightColumnMapping(currFactor, fieldPos)) != null) {
                    newOffset = (Integer)factorToOffsetMap.get(leftFactor) + leftOffset;
                }
                newProjExprs.add(rexBuilder.makeInputRef(fields.get(newProjExprs.size()).getType(), newOffset));
                ++fieldPos;
            }
            ++currFactor;
        }
        ProjectRel newProject = (ProjectRel)CalcRel.createProject(joinTree.getJoinTree(), newProjExprs, fieldNames);
        RexNode postJoinFilter = multiJoin.getMultiJoinRel().getPostJoinFilter();
        if (postJoinFilter != null) {
            return CalcRel.createFilter(newProject, postJoinFilter);
        }
        return newProject;
    }

    private Double computeJoinCardinality(LoptMultiJoin multiJoin, LoptSemiJoinOptimizer semiJoinOpt, LoptJoinTree joinTree, List<RexNode> filters, int factor) {
        int nJoinFactors = multiJoin.getNumJoinFactors();
        BitSet childFactors = new BitSet(nJoinFactors);
        multiJoin.getChildFactors(joinTree, childFactors);
        childFactors.set(factor);
        int factorStart = multiJoin.getJoinStart(factor);
        int nFields = multiJoin.getNumFieldsInJoinFactor(factor);
        BitSet joinKeys = new BitSet(nFields);
        this.setFactorJoinKeys(multiJoin, filters, childFactors, factorStart, nFields, joinKeys);
        RexNode outerJoinCond = multiJoin.getOuterJoinCond(factor);
        ArrayList<RexNode> outerJoinFilters = new ArrayList<RexNode>();
        RelOptUtil.decomposeConjunction(outerJoinCond, outerJoinFilters);
        this.setFactorJoinKeys(multiJoin, outerJoinFilters, childFactors, factorStart, nFields, joinKeys);
        if (joinKeys.isEmpty()) {
            return null;
        }
        return RelMetadataQuery.getDistinctRowCount(semiJoinOpt.getChosenSemiJoin(factor), joinKeys, null);
    }

    private void setFactorJoinKeys(LoptMultiJoin multiJoin, List<RexNode> filters, BitSet joinFactors, int factorStart, int nFields, BitSet joinKeys) {
        for (RexNode joinFilter : filters) {
            BitSet filterFactors = multiJoin.getFactorsRefByJoinFilter(joinFilter);
            if (!BitSets.contains(joinFactors, filterFactors)) continue;
            BitSet joinFields = multiJoin.getFieldsRefByJoinFilter(joinFilter);
            int field = joinFields.nextSetBit(factorStart);
            while (field >= 0 && field < factorStart + nFields) {
                joinKeys.set(field - factorStart);
                field = joinFields.nextSetBit(field + 1);
            }
        }
    }

    private LoptJoinTree createOrdering(LoptMultiJoin multiJoin, LoptSemiJoinOptimizer semiJoinOpt, int firstFactor) {
        LoptJoinTree joinTree = null;
        int nJoinFactors = multiJoin.getNumJoinFactors();
        BitSet factorsToAdd = new BitSet(nJoinFactors);
        BitSet factorsAdded = new BitSet(nJoinFactors);
        factorsToAdd.flip(0, nJoinFactors);
        ArrayList<RexNode> filtersToAdd = new ArrayList<RexNode>(multiJoin.getJoinFilters());
        int prevFactor = -1;
        while (factorsToAdd.cardinality() > 0) {
            int nextFactor;
            boolean selfJoin = false;
            if (factorsAdded.cardinality() == 0) {
                nextFactor = firstFactor;
            } else {
                Integer selfJoinFactor = multiJoin.getOtherSelfJoinFactor(prevFactor);
                if (selfJoinFactor != null && !factorsAdded.get(selfJoinFactor)) {
                    nextFactor = selfJoinFactor;
                    selfJoin = true;
                } else {
                    nextFactor = this.getBestNextFactor(multiJoin, factorsToAdd, factorsAdded, semiJoinOpt, joinTree, filtersToAdd);
                }
            }
            BitSet factorsNeeded = (BitSet)multiJoin.getFactorsRefByFactor(nextFactor).clone();
            if (multiJoin.isNullGenerating(nextFactor)) {
                factorsNeeded.or(multiJoin.getOuterJoinFactors(nextFactor));
            }
            factorsNeeded.and(factorsAdded);
            joinTree = this.addFactorToTree(multiJoin, semiJoinOpt, joinTree, nextFactor, factorsNeeded, filtersToAdd, selfJoin);
            if (joinTree == null) {
                return null;
            }
            factorsToAdd.clear(nextFactor);
            factorsAdded.set(nextFactor);
            prevFactor = nextFactor;
        }
        assert (filtersToAdd.size() == 0);
        return joinTree;
    }

    private int getBestNextFactor(LoptMultiJoin multiJoin, BitSet factorsToAdd, BitSet factorsAdded, LoptSemiJoinOptimizer semiJoinOpt, LoptJoinTree joinTree, List<RexNode> filtersToAdd) {
        int nextFactor = -1;
        int bestWeight = 0;
        Double bestCardinality = null;
        int[][] factorWeights = multiJoin.getFactorWeights();
        for (int factor : BitSets.toIter(factorsToAdd)) {
            Integer factIdx = multiJoin.getJoinRemovalFactor(factor);
            if (factIdx != null && !factorsAdded.get(factIdx)) continue;
            if (multiJoin.isNullGenerating(factor)) {
                BitSet tmp = (BitSet)multiJoin.getOuterJoinFactors(factor).clone();
                tmp.andNot(factorsAdded);
                if (tmp.cardinality() != 0) continue;
            }
            int dimWeight = 0;
            for (int prevFactor : BitSets.toIter(factorsAdded)) {
                if (factorWeights[prevFactor][factor] <= dimWeight) continue;
                dimWeight = factorWeights[prevFactor][factor];
            }
            Double cardinality = null;
            if (dimWeight > 0 && (dimWeight > bestWeight || dimWeight == bestWeight)) {
                cardinality = this.computeJoinCardinality(multiJoin, semiJoinOpt, joinTree, filtersToAdd, factor);
            }
            if (dimWeight <= bestWeight && (dimWeight != bestWeight || bestCardinality != null && (cardinality == null || !(cardinality > bestCardinality)))) continue;
            nextFactor = factor;
            bestWeight = dimWeight;
            bestCardinality = cardinality;
        }
        return nextFactor;
    }

    private boolean isJoinTree(RelNode rel) {
        if (rel instanceof JoinRelBase) {
            assert (((JoinRelBase)rel).getJoinType() != JoinRelType.FULL);
            return true;
        }
        return false;
    }

    private LoptJoinTree addFactorToTree(LoptMultiJoin multiJoin, LoptSemiJoinOptimizer semiJoinOpt, LoptJoinTree joinTree, int factorToAdd, BitSet factorsNeeded, List<RexNode> filtersToAdd, boolean selfJoin) {
        if (multiJoin.isRemovableOuterJoinFactor(factorToAdd)) {
            return this.createReplacementJoin(multiJoin, semiJoinOpt, joinTree, -1, factorToAdd, new ArrayList<Integer>(), null, filtersToAdd);
        }
        if (multiJoin.getJoinRemovalFactor(factorToAdd) != null) {
            return this.createReplacementSemiJoin(multiJoin, semiJoinOpt, joinTree, factorToAdd, filtersToAdd);
        }
        if (joinTree == null) {
            return new LoptJoinTree(semiJoinOpt.getChosenSemiJoin(factorToAdd), factorToAdd);
        }
        ArrayList<RexNode> tmpFilters = new ArrayList<RexNode>(filtersToAdd);
        LoptJoinTree topTree = this.addToTop(multiJoin, semiJoinOpt, joinTree, factorToAdd, filtersToAdd, selfJoin);
        LoptJoinTree pushDownTree = this.pushDownFactor(multiJoin, semiJoinOpt, joinTree, factorToAdd, factorsNeeded, topTree == null ? filtersToAdd : tmpFilters, selfJoin);
        RelOptCost costPushDown = null;
        RelOptCost costTop = null;
        if (pushDownTree != null) {
            costPushDown = RelMetadataQuery.getCumulativeCost(pushDownTree.getJoinTree());
        }
        if (topTree != null) {
            costTop = RelMetadataQuery.getCumulativeCost(topTree.getJoinTree());
        }
        LoptJoinTree bestTree = pushDownTree == null ? topTree : (topTree == null ? pushDownTree : (costPushDown.isEqWithEpsilon(costTop) ? (this.rowWidthCost(pushDownTree.getJoinTree()) < this.rowWidthCost(topTree.getJoinTree()) ? pushDownTree : topTree) : (costPushDown.isLt(costTop) ? pushDownTree : topTree)));
        return bestTree;
    }

    private int rowWidthCost(RelNode tree) {
        int width = tree.getRowType().getFieldCount();
        if (this.isJoinTree(tree)) {
            JoinRelBase joinRel = (JoinRelBase)tree;
            width += this.rowWidthCost(joinRel.getLeft()) + this.rowWidthCost(joinRel.getRight());
        }
        return width;
    }

    private LoptJoinTree pushDownFactor(LoptMultiJoin multiJoin, LoptSemiJoinOptimizer semiJoinOpt, LoptJoinTree joinTree, int factorToAdd, BitSet factorsNeeded, List<RexNode> filtersToAdd, boolean selfJoin) {
        if (!this.isJoinTree(joinTree.getJoinTree())) {
            return null;
        }
        int childNo = -1;
        LoptJoinTree left = joinTree.getLeft();
        LoptJoinTree right = joinTree.getRight();
        JoinRelBase joinRel = (JoinRelBase)joinTree.getJoinTree();
        JoinRelType joinType = joinRel.getJoinType();
        if (joinTree.isRemovableSelfJoin()) {
            return null;
        }
        if (selfJoin) {
            BitSet selfJoinFactor = new BitSet(multiJoin.getNumJoinFactors());
            selfJoinFactor.set(multiJoin.getOtherSelfJoinFactor(factorToAdd));
            if (multiJoin.hasAllFactors(left, selfJoinFactor)) {
                childNo = 0;
            } else {
                assert (multiJoin.hasAllFactors(right, selfJoinFactor));
                childNo = 1;
            }
        } else if (factorsNeeded.cardinality() == 0 && !joinType.generatesNullsOnLeft()) {
            childNo = 0;
        } else if (multiJoin.hasAllFactors(left, factorsNeeded) && !joinType.generatesNullsOnLeft()) {
            childNo = 0;
        } else if (multiJoin.hasAllFactors(right, factorsNeeded) && !joinType.generatesNullsOnRight()) {
            childNo = 1;
        }
        if (childNo == -1) {
            return null;
        }
        ArrayList<Integer> origJoinOrder = new ArrayList<Integer>();
        joinTree.getTreeOrder(origJoinOrder);
        LoptJoinTree subTree = childNo == 0 ? left : right;
        subTree = this.addFactorToTree(multiJoin, semiJoinOpt, subTree, factorToAdd, factorsNeeded, filtersToAdd, selfJoin);
        if (childNo == 0) {
            left = subTree;
        } else {
            right = subTree;
        }
        RexNode newCondition = ((JoinRelBase)joinTree.getJoinTree()).getCondition();
        newCondition = this.adjustFilter(multiJoin, left, right, newCondition, factorToAdd, origJoinOrder, joinTree.getJoinTree().getRowType().getFieldList());
        if (joinType != JoinRelType.LEFT && joinType != JoinRelType.RIGHT) {
            RexNode condition = this.addFilters(multiJoin, left, -1, right, filtersToAdd, true);
            RexBuilder rexBuilder = multiJoin.getMultiJoinRel().getCluster().getRexBuilder();
            newCondition = RelOptUtil.andJoinFilters(rexBuilder, newCondition, condition);
        }
        return this.createJoinSubtree(multiJoin, left, right, newCondition, joinType, filtersToAdd, false, false);
    }

    private LoptJoinTree addToTop(LoptMultiJoin multiJoin, LoptSemiJoinOptimizer semiJoinOpt, LoptJoinTree joinTree, int factorToAdd, List<RexNode> filtersToAdd, boolean selfJoin) {
        JoinRelType joinType;
        if (selfJoin && this.isJoinTree(joinTree.getJoinTree())) {
            return null;
        }
        if (multiJoin.getMultiJoinRel().isFullOuterJoin()) {
            assert (multiJoin.getNumJoinFactors() == 2);
            joinType = JoinRelType.FULL;
        } else {
            joinType = multiJoin.isNullGenerating(factorToAdd) ? JoinRelType.LEFT : JoinRelType.INNER;
        }
        LoptJoinTree rightTree = new LoptJoinTree(semiJoinOpt.getChosenSemiJoin(factorToAdd), factorToAdd);
        RexNode condition = joinType == JoinRelType.LEFT || joinType == JoinRelType.RIGHT ? multiJoin.getOuterJoinCond(factorToAdd) : this.addFilters(multiJoin, joinTree, -1, rightTree, filtersToAdd, false);
        return this.createJoinSubtree(multiJoin, joinTree, rightTree, condition, joinType, filtersToAdd, true, selfJoin);
    }

    private RexNode addFilters(LoptMultiJoin multiJoin, LoptJoinTree leftTree, int leftIdx, LoptJoinTree rightTree, List<RexNode> filtersToAdd, boolean adjust) {
        int[] adjustments;
        RexNode condition = null;
        ListIterator<RexNode> filterIter = filtersToAdd.listIterator();
        int nJoinFactors = multiJoin.getNumJoinFactors();
        RexBuilder rexBuilder = multiJoin.getMultiJoinRel().getCluster().getRexBuilder();
        BitSet childFactors = new BitSet(nJoinFactors);
        if (leftIdx >= 0) {
            childFactors.set(leftIdx);
        } else {
            multiJoin.getChildFactors(leftTree, childFactors);
        }
        multiJoin.getChildFactors(rightTree, childFactors);
        while (filterIter.hasNext()) {
            RexNode joinFilter = filterIter.next();
            BitSet filterBitmap = multiJoin.getFactorsRefByJoinFilter(joinFilter);
            if (!BitSets.contains(childFactors, filterBitmap)) continue;
            condition = condition == null ? joinFilter : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, condition, joinFilter);
            filterIter.remove();
        }
        if (adjust && condition != null && this.needsAdjustment(multiJoin, adjustments = new int[multiJoin.getNumTotalFields()], leftTree, rightTree, false)) {
            condition = ((RexNode)condition).accept(new RelOptUtil.RexInputConverter(rexBuilder, multiJoin.getMultiJoinFields(), leftTree.getJoinTree().getRowType().getFieldList(), rightTree.getJoinTree().getRowType().getFieldList(), adjustments));
        }
        if (condition == null) {
            condition = rexBuilder.makeLiteral(true);
        }
        return condition;
    }

    private RexNode adjustFilter(LoptMultiJoin multiJoin, LoptJoinTree left, LoptJoinTree right, RexNode condition, int factorAdded, List<Integer> origJoinOrder, List<RelDataTypeField> origFields) {
        ArrayList<Integer> newJoinOrder = new ArrayList<Integer>();
        left.getTreeOrder(newJoinOrder);
        right.getTreeOrder(newJoinOrder);
        int totalFields = left.getJoinTree().getRowType().getFieldCount() + right.getJoinTree().getRowType().getFieldCount() - multiJoin.getNumFieldsInJoinFactor(factorAdded);
        int[] adjustments = new int[totalFields];
        boolean needAdjust = false;
        int nFieldsNew = 0;
        int newPos = 0;
        while (newPos < newJoinOrder.size()) {
            int nFieldsOld = 0;
            int factor = (Integer)newJoinOrder.get(newPos);
            if (factor != factorAdded) {
                for (int pos : origJoinOrder) {
                    if (factor == pos) break;
                    nFieldsOld += multiJoin.getNumFieldsInJoinFactor(pos);
                }
                if (this.remapJoinReferences(multiJoin, factor, newJoinOrder, newPos, adjustments, nFieldsOld, nFieldsNew, false)) {
                    needAdjust = true;
                }
            }
            nFieldsNew += multiJoin.getNumFieldsInJoinFactor(factor);
            ++newPos;
        }
        if (needAdjust) {
            RexBuilder rexBuilder = multiJoin.getMultiJoinRel().getCluster().getRexBuilder();
            condition = condition.accept(new RelOptUtil.RexInputConverter(rexBuilder, origFields, left.getJoinTree().getRowType().getFieldList(), right.getJoinTree().getRowType().getFieldList(), adjustments));
        }
        return condition;
    }

    private boolean remapJoinReferences(LoptMultiJoin multiJoin, int factor, List<Integer> newJoinOrder, int newPos, int[] adjustments, int offset, int newOffset, boolean alwaysUseDefault) {
        boolean needAdjust;
        block4: {
            int defaultAdjustment;
            block3: {
                needAdjust = false;
                defaultAdjustment = -offset + newOffset;
                if (alwaysUseDefault || !multiJoin.isRightFactorInRemovableSelfJoin(factor) || newPos == 0 || !newJoinOrder.get(newPos - 1).equals(multiJoin.getOtherSelfJoinFactor(factor))) break block3;
                int nLeftFields = multiJoin.getNumFieldsInJoinFactor(newJoinOrder.get(newPos - 1));
                int i = 0;
                while (i < multiJoin.getNumFieldsInJoinFactor(factor)) {
                    Integer leftOffset = multiJoin.getRightColumnMapping(factor, i);
                    adjustments[i + offset] = leftOffset == null ? defaultAdjustment : -(offset + i) + (newOffset - nLeftFields) + leftOffset;
                    if (adjustments[i + offset] != 0) {
                        needAdjust = true;
                    }
                    ++i;
                }
                break block4;
            }
            if (defaultAdjustment == 0) break block4;
            needAdjust = true;
            int i = 0;
            while (i < multiJoin.getNumFieldsInJoinFactor(newJoinOrder.get(newPos))) {
                adjustments[i + offset] = defaultAdjustment;
                ++i;
            }
        }
        return needAdjust;
    }

    private LoptJoinTree createReplacementSemiJoin(LoptMultiJoin multiJoin, LoptSemiJoinOptimizer semiJoinOpt, LoptJoinTree factTree, int dimIdx, List<RexNode> filtersToAdd) {
        if (factTree == null) {
            return null;
        }
        int factIdx = multiJoin.getJoinRemovalFactor(dimIdx);
        ArrayList<Integer> joinOrder = new ArrayList<Integer>();
        factTree.getTreeOrder(joinOrder);
        assert (joinOrder.contains(factIdx));
        int adjustment = 0;
        for (Integer factor : joinOrder) {
            if (factor == factIdx) break;
            adjustment += multiJoin.getNumFieldsInJoinFactor(factor);
        }
        List<RelDataTypeField> dimFields = multiJoin.getJoinFactor(dimIdx).getRowType().getFieldList();
        int nDimFields = dimFields.size();
        Integer[] replacementKeys = new Integer[nDimFields];
        SemiJoinRel semiJoin = multiJoin.getJoinRemovalSemiJoin(dimIdx);
        List<Integer> dimKeys = semiJoin.getRightKeys();
        List<Integer> factKeys = semiJoin.getLeftKeys();
        int i = 0;
        while (i < dimKeys.size()) {
            replacementKeys[dimKeys.get((int)i).intValue()] = factKeys.get(i) + adjustment;
            ++i;
        }
        return this.createReplacementJoin(multiJoin, semiJoinOpt, factTree, factIdx, dimIdx, dimKeys, replacementKeys, filtersToAdd);
    }

    private LoptJoinTree createReplacementJoin(LoptMultiJoin multiJoin, LoptSemiJoinOptimizer semiJoinOpt, LoptJoinTree currJoinTree, int leftIdx, int factorToAdd, List<Integer> newKeys, Integer[] replacementKeys, List<RexNode> filtersToAdd) {
        RelNode currJoinRel = currJoinTree.getJoinTree();
        List<RelDataTypeField> currFields = currJoinRel.getRowType().getFieldList();
        int nCurrFields = currFields.size();
        List<RelDataTypeField> newFields = multiJoin.getJoinFactor(factorToAdd).getRowType().getFieldList();
        int nNewFields = newFields.size();
        ArrayList projects = Lists.newArrayList();
        RexBuilder rexBuilder = currJoinRel.getCluster().getRexBuilder();
        RelDataTypeFactory typeFactory = rexBuilder.getTypeFactory();
        int i = 0;
        while (i < nCurrFields) {
            projects.add(Pair.of(rexBuilder.makeInputRef(currFields.get(i).getType(), i), currFields.get(i).getName()));
            ++i;
        }
        i = 0;
        while (i < nNewFields) {
            RexNode projExpr;
            RelDataType newType = newFields.get(i).getType();
            if (!newKeys.contains(i)) {
                if (replacementKeys == null) {
                    newType = typeFactory.createTypeWithNullability(newType, true);
                }
                projExpr = rexBuilder.makeCast(newType, rexBuilder.constantNull());
            } else {
                RelDataTypeField mappedField = currFields.get(replacementKeys[i]);
                RexInputRef mappedInput = rexBuilder.makeInputRef(mappedField.getType(), (int)replacementKeys[i]);
                projExpr = mappedField.getType() == newType ? mappedInput : rexBuilder.makeCast(newFields.get(i).getType(), mappedInput);
            }
            projects.add(Pair.of(projExpr, newFields.get(i).getName()));
            ++i;
        }
        ProjectRel projRel = (ProjectRel)CalcRel.createProject(currJoinRel, projects, false);
        LoptJoinTree newTree = new LoptJoinTree(semiJoinOpt.getChosenSemiJoin(factorToAdd), factorToAdd);
        this.addFilters(multiJoin, currJoinTree, leftIdx, newTree, filtersToAdd, false);
        RelNode topRelNode = projRel;
        if (leftIdx >= 0) {
            topRelNode = this.addAdditionalFilters(topRelNode, multiJoin, currJoinTree, newTree, filtersToAdd);
        }
        return new LoptJoinTree(topRelNode, currJoinTree.getFactorTree(), newTree.getFactorTree());
    }

    private LoptJoinTree createJoinSubtree(LoptMultiJoin multiJoin, LoptJoinTree left, LoptJoinTree right, RexNode condition, JoinRelType joinType, List<RexNode> filtersToAdd, boolean fullAdjust, boolean selfJoin) {
        int[] adjustments;
        RexBuilder rexBuilder = multiJoin.getMultiJoinRel().getCluster().getRexBuilder();
        if (this.swapInputs(multiJoin, left, right, selfJoin)) {
            LoptJoinTree tmp = right;
            right = left;
            left = tmp;
            if (!fullAdjust) {
                condition = this.swapFilter(rexBuilder, multiJoin, right, left, condition);
            }
            if (joinType != JoinRelType.INNER && joinType != JoinRelType.FULL) {
                JoinRelType joinRelType = joinType = joinType == JoinRelType.LEFT ? JoinRelType.RIGHT : JoinRelType.LEFT;
            }
        }
        if (fullAdjust && this.needsAdjustment(multiJoin, adjustments = new int[multiJoin.getNumTotalFields()], left, right, selfJoin)) {
            condition = condition.accept(new RelOptUtil.RexInputConverter(rexBuilder, multiJoin.getMultiJoinFields(), left.getJoinTree().getRowType().getFieldList(), right.getJoinTree().getRowType().getFieldList(), adjustments));
        }
        RelNode joinTree = this.joinFactory.createJoin(left.getJoinTree(), right.getJoinTree(), condition, joinType, (Set<String>)ImmutableSet.of(), true);
        if (joinType == JoinRelType.LEFT || joinType == JoinRelType.RIGHT) {
            assert (!selfJoin);
            joinTree = this.addAdditionalFilters(joinTree, multiJoin, left, right, filtersToAdd);
        }
        return new LoptJoinTree(joinTree, left.getFactorTree(), right.getFactorTree(), selfJoin);
    }

    private RelNode addAdditionalFilters(RelNode joinTree, LoptMultiJoin multiJoin, LoptJoinTree left, LoptJoinTree right, List<RexNode> filtersToAdd) {
        RexNode filterCond = this.addFilters(multiJoin, left, -1, right, filtersToAdd, false);
        if (filterCond.isAlwaysTrue()) {
            return joinTree;
        }
        int[] adjustments = new int[multiJoin.getNumTotalFields()];
        if (this.needsAdjustment(multiJoin, adjustments, left, right, false)) {
            RexBuilder rexBuilder = multiJoin.getMultiJoinRel().getCluster().getRexBuilder();
            filterCond = filterCond.accept(new RelOptUtil.RexInputConverter(rexBuilder, multiJoin.getMultiJoinFields(), joinTree.getRowType().getFieldList(), adjustments));
        }
        joinTree = CalcRel.createFilter(joinTree, filterCond);
        return joinTree;
    }

    private boolean swapInputs(LoptMultiJoin multiJoin, LoptJoinTree left, LoptJoinTree right, boolean selfJoin) {
        boolean swap = false;
        if (selfJoin) {
            return !multiJoin.isLeftFactorInRemovableSelfJoin(left.getFactorTree().getId());
        }
        Double leftRowCount = RelMetadataQuery.getRowCount(left.getJoinTree());
        Double rightRowCount = RelMetadataQuery.getRowCount(right.getJoinTree());
        if (leftRowCount != null && rightRowCount != null && (leftRowCount < rightRowCount || Math.abs(leftRowCount - rightRowCount) < 1.0E-5 && this.rowWidthCost(left.getJoinTree()) < this.rowWidthCost(right.getJoinTree()))) {
            swap = true;
        }
        return swap;
    }

    private RexNode swapFilter(RexBuilder rexBuilder, LoptMultiJoin multiJoin, LoptJoinTree origLeft, LoptJoinTree origRight, RexNode condition) {
        int nFieldsOnLeft = origLeft.getJoinTree().getRowType().getFieldCount();
        int nFieldsOnRight = origRight.getJoinTree().getRowType().getFieldCount();
        int[] adjustments = new int[nFieldsOnLeft + nFieldsOnRight];
        int i = 0;
        while (i < nFieldsOnLeft) {
            adjustments[i] = nFieldsOnRight;
            ++i;
        }
        i = nFieldsOnLeft;
        while (i < nFieldsOnLeft + nFieldsOnRight) {
            adjustments[i] = -nFieldsOnLeft;
            ++i;
        }
        condition = condition.accept(new RelOptUtil.RexInputConverter(rexBuilder, multiJoin.getJoinFields(origLeft, origRight), multiJoin.getJoinFields(origRight, origLeft), adjustments));
        return condition;
    }

    private boolean needsAdjustment(LoptMultiJoin multiJoin, int[] adjustments, LoptJoinTree joinTree, LoptJoinTree otherTree, boolean selfJoin) {
        boolean needAdjustment = false;
        ArrayList<Integer> joinOrder = new ArrayList<Integer>();
        joinTree.getTreeOrder(joinOrder);
        if (otherTree != null) {
            otherTree.getTreeOrder(joinOrder);
        }
        int nFields = 0;
        int newPos = 0;
        while (newPos < joinOrder.size()) {
            int joinStart;
            int origPos = (Integer)joinOrder.get(newPos);
            if (this.remapJoinReferences(multiJoin, origPos, joinOrder, newPos, adjustments, joinStart = multiJoin.getJoinStart(origPos), nFields, selfJoin)) {
                needAdjustment = true;
            }
            nFields += multiJoin.getNumFieldsInJoinFactor(origPos);
            ++newPos;
        }
        return needAdjustment;
    }

    public static boolean isRemovableSelfJoin(JoinRelBase joinRel) {
        RelNode left = joinRel.getLeft();
        RelNode right = joinRel.getRight();
        if (joinRel.getJoinType() != JoinRelType.INNER) {
            return false;
        }
        RelOptTable leftTable = RelMetadataQuery.getTableOrigin(left);
        if (leftTable == null) {
            return false;
        }
        RelOptTable rightTable = RelMetadataQuery.getTableOrigin(right);
        if (rightTable == null) {
            return false;
        }
        if (!leftTable.getQualifiedName().equals(rightTable.getQualifiedName())) {
            return false;
        }
        return LoptOptimizeJoinRule.areSelfJoinKeysUnique(left, right, joinRel.getCondition());
    }

    private static boolean areSelfJoinKeysUnique(RelNode leftRel, RelNode rightRel, RexNode joinFilters) {
        ArrayList<Integer> leftKeys = new ArrayList<Integer>();
        ArrayList<Integer> rightKeys = new ArrayList<Integer>();
        RelOptUtil.splitJoinCondition(leftRel, rightRel, joinFilters, leftKeys, rightKeys);
        for (IntPair pair : IntPair.zip(leftKeys, rightKeys)) {
            RelColumnOrigin leftOrigin = RelMetadataQuery.getColumnOrigin(leftRel, pair.source);
            if (leftOrigin == null) {
                return false;
            }
            RelColumnOrigin rightOrigin = RelMetadataQuery.getColumnOrigin(rightRel, pair.target);
            if (rightOrigin == null) {
                return false;
            }
            if (leftOrigin.getOriginColumnOrdinal() == rightOrigin.getOriginColumnOrdinal()) continue;
            return false;
        }
        return RelMdUtil.areColumnsDefinitelyUniqueWhenNullsFiltered(leftRel, BitSets.of(leftKeys));
    }
}

