/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.hydromatic.linq4j.Ord;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelCollationTraitDef;
import org.eigenbase.rel.RelInput;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.rel.SingleRel;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexChecker;
import org.eigenbase.rex.RexFieldAccess;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLocalRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.rex.RexVisitorImpl;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProjectRelBase
extends SingleRel {
    protected final ImmutableList<RexNode> exps;
    protected int flags;
    protected final ImmutableList<RelCollation> collationList;

    protected ProjectRelBase(RelOptCluster cluster, RelTraitSet traits, RelNode child, List<RexNode> exps, RelDataType rowType, int flags) {
        super(cluster, traits, child);
        assert (rowType != null);
        this.exps = ImmutableList.copyOf(exps);
        this.rowType = rowType;
        this.flags = flags;
        RelCollation collation = traits.getTrait(RelCollationTraitDef.INSTANCE);
        ImmutableList immutableList = this.collationList = collation == null ? ImmutableList.of() : ImmutableList.of((Object)collation);
        assert (this.isValid(true));
    }

    protected ProjectRelBase(RelInput input) {
        this(input.getCluster(), input.getTraitSet(), input.getInput(), input.getExpressionList("exprs"), input.getRowType("exprs", "fields"), 1);
    }

    @Override
    public final RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, ProjectRelBase.sole(inputs), (List<RexNode>)this.exps, this.rowType);
    }

    public abstract ProjectRelBase copy(RelTraitSet var1, RelNode var2, List<RexNode> var3, RelDataType var4);

    @Override
    public List<RelCollation> getCollationList() {
        return this.collationList;
    }

    public boolean isBoxed() {
        return (this.flags & 1) == 1;
    }

    @Override
    public List<RexNode> getChildExps() {
        return this.exps;
    }

    public List<RexNode> getProjects() {
        return this.exps;
    }

    public final List<Pair<RexNode, String>> getNamedProjects() {
        return Pair.zip(this.getProjects(), this.getRowType().getFieldNames());
    }

    public int getFlags() {
        return this.flags;
    }

    @Override
    public boolean isValid(boolean fail) {
        if (!super.isValid(fail)) {
            assert (!fail);
            return false;
        }
        if (!RexUtil.compatibleTypes(this.exps, this.getRowType(), true)) {
            assert (!fail);
            return false;
        }
        RexChecker checker = new RexChecker(this.getChild().getRowType(), fail);
        for (RexNode exp : this.exps) {
            exp.accept(checker);
        }
        if (checker.getFailureCount() > 0) {
            assert (!fail);
            return false;
        }
        if (!this.isBoxed() && this.exps.size() != 1) {
            assert (!fail);
            return false;
        }
        if (this.collationList == null) {
            assert (!fail);
            return false;
        }
        if (!this.collationList.isEmpty() && this.collationList.get(0) != this.traitSet.getTrait(RelCollationTraitDef.INSTANCE)) {
            assert (!fail);
            return false;
        }
        if (!Util.isDistinct(this.rowType.getFieldNames())) {
            assert (!fail) : this.rowType;
            return false;
        }
        return true;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        double dRows = RelMetadataQuery.getRowCount(this.getChild());
        double dCpu = dRows * (double)this.exps.size();
        double dIo = 0.0;
        return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        if (pw.nest()) {
            pw.item("fields", this.rowType.getFieldNames());
            pw.item("exprs", this.exps);
        } else {
            for (Ord field : Ord.zip(this.rowType.getFieldList())) {
                String fieldName = ((RelDataTypeField)field.e).getName();
                if (fieldName == null) {
                    fieldName = "field#" + field.i;
                }
                pw.item(fieldName, this.exps.get(field.i));
            }
        }
        pw.getDetailLevel();
        return pw;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Checker
    extends RexVisitorImpl<Boolean> {
        private final boolean fail;
        private final RelDataType inputRowType;
        int failCount = 0;

        private Checker(RelDataType inputRowType, boolean fail) {
            super(true);
            this.fail = fail;
            this.inputRowType = inputRowType;
        }

        @Override
        public Boolean visitInputRef(RexInputRef inputRef) {
            int index = inputRef.getIndex();
            List<RelDataTypeField> fields = this.inputRowType.getFieldList();
            if (index < 0 || index >= fields.size()) {
                assert (!this.fail);
                ++this.failCount;
                return false;
            }
            if (!RelOptUtil.eq("inputRef", inputRef.getType(), "underlying field", fields.get(index).getType(), this.fail)) {
                assert (!this.fail);
                ++this.failCount;
                return false;
            }
            return true;
        }

        @Override
        public Boolean visitLocalRef(RexLocalRef localRef) {
            assert (!this.fail) : "localRef invalid in project";
            ++this.failCount;
            return false;
        }

        @Override
        public Boolean visitFieldAccess(RexFieldAccess fieldAccess) {
            super.visitFieldAccess(fieldAccess);
            RelDataType refType = fieldAccess.getReferenceExpr().getType();
            assert (refType.isStruct());
            RelDataTypeField field = fieldAccess.getField();
            int index = field.getIndex();
            if (index < 0 || index > refType.getFieldList().size()) {
                assert (!this.fail);
                ++this.failCount;
                return false;
            }
            RelDataTypeField typeField = refType.getFieldList().get(index);
            if (!RelOptUtil.eq("type1", typeField.getType(), "type2", fieldAccess.getType(), this.fail)) {
                assert (!this.fail);
                ++this.failCount;
                return false;
            }
            return true;
        }
    }

    public static class Flags {
        public static final int ANON_FIELDS = 2;
        public static final int BOXED = 1;
        public static final int NONE = 0;
    }
}

