/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.tools;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.hydromatic.optiq.prepare.OptiqPrepareImpl;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlRun {
    private static final Ordering<String[]> ORDERING = Ordering.natural().nullsLast().lexicographical().onResultOf((Function)new Function<String[], Iterable<Comparable>>(){

        public Iterable<Comparable> apply(String[] input) {
            return Arrays.asList(input);
        }
    });
    private BufferedReader reader;
    private Writer writer;
    private PrintWriter printWriter;
    private final Map<Property, Object> map = new HashMap<Property, Object>();
    private ResultSet resultSet;
    private boolean sort;
    private SQLException resultSetException;
    private final List<String> lines = new ArrayList<String>();
    private String pushedLine;
    private final StringBuilder buf = new StringBuilder();
    private Connection connection;
    private ConnectionFactory connectionFactory;
    private boolean execute = true;
    private boolean skip = false;

    public SqlRun(BufferedReader reader, Writer writer) {
        this.reader = reader;
        this.writer = writer;
        this.map.put(Property.OUTPUTFORMAT, (Object)OutputFormat.CSV);
    }

    public static void main(String[] args) {
        FileWriter writer;
        LineNumberReader reader;
        File inFile = new File(args[0]);
        File outFile = new File(args[1]);
        try {
            reader = new LineNumberReader(new FileReader(inFile));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Error opening input " + inFile, e);
        }
        try {
            writer = new FileWriter(outFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening output " + outFile, e);
        }
        SqlRun sqlRun = new SqlRun(new BufferedReader(reader), writer);
        try {
            sqlRun.execute(new ConnectionFactory(){

                public Connection connect(String name) {
                    throw new UnsupportedOperationException();
                }
            });
            ((Reader)reader).close();
            ((Writer)writer).close();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void execute(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        this.printWriter = new PrintWriter(this.writer);
        try {
            Command command = new Parser().parse();
            try {
                command.execute(this.execute);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while executing command " + command, e);
            }
        }
        finally {
            this.printWriter.flush();
            this.connection = null;
        }
    }

    Command of(List<Command> commands) {
        return commands.size() == 1 ? commands.get(0) : new CompositeCommand((List<Command>)ImmutableList.copyOf(commands));
    }

    private static String pad(String s, int width, boolean right) {
        int x;
        if (s == null) {
            s = "";
        }
        if ((x = width - s.length()) <= 0) {
            return s;
        }
        StringBuilder buf = new StringBuilder();
        if (right) {
            buf.append(SqlRun.chars(' ', x)).append(s);
        } else {
            buf.append(s).append(SqlRun.chars(' ', x));
        }
        return buf.toString();
    }

    private static CharSequence chars(final char c, final int length) {
        return new CharSequence(){

            public String toString() {
                StringBuilder buf = new StringBuilder();
                int i = 0;
                while (i < length) {
                    buf.append(c);
                    ++i;
                }
                return buf.toString();
            }

            public int length() {
                return length;
            }

            public char charAt(int index) {
                return c;
            }

            public CharSequence subSequence(int start, int end) {
                return SqlRun.chars(c, end - start);
            }
        };
    }

    private static void format(ResultSet resultSet, List<String> headerLines, List<String> bodyLines, List<String> footerLines, boolean sort, boolean mysql) throws SQLException {
        int i;
        ResultSetMetaData metaData = resultSet.getMetaData();
        int n = metaData.getColumnCount();
        int[] widths = new int[n];
        ArrayList<String[]> rows = new ArrayList<String[]>();
        boolean[] rights = new boolean[n];
        int i2 = 0;
        while (i2 < n) {
            widths[i2] = metaData.getColumnLabel(i2 + 1).length();
            ++i2;
        }
        while (resultSet.next()) {
            String[] row = new String[n];
            i = 0;
            while (i < n) {
                String value = resultSet.getString(i + 1);
                widths[i] = Math.max(widths[i], value == null ? 0 : value.length());
                row[i] = value;
                ++i;
            }
            rows.add(row);
        }
        i = 0;
        while (i < widths.length) {
            switch (metaData.getColumnType(i + 1)) {
                case 4: {
                    rights[i] = true;
                }
            }
            ++i;
        }
        if (sort) {
            Collections.sort(rows, ORDERING);
        }
        StringBuilder buf = new StringBuilder();
        i = 0;
        while (i < n) {
            buf.append(mysql || i > 0 ? "+" : "");
            buf.append(SqlRun.chars('-', widths[i] + 2));
            ++i;
        }
        buf.append(mysql ? "+" : "");
        String hyphens = SqlRun.flush(buf);
        if (mysql) {
            headerLines.add(hyphens);
        }
        int i3 = 0;
        while (i3 < n) {
            buf.append(i3 > 0 ? " | " : (mysql ? "| " : " "));
            buf.append(SqlRun.pad(metaData.getColumnLabel(i3 + 1), widths[i3], false));
            ++i3;
        }
        buf.append(mysql ? " |" : "");
        headerLines.add(SqlRun.flush(buf));
        headerLines.add(hyphens);
        for (String[] row : rows) {
            int i4 = 0;
            while (i4 < n) {
                buf.append(i4 > 0 ? " | " : (mysql ? "| " : " "));
                String s = !mysql && i4 == n - 1 && !rights[i4] ? row[i4] : SqlRun.pad(row[i4], widths[i4], rights[i4]);
                buf.append(s);
                ++i4;
            }
            buf.append(mysql ? " |" : "");
            bodyLines.add(SqlRun.flush(buf));
        }
        if (mysql) {
            footerLines.add(hyphens);
        }
        footerLines.add(rows.size() == 1 ? "(1 row)" : "(" + rows.size() + " rows)");
        footerLines.add("");
    }

    private static String flush(StringBuilder buf) {
        String s = buf.toString();
        buf.setLength(0);
        return s;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AbstractCommand
    implements Command {
        AbstractCommand() {
        }

        protected Command echo(Iterable<String> lines) {
            for (String line : lines) {
                try {
                    SqlRun.this.printWriter.println(line);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while writing output", e);
                }
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CheckResultCommand
    extends SimpleCommand {
        private final SqlCommand sqlCommand;

        public CheckResultCommand(List<String> lines, SqlCommand sqlCommand) {
            super(lines);
            this.sqlCommand = sqlCommand;
        }

        @Override
        public void execute(boolean execute) throws Exception {
            if (execute) {
                OutputFormat format = (OutputFormat)((Object)SqlRun.this.map.get((Object)Property.OUTPUTFORMAT));
                if (SqlRun.this.resultSet != null) {
                    ArrayList<String> headerLines = new ArrayList<String>();
                    ArrayList<String> bodyLines = new ArrayList<String>();
                    ArrayList<String> footerLines = new ArrayList<String>();
                    format.format(SqlRun.this.resultSet, headerLines, bodyLines, footerLines, SqlRun.this);
                    ArrayList lines = new ArrayList(this.sqlCommand.output);
                    for (String line : headerLines) {
                        if (lines.isEmpty()) continue;
                        lines.remove(0);
                    }
                    for (String line : footerLines) {
                        if (lines.isEmpty()) continue;
                        lines.remove(lines.size() - 1);
                    }
                    for (String line : headerLines) {
                        SqlRun.this.printWriter.println(line);
                    }
                    for (String line : lines) {
                        if (!bodyLines.remove(line)) continue;
                        SqlRun.this.printWriter.println(line);
                    }
                    for (String line : bodyLines) {
                        SqlRun.this.printWriter.println(line);
                    }
                    for (String line : footerLines) {
                        SqlRun.this.printWriter.println(line);
                    }
                    SqlRun.this.resultSet.close();
                } else if (SqlRun.this.resultSetException != null) {
                    SqlRun.this.resultSetException.printStackTrace(SqlRun.this.printWriter);
                } else {
                    throw new AssertionError((Object)"neither resultSet nor exception set");
                }
                SqlRun.this.resultSet = null;
                SqlRun.this.resultSetException = null;
            }
            this.echo((Iterable<String>)this.lines);
        }
    }

    static interface Command {
        public void execute(boolean var1) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CommentCommand
    extends SimpleCommand {
        public CommentCommand(List<String> lines) {
            super(lines);
        }

        @Override
        public void execute(boolean execute) throws Exception {
            this.echo((Iterable<String>)this.lines);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CompositeCommand
    extends AbstractCommand {
        private final List<Command> commands;

        public CompositeCommand(List<Command> commands) {
            this.commands = commands;
        }

        @Override
        public void execute(boolean execute) throws Exception {
            for (Command command : this.commands) {
                try {
                    command.execute(execute);
                }
                catch (Exception e) {
                    command.execute(false);
                    SqlRun.this.printWriter.println("Error while executing command " + command);
                    e.printStackTrace(SqlRun.this.printWriter);
                }
            }
        }
    }

    public static interface ConnectionFactory {
        public Connection connect(String var1) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IfCommand
    extends AbstractCommand {
        private final List<String> ifLines;
        private final List<String> endLines;
        private final Command command;

        public IfCommand(List<String> ifLines, List<String> endLines, Command command) {
            this.ifLines = ImmutableList.copyOf(ifLines);
            this.endLines = ImmutableList.copyOf(endLines);
            this.command = command;
        }

        @Override
        public void execute(boolean execute) throws Exception {
            this.echo(this.ifLines);
            boolean oldExecute = SqlRun.this.execute;
            boolean newExecute = execute;
            if (!SqlRun.this.skip) {
                newExecute = false;
            }
            this.command.execute(newExecute);
            this.echo(this.endLines);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum OutputFormat {
        CSV{

            @Override
            public void format(ResultSet resultSet, List<String> headerLines, List<String> bodyLines, List<String> footerLines, SqlRun run) throws Exception {
                ResultSetMetaData metaData = resultSet.getMetaData();
                PrintWriter pw = run.printWriter;
                int n = metaData.getColumnCount();
                int i = 0;
                while (i < n) {
                    if (i > 0) {
                        pw.print(", ");
                    }
                    pw.print(metaData.getColumnLabel(i + 1));
                    ++i;
                }
                pw.println();
                while (resultSet.next()) {
                    i = 0;
                    while (i < n) {
                        if (i > 0) {
                            pw.print(", ");
                        }
                        pw.print(resultSet.getString(i + 1));
                        ++i;
                    }
                    pw.println();
                }
            }
        }
        ,
        PSQL{

            @Override
            public void format(ResultSet resultSet, List<String> headerLines, List<String> bodyLines, List<String> footerLines, SqlRun run) throws Exception {
                SqlRun.format(resultSet, headerLines, bodyLines, footerLines, run.sort, false);
            }
        }
        ,
        MYSQL{

            @Override
            public void format(ResultSet resultSet, List<String> headerLines, List<String> bodyLines, List<String> footerLines, SqlRun run) throws Exception {
                SqlRun.format(resultSet, headerLines, bodyLines, footerLines, run.sort, true);
            }
        };


        public abstract void format(ResultSet var1, List<String> var2, List<String> var3, List<String> var4, SqlRun var5) throws Exception;
    }

    private class Parser {
        final List<Command> commands = new ArrayList<Command>();

        private Parser() {
        }

        Command parse() {
            while (true) {
                Command command;
                try {
                    command = this.nextCommand();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error while reading next command", e);
                }
                if (command == null) break;
                this.commands.add(command);
            }
            return SqlRun.this.of(this.commands);
        }

        private Command nextCommand() throws IOException {
            String line;
            block13: {
                SqlRun.this.lines.clear();
                line = this.nextLine();
                if (line == null) {
                    return null;
                }
                if (line.startsWith("#") || line.isEmpty()) {
                    return new CommentCommand(SqlRun.this.lines);
                }
                if (line.startsWith("!")) {
                    line = line.substring(1);
                    while (line.startsWith(" ")) {
                        line = line.substring(1);
                    }
                    if (line.startsWith("use")) {
                        String[] parts = line.split(" ");
                        return new UseCommand(SqlRun.this.lines, parts[1]);
                    }
                    if (line.startsWith("ok")) {
                        SqlCommand command = (SqlCommand)Util.last(this.commands);
                        return new CheckResultCommand(SqlRun.this.lines, command);
                    }
                    if (line.startsWith("skip")) {
                        return new SkipCommand(SqlRun.this.lines);
                    }
                    if (line.startsWith("set outputformat")) {
                        String[] parts = line.split(" ");
                        OutputFormat outputFormat = OutputFormat.valueOf(parts[2].toUpperCase());
                        return new SetCommand(SqlRun.this.lines, Property.OUTPUTFORMAT, (Object)outputFormat);
                    }
                    if (line.equals("if (false) {")) {
                        ImmutableList ifLines = ImmutableList.copyOf((Collection)SqlRun.this.lines);
                        SqlRun.this.lines.clear();
                        Command command = new Parser().parse();
                        return new IfCommand((List<String>)ifLines, SqlRun.this.lines, command);
                    }
                    if (line.equals("}")) {
                        return null;
                    }
                    throw new RuntimeException("Unknown command: " + line);
                }
                SqlRun.this.buf.setLength(0);
                do {
                    boolean last = false;
                    if (line.endsWith(";")) {
                        last = true;
                        line = line.substring(0, line.length() - 1);
                    }
                    SqlRun.this.buf.append(line).append("\n");
                    if (last) break block13;
                } while ((line = this.nextLine()) != null);
                throw new RuntimeException("end of file reached before end of SQL command");
            }
            ImmutableList sqlLines = ImmutableList.copyOf((Collection)SqlRun.this.lines);
            String sql = SqlRun.this.buf.toString();
            while ((line = this.nextLine()) != null && !line.startsWith("!") && !line.startsWith("#")) {
            }
            this.pushLine();
            List<String> outputLines = SqlRun.this.lines.subList(sqlLines.size(), SqlRun.this.lines.size());
            return new SqlCommand((List<String>)sqlLines, sql, outputLines);
        }

        private void pushLine() {
            if (SqlRun.this.pushedLine != null) {
                throw new AssertionError((Object)"cannot push two lines");
            }
            if (SqlRun.this.lines.size() == 0) {
                throw new AssertionError((Object)"no line has been read");
            }
            SqlRun.this.pushedLine = (String)SqlRun.this.lines.get(SqlRun.this.lines.size() - 1);
            SqlRun.this.lines.remove(SqlRun.this.lines.size() - 1);
        }

        private String nextLine() throws IOException {
            String line;
            if (SqlRun.this.pushedLine != null) {
                line = SqlRun.this.pushedLine;
                SqlRun.this.pushedLine = null;
            } else {
                line = SqlRun.this.reader.readLine();
                if (line == null) {
                    return null;
                }
            }
            SqlRun.this.lines.add(line);
            return line;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Property {
        OUTPUTFORMAT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SetCommand
    extends SimpleCommand {
        private final Property property;
        private final Object value;

        public SetCommand(List<String> lines, Property property, Object value) {
            super(lines);
            this.property = property;
            this.value = value;
        }

        @Override
        public void execute(boolean execute) throws Exception {
            this.echo((Iterable<String>)this.lines);
            SqlRun.this.map.put(this.property, this.value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class SimpleCommand
    extends AbstractCommand {
        protected final ImmutableList<String> lines;

        public SimpleCommand(List<String> lines) {
            this.lines = ImmutableList.copyOf(lines);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SkipCommand
    extends SimpleCommand {
        public SkipCommand(List<String> lines) {
            super(lines);
        }

        @Override
        public void execute(boolean execute) throws Exception {
            this.echo((Iterable<String>)this.lines);
            SqlRun.this.skip = true;
            SqlRun.this.execute = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SqlCommand
    extends SimpleCommand {
        private final String sql;
        private final ImmutableList<String> output;

        protected SqlCommand(List<String> lines, String sql, List<String> output) {
            super(lines);
            this.sql = sql;
            this.output = ImmutableList.copyOf(output);
        }

        @Override
        public void execute(boolean execute) throws Exception {
            this.echo((Iterable<String>)this.lines);
            if (execute) {
                if (SqlRun.this.connection == null) {
                    throw new RuntimeException("no connection");
                }
                Statement statement = SqlRun.this.connection.createStatement();
                if (SqlRun.this.resultSet != null) {
                    throw new AssertionError((Object)"result set already present");
                }
                try {
                    if (OptiqPrepareImpl.DEBUG) {
                        System.out.println("sql=" + this.sql);
                    }
                    SqlRun.this.resultSet = statement.executeQuery(this.sql);
                    SqlRun.this.sort = !this.sql.toUpperCase().contains("ORDER BY");
                }
                catch (SQLException e) {
                    SqlRun.this.resultSetException = e;
                }
            } else {
                this.echo((Iterable<String>)this.output);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UseCommand
    extends SimpleCommand {
        private final String name;

        public UseCommand(List<String> lines, String name) {
            super(lines);
            this.name = name;
        }

        @Override
        public void execute(boolean execute) throws Exception {
            this.echo((Iterable<String>)this.lines);
            if (SqlRun.this.connection != null) {
                SqlRun.this.connection.close();
            }
            SqlRun.this.connection = SqlRun.this.connectionFactory.connect(this.name);
        }
    }
}

