/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.runtime;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.sql.Array;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import net.hydromatic.avatica.ByteString;
import net.hydromatic.linq4j.Enumerable;
import net.hydromatic.linq4j.Linq4j;
import net.hydromatic.linq4j.expressions.Primitive;
import net.hydromatic.linq4j.function.Deterministic;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.linq4j.function.NonDeterministic;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.runtime.Like;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deterministic
public class SqlFunctions {
    private static final DecimalFormat DOUBLE_FORMAT = new DecimalFormat("0.0E0");
    public static final int EPOCH_JULIAN = 2440588;
    private static final TimeZone LOCAL_TZ = TimeZone.getDefault();
    private static final Function1<List<Object>, Enumerable<Object>> LIST_AS_ENUMERABLE = new Function1<List<Object>, Enumerable<Object>>(){

        public Enumerable<Object> apply(List<Object> list) {
            return Linq4j.asEnumerable(list);
        }
    };

    private SqlFunctions() {
    }

    public static String substring(String s, int from, int for_) {
        return s.substring(from - 1, Math.min(from - 1 + for_, s.length()));
    }

    public static String substring(String s, int from) {
        return s.substring(from - 1);
    }

    public static String upper(String s) {
        return s.toUpperCase();
    }

    public static String lower(String s) {
        return s.toLowerCase();
    }

    public static String initcap(String s) {
        int len = s.length();
        boolean start = true;
        StringBuilder newS = new StringBuilder();
        int i = 0;
        while (i < len) {
            char curCh;
            char c = curCh = s.charAt(i);
            if (start) {
                if (c > '/' && c < ':') {
                    start = false;
                } else if (c > '@' && c < '[') {
                    start = false;
                } else if (c > '`' && c < '{') {
                    start = false;
                    curCh = (char)(c - 32);
                }
            } else if (c <= '/' || c >= ':') {
                if (c > '@' && c < '[') {
                    curCh = (char)(c + 32);
                } else if (c <= '`' || c >= '{') {
                    start = true;
                }
            }
            newS.append(curCh);
            ++i;
        }
        return newS.toString();
    }

    public static int charLength(String s) {
        return s.length();
    }

    public static String concat(String s0, String s1) {
        return String.valueOf(s0) + s1;
    }

    public static ByteString concat(ByteString s0, ByteString s1) {
        return s0.concat(s1);
    }

    public static String rtrim(String s) {
        return SqlFunctions.trim_(s, false, true, ' ');
    }

    public static String ltrim(String s) {
        return SqlFunctions.trim_(s, true, false, ' ');
    }

    public static String trim(boolean leading, boolean trailing, String seek, String s) {
        return SqlFunctions.trim_(s, leading, trailing, seek.charAt(0));
    }

    private static String trim_(String s, boolean left, boolean right, char c) {
        int j = s.length();
        if (right) {
            while (true) {
                if (j == 0) {
                    return "";
                }
                if (s.charAt(j - 1) != c) break;
                --j;
            }
        }
        int i = 0;
        if (left) {
            while (true) {
                if (i == j) {
                    return "";
                }
                if (s.charAt(i) != c) break;
                ++i;
            }
        }
        return s.substring(i, j);
    }

    public static ByteString trim(ByteString s) {
        return SqlFunctions.trim_(s, true, true);
    }

    public static ByteString rtrim(ByteString s) {
        return SqlFunctions.trim_(s, false, true);
    }

    private static ByteString trim_(ByteString s, boolean left, boolean right) {
        int j = s.length();
        if (right) {
            while (true) {
                if (j == 0) {
                    return ByteString.EMPTY;
                }
                if (s.byteAt(j - 1) != 0) break;
                --j;
            }
        }
        int i = 0;
        if (left) {
            while (true) {
                if (i == j) {
                    return ByteString.EMPTY;
                }
                if (s.byteAt(i) != 0) break;
                ++i;
            }
        }
        return s.substring(i, j);
    }

    public static String overlay(String s, String r, int start) {
        if (s == null || r == null) {
            return null;
        }
        return String.valueOf(s.substring(0, start - 1)) + r + s.substring(start - 1 + r.length());
    }

    public static String overlay(String s, String r, int start, int length) {
        if (s == null || r == null) {
            return null;
        }
        return String.valueOf(s.substring(0, start - 1)) + r + s.substring(start - 1 + length);
    }

    public static ByteString overlay(ByteString s, ByteString r, int start) {
        if (s == null || r == null) {
            return null;
        }
        return s.substring(0, start - 1).concat(r).concat(s.substring(start - 1 + r.length()));
    }

    public static ByteString overlay(ByteString s, ByteString r, int start, int length) {
        if (s == null || r == null) {
            return null;
        }
        return s.substring(0, start - 1).concat(r).concat(s.substring(start - 1 + length));
    }

    public static boolean like(String s, String pattern) {
        String regex = Like.sqlToRegexLike(pattern, null);
        return Pattern.matches(regex, s);
    }

    public static boolean like(String s, String pattern, String escape) {
        String regex = Like.sqlToRegexLike(pattern, escape);
        return Pattern.matches(regex, s);
    }

    public static boolean similar(String s, String pattern) {
        String regex = Like.sqlToRegexSimilar(pattern, null);
        return Pattern.matches(regex, s);
    }

    public static boolean similar(String s, String pattern, String escape) {
        String regex = Like.sqlToRegexSimilar(pattern, escape);
        return Pattern.matches(regex, s);
    }

    public static boolean eq(Object b0, Object b1) {
        return b0.equals(b1);
    }

    public static boolean eq(BigDecimal b0, BigDecimal b1) {
        return b0.stripTrailingZeros().equals(b1.stripTrailingZeros());
    }

    public static boolean ne(Object b0, Object b1) {
        return !b0.equals(b1);
    }

    public static boolean ne(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) != 0;
    }

    public static boolean lt(boolean b0, boolean b1) {
        return SqlFunctions.compare(b0, b1) < 0;
    }

    public static boolean lt(String b0, String b1) {
        return b0.compareTo(b1) < 0;
    }

    public static boolean lt(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) < 0;
    }

    public static boolean lt(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) < 0;
    }

    public static boolean le(boolean b0, boolean b1) {
        return SqlFunctions.compare(b0, b1) <= 0;
    }

    public static boolean le(String b0, String b1) {
        return b0.compareTo(b1) <= 0;
    }

    public static boolean le(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) <= 0;
    }

    public static boolean le(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) <= 0;
    }

    public static boolean gt(boolean b0, boolean b1) {
        return SqlFunctions.compare(b0, b1) > 0;
    }

    public static boolean gt(String b0, String b1) {
        return b0.compareTo(b1) > 0;
    }

    public static boolean gt(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) > 0;
    }

    public static boolean gt(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) > 0;
    }

    public static boolean ge(boolean b0, boolean b1) {
        return SqlFunctions.compare(b0, b1) >= 0;
    }

    public static boolean ge(String b0, String b1) {
        return b0.compareTo(b1) >= 0;
    }

    public static boolean ge(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) >= 0;
    }

    public static boolean ge(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) >= 0;
    }

    public static int plus(int b0, int b1) {
        return b0 + b1;
    }

    public static Integer plus(Integer b0, int b1) {
        return b0 == null ? null : Integer.valueOf(b0 + b1);
    }

    public static Integer plus(int b0, Integer b1) {
        return b1 == null ? null : Integer.valueOf(b0 + b1);
    }

    public static Integer plus(Integer b0, Integer b1) {
        return b0 == null || b1 == null ? null : Integer.valueOf(b0 + b1);
    }

    public static Long plus(Long b0, Integer b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0 + b1.longValue());
    }

    public static Long plus(Integer b0, Long b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0.longValue() + b1);
    }

    public static BigDecimal plus(BigDecimal b0, BigDecimal b1) {
        return b0 == null || b1 == null ? null : b0.add(b1);
    }

    public static int minus(int b0, int b1) {
        return b0 - b1;
    }

    public static Integer minus(Integer b0, int b1) {
        return b0 == null ? null : Integer.valueOf(b0 - b1);
    }

    public static Integer minus(int b0, Integer b1) {
        return b1 == null ? null : Integer.valueOf(b0 - b1);
    }

    public static Integer minus(Integer b0, Integer b1) {
        return b0 == null || b1 == null ? null : Integer.valueOf(b0 - b1);
    }

    public static Long minus(Long b0, Integer b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0 - b1.longValue());
    }

    public static Long minus(Integer b0, Long b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0.longValue() - b1);
    }

    public static BigDecimal minus(BigDecimal b0, BigDecimal b1) {
        return b0 == null || b1 == null ? null : b0.subtract(b1);
    }

    public static int divide(int b0, int b1) {
        return b0 / b1;
    }

    public static Integer divide(Integer b0, int b1) {
        return b0 == null ? null : Integer.valueOf(b0 / b1);
    }

    public static Integer divide(int b0, Integer b1) {
        return b1 == null ? null : Integer.valueOf(b0 / b1);
    }

    public static Integer divide(Integer b0, Integer b1) {
        return b0 == null || b1 == null ? null : Integer.valueOf(b0 / b1);
    }

    public static Long divide(Long b0, Integer b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0 / b1.longValue());
    }

    public static Long divide(Integer b0, Long b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0.longValue() / b1);
    }

    public static BigDecimal divide(BigDecimal b0, BigDecimal b1) {
        return b0 == null || b1 == null ? null : b0.divide(b1);
    }

    public static int multiply(int b0, int b1) {
        return b0 * b1;
    }

    public static Integer multiply(Integer b0, int b1) {
        return b0 == null ? null : Integer.valueOf(b0 * b1);
    }

    public static Integer multiply(int b0, Integer b1) {
        return b1 == null ? null : Integer.valueOf(b0 * b1);
    }

    public static Integer multiply(Integer b0, Integer b1) {
        return b0 == null || b1 == null ? null : Integer.valueOf(b0 * b1);
    }

    public static Long multiply(Long b0, Integer b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0 * b1.longValue());
    }

    public static Long multiply(Integer b0, Long b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0.longValue() * b1);
    }

    public static BigDecimal multiply(BigDecimal b0, BigDecimal b1) {
        return b0 == null || b1 == null ? null : b0.multiply(b1);
    }

    public static double exp(double b0) {
        return Math.exp(b0);
    }

    public static double exp(long b0) {
        return Math.exp(b0);
    }

    public static double power(double b0, double b1) {
        return Math.pow(b0, b1);
    }

    public static double power(long b0, long b1) {
        return Math.pow(b0, b1);
    }

    public static double power(long b0, BigDecimal b1) {
        return Math.pow(b0, b1.doubleValue());
    }

    public static double ln(double d) {
        return Math.log(d);
    }

    public static double ln(long b0) {
        return Math.log(b0);
    }

    public static double ln(BigDecimal d) {
        return Math.log(d.doubleValue());
    }

    public static double log10(double b0) {
        return Math.log10(b0);
    }

    public static double log10(long b0) {
        return Math.log10(b0);
    }

    public static double log10(BigDecimal d) {
        return Math.log10(d.doubleValue());
    }

    public static byte mod(byte b0, byte b1) {
        return (byte)(b0 % b1);
    }

    public static short mod(short b0, short b1) {
        return (short)(b0 % b1);
    }

    public static int mod(int b0, int b1) {
        return b0 % b1;
    }

    public static long mod(long b0, long b1) {
        return b0 % b1;
    }

    public static BigDecimal mod(BigDecimal b0, int b1) {
        return SqlFunctions.mod(b0, BigDecimal.valueOf(b1));
    }

    public static int mod(int b0, BigDecimal b1) {
        return SqlFunctions.mod(b0, b1.intValue());
    }

    public static BigDecimal mod(BigDecimal b0, BigDecimal b1) {
        BigDecimal[] bigDecimals = b0.divideAndRemainder(b1);
        return bigDecimals[1];
    }

    public static byte abs(byte b0) {
        return (byte)Math.abs(b0);
    }

    public static short abs(short b0) {
        return (short)Math.abs(b0);
    }

    public static int abs(int b0) {
        return Math.abs(b0);
    }

    public static long abs(long b0) {
        return Math.abs(b0);
    }

    public static float abs(float b0) {
        return Math.abs(b0);
    }

    public static double abs(double b0) {
        return Math.abs(b0);
    }

    public static BigDecimal abs(BigDecimal b0) {
        return b0.abs();
    }

    public static <T extends Comparable<T>> T lesser(T b0, T b1) {
        return b0 == null || b0.compareTo(b1) > 0 ? b1 : b0;
    }

    public static <T extends Comparable<T>> T least(T b0, T b1) {
        return b0 == null || b1 != null && b0.compareTo(b1) > 0 ? b1 : b0;
    }

    public static boolean greater(boolean b0, boolean b1) {
        return b0 || b1;
    }

    public static boolean lesser(boolean b0, boolean b1) {
        return b0 && b1;
    }

    public static byte greater(byte b0, byte b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static byte lesser(byte b0, byte b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static char greater(char b0, char b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static char lesser(char b0, char b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static short greater(short b0, short b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static short lesser(short b0, short b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static int greater(int b0, int b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static int lesser(int b0, int b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static long greater(long b0, long b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static long lesser(long b0, long b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static float greater(float b0, float b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static float lesser(float b0, float b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static double greater(double b0, double b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static double lesser(double b0, double b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static <T extends Comparable<T>> T greater(T b0, T b1) {
        return b0 == null || b0.compareTo(b1) < 0 ? b1 : b0;
    }

    public static <T extends Comparable<T>> T greatest(T b0, T b1) {
        return b0 == null || b1 != null && b0.compareTo(b1) < 0 ? b1 : b0;
    }

    public static int compare(boolean x, boolean y) {
        return x == y ? 0 : (x ? 1 : -1);
    }

    public static String toString(float x) {
        if (x == 0.0f) {
            return "0E0";
        }
        BigDecimal bigDecimal = new BigDecimal(x, MathContext.DECIMAL32).stripTrailingZeros();
        String s = bigDecimal.toString();
        return s.replaceAll("0*E", "E").replace("E+", "E");
    }

    public static String toString(double x) {
        if (x == 0.0) {
            return "0E0";
        }
        BigDecimal bigDecimal = new BigDecimal(x, MathContext.DECIMAL64).stripTrailingZeros();
        String s = bigDecimal.toString();
        return s.replaceAll("0*E", "E").replace("E+", "E");
    }

    public static String toString(BigDecimal x) {
        String s = x.toString();
        if (s.startsWith("0")) {
            return s.substring(1);
        }
        if (s.startsWith("-0")) {
            return "-" + s.substring(2);
        }
        return s;
    }

    public static String toString(boolean x) {
        return x ? "TRUE" : "FALSE";
    }

    @NonDeterministic
    private static Object cannotConvert(Object o, Class toType) {
        throw new RuntimeException("Cannot convert " + o + " to " + toType);
    }

    public static boolean toBoolean(String s) {
        if ((s = SqlFunctions.trim_(s, true, true, ' ')).equalsIgnoreCase("TRUE")) {
            return true;
        }
        if (s.equalsIgnoreCase("FALSE")) {
            return false;
        }
        throw new RuntimeException("Invalid character for cast");
    }

    public static boolean toBoolean(Number number) {
        return !number.equals(0);
    }

    public static boolean toBoolean(Object o) {
        return o instanceof Boolean ? (Boolean)o : (o instanceof Number ? SqlFunctions.toBoolean((Number)o) : (o instanceof String ? SqlFunctions.toBoolean((String)o) : (Boolean)SqlFunctions.cannotConvert(o, Boolean.TYPE)));
    }

    public static byte toByte(Object o) {
        return o instanceof Byte ? (Byte)o : (o instanceof Number ? SqlFunctions.toByte((Number)o) : Byte.parseByte(o.toString()));
    }

    public static byte toByte(Number number) {
        return number.byteValue();
    }

    public static char toChar(String s) {
        return s.charAt(0);
    }

    public static Character toCharBoxed(String s) {
        return Character.valueOf(s.charAt(0));
    }

    public static short toShort(String s) {
        return Short.parseShort(s.trim());
    }

    public static short toShort(Number number) {
        return number.shortValue();
    }

    public static short toShort(Object o) {
        return o instanceof Short ? (Short)o : (o instanceof Number ? SqlFunctions.toShort((Number)o) : (o instanceof String ? SqlFunctions.toShort((String)o) : (Short)SqlFunctions.cannotConvert(o, Short.TYPE)));
    }

    public static int toInt(Date v) {
        return SqlFunctions.toInt(v, LOCAL_TZ);
    }

    public static int toInt(Date v, TimeZone timeZone) {
        return (int)(SqlFunctions.toLong(v, timeZone) / 86400000L);
    }

    public static Integer toIntOptional(Date v) {
        return v == null ? null : Integer.valueOf(SqlFunctions.toInt(v));
    }

    public static Integer toIntOptional(Date v, TimeZone timeZone) {
        return v == null ? null : Integer.valueOf(SqlFunctions.toInt(v, timeZone));
    }

    public static int toInt(Time v) {
        return (int)(SqlFunctions.toLong(v) % 86400000L);
    }

    public static Integer toIntOptional(Time v) {
        return v == null ? null : Integer.valueOf(SqlFunctions.toInt(v));
    }

    public static int toInt(String s) {
        return Integer.parseInt(s.trim());
    }

    public static int toInt(Number number) {
        return number.intValue();
    }

    public static int toInt(Object o) {
        return o instanceof Integer ? (Integer)o : (o instanceof Number ? SqlFunctions.toInt((Number)o) : (o instanceof String ? SqlFunctions.toInt((String)o) : (Integer)SqlFunctions.cannotConvert(o, Integer.TYPE)));
    }

    public static long toLong(Timestamp v) {
        return SqlFunctions.toLong(v, LOCAL_TZ);
    }

    public static long toLong(Date v, TimeZone timeZone) {
        long time = v.getTime();
        return time + (long)timeZone.getOffset(time);
    }

    public static Long toLongOptional(Date v) {
        return v == null ? null : Long.valueOf(SqlFunctions.toLong(v, LOCAL_TZ));
    }

    public static Long toLongOptional(Timestamp v, TimeZone timeZone) {
        if (v == null) {
            return null;
        }
        return SqlFunctions.toLong(v, LOCAL_TZ);
    }

    public static long toLong(String s) {
        if (s.startsWith("199") && s.contains(":")) {
            return Timestamp.valueOf(s).getTime();
        }
        return Long.parseLong(s.trim());
    }

    public static long toLong(Number number) {
        return number.longValue();
    }

    public static long toLong(Object o) {
        return o instanceof Long ? (Long)o : (o instanceof Number ? SqlFunctions.toLong((Number)o) : (o instanceof String ? SqlFunctions.toLong((String)o) : (Long)SqlFunctions.cannotConvert(o, Long.TYPE)));
    }

    public static float toFloat(String s) {
        return Float.parseFloat(s.trim());
    }

    public static float toFloat(Number number) {
        return number.floatValue();
    }

    public static float toFloat(Object o) {
        return o instanceof Float ? ((Float)o).floatValue() : (o instanceof Number ? SqlFunctions.toFloat((Number)o) : (o instanceof String ? SqlFunctions.toFloat((String)o) : ((Float)SqlFunctions.cannotConvert(o, Float.TYPE)).floatValue()));
    }

    public static double toDouble(String s) {
        return Double.parseDouble(s.trim());
    }

    public static double toDouble(Number number) {
        return number.doubleValue();
    }

    public static double toDouble(Object o) {
        return o instanceof Double ? (Double)o : (o instanceof Number ? SqlFunctions.toDouble((Number)o) : (o instanceof String ? SqlFunctions.toDouble((String)o) : (Double)SqlFunctions.cannotConvert(o, Double.TYPE)));
    }

    public static BigDecimal toBigDecimal(String s) {
        return new BigDecimal(s.trim());
    }

    public static BigDecimal toBigDecimal(Number number) {
        return number instanceof BigDecimal ? (BigDecimal)number : (number instanceof BigInteger ? new BigDecimal((BigInteger)number) : (number instanceof Long ? new BigDecimal(number.longValue()) : new BigDecimal(number.doubleValue())));
    }

    public static BigDecimal toBigDecimal(Object o) {
        return o instanceof Number ? SqlFunctions.toBigDecimal((Number)o) : SqlFunctions.toBigDecimal(o.toString());
    }

    public static String truncate(String s, int maxLength) {
        return s == null ? null : (s.length() > maxLength ? s.substring(0, maxLength) : s);
    }

    public static ByteString truncate(ByteString s, int maxLength) {
        return s == null ? null : (s.length() > maxLength ? s.substring(0, maxLength) : s);
    }

    public static int position(String seek, String s) {
        return s.indexOf(seek) + 1;
    }

    public static int position(ByteString seek, ByteString s) {
        return s.indexOf(seek) + 1;
    }

    public static long powerX(long a, long b) {
        long x = 1L;
        while (b > 0L) {
            x *= a;
            --b;
        }
        return x;
    }

    public static long round(long v, long x) {
        return SqlFunctions.truncate(v + x / 2L, x);
    }

    public static long truncate(long v, long x) {
        long remainder = v % x;
        if (remainder < 0L) {
            remainder += x;
        }
        return v - remainder;
    }

    public static int round(int v, int x) {
        return SqlFunctions.truncate(v + x / 2, x);
    }

    public static int truncate(int v, int x) {
        int remainder = v % x;
        if (remainder < 0) {
            remainder += x;
        }
        return v - remainder;
    }

    public static String unixTimestampToString(long timestamp) {
        StringBuilder buf = new StringBuilder(17);
        int date = (int)(timestamp / 86400000L);
        int time = (int)(timestamp % 86400000L);
        if (time < 0) {
            --date;
            time = (int)((long)time + 86400000L);
        }
        SqlFunctions.unixDateToString(buf, date);
        buf.append(' ');
        SqlFunctions.unixTimeToString(buf, time);
        return buf.toString();
    }

    public static String unixTimeToString(int time) {
        StringBuilder buf = new StringBuilder(8);
        SqlFunctions.unixTimeToString(buf, time);
        return buf.toString();
    }

    private static void unixTimeToString(StringBuilder buf, int time) {
        int h = time / 3600000;
        int time2 = time % 3600000;
        int m = time2 / 60000;
        int time3 = time2 % 60000;
        int s = time3 / 1000;
        int ms = time3 % 1000;
        SqlFunctions.int2(buf, h);
        buf.append(':');
        SqlFunctions.int2(buf, m);
        buf.append(':');
        SqlFunctions.int2(buf, s);
    }

    @NonDeterministic
    public static long currentTimestamp(DataContext root) {
        return (Long)DataContext.Variable.CURRENT_TIMESTAMP.get(root);
    }

    @NonDeterministic
    public static int currentTime(DataContext root) {
        int time = (int)(SqlFunctions.currentTimestamp(root) % 86400000L);
        if (time < 0) {
            time = (int)((long)time + 86400000L);
        }
        return time;
    }

    @NonDeterministic
    public static int currentDate(DataContext root) {
        long timestamp = SqlFunctions.currentTimestamp(root);
        int date = (int)(timestamp / 86400000L);
        int time = (int)(timestamp % 86400000L);
        if (time < 0) {
            --date;
        }
        return date;
    }

    @NonDeterministic
    public static long localTimestamp(DataContext root) {
        return (Long)DataContext.Variable.LOCAL_TIMESTAMP.get(root);
    }

    @NonDeterministic
    public static int localTime(DataContext root) {
        return (int)(SqlFunctions.localTimestamp(root) % 86400000L);
    }

    private static void int2(StringBuilder buf, int i) {
        buf.append((char)(48 + i / 10 % 10));
        buf.append((char)(48 + i % 10));
    }

    private static void int4(StringBuilder buf, int i) {
        buf.append((char)(48 + i / 1000 % 10));
        buf.append((char)(48 + i / 100 % 10));
        buf.append((char)(48 + i / 10 % 10));
        buf.append((char)(48 + i % 10));
    }

    public static String unixDateToString(int date) {
        StringBuilder buf = new StringBuilder(10);
        SqlFunctions.unixDateToString(buf, date);
        return buf.toString();
    }

    private static void unixDateToString(StringBuilder buf, int date) {
        SqlFunctions.julianToString(buf, date + 2440588);
    }

    private static void julianToString(StringBuilder buf, int julian) {
        int j = julian + 32044;
        int g = j / 146097;
        int dg = j % 146097;
        int c = (dg / 36524 + 1) * 3 / 4;
        int dc = dg - c * 36524;
        int b = dc / 1461;
        int db = dc % 1461;
        int a = (db / 365 + 1) * 3 / 4;
        int da = db - a * 365;
        int y = g * 400 + c * 100 + b * 4 + a;
        int m = (da * 5 + 308) / 153 - 2;
        int d = da - (m + 4) * 153 / 5 + 122;
        int year = y - 4800 + (m + 2) / 12;
        int month = (m + 2) % 12 + 1;
        int day = d + 1;
        SqlFunctions.int4(buf, year);
        buf.append('-');
        SqlFunctions.int2(buf, month);
        buf.append('-');
        SqlFunctions.int2(buf, day);
    }

    public static long unixDateExtract(TimeUnitRange range, long date) {
        return SqlFunctions.julianExtract(range, (int)date + 2440588);
    }

    private static int julianExtract(TimeUnitRange range, int julian) {
        int j = julian + 32044;
        int g = j / 146097;
        int dg = j % 146097;
        int c = (dg / 36524 + 1) * 3 / 4;
        int dc = dg - c * 36524;
        int b = dc / 1461;
        int db = dc % 1461;
        int a = (db / 365 + 1) * 3 / 4;
        int da = db - a * 365;
        int y = g * 400 + c * 100 + b * 4 + a;
        int m = (da * 5 + 308) / 153 - 2;
        int d = da - (m + 4) * 153 / 5 + 122;
        int year = y - 4800 + (m + 2) / 12;
        int month = (m + 2) % 12 + 1;
        int day = d + 1;
        switch (range) {
            case YEAR: {
                return year;
            }
            case MONTH: {
                return month;
            }
            case DAY: {
                return day;
            }
        }
        throw new AssertionError((Object)range);
    }

    public static int ymdToUnixDate(int year, int month, int day) {
        int julian = SqlFunctions.ymdToJulian(year, month, day);
        return julian - 2440588;
    }

    public static int ymdToJulian(int year, int month, int day) {
        int a = (14 - month) / 12;
        int m = month + 12 * a - 3;
        int y = year + 4800 - a;
        int j = day + (153 * m + 2) / 5 + 365 * y + y / 4 - y / 100 + y / 400 - 32045;
        if (j < 2299161) {
            j = day + (153 * m + 2) / 5 + 365 * y + y / 4 - 32083;
        }
        return j;
    }

    public static String intervalYearMonthToString(int v, TimeUnitRange range) {
        StringBuilder buf = new StringBuilder();
        if (v >= 0) {
            buf.append('+');
        } else {
            buf.append('-');
            v = -v;
        }
        switch (range) {
            case YEAR: {
                v = SqlFunctions.roundUp(v, 12);
                int y = v / 12;
                buf.append(y);
                break;
            }
            case YEAR_TO_MONTH: {
                int y = v / 12;
                buf.append(y);
                buf.append('-');
                int m = v % 12;
                SqlFunctions.number(buf, m, 2);
                break;
            }
            case MONTH: {
                int m = v;
                buf.append(m);
                break;
            }
            default: {
                throw new AssertionError((Object)range);
            }
        }
        return buf.toString();
    }

    private static StringBuilder number(StringBuilder buf, int v, int n) {
        int k = SqlFunctions.digitCount(v);
        while (k < n) {
            buf.append('0');
            ++k;
        }
        return buf.append(v);
    }

    public static int digitCount(int v) {
        int n = 1;
        while ((v /= 10) != 0) {
            ++n;
        }
        return n;
    }

    public static String intervalDayTimeToString(long v, TimeUnitRange range, int scale) {
        StringBuilder buf = new StringBuilder();
        if (v >= 0L) {
            buf.append('+');
        } else {
            buf.append('-');
            v = -v;
        }
        switch (range) {
            case DAY_TO_SECOND: {
                v = SqlFunctions.roundUp(v, SqlFunctions.powerX(10L, 3 - scale));
                long ms = v % 1000L;
                long s = (v /= 1000L) % 60L;
                long m = (v /= 60L) % 60L;
                long h = (v /= 60L) % 24L;
                long d = v /= 24L;
                buf.append((int)d);
                buf.append(' ');
                SqlFunctions.number(buf, (int)h, 2);
                buf.append(':');
                SqlFunctions.number(buf, (int)m, 2);
                buf.append(':');
                SqlFunctions.number(buf, (int)s, 2);
                SqlFunctions.fraction(buf, scale, ms);
                break;
            }
            case DAY_TO_MINUTE: {
                v = SqlFunctions.roundUp(v, 60000L);
                v /= 1000L;
                long m = (v /= 60L) % 60L;
                long h = (v /= 60L) % 24L;
                long d = v /= 24L;
                buf.append((int)d);
                buf.append(' ');
                SqlFunctions.number(buf, (int)h, 2);
                buf.append(':');
                SqlFunctions.number(buf, (int)m, 2);
                break;
            }
            case DAY_TO_HOUR: {
                v = SqlFunctions.roundUp(v, 3600000L);
                v /= 1000L;
                v /= 60L;
                long h = (v /= 60L) % 24L;
                long d = v /= 24L;
                buf.append((int)d);
                buf.append(' ');
                SqlFunctions.number(buf, (int)h, 2);
                break;
            }
            case DAY: {
                v = SqlFunctions.roundUp(v, 86400000L);
                long d = v / 86400000L;
                buf.append((int)d);
                break;
            }
            case HOUR: {
                v = SqlFunctions.roundUp(v, 3600000L);
                v /= 1000L;
                v /= 60L;
                long h = v /= 60L;
                buf.append((int)h);
                break;
            }
            case HOUR_TO_MINUTE: {
                v = SqlFunctions.roundUp(v, 60000L);
                v /= 1000L;
                long m = (v /= 60L) % 60L;
                long h = v /= 60L;
                buf.append((int)h);
                buf.append(':');
                SqlFunctions.number(buf, (int)m, 2);
                break;
            }
            case HOUR_TO_SECOND: {
                v = SqlFunctions.roundUp(v, SqlFunctions.powerX(10L, 3 - scale));
                long ms = v % 1000L;
                long s = (v /= 1000L) % 60L;
                long m = (v /= 60L) % 60L;
                long h = v /= 60L;
                buf.append((int)h);
                buf.append(':');
                SqlFunctions.number(buf, (int)m, 2);
                buf.append(':');
                SqlFunctions.number(buf, (int)s, 2);
                SqlFunctions.fraction(buf, scale, ms);
                break;
            }
            case MINUTE_TO_SECOND: {
                v = SqlFunctions.roundUp(v, SqlFunctions.powerX(10L, 3 - scale));
                long ms = v % 1000L;
                long s = (v /= 1000L) % 60L;
                long m = v /= 60L;
                buf.append((int)m);
                buf.append(':');
                SqlFunctions.number(buf, (int)s, 2);
                SqlFunctions.fraction(buf, scale, ms);
                break;
            }
            case MINUTE: {
                v = SqlFunctions.roundUp(v, 60000L);
                v /= 1000L;
                long m = v /= 60L;
                buf.append((int)m);
                break;
            }
            case SECOND: {
                v = SqlFunctions.roundUp(v, SqlFunctions.powerX(10L, 3 - scale));
                long ms = v % 1000L;
                long s = v /= 1000L;
                buf.append((int)s);
                SqlFunctions.fraction(buf, scale, ms);
                break;
            }
            default: {
                throw new AssertionError((Object)range);
            }
        }
        return buf.toString();
    }

    private static long roundUp(long dividend, long divisor) {
        long remainder = dividend % divisor;
        dividend -= remainder;
        if (remainder * 2L > divisor) {
            dividend += divisor;
        }
        return dividend;
    }

    private static int roundUp(int dividend, int divisor) {
        int remainder = dividend % divisor;
        dividend -= remainder;
        if (remainder * 2 > divisor) {
            dividend += divisor;
        }
        return dividend;
    }

    private static void fraction(StringBuilder buf, int scale, long ms) {
        if (scale > 0) {
            buf.append('.');
            long v1 = scale == 3 ? ms : (scale == 2 ? ms / 10L : (scale == 1 ? ms / 100L : 0L));
            SqlFunctions.number(buf, (int)v1, scale);
        }
    }

    public static Object arrayItem(List list, int item) {
        if (item < 1 || item > list.size()) {
            return null;
        }
        return list.get(item - 1);
    }

    public static Object mapItem(Map map, Object item) {
        return map.get(item);
    }

    public static Object item(Object object, Object index) {
        if (object instanceof Map) {
            return ((Map)object).get(index);
        }
        if (object instanceof List && index instanceof Number) {
            List list = (List)object;
            return list.get(((Number)index).intValue());
        }
        return null;
    }

    public static boolean isTrue(Boolean b) {
        return b != null && b != false;
    }

    public static boolean isNotFalse(Boolean b) {
        return b == null || b != false;
    }

    public static List arrayToList(Array a) {
        if (a == null) {
            return null;
        }
        try {
            return Primitive.asList((Object)a.getArray());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static List slice(List list) {
        return list;
    }

    public static Object element(List list) {
        switch (list.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return list.get(0);
            }
        }
        throw new RuntimeException("more than one value");
    }

    public static <E> Function1<List<E>, Enumerable<E>> listToEnumerable() {
        return LIST_AS_ENUMERABLE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TimeUnitRange {
        YEAR,
        YEAR_TO_MONTH,
        MONTH,
        DAY,
        DAY_TO_HOUR,
        DAY_TO_MINUTE,
        DAY_TO_SECOND,
        HOUR,
        HOUR_TO_MINUTE,
        HOUR_TO_SECOND,
        MINUTE,
        MINUTE_TO_SECOND,
        SECOND;


        public boolean monthly() {
            return this.ordinal() <= MONTH.ordinal();
        }
    }
}

