/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.rules.java;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.hydromatic.linq4j.expressions.BlockBuilder;
import net.hydromatic.linq4j.expressions.BlockStatement;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.Node;
import net.hydromatic.linq4j.expressions.ParameterExpression;
import net.hydromatic.linq4j.expressions.Primitive;
import net.hydromatic.linq4j.expressions.Statement;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.optiq.rules.java.AggAddContext;
import net.hydromatic.optiq.rules.java.AggContext;
import net.hydromatic.optiq.rules.java.AggImplementor;
import net.hydromatic.optiq.rules.java.AggResetContext;
import net.hydromatic.optiq.rules.java.AggResultContext;
import net.hydromatic.optiq.rules.java.RexImpTable;
import net.hydromatic.optiq.rules.java.RexToLixTranslator;
import net.hydromatic.optiq.rules.java.WinAggContext;
import net.hydromatic.optiq.rules.java.WinAggResultContext;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StrictAggImplementor
implements AggImplementor {
    private boolean needTrackEmptySet;
    private boolean trackNullsPerRow;
    private int stateSize;

    protected boolean nonDefaultOnEmptySet(AggContext info) {
        return info.returnRelType().isNullable();
    }

    protected final int getStateSize() {
        return this.stateSize;
    }

    protected final void accAdvance(AggAddContext add, Expression acc, Expression next) {
        add.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)acc, (Expression)Types.castIfNecessary((Type)acc.type, (Expression)next))));
    }

    @Override
    public final List<Type> getStateType(AggContext info) {
        List<Type> subState = this.getNotNullState(info);
        this.stateSize = subState.size();
        this.needTrackEmptySet = this.nonDefaultOnEmptySet(info);
        if (!this.needTrackEmptySet) {
            return subState;
        }
        boolean hasNullableArgs = false;
        for (RelDataType relDataType : info.parameterRelTypes()) {
            if (!relDataType.isNullable()) continue;
            hasNullableArgs = true;
            break;
        }
        this.trackNullsPerRow = !(info instanceof WinAggContext) || hasNullableArgs;
        ArrayList<Type> arrayList = new ArrayList<Type>(subState.size() + 1);
        arrayList.addAll(subState);
        arrayList.add(Boolean.TYPE);
        return arrayList;
    }

    public List<Type> getNotNullState(AggContext info) {
        return Collections.singletonList(Primitive.unbox((Type)info.returnType()));
    }

    @Override
    public final void implementReset(AggContext info, AggResetContext reset) {
        if (this.trackNullsPerRow) {
            List<Expression> acc = reset.accumulator();
            Expression flag = acc.get(acc.size() - 1);
            BlockBuilder block = reset.currentBlock();
            block.add(Expressions.statement((Expression)Expressions.assign((Expression)flag, (Expression)RexImpTable.getDefaultValue(flag.getType()))));
        }
        this.implementNotNullReset(info, reset);
    }

    protected void implementNotNullReset(AggContext info, AggResetContext reset) {
        BlockBuilder block = reset.currentBlock();
        List<Expression> accumulator = reset.accumulator();
        int i = 0;
        while (i < this.getStateSize()) {
            Expression exp = accumulator.get(i);
            block.add(Expressions.statement((Expression)Expressions.assign((Expression)exp, (Expression)RexImpTable.getDefaultValue(exp.getType()))));
            ++i;
        }
    }

    @Override
    public final void implementAdd(AggContext info, AggAddContext add) {
        BlockBuilder thenBlock;
        List<RexNode> args = add.rexArguments();
        RexToLixTranslator translator = add.rowTranslator();
        List<Expression> conditions = translator.translateList(args, RexImpTable.NullAs.IS_NOT_NULL);
        Expression condition = Expressions.foldAnd(conditions);
        if (Expressions.constant((Object)false).equals((Object)condition)) {
            return;
        }
        boolean argsNotNull = Expressions.constant((Object)true).equals((Object)condition);
        BlockBuilder blockBuilder = thenBlock = argsNotNull ? add.currentBlock() : new BlockBuilder(true, add.currentBlock());
        if (this.trackNullsPerRow) {
            List<Expression> acc = add.accumulator();
            thenBlock.add(Expressions.statement((Expression)Expressions.assign((Expression)acc.get(acc.size() - 1), (Expression)Expressions.constant((Object)true))));
        }
        if (argsNotNull) {
            this.implementNotNullAdd(info, add);
            return;
        }
        HashMap<RexNode, Boolean> nullables = new HashMap<RexNode, Boolean>();
        for (RexNode arg : args) {
            if (!translator.isNullable(arg)) continue;
            nullables.put(arg, false);
        }
        add.nestBlock(thenBlock, nullables);
        this.implementNotNullAdd(info, add);
        add.exitBlock();
        add.currentBlock().add((Statement)Expressions.ifThen((Expression)condition, (Node)thenBlock.toBlock()));
    }

    protected abstract void implementNotNullAdd(AggContext var1, AggAddContext var2);

    @Override
    public final Expression implementResult(AggContext info, AggResultContext result) {
        Expression seenNotNullRows;
        if (!this.needTrackEmptySet) {
            return RexToLixTranslator.convert(this.implementNotNullResult(info, result), info.returnType());
        }
        String tmpName = result.accumulator().isEmpty() ? "ar" : result.accumulator().get(0) + "$Res";
        ParameterExpression res = Expressions.parameter((int)0, (Type)info.returnType(), (String)result.currentBlock().newName(tmpName));
        List<Expression> acc = result.accumulator();
        BlockBuilder thenBlock = result.nestBlock();
        Expression nonNull = RexToLixTranslator.convert(this.implementNotNullResult(info, result), info.returnType());
        result.exitBlock();
        thenBlock.add(Expressions.statement((Expression)Expressions.assign((Expression)res, (Expression)nonNull)));
        BlockStatement thenBranch = thenBlock.toBlock();
        Expression expression = seenNotNullRows = this.trackNullsPerRow ? acc.get(acc.size() - 1) : ((WinAggResultContext)result).hasRows();
        if (thenBranch.statements.size() == 1) {
            return Expressions.condition((Expression)seenNotNullRows, (Expression)nonNull, (Expression)RexImpTable.getDefaultValue(res.getType()));
        }
        result.currentBlock().add((Statement)Expressions.declare((int)0, (ParameterExpression)res, null));
        result.currentBlock().add((Statement)Expressions.ifThenElse((Expression)seenNotNullRows, (Node)thenBranch, (Node)Expressions.statement((Expression)Expressions.assign((Expression)res, (Expression)RexImpTable.getDefaultValue(res.getType())))));
        return res;
    }

    protected Expression implementNotNullResult(AggContext info, AggResultContext result) {
        return result.accumulator().get(0);
    }
}

