/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.prepare;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.hydromatic.avatica.AvaticaParameter;
import net.hydromatic.avatica.ColumnMetaData;
import net.hydromatic.avatica.Helper;
import net.hydromatic.linq4j.Enumerable;
import net.hydromatic.linq4j.Linq4j;
import net.hydromatic.linq4j.Ord;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.linq4j.expressions.BinaryExpression;
import net.hydromatic.linq4j.expressions.BlockStatement;
import net.hydromatic.linq4j.expressions.Blocks;
import net.hydromatic.linq4j.expressions.ClassDeclaration;
import net.hydromatic.linq4j.expressions.ConstantExpression;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.MemberExpression;
import net.hydromatic.linq4j.expressions.MethodCallExpression;
import net.hydromatic.linq4j.expressions.NewExpression;
import net.hydromatic.linq4j.expressions.ParameterExpression;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.config.OptiqConnectionConfig;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.jdbc.OptiqPrepare;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import net.hydromatic.optiq.materialize.MaterializationService;
import net.hydromatic.optiq.prepare.LixToRelTranslator;
import net.hydromatic.optiq.prepare.OptiqCatalogReader;
import net.hydromatic.optiq.prepare.OptiqMaterializer;
import net.hydromatic.optiq.prepare.OptiqSqlValidator;
import net.hydromatic.optiq.prepare.Prepare;
import net.hydromatic.optiq.rules.java.EnumerableConvention;
import net.hydromatic.optiq.rules.java.EnumerableRel;
import net.hydromatic.optiq.rules.java.EnumerableRelImplementor;
import net.hydromatic.optiq.rules.java.JavaRules;
import net.hydromatic.optiq.rules.java.RexToLixTranslator;
import net.hydromatic.optiq.runtime.Bindable;
import net.hydromatic.optiq.runtime.Hook;
import net.hydromatic.optiq.runtime.Spaces;
import net.hydromatic.optiq.runtime.Typed;
import net.hydromatic.optiq.runtime.Utilities;
import net.hydromatic.optiq.server.OptiqServerStatement;
import net.hydromatic.optiq.tools.Frameworks;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.CompilerFactoryFactory;
import org.codehaus.commons.compiler.IClassBodyEvaluator;
import org.codehaus.commons.compiler.ICompilerFactory;
import org.eigenbase.rel.RelCollationTraitDef;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.rules.MergeProjectRule;
import org.eigenbase.rel.rules.PushFilterPastJoinRule;
import org.eigenbase.rel.rules.PushFilterPastProjectRule;
import org.eigenbase.rel.rules.PushJoinThroughJoinRule;
import org.eigenbase.rel.rules.PushSortPastProjectRule;
import org.eigenbase.rel.rules.ReduceAggregatesRule;
import org.eigenbase.rel.rules.ReduceExpressionsRule;
import org.eigenbase.rel.rules.ReduceValuesRule;
import org.eigenbase.rel.rules.RemoveDistinctAggregateRule;
import org.eigenbase.rel.rules.SwapJoinRule;
import org.eigenbase.rel.rules.TableAccessRule;
import org.eigenbase.relopt.Context;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.ConventionTraitDef;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCostFactory;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptQuery;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.volcano.VolcanoPlanner;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeFactoryImpl;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.SqlBinaryOperator;
import org.eigenbase.sql.SqlExplainLevel;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlOperatorTable;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.parser.SqlParseException;
import org.eigenbase.sql.parser.SqlParser;
import org.eigenbase.sql.parser.impl.SqlParserImpl;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.util.ChainedSqlOperatorTable;
import org.eigenbase.sql.validate.SqlConformance;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorImpl;
import org.eigenbase.sql2rel.SqlToRelConverter;
import org.eigenbase.sql2rel.StandardConvertletTable;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptiqPrepareImpl
implements OptiqPrepare {
    public static final boolean DEBUG = "true".equals(System.getProperties().getProperty("optiq.debug"));
    private static final boolean ENABLE_COLLATION_TRAIT = true;
    private static final Set<String> SIMPLE_SQLS = ImmutableSet.of((Object)"SELECT 1", (Object)"select 1", (Object)"SELECT 1 FROM DUAL", (Object)"select 1 from dual", (Object)"values 1", (Object)"VALUES 1", (Object[])new String[0]);
    private static final List<RelOptRule> DEFAULT_RULES = ImmutableList.of((Object)JavaRules.ENUMERABLE_JOIN_RULE, (Object)JavaRules.ENUMERABLE_PROJECT_RULE, (Object)JavaRules.ENUMERABLE_FILTER_RULE, (Object)JavaRules.ENUMERABLE_AGGREGATE_RULE, (Object)JavaRules.ENUMERABLE_SORT_RULE, (Object)JavaRules.ENUMERABLE_LIMIT_RULE, (Object)JavaRules.ENUMERABLE_COLLECT_RULE, (Object)JavaRules.ENUMERABLE_UNCOLLECT_RULE, (Object)JavaRules.ENUMERABLE_UNION_RULE, (Object)JavaRules.ENUMERABLE_INTERSECT_RULE, (Object)JavaRules.ENUMERABLE_MINUS_RULE, (Object)JavaRules.ENUMERABLE_TABLE_MODIFICATION_RULE, (Object[])new RelOptRule[]{JavaRules.ENUMERABLE_VALUES_RULE, JavaRules.ENUMERABLE_WINDOW_RULE, JavaRules.ENUMERABLE_ONE_ROW_RULE, JavaRules.ENUMERABLE_EMPTY_RULE, JavaRules.ENUMERABLE_TABLE_FUNCTION_RULE, TableAccessRule.INSTANCE, MergeProjectRule.INSTANCE, PushFilterPastProjectRule.INSTANCE, PushFilterPastJoinRule.FILTER_ON_JOIN, RemoveDistinctAggregateRule.INSTANCE, ReduceAggregatesRule.INSTANCE, SwapJoinRule.INSTANCE, PushJoinThroughJoinRule.RIGHT, PushJoinThroughJoinRule.LEFT, PushSortPastProjectRule.INSTANCE});
    private static final List<RelOptRule> CONSTANT_REDUCTION_RULES = ImmutableList.of((Object)ReduceExpressionsRule.PROJECT_INSTANCE, (Object)ReduceExpressionsRule.FILTER_INSTANCE, (Object)ReduceExpressionsRule.CALC_INSTANCE, (Object)ReduceExpressionsRule.JOIN_INSTANCE, (Object)ReduceValuesRule.FILTER_INSTANCE, (Object)ReduceValuesRule.PROJECT_FILTER_INSTANCE, (Object)ReduceValuesRule.PROJECT_INSTANCE);

    @Override
    public OptiqPrepare.ParseResult parse(OptiqPrepare.Context context, String sql) {
        SqlNode sqlNode;
        JavaTypeFactory typeFactory = context.getTypeFactory();
        OptiqCatalogReader catalogReader = new OptiqCatalogReader(context.getRootSchema(), context.config().caseSensitive(), context.getDefaultSchemaPath(), typeFactory);
        SqlParser parser = SqlParser.create(sql);
        try {
            sqlNode = parser.parseStmt();
        }
        catch (SqlParseException e) {
            throw new RuntimeException("parse failed", e);
        }
        OptiqSqlValidator validator = new OptiqSqlValidator(SqlStdOperatorTable.instance(), catalogReader, typeFactory);
        SqlNode sqlNode1 = validator.validate(sqlNode);
        return new OptiqPrepare.ParseResult(this, validator, sql, sqlNode1, validator.getValidatedNodeType(sqlNode1));
    }

    protected List<Function1<OptiqPrepare.Context, RelOptPlanner>> createPlannerFactories() {
        return Collections.singletonList(new Function1<OptiqPrepare.Context, RelOptPlanner>(){

            public RelOptPlanner apply(OptiqPrepare.Context context) {
                return OptiqPrepareImpl.this.createPlanner(context, null, null);
            }
        });
    }

    protected RelOptPlanner createPlanner(OptiqPrepare.Context prepareContext) {
        return this.createPlanner(prepareContext, null, null);
    }

    protected RelOptPlanner createPlanner(OptiqPrepare.Context prepareContext, Context externalContext, RelOptCostFactory costFactory) {
        VolcanoPlanner planner = new VolcanoPlanner(costFactory, externalContext);
        planner.addRelTraitDef(ConventionTraitDef.INSTANCE);
        planner.addRelTraitDef(RelCollationTraitDef.INSTANCE);
        planner.registerAbstractRelationalRules();
        RelOptUtil.registerAbstractRels(planner);
        for (RelOptRule rule : DEFAULT_RULES) {
            planner.addRule(rule);
        }
        OptiqPrepare.SparkHandler spark = prepareContext.spark();
        if (spark.enabled()) {
            spark.registerRules(new OptiqPrepare.SparkHandler.RuleSetBuilder(){

                public void addRule(RelOptRule rule) {
                }

                public void removeRule(RelOptRule rule) {
                }
            });
        }
        return planner;
    }

    @Override
    public <T> OptiqPrepare.PrepareResult<T> prepareQueryable(OptiqPrepare.Context context, Queryable<T> queryable) {
        return this.prepare_(context, null, queryable, queryable.getElementType(), -1);
    }

    @Override
    public <T> OptiqPrepare.PrepareResult<T> prepareSql(OptiqPrepare.Context context, String sql, Queryable<T> expression, Type elementType, int maxRowCount) {
        return this.prepare_(context, sql, expression, elementType, maxRowCount);
    }

    <T> OptiqPrepare.PrepareResult<T> prepare_(OptiqPrepare.Context context, String sql, Queryable<T> queryable, Type elementType, int maxRowCount) {
        if (SIMPLE_SQLS.contains(sql)) {
            return this.simplePrepare(context, sql);
        }
        JavaTypeFactory typeFactory = context.getTypeFactory();
        OptiqCatalogReader catalogReader = new OptiqCatalogReader(context.getRootSchema(), context.config().caseSensitive(), context.getDefaultSchemaPath(), typeFactory);
        List<Function1<OptiqPrepare.Context, RelOptPlanner>> plannerFactories = this.createPlannerFactories();
        if (plannerFactories.isEmpty()) {
            throw new AssertionError((Object)"no planner factories");
        }
        RuntimeException exception = new RuntimeException();
        for (Function1<OptiqPrepare.Context, RelOptPlanner> plannerFactory : plannerFactories) {
            RelOptPlanner planner = (RelOptPlanner)plannerFactory.apply((Object)context);
            if (planner == null) {
                throw new AssertionError((Object)"factory returned null planner");
            }
            try {
                return this.prepare2_(context, sql, queryable, elementType, maxRowCount, catalogReader, planner);
            }
            catch (RelOptPlanner.CannotPlanException e) {
                exception = e;
            }
        }
        throw exception;
    }

    private <T> OptiqPrepare.PrepareResult<T> simplePrepare(OptiqPrepare.Context context, String sql) {
        JavaTypeFactory typeFactory = context.getTypeFactory();
        RelDataType x = typeFactory.builder().add("EXPR$0", SqlTypeName.INTEGER).build();
        ImmutableList list = ImmutableList.of((Object)1);
        Object origin = null;
        List<Object> origins = Collections.nCopies(x.getFieldCount(), origin);
        return new OptiqPrepare.PrepareResult(sql, (List<AvaticaParameter>)ImmutableList.of(), x, this.getColumnMetaDataList(typeFactory, x, x, origins), -1, new Bindable<T>((List)list){
            private final /* synthetic */ List val$list;
            {
                this.val$list = list;
            }

            @Override
            public Enumerable<T> bind(DataContext dataContext) {
                return Linq4j.asEnumerable((List)this.val$list);
            }
        }, Integer.class);
    }

    <T> OptiqPrepare.PrepareResult<T> prepare2_(OptiqPrepare.Context context, String sql, Queryable<T> queryable, Type elementType, int maxRowCount, OptiqCatalogReader catalogReader, RelOptPlanner planner) {
        RelDataType x;
        Prepare.PreparedResult preparedResult;
        JavaTypeFactory typeFactory = context.getTypeFactory();
        EnumerableRel.Prefer prefer = elementType == Object[].class ? EnumerableRel.Prefer.ARRAY : EnumerableRel.Prefer.CUSTOM;
        OptiqPreparingStmt preparingStmt = new OptiqPreparingStmt(context, catalogReader, typeFactory, context.getRootSchema(), prefer, planner, EnumerableConvention.INSTANCE);
        if (sql != null) {
            SqlNode sqlNode;
            assert (queryable == null);
            OptiqConnectionConfig config = context.config();
            SqlParser parser = SqlParser.create(SqlParserImpl.FACTORY, sql, config.quoting(), config.unquotedCasing(), config.quotedCasing());
            try {
                sqlNode = parser.parseStmt();
            }
            catch (SqlParseException e) {
                throw new RuntimeException("parse failed: " + e.getMessage(), e);
            }
            Hook.PARSE_TREE.run(new Object[]{sql, sqlNode});
            OptiqSchema rootSchema = context.getRootSchema();
            ChainedSqlOperatorTable opTab = new ChainedSqlOperatorTable((List<SqlOperatorTable>)ImmutableList.of((Object)SqlStdOperatorTable.instance(), (Object)catalogReader));
            OptiqSqlValidator validator = new OptiqSqlValidator(opTab, catalogReader, typeFactory);
            validator.setIdentifierExpansion(true);
            ImmutableList materializations = config.materializationsEnabled() ? MaterializationService.instance().query(rootSchema) : ImmutableList.of();
            for (Prepare.Materialization materialization : materializations) {
                this.populateMaterializations(context, planner, materialization);
            }
            preparedResult = preparingStmt.prepareSql(sqlNode, Object.class, validator, true, (List<Prepare.Materialization>)materializations);
            switch (sqlNode.getKind()) {
                case EXPLAIN: 
                case INSERT: {
                    x = RelOptUtil.createDmlRowType(sqlNode.getKind(), typeFactory);
                    break;
                }
                default: {
                    x = validator.getValidatedNodeType(sqlNode);
                    break;
                }
            }
        } else {
            assert (queryable != null);
            x = context.getTypeFactory().createType(elementType);
            preparedResult = preparingStmt.prepareQueryable(queryable, x);
        }
        ArrayList<AvaticaParameter> parameters = new ArrayList<AvaticaParameter>();
        RelDataType parameterRowType = preparedResult.getParameterRowType();
        for (RelDataTypeField field : parameterRowType.getFieldList()) {
            RelDataType type = field.getType();
            parameters.add(new AvaticaParameter(false, OptiqPrepareImpl.getPrecision(type), OptiqPrepareImpl.getScale(type), this.getTypeOrdinal(type), OptiqPrepareImpl.getTypeName(type), OptiqPrepareImpl.getClassName(type), field.getName()));
        }
        RelDataType jdbcType = OptiqPrepareImpl.makeStruct(typeFactory, x);
        List<List<String>> originList = preparedResult.getFieldOrigins();
        ColumnMetaData.StructType structType = this.getColumnMetaDataList(typeFactory, x, jdbcType, originList);
        Class resultClazz = null;
        if (preparedResult instanceof Typed) {
            resultClazz = (Class)((Typed)((Object)preparedResult)).getElementType();
        }
        return new OptiqPrepare.PrepareResult(sql, parameters, jdbcType, structType, maxRowCount, preparedResult.getBindable(), resultClazz);
    }

    private ColumnMetaData.StructType getColumnMetaDataList(JavaTypeFactory typeFactory, RelDataType x, RelDataType jdbcType, List<List<String>> originList) {
        ArrayList<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();
        for (Ord pair : Ord.zip(jdbcType.getFieldList())) {
            RelDataTypeField field = (RelDataTypeField)pair.e;
            RelDataType type = field.getType();
            RelDataType fieldType = x.isStruct() ? x.getFieldList().get(pair.i).getType() : type;
            columns.add(this.metaData(typeFactory, columns.size(), field.getName(), type, fieldType, originList.get(pair.i)));
        }
        return ColumnMetaData.struct(columns);
    }

    private ColumnMetaData metaData(JavaTypeFactory typeFactory, int ordinal, String fieldName, RelDataType type, RelDataType fieldType, List<String> origins) {
        return new ColumnMetaData(ordinal, false, true, false, false, type.isNullable() ? 1 : 0, true, type.getPrecision(), fieldName, OptiqPrepareImpl.origin(origins, 0), OptiqPrepareImpl.origin(origins, 2), OptiqPrepareImpl.getPrecision(type), OptiqPrepareImpl.getScale(type), OptiqPrepareImpl.origin(origins, 1), null, this.avaticaType(typeFactory, type, fieldType), true, false, false, OptiqPrepareImpl.getClassName(type));
    }

    private ColumnMetaData.AvaticaType avaticaType(JavaTypeFactory typeFactory, RelDataType type, RelDataType fieldType) {
        Type clazz = typeFactory.getJavaClass(Util.first(fieldType, type));
        ColumnMetaData.Rep rep = ColumnMetaData.Rep.of((Type)clazz);
        assert (rep != null);
        String typeName = OptiqPrepareImpl.getTypeName(type);
        if (type.getComponentType() != null) {
            ColumnMetaData.AvaticaType componentType = this.avaticaType(typeFactory, type.getComponentType(), null);
            return ColumnMetaData.array((ColumnMetaData.AvaticaType)componentType, (String)typeName, (ColumnMetaData.Rep)rep);
        }
        return ColumnMetaData.scalar((int)this.getTypeOrdinal(type), (String)typeName, (ColumnMetaData.Rep)rep);
    }

    private static String origin(List<String> origins, int offsetFromEnd) {
        return origins == null || offsetFromEnd >= origins.size() ? null : origins.get(origins.size() - 1 - offsetFromEnd);
    }

    private int getTypeOrdinal(RelDataType type) {
        return type.getSqlTypeName().getJdbcOrdinal();
    }

    private static String getClassName(RelDataType type) {
        return null;
    }

    private static int getScale(RelDataType type) {
        return type.getScale() == Integer.MIN_VALUE ? 0 : type.getScale();
    }

    private static int getPrecision(RelDataType type) {
        return type.getPrecision() == -1 ? 0 : type.getPrecision();
    }

    private static String getTypeName(RelDataType type) {
        SqlTypeName sqlTypeName = type.getSqlTypeName();
        if (type instanceof RelDataTypeFactoryImpl.JavaType) {
            return sqlTypeName.getName();
        }
        switch (sqlTypeName) {
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY_TIME: {
                return "INTERVAL_" + type.getIntervalQualifier().toString().replace(' ', '_');
            }
        }
        return type.toString();
    }

    protected void populateMaterializations(OptiqPrepare.Context context, RelOptPlanner planner, Prepare.Materialization materialization) {
        try {
            OptiqSchema schema = materialization.materializedTable.schema;
            OptiqCatalogReader catalogReader = new OptiqCatalogReader(schema.root(), context.config().caseSensitive(), Util.skipLast(materialization.materializedTable.path()), context.getTypeFactory());
            OptiqMaterializer materializer = new OptiqMaterializer(context, catalogReader, schema, planner);
            materializer.populate(materialization);
        }
        catch (Exception e) {
            throw new RuntimeException("While populating materialization " + materialization.materializedTable.path(), e);
        }
    }

    private static RelDataType makeStruct(RelDataTypeFactory typeFactory, RelDataType type) {
        if (type.isStruct()) {
            return type;
        }
        return typeFactory.builder().add("$0", type).build();
    }

    public <R> R perform(OptiqServerStatement statement, Frameworks.PrepareAction<R> action) {
        OptiqPrepare.Context prepareContext = statement.createPrepareContext();
        JavaTypeFactory typeFactory = prepareContext.getTypeFactory();
        OptiqCatalogReader catalogReader = new OptiqCatalogReader(prepareContext.getRootSchema(), prepareContext.config().caseSensitive(), prepareContext.getDefaultSchemaPath(), typeFactory);
        RexBuilder rexBuilder = new RexBuilder(typeFactory);
        RelOptPlanner planner = this.createPlanner(prepareContext, action.getConfig().getContext(), action.getConfig().getCostFactory());
        RelOptQuery query = new RelOptQuery(planner);
        RelOptCluster cluster = query.createCluster(rexBuilder.getTypeFactory(), rexBuilder);
        return action.apply(cluster, catalogReader, prepareContext.getRootSchema().plus(), statement);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EmptyScalarTranslator
    implements ScalarTranslator {
        private final RexBuilder rexBuilder;

        public EmptyScalarTranslator(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        public static ScalarTranslator empty(RexBuilder builder) {
            return new EmptyScalarTranslator(builder);
        }

        @Override
        public List<RexNode> toRexList(BlockStatement statement) {
            List<Expression> simpleList = EmptyScalarTranslator.simpleList(statement);
            ArrayList<RexNode> list = new ArrayList<RexNode>();
            for (Expression expression1 : simpleList) {
                list.add(this.toRex(expression1));
            }
            return list;
        }

        @Override
        public RexNode toRex(BlockStatement statement) {
            return this.toRex(Blocks.simple((BlockStatement)statement));
        }

        private static List<Expression> simpleList(BlockStatement statement) {
            Expression simple = Blocks.simple((BlockStatement)statement);
            if (simple instanceof NewExpression) {
                NewExpression newExpression = (NewExpression)simple;
                return newExpression.arguments;
            }
            return Collections.singletonList(simple);
        }

        @Override
        public RexNode toRex(Expression expression) {
            switch (expression.getNodeType()) {
                case MemberAccess: {
                    return this.rexBuilder.makeFieldAccess(this.toRex(((MemberExpression)expression).expression), ((MemberExpression)expression).field.getName(), true);
                }
                case GreaterThan: {
                    return this.binary(expression, SqlStdOperatorTable.GREATER_THAN);
                }
                case LessThan: {
                    return this.binary(expression, SqlStdOperatorTable.LESS_THAN);
                }
                case Parameter: {
                    return this.parameter((ParameterExpression)expression);
                }
                case Call: {
                    MethodCallExpression call = (MethodCallExpression)expression;
                    SqlOperator operator = RexToLixTranslator.JAVA_TO_SQL_METHOD_MAP.get(call.method);
                    if (operator != null) {
                        return this.rexBuilder.makeCall(operator, this.toRex((List<Expression>)Expressions.list().appendIfNotNull((Object)call.targetExpression).appendAll((Iterable)call.expressions)));
                    }
                    throw new RuntimeException("Could translate call to method " + call.method);
                }
                case Constant: {
                    ConstantExpression constant = (ConstantExpression)expression;
                    Object value = constant.value;
                    if (value instanceof Number) {
                        Number number = (Number)value;
                        if (value instanceof Double || value instanceof Float) {
                            return this.rexBuilder.makeApproxLiteral(BigDecimal.valueOf(number.doubleValue()));
                        }
                        if (value instanceof BigDecimal) {
                            return this.rexBuilder.makeExactLiteral((BigDecimal)value);
                        }
                        return this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(number.longValue()));
                    }
                    if (value instanceof Boolean) {
                        return this.rexBuilder.makeLiteral((Boolean)value);
                    }
                    return this.rexBuilder.makeLiteral(constant.toString());
                }
            }
            throw new UnsupportedOperationException("unknown expression type " + expression.getNodeType() + " " + expression);
        }

        private RexNode binary(Expression expression, SqlBinaryOperator op) {
            BinaryExpression call = (BinaryExpression)expression;
            return this.rexBuilder.makeCall((SqlOperator)op, this.toRex((List<Expression>)ImmutableList.of((Object)call.expression0, (Object)call.expression1)));
        }

        private List<RexNode> toRex(List<Expression> expressions) {
            ArrayList<RexNode> list = new ArrayList<RexNode>();
            for (Expression expression : expressions) {
                list.add(this.toRex(expression));
            }
            return list;
        }

        @Override
        public ScalarTranslator bind(List<ParameterExpression> parameterList, List<RexNode> values) {
            return new LambdaScalarTranslator(this.rexBuilder, parameterList, values);
        }

        public RexNode parameter(ParameterExpression param) {
            throw new RuntimeException("unknown parameter " + param);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LambdaScalarTranslator
    extends EmptyScalarTranslator {
        private final List<ParameterExpression> parameterList;
        private final List<RexNode> values;

        public LambdaScalarTranslator(RexBuilder rexBuilder, List<ParameterExpression> parameterList, List<RexNode> values) {
            super(rexBuilder);
            this.parameterList = parameterList;
            this.values = values;
        }

        @Override
        public RexNode parameter(ParameterExpression param) {
            int i = this.parameterList.indexOf(param);
            if (i >= 0) {
                return this.values.get(i);
            }
            throw new RuntimeException("unknown parameter " + param);
        }
    }

    private static class OptiqPreparedExplain
    extends Prepare.PreparedExplain {
        public OptiqPreparedExplain(RelDataType resultType, RelDataType parameterRowType, RelNode rootRel, boolean explainAsXml, SqlExplainLevel detailLevel) {
            super(resultType, parameterRowType, rootRel, explainAsXml, detailLevel);
        }

        public Bindable getBindable() {
            final String explanation = this.getCode();
            return new Bindable(){

                public Enumerable bind(DataContext dataContext) {
                    return Linq4j.singletonEnumerable((Object)explanation);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OptiqPreparingStmt
    extends Prepare
    implements RelOptTable.ViewExpander {
        private final RelOptPlanner planner;
        private final RexBuilder rexBuilder;
        protected final OptiqSchema schema;
        protected final RelDataTypeFactory typeFactory;
        private final EnumerableRel.Prefer prefer;
        private int expansionDepth;
        private SqlValidator sqlValidator;

        public OptiqPreparingStmt(OptiqPrepare.Context context, Prepare.CatalogReader catalogReader, RelDataTypeFactory typeFactory, OptiqSchema schema, EnumerableRel.Prefer prefer, RelOptPlanner planner, Convention resultConvention) {
            super(context, catalogReader, resultConvention);
            this.schema = schema;
            this.prefer = prefer;
            this.planner = planner;
            this.typeFactory = typeFactory;
            this.rexBuilder = new RexBuilder(typeFactory);
        }

        @Override
        protected void init(Class runtimeContextClass) {
        }

        public Prepare.PreparedResult prepareQueryable(Queryable queryable, RelDataType resultType) {
            this.queryString = null;
            Class<Object> runtimeContextClass = Object.class;
            this.init(runtimeContextClass);
            RelOptQuery query = new RelOptQuery(this.planner);
            RelOptCluster cluster = query.createCluster(this.rexBuilder.getTypeFactory(), this.rexBuilder);
            RelNode rootRel = new LixToRelTranslator(cluster, this).translate(queryable);
            if (this.timingTracer != null) {
                this.timingTracer.traceTime("end sql2rel");
            }
            RelDataType jdbcType = OptiqPrepareImpl.makeStruct(this.rexBuilder.getTypeFactory(), resultType);
            this.fieldOrigins = Collections.nCopies(jdbcType.getFieldCount(), null);
            this.parameterRowType = this.rexBuilder.getTypeFactory().builder().build();
            rootRel = this.flattenTypes(rootRel, true);
            rootRel = this.trimUnusedFields(rootRel);
            ImmutableList materializations = ImmutableList.of();
            rootRel = this.optimize(resultType, rootRel, (List<Prepare.Materialization>)materializations);
            if (this.timingTracer != null) {
                this.timingTracer.traceTime("end optimization");
            }
            return this.implement(resultType, rootRel, SqlKind.SELECT);
        }

        @Override
        protected SqlToRelConverter getSqlToRelConverter(SqlValidator validator, Prepare.CatalogReader catalogReader) {
            SqlToRelConverter sqlToRelConverter = new SqlToRelConverter(this, validator, catalogReader, this.planner, this.rexBuilder, StandardConvertletTable.INSTANCE);
            sqlToRelConverter.setTrimUnusedFields(true);
            return sqlToRelConverter;
        }

        @Override
        protected EnumerableRelImplementor getRelImplementor(RexBuilder rexBuilder) {
            return new EnumerableRelImplementor(rexBuilder);
        }

        @Override
        protected boolean shouldAlwaysWriteJavaFile() {
            return false;
        }

        @Override
        public RelNode flattenTypes(RelNode rootRel, boolean restructure) {
            OptiqPrepare.SparkHandler spark = this.context.spark();
            if (spark.enabled()) {
                return spark.flattenTypes(this.planner, rootRel, restructure);
            }
            return rootRel;
        }

        @Override
        protected RelNode decorrelate(SqlToRelConverter sqlToRelConverter, SqlNode query, RelNode rootRel) {
            return sqlToRelConverter.decorrelate(query, rootRel);
        }

        @Override
        public RelNode expandView(RelDataType rowType, String queryString, List<String> schemaPath) {
            SqlNode sqlNode;
            ++this.expansionDepth;
            SqlParser parser = SqlParser.create(queryString);
            try {
                sqlNode = parser.parseQuery();
            }
            catch (SqlParseException e) {
                throw new RuntimeException("parse failed", e);
            }
            Prepare.CatalogReader catalogReader = this.catalogReader.withSchemaPath(schemaPath);
            SqlValidatorImpl validator = this.createSqlValidator(catalogReader);
            SqlNode sqlNode1 = validator.validate(sqlNode);
            SqlToRelConverter sqlToRelConverter = this.getSqlToRelConverter(validator, catalogReader);
            RelNode relNode = sqlToRelConverter.convertQuery(sqlNode1, true, false);
            --this.expansionDepth;
            return relNode;
        }

        private SqlValidatorImpl createSqlValidator(Prepare.CatalogReader catalogReader) {
            return new SqlValidatorImpl(SqlStdOperatorTable.instance(), catalogReader, this.rexBuilder.getTypeFactory(), SqlConformance.DEFAULT){};
        }

        @Override
        protected SqlValidator getSqlValidator() {
            if (this.sqlValidator == null) {
                this.sqlValidator = this.createSqlValidator(this.catalogReader);
            }
            return this.sqlValidator;
        }

        @Override
        protected Prepare.PreparedResult createPreparedExplanation(RelDataType resultType, RelDataType parameterRowType, RelNode rootRel, boolean explainAsXml, SqlExplainLevel detailLevel) {
            return new OptiqPreparedExplain(resultType, parameterRowType, rootRel, explainAsXml, detailLevel);
        }

        @Override
        protected Prepare.PreparedResult implement(RelDataType rowType, RelNode rootRel, SqlKind sqlKind) {
            Bindable bindable;
            RelDataType resultType = rootRel.getRowType();
            boolean isDml = sqlKind.belongsTo(SqlKind.DML);
            EnumerableRelImplementor relImplementor = this.getRelImplementor(rootRel.getCluster().getRexBuilder());
            ClassDeclaration expr = relImplementor.implementRoot((EnumerableRel)rootRel, this.prefer);
            String s = Expressions.toString((List)expr.memberDeclarations, (String)"\n", (boolean)false);
            if (DEBUG) {
                this.debugCode(System.out, s);
            }
            Hook.JAVA_PLAN.run(s);
            try {
                bindable = this.getBindable(expr, s);
            }
            catch (Exception e) {
                throw Helper.INSTANCE.wrap("Error while compiling generated Java code:\n" + s, e);
            }
            if (this.timingTracer != null) {
                this.timingTracer.traceTime("end codegen");
            }
            if (this.timingTracer != null) {
                this.timingTracer.traceTime("end compilation");
            }
            return new Prepare.PreparedResultImpl(resultType, this.parameterRowType, this.fieldOrigins, rootRel, this.mapTableModOp(isDml, sqlKind), isDml){

                public String getCode() {
                    throw new UnsupportedOperationException();
                }

                public Bindable getBindable() {
                    return bindable;
                }

                public Type getElementType() {
                    return ((Typed)((Object)bindable)).getElementType();
                }
            };
        }

        private void debugCode(PrintStream out, String code) {
            out.println();
            StringReader sr = new StringReader(code);
            BufferedReader br = new BufferedReader(sr);
            try {
                String line;
                int i = 1;
                while ((line = br.readLine()) != null) {
                    out.print("/*");
                    String number = Integer.toString(i);
                    if (number.length() < 4) {
                        Spaces.append(out, 4 - number.length());
                    }
                    out.print(number);
                    out.print(" */ ");
                    out.println(line);
                    ++i;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private Bindable getBindable(ClassDeclaration expr, String s) throws CompileException, IOException {
            ICompilerFactory compilerFactory;
            if (this.context.spark().enabled()) {
                return this.context.spark().compile(expr, s);
            }
            try {
                compilerFactory = CompilerFactoryFactory.getDefaultCompilerFactory();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to instantiate java compiler", e);
            }
            IClassBodyEvaluator cbe = compilerFactory.newClassBodyEvaluator();
            cbe.setClassName(expr.name);
            cbe.setExtendedClass(Utilities.class);
            cbe.setImplementedInterfaces(new Class[]{Bindable.class, Typed.class});
            cbe.setParentClassLoader(this.getClass().getClassLoader());
            if (DEBUG) {
                cbe.setDebuggingInformation(true, true, true);
            }
            return (Bindable)cbe.createInstance((Reader)new StringReader(s));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ScalarTranslator {
        public RexNode toRex(BlockStatement var1);

        public List<RexNode> toRexList(BlockStatement var1);

        public RexNode toRex(Expression var1);

        public ScalarTranslator bind(List<ParameterExpression> var1, List<RexNode> var2);
    }
}

