/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.jdbc;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.hydromatic.linq4j.Linq4j;
import net.hydromatic.optiq.Function;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.TableMacro;
import net.hydromatic.optiq.TranslatableTable;
import net.hydromatic.optiq.jdbc.CachingOptiqRootSchema;
import net.hydromatic.optiq.jdbc.MetadataSchema;
import net.hydromatic.optiq.jdbc.OptiqConnectionImpl;
import net.hydromatic.optiq.jdbc.OptiqRootSchema;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import org.eigenbase.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingOptiqSchema
extends OptiqSchema {
    private static final Comparator<String> COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            int c = o1.compareToIgnoreCase(o2);
            if (c == 0) {
                c = o1.compareTo(o2);
            }
            return c;
        }
    };
    public final NavigableMap<String, OptiqSchema.TableEntry> tableMap = new TreeMap<String, OptiqSchema.TableEntry>(COMPARATOR);
    private final Multimap<String, OptiqSchema.FunctionEntry> functionMap = LinkedListMultimap.create();
    private final NavigableSet<String> functionNames = new TreeSet<String>(COMPARATOR);
    private final NavigableMap<String, OptiqSchema.FunctionEntry> nullaryFunctionMap = new TreeMap<String, OptiqSchema.FunctionEntry>(COMPARATOR);
    private final NavigableMap<String, OptiqSchema> subSchemaMap = new TreeMap<String, OptiqSchema>(COMPARATOR);
    private boolean cache = true;
    private final Cached<SubSchemaCache> implicitSubSchemaCache;
    private final Cached<ImmutableSortedSet<String>> implicitTableCache;
    private final Cached<ImmutableSortedSet<String>> implicitFunctionCache;

    public CachingOptiqSchema(OptiqSchema parent, final Schema schema, String name) {
        super(parent, schema, name);
        assert (parent == null == this instanceof OptiqRootSchema);
        this.implicitSubSchemaCache = new AbstractCached<SubSchemaCache>(this){

            @Override
            public SubSchemaCache build() {
                return new SubSchemaCache(this, ImmutableSortedSet.copyOf((Comparator)COMPARATOR, schema.getSubSchemaNames()));
            }
        };
        this.implicitTableCache = new AbstractCached<ImmutableSortedSet<String>>(this){

            @Override
            public ImmutableSortedSet<String> build() {
                return ImmutableSortedSet.copyOf((Comparator)COMPARATOR, schema.getTableNames());
            }
        };
        this.implicitFunctionCache = new AbstractCached<ImmutableSortedSet<String>>(this){

            @Override
            public ImmutableSortedSet<String> build() {
                return ImmutableSortedSet.copyOf((Comparator)COMPARATOR, schema.getFunctionNames());
            }
        };
    }

    @Override
    public Collection<OptiqSchema.TableEntry> getTableEntries() {
        return this.tableMap.values();
    }

    public static OptiqSchema createRootSchema(boolean addMetadataSchema) {
        CachingOptiqRootSchema rootSchema = new CachingOptiqRootSchema(new OptiqConnectionImpl.RootSchema());
        if (addMetadataSchema) {
            rootSchema.add("metadata", MetadataSchema.INSTANCE);
        }
        return rootSchema;
    }

    @Override
    public OptiqSchema.TableEntry add(String tableName, Table table) {
        OptiqSchema.TableEntryImpl entry = new OptiqSchema.TableEntryImpl(this, tableName, table);
        this.tableMap.put(tableName, entry);
        return entry;
    }

    @Override
    protected OptiqSchema.FunctionEntry add(String name, Function function) {
        OptiqSchema.FunctionEntryImpl entry = new OptiqSchema.FunctionEntryImpl(this, name, function);
        this.functionMap.put((Object)name, (Object)entry);
        this.functionNames.add(name);
        if (function.getParameters().isEmpty()) {
            this.nullaryFunctionMap.put(name, entry);
        }
        return entry;
    }

    @Override
    protected void setCache(boolean cache) {
        if (cache == this.cache) {
            return;
        }
        long now = System.currentTimeMillis();
        this.implicitSubSchemaCache.enable(now, cache);
        this.implicitTableCache.enable(now, cache);
        this.implicitFunctionCache.enable(now, cache);
        this.cache = cache;
    }

    @Override
    public final OptiqSchema getSubSchema(String schemaName, boolean caseSensitive) {
        if (caseSensitive) {
            OptiqSchema entry = (OptiqSchema)this.subSchemaMap.get(schemaName);
            if (entry != null) {
                return entry;
            }
            long now = System.currentTimeMillis();
            SubSchemaCache subSchemaCache = this.implicitSubSchemaCache.get(now);
            if (subSchemaCache.names.contains((Object)schemaName)) {
                return (OptiqSchema)subSchemaCache.cache.getUnchecked((Object)schemaName);
            }
            return null;
        }
        Iterator iterator = CachingOptiqSchema.find(this.subSchemaMap, schemaName).entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            return (OptiqSchema)entry.getValue();
        }
        long now = System.currentTimeMillis();
        SubSchemaCache subSchemaCache = this.implicitSubSchemaCache.get(now);
        String schemaName2 = (String)subSchemaCache.names.floor((Object)schemaName);
        if (schemaName2 != null) {
            return (OptiqSchema)subSchemaCache.cache.getUnchecked((Object)schemaName2);
        }
        return null;
    }

    @Override
    public OptiqSchema add(String name, Schema schema) {
        CachingOptiqSchema optiqSchema = new CachingOptiqSchema(this, schema, name);
        this.subSchemaMap.put(name, optiqSchema);
        return optiqSchema;
    }

    @Override
    public final Pair<String, Table> getTable(String tableName, boolean caseSensitive) {
        Table table;
        if (caseSensitive) {
            Table table2;
            OptiqSchema.TableEntry entry = (OptiqSchema.TableEntry)this.tableMap.get(tableName);
            if (entry != null) {
                return Pair.of(tableName, entry.getTable());
            }
            long now = System.currentTimeMillis();
            if (this.implicitTableCache.get(now).contains((Object)tableName) && (table2 = this.schema.getTable(tableName)) != null) {
                return Pair.of(tableName, table2);
            }
            return null;
        }
        Iterator iterator = CachingOptiqSchema.find(this.tableMap, tableName).entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            return Pair.of((String)entry.getKey(), ((OptiqSchema.TableEntry)entry.getValue()).getTable());
        }
        long now = System.currentTimeMillis();
        NavigableSet implicitTableNames = (NavigableSet)this.implicitTableCache.get(now);
        String tableName2 = implicitTableNames.floor(tableName);
        if (tableName2 != null && (table = this.schema.getTable(tableName2)) != null) {
            return Pair.of(tableName2, table);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SchemaPlus plus() {
        return new OptiqSchema.SchemaPlusImpl(this);
    }

    public static OptiqSchema from(SchemaPlus plus) {
        return ((OptiqSchema.SchemaPlusImpl)plus).optiqSchema();
    }

    @Override
    public Set<String> getSubSchemaNames() {
        return this.getSubSchemaMap().keySet();
    }

    @Override
    public Collection<OptiqSchema> getSubSchemas() {
        return this.getSubSchemaMap().values();
    }

    public NavigableMap<String, OptiqSchema> getSubSchemaMap() {
        ImmutableSortedMap.Builder builder = new ImmutableSortedMap.Builder(COMPARATOR);
        long now = System.currentTimeMillis();
        SubSchemaCache subSchemaCache = this.implicitSubSchemaCache.get(now);
        for (String name : subSchemaCache.names) {
            builder.put((Object)name, (Object)((OptiqSchema)subSchemaCache.cache.getUnchecked((Object)name)));
        }
        builder.putAll(this.subSchemaMap);
        return builder.build();
    }

    public NavigableSet<String> getTableNames() {
        ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(COMPARATOR);
        builder.addAll(this.tableMap.keySet());
        builder.addAll((Iterable)this.implicitTableCache.get(System.currentTimeMillis()));
        return builder.build();
    }

    @Override
    public Collection<Function> getFunctions(String name, boolean caseSensitive) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (caseSensitive) {
            Collection<Function> functions;
            Collection functionEntries = this.functionMap.get((Object)name);
            if (functionEntries != null) {
                for (OptiqSchema.FunctionEntry functionEntry : functionEntries) {
                    builder.add((Object)functionEntry.getFunction());
                }
            }
            if ((functions = this.schema.getFunctions(name)) != null) {
                builder.addAll(functions);
            }
        } else {
            for (String name2 : CachingOptiqSchema.find(this.functionNames, name)) {
                Collection functionEntries = this.functionMap.get((Object)name2);
                if (functionEntries == null) continue;
                for (OptiqSchema.FunctionEntry functionEntry : functionEntries) {
                    builder.add((Object)functionEntry.getFunction());
                }
            }
            for (String name2 : CachingOptiqSchema.find((NavigableSet)this.implicitFunctionCache.get(System.currentTimeMillis()), name)) {
                Collection<Function> functions = this.schema.getFunctions(name2);
                if (functions == null) continue;
                builder.addAll(functions);
            }
        }
        return builder.build();
    }

    public NavigableSet<String> getFunctionNames() {
        ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(COMPARATOR);
        builder.addAll((Iterable)this.functionMap.keySet());
        builder.addAll((Iterable)this.implicitFunctionCache.get(System.currentTimeMillis()));
        return builder.build();
    }

    public NavigableMap<String, Table> getTablesBasedOnNullaryFunctions() {
        ImmutableSortedMap.Builder builder = new ImmutableSortedMap.Builder(COMPARATOR);
        for (Map.Entry s : this.nullaryFunctionMap.entrySet()) {
            Function function = ((OptiqSchema.FunctionEntry)s.getValue()).getFunction();
            if (!(function instanceof TableMacro)) continue;
            assert (function.getParameters().isEmpty());
            TranslatableTable table = ((TableMacro)function).apply((List<Object>)ImmutableList.of());
            builder.put((Object)((String)s.getKey()), (Object)table);
        }
        for (Map.Entry s : this.implicitFunctionCache.get(System.currentTimeMillis())) {
            for (Function function : this.schema.getFunctions((String)((Object)s))) {
                if (!(function instanceof TableMacro) || !function.getParameters().isEmpty()) continue;
                TranslatableTable table = ((TableMacro)function).apply((List<Object>)ImmutableList.of());
                builder.put((Object)s, (Object)table);
            }
        }
        return builder.build();
    }

    @Override
    public Pair<String, Table> getTableBasedOnNullaryFunction(String tableName, boolean caseSensitive) {
        if (caseSensitive) {
            Function function2;
            OptiqSchema.FunctionEntry functionEntry = (OptiqSchema.FunctionEntry)this.nullaryFunctionMap.get(tableName);
            if (functionEntry != null && (function2 = functionEntry.getFunction()) instanceof TableMacro) {
                assert (function2.getParameters().isEmpty());
                TranslatableTable table = ((TableMacro)function2).apply((List<Object>)ImmutableList.of());
                return Pair.of(tableName, table);
            }
            for (Function function2 : this.schema.getFunctions(tableName)) {
                if (!(function2 instanceof TableMacro) || !function2.getParameters().isEmpty()) continue;
                TranslatableTable table = ((TableMacro)function2).apply((List<Object>)ImmutableList.of());
                return Pair.of(tableName, table);
            }
        } else {
            for (Map.Entry entry : CachingOptiqSchema.find(this.nullaryFunctionMap, tableName).entrySet()) {
                Function function = ((OptiqSchema.FunctionEntry)entry.getValue()).getFunction();
                if (!(function instanceof TableMacro)) continue;
                assert (function.getParameters().isEmpty());
                TranslatableTable table = ((TableMacro)function).apply((List<Object>)ImmutableList.of());
                return Pair.of((String)entry.getKey(), table);
            }
            NavigableSet set = (NavigableSet)this.implicitFunctionCache.get(System.currentTimeMillis());
            for (String s : CachingOptiqSchema.find(set, tableName)) {
                for (Function function : this.schema.getFunctions(s)) {
                    if (!(function instanceof TableMacro) || !function.getParameters().isEmpty()) continue;
                    TranslatableTable table = ((TableMacro)function).apply((List<Object>)ImmutableList.of());
                    return Pair.of(s, table);
                }
            }
        }
        return null;
    }

    private static <V> NavigableMap<String, V> find(NavigableMap<String, V> map, String s) {
        assert (map.comparator() == COMPARATOR);
        return map.subMap(s.toUpperCase(), true, s.toLowerCase(), true);
    }

    private static Iterable<String> find(NavigableSet<String> set, String name) {
        assert (set.comparator() == COMPARATOR);
        return set.subSet(name.toUpperCase(), true, name.toLowerCase(), true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractCached<T>
    implements Cached<T> {
        T t;
        long checked = Long.MIN_VALUE;

        private AbstractCached() {
        }

        @Override
        public T get(long now) {
            if (!CachingOptiqSchema.this.cache) {
                return this.build();
            }
            if (this.checked == Long.MIN_VALUE || CachingOptiqSchema.this.schema.contentsHaveChangedSince(this.checked, now)) {
                this.t = this.build();
            }
            this.checked = now;
            return this.t;
        }

        @Override
        public void enable(long now, boolean enabled) {
            if (!enabled) {
                this.t = null;
            }
            this.checked = Long.MIN_VALUE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Cached<T> {
        public T get(long var1);

        public T build();

        public void enable(long var1, boolean var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Entry {
        public final OptiqSchema schema;
        public final String name;

        public Entry(OptiqSchema schema, String name) {
            Linq4j.requireNonNull((Object)schema);
            Linq4j.requireNonNull((Object)name);
            this.schema = schema;
            this.name = name;
        }

        public final List<String> path() {
            return this.schema.path(this.name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubSchemaCache {
        final ImmutableSortedSet<String> names;
        final LoadingCache<String, OptiqSchema> cache;

        private SubSchemaCache(final OptiqSchema optiqSchema, ImmutableSortedSet<String> names) {
            this.names = names;
            this.cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, OptiqSchema>(){

                public OptiqSchema load(String schemaName) {
                    Schema subSchema = optiqSchema.schema.getSubSchema(schemaName);
                    if (subSchema == null) {
                        throw new RuntimeException("sub-schema " + schemaName + " not found");
                    }
                    return new CachingOptiqSchema(optiqSchema, subSchema, schemaName);
                }
            });
        }
    }
}

