/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.test.concurrent;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.hydromatic.optiq.jdbc.SqlTimeoutException;
import org.eigenbase.test.concurrent.ConcurrentTestCommand;
import org.eigenbase.test.concurrent.ConcurrentTestCommandExecutor;
import org.eigenbase.test.concurrent.ConcurrentTestCommandGenerator;
import org.eigenbase.test.concurrent.ConcurrentTestPlugin;
import org.eigenbase.test.concurrent.ConcurrentTestPluginCommand;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentTestCommandScript
extends ConcurrentTestCommandGenerator {
    private static final String PRE_SETUP_STATE = "pre-setup";
    private static final String SETUP_STATE = "setup";
    private static final String POST_SETUP_STATE = "post-setup";
    private static final String CLEANUP_STATE = "cleanup";
    private static final String POST_CLEANUP_STATE = "post-cleanup";
    private static final String THREAD_STATE = "thread";
    private static final String REPEAT_STATE = "repeat";
    private static final String SQL_STATE = "sql";
    private static final String POST_THREAD_STATE = "post-thread";
    private static final String EOF_STATE = "eof";
    private static final String VAR = "@var";
    private static final String LOCKSTEP = "@lockstep";
    private static final String NOLOCKSTEP = "@nolockstep";
    private static final String ENABLED = "@enabled";
    private static final String DISABLED = "@disabled";
    private static final String SETUP = "@setup";
    private static final String CLEANUP = "@cleanup";
    private static final String END = "@end";
    private static final String THREAD = "@thread";
    private static final String REPEAT = "@repeat";
    private static final String SYNC = "@sync";
    private static final String TIMEOUT = "@timeout";
    private static final String ROWLIMIT = "@rowlimit";
    private static final String PREPARE = "@prepare";
    private static final String PRINT = "@print";
    private static final String FETCH = "@fetch";
    private static final String CLOSE = "@close";
    private static final String SLEEP = "@sleep";
    private static final String ERR = "@err";
    private static final String ECHO = "@echo";
    private static final String INCLUDE = "@include";
    private static final String SHELL = "@shell";
    private static final String PLUGIN = "@plugin";
    private static final String SQL = "";
    private static final String EOF = null;
    private static final StateAction[] STATE_TABLE = new StateAction[]{new StateAction("pre-setup", new StateDatum[]{new StateDatum("@var", "pre-setup"), new StateDatum("@lockstep", "pre-setup"), new StateDatum("@nolockstep", "pre-setup"), new StateDatum("@enabled", "pre-setup"), new StateDatum("@disabled", "pre-setup"), new StateDatum("@plugin", "pre-setup"), new StateDatum("@setup", "setup"), new StateDatum("@cleanup", "cleanup"), new StateDatum("@thread", "thread")}), new StateAction("setup", new StateDatum[]{new StateDatum("@end", "post-setup"), new StateDatum("", "setup"), new StateDatum("@include", "setup")}), new StateAction("post-setup", new StateDatum[]{new StateDatum("@cleanup", "cleanup"), new StateDatum("@thread", "thread")}), new StateAction("cleanup", new StateDatum[]{new StateDatum("@end", "post-cleanup"), new StateDatum("", "cleanup"), new StateDatum("@include", "cleanup")}), new StateAction("post-cleanup", new StateDatum[]{new StateDatum("@thread", "thread")}), new StateAction("thread", new StateDatum[]{new StateDatum("@repeat", "repeat"), new StateDatum("@sync", "thread"), new StateDatum("@timeout", "thread"), new StateDatum("@rowlimit", "thread"), new StateDatum("@prepare", "thread"), new StateDatum("@print", "thread"), new StateDatum("@fetch", "thread"), new StateDatum("@close", "thread"), new StateDatum("@sleep", "thread"), new StateDatum("", "thread"), new StateDatum("@echo", "thread"), new StateDatum("@err", "thread"), new StateDatum("@shell", "thread"), new StateDatum("@end", "post-thread")}), new StateAction("repeat", new StateDatum[]{new StateDatum("@sync", "repeat"), new StateDatum("@timeout", "repeat"), new StateDatum("@rowlimit", "repeat"), new StateDatum("@prepare", "repeat"), new StateDatum("@print", "repeat"), new StateDatum("@fetch", "repeat"), new StateDatum("@close", "repeat"), new StateDatum("@sleep", "repeat"), new StateDatum("", "repeat"), new StateDatum("@echo", "repeat"), new StateDatum("@err", "repeat"), new StateDatum("@shell", "repeat"), new StateDatum("@end", "thread")}), new StateAction("post-thread", new StateDatum[]{new StateDatum("@thread", "thread"), new StateDatum(EOF, "eof")})};
    private static final int FETCH_LEN = "@fetch".length();
    private static final int PREPARE_LEN = "@prepare".length();
    private static final int PRINT_LEN = "@print".length();
    private static final int REPEAT_LEN = "@repeat".length();
    private static final int SLEEP_LEN = "@sleep".length();
    private static final int THREAD_LEN = "@thread".length();
    private static final int TIMEOUT_LEN = "@timeout".length();
    private static final int ROWLIMIT_LEN = "@rowlimit".length();
    private static final int ERR_LEN = "@err".length();
    private static final int ECHO_LEN = "@echo".length();
    private static final int SHELL_LEN = "@shell".length();
    private static final int PLUGIN_LEN = "@plugin".length();
    private static final int INCLUDE_LEN = "@include".length();
    private static final int VAR_LEN = "@var".length();
    private static final int BUF_SIZE = 1024;
    private static final int REPEAT_READ_AHEAD_LIMIT = 65536;
    private static final char[] SPACES = ConcurrentTestCommandScript.fill(new char[1024], ' ');
    private static final char[] DASHES = ConcurrentTestCommandScript.fill(new char[1024], '-');
    private static final Integer SETUP_THREAD_ID = -1;
    private static final Integer CLEANUP_THREAD_ID = -2;
    private boolean quiet = false;
    private boolean verbose = false;
    private Boolean lockstep;
    private Boolean disabled;
    private VariableTable vars = new VariableTable();
    private File scriptDirectory;
    private long scriptStartTime = 0L;
    private final List<ConcurrentTestPlugin> plugins = new ArrayList<ConcurrentTestPlugin>();
    private final Map<String, ConcurrentTestPlugin> pluginForCommand = new HashMap<String, ConcurrentTestPlugin>();
    private final Map<String, ConcurrentTestPlugin> preSetupPluginForCommand = new HashMap<String, ConcurrentTestPlugin>();
    private List<String> setupCommands = new ArrayList<String>();
    private List<String> cleanupCommands = new ArrayList<String>();
    private Map<Integer, BufferedWriter> threadBufferedWriters = new HashMap<Integer, BufferedWriter>();
    private Map<Integer, StringWriter> threadStringWriters = new HashMap<Integer, StringWriter>();
    private Map<Integer, ResultsReader> threadResultsReaders = new HashMap<Integer, ResultsReader>();
    private final Pattern shellWildcardPattern = Pattern.compile("[*?$|<>&]");

    public ConcurrentTestCommandScript() throws IOException {
    }

    public ConcurrentTestCommandScript(String filename) throws IOException {
        this();
        this.prepare(filename, null);
    }

    private static char[] fill(char[] chars, char c) {
        Arrays.fill(chars, c);
        return chars;
    }

    private void prepare(String filename, List<String> bindings) throws IOException {
        this.vars = new VariableTable();
        CommandParser parser = new CommandParser();
        parser.rememberVariableRebindings(bindings);
        parser.load(filename);
        for (Integer threadId : this.getThreadIds()) {
            this.addThreadWriters(threadId);
        }
        this.setThreadName(SETUP_THREAD_ID, SETUP_STATE);
        this.addThreadWriters(SETUP_THREAD_ID);
        if (!this.cleanupCommands.isEmpty()) {
            this.setThreadName(CLEANUP_THREAD_ID, CLEANUP_STATE);
            this.addThreadWriters(CLEANUP_THREAD_ID);
        }
    }

    @Override
    public void execute() throws Exception {
        this.scriptStartTime = System.currentTimeMillis();
        this.executeSetup();
        ConcurrentTestCommandExecutor[] threads = this.innerExecute();
        this.executeCleanup();
        this.postExecute(threads);
    }

    private void addThreadWriters(Integer threadId) {
        StringWriter w = new StringWriter();
        BufferedWriter bw = new BufferedWriter(w);
        this.threadStringWriters.put(threadId, w);
        this.threadBufferedWriters.put(threadId, bw);
        this.threadResultsReaders.put(threadId, new ResultsReader(bw));
    }

    public void setQuiet(boolean val) {
        this.quiet = val;
    }

    public void setVerbose(boolean val) {
        this.verbose = val;
    }

    public boolean useLockstep() {
        if (this.lockstep == null) {
            return false;
        }
        return this.lockstep;
    }

    public boolean isDisabled() {
        for (ConcurrentTestPlugin plugin : this.plugins) {
            if (!plugin.isTestDisabled()) continue;
            return true;
        }
        if (this.disabled == null) {
            return false;
        }
        return this.disabled;
    }

    public void executeSetup() throws Exception {
        this.executeCommands(SETUP_THREAD_ID, this.setupCommands);
    }

    public void executeCleanup() throws Exception {
        this.executeCommands(CLEANUP_THREAD_ID, this.cleanupCommands);
    }

    protected void executeCommands(int threadID, List<String> commands) throws Exception {
        if (commands == null || commands.size() == 0) {
            return;
        }
        Connection connection = DriverManager.getConnection(this.jdbcURL, this.jdbcProps);
        if (connection.getMetaData().supportsTransactions()) {
            connection.setAutoCommit(false);
        }
        boolean forced = false;
        try {
            for (String command : commands) {
                Statement stmt;
                String sql = command.trim();
                this.storeSql(threadID, sql);
                if (this.isComment(sql)) continue;
                if (sql.startsWith("!set")) {
                    String[] tokens = sql.split(" +");
                    if (tokens.length <= 2 || !tokens[1].equalsIgnoreCase("force")) continue;
                    forced = this.asBoolValue(tokens[2]);
                    continue;
                }
                if (sql.startsWith("!")) continue;
                if (sql.endsWith(";")) {
                    sql = sql.substring(0, sql.length() - 1);
                }
                if (this.isSelect(sql)) {
                    stmt = connection.createStatement();
                    try {
                        ResultSet rset = stmt.executeQuery(sql);
                        this.storeResults(threadID, rset, -1L);
                        continue;
                    }
                    finally {
                        stmt.close();
                    }
                }
                if (sql.equalsIgnoreCase("commit")) {
                    connection.commit();
                    continue;
                }
                if (sql.equalsIgnoreCase("rollback")) {
                    connection.rollback();
                    continue;
                }
                stmt = connection.createStatement();
                try {
                    try {
                        int rows = stmt.executeUpdate(sql);
                        if (rows != 1) {
                            this.storeMessage(threadID, String.valueOf(String.valueOf(rows)) + " rows affected.");
                        } else {
                            this.storeMessage(threadID, "1 row affected.");
                        }
                    }
                    catch (SQLException ex) {
                        if (!forced) {
                            throw ex;
                        }
                        this.storeMessage(threadID, ex.getMessage());
                        stmt.close();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    stmt.close();
                    throw throwable;
                }
                stmt.close();
            }
        }
        finally {
            if (connection.getMetaData().supportsTransactions()) {
                connection.rollback();
            }
            connection.close();
        }
    }

    private void storeResults(Integer threadId, ResultSet rset, long timeout) throws SQLException {
        ResultsReader r = this.threadResultsReaders.get(threadId);
        r.read(rset, timeout);
    }

    private boolean isComment(String line) {
        return line.startsWith("--") || line.startsWith("#");
    }

    private boolean asBoolValue(String s) {
        return (s = s.toLowerCase()).equals("true") || s.equals("yes") || s.equals("on");
    }

    /*
     * Exception decompiling
     */
    private boolean isSelect(String sql) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<Integer, String[]> collectResults() {
        TreeMap<Integer, String[]> results = new TreeMap<Integer, String[]>();
        TreeSet<Integer> threadIds = new TreeSet<Integer>(this.getThreadIds());
        threadIds.add(SETUP_THREAD_ID);
        threadIds.add(CLEANUP_THREAD_ID);
        for (Integer threadId : threadIds) {
            block4: {
                try {
                    BufferedWriter bout = this.threadBufferedWriters.get(threadId);
                    if (bout != null) {
                        bout.flush();
                    }
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError((Object)"IOException via StringWriter");
                }
            }
            String threadName = this.getFormattedThreadName(threadId);
            StringWriter out = this.threadStringWriters.get(threadId);
            if (out == null) continue;
            results.put(threadId, new String[]{threadName, out.toString()});
        }
        return results;
    }

    private String getFormattedThreadName(Integer id) {
        if (id < 0) {
            return this.getThreadName(id);
        }
        return "thread " + this.getThreadName(id);
    }

    public void printResults(BufferedWriter out) throws IOException {
        Map<Integer, String[]> results = this.collectResults();
        if (this.verbose) {
            out.write(String.format("script execution started at %tc (%d)%n", new Timestamp(this.scriptStartTime), this.scriptStartTime));
        }
        this.printThreadResults(out, results.get(SETUP_THREAD_ID));
        for (Integer id : results.keySet()) {
            if (id < 0) continue;
            this.printThreadResults(out, results.get(id));
        }
        this.printThreadResults(out, results.get(CLEANUP_THREAD_ID));
    }

    private void printThreadResults(BufferedWriter out, String[] threadResult) throws IOException {
        if (threadResult == null) {
            return;
        }
        String threadName = threadResult[0];
        out.write("-- " + threadName);
        out.newLine();
        out.write(threadResult[1]);
        out.write("-- end of " + threadName);
        out.newLine();
        out.newLine();
        out.flush();
    }

    @Override
    boolean requiresCustomErrorHandling() {
        return true;
    }

    @Override
    void customErrorHandler(ConcurrentTestCommandExecutor executor) {
        StringBuilder message = new StringBuilder();
        Throwable cause = executor.getFailureCause();
        ConcurrentTestCommand command = executor.getFailureCommand();
        if (command == null || !command.isFailureExpected()) {
            StackTraceElement[] trace;
            message.append(cause.getMessage());
            StackTraceElement[] stackTraceElementArray = trace = cause.getStackTrace();
            int n = trace.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement aTrace = stackTraceElementArray[n2];
                message.append("\n\t").append(aTrace.toString());
                ++n2;
            }
        } else {
            message.append(cause.getClass().getName()).append(": ").append(cause.getMessage());
        }
        this.storeMessage(executor.getThreadId(), message.toString());
    }

    private BufferedWriter getThreadWriter(Integer threadId) {
        assert (this.threadBufferedWriters.containsKey(threadId));
        return this.threadBufferedWriters.get(threadId);
    }

    private void storeSql(Integer threadId, String sql) {
        StringBuilder message;
        block15: {
            message = new StringBuilder();
            BufferedReader rdr = new BufferedReader(new StringReader(sql));
            try {
                try {
                    String line;
                    while ((line = rdr.readLine()) != null) {
                        line = line.trim();
                        if (message.length() > 0) {
                            message.append('\n');
                        }
                        message.append("> ").append(line);
                    }
                }
                catch (IOException e) {
                    assert (false) : "IOException via StringReader";
                    try {
                        rdr.close();
                        break block15;
                    }
                    catch (IOException e2) {
                        assert (false) : "IOException via StringReader";
                        break block15;
                    }
                }
            }
            catch (Throwable throwable) {
                block16: {
                    try {
                        rdr.close();
                    }
                    catch (IOException e) {
                        if ($assertionsDisabled) break block16;
                        throw new AssertionError((Object)"IOException via StringReader");
                    }
                }
                throw throwable;
            }
            try {
                rdr.close();
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block15;
                throw new AssertionError((Object)"IOException via StringReader");
            }
        }
        this.storeMessage(threadId, message.toString());
    }

    private void storeMessage(Integer threadId, String message) {
        block3: {
            BufferedWriter out = this.getThreadWriter(threadId);
            try {
                if (this.verbose) {
                    long t = System.currentTimeMillis() - this.scriptStartTime;
                    out.write("at " + t + ": ");
                }
                out.write(message);
                out.newLine();
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)"IOException on StringWriter");
            }
        }
    }

    public static void main(String[] args) {
        int status = new Tool().run(args);
        System.exit(status);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CommandParser {
        final Pattern splitWords = Pattern.compile("\\s+");
        final Pattern splitBinding = Pattern.compile("=");
        final Pattern matchesVarDefn = Pattern.compile("([A-Za-z]\\w*) *=(.*)$");
        private String state = "pre-setup";
        private int threadId = 1;
        private int nextThreadId = 1;
        private int order = 1;
        private int repeatCount = 0;
        private boolean scriptHasVars = false;
        private Stack<File> currentDirectory = new Stack();
        private List<Binding> deferredBindings = new ArrayList<Binding>();

        public CommandParser() {
            this.currentDirectory.push(null);
        }

        public void rememberVariableRebindings(List<String> pairs) {
            if (pairs == null) {
                return;
            }
            for (String pair : pairs) {
                this.deferredBindings.add(new Binding(pair));
            }
        }

        private void applyVariableRebindings() {
            for (Binding binding : this.deferredBindings) {
                ConcurrentTestCommandScript.this.vars.set(binding.var, binding.val);
            }
        }

        private void trace(String prefix, Object message) {
            if (ConcurrentTestCommandScript.this.verbose && !ConcurrentTestCommandScript.this.quiet) {
                if (prefix != null) {
                    System.out.print(String.valueOf(prefix) + ": ");
                }
                System.out.println(message);
            }
        }

        private void trace(String message) {
            this.trace(null, message);
        }

        private void load(String scriptFileName) throws IOException {
            File scriptFile = new File(this.currentDirectory.peek(), scriptFileName);
            File file = scriptFile.getParentFile();
            ConcurrentTestCommandScript.this.scriptDirectory = file;
            this.currentDirectory.push(file);
            BufferedReader in = new BufferedReader(new FileReader(scriptFile));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    boolean changeState;
                    line = line.trim();
                    Map<String, String> commandStateMap = this.lookupState(this.state);
                    String command = null;
                    boolean isSql = false;
                    if (line.equals(ConcurrentTestCommandScript.SQL) || line.startsWith("--")) continue;
                    if (line.startsWith("@")) {
                        command = this.firstWord(line);
                    } else {
                        isSql = true;
                        command = ConcurrentTestCommandScript.SQL;
                    }
                    if (!commandStateMap.containsKey(command)) {
                        throw new IllegalStateException(String.valueOf(command) + " not allowed in state " + this.state);
                    }
                    if (isSql) {
                        String sql = this.readSql(line, in);
                        this.loadSql(sql);
                        changeState = true;
                    } else {
                        changeState = this.loadCommand(command, line, in);
                    }
                    if (!changeState) continue;
                    String nextState = commandStateMap.get(command);
                    assert (nextState != null);
                    if (!nextState.equals(this.state)) {
                        this.doEndOfState(this.state);
                    }
                    this.state = nextState;
                }
                this.currentDirectory.pop();
                if (this.currentDirectory.size() == 1 && !this.lookupState(this.state).containsKey(EOF)) {
                    throw new IllegalStateException("Premature end of file in '" + this.state + "' state");
                }
            }
            finally {
                in.close();
            }
        }

        private void loadSql(String sql) {
            if (ConcurrentTestCommandScript.SETUP_STATE.equals(this.state)) {
                this.trace(ConcurrentTestCommandScript.SETUP, sql);
                ConcurrentTestCommandScript.this.setupCommands.add(sql);
            } else if (ConcurrentTestCommandScript.CLEANUP_STATE.equals(this.state)) {
                this.trace(ConcurrentTestCommandScript.CLEANUP, sql);
                ConcurrentTestCommandScript.this.cleanupCommands.add(sql);
            } else if (ConcurrentTestCommandScript.THREAD_STATE.equals(this.state) || ConcurrentTestCommandScript.REPEAT_STATE.equals(this.state)) {
                boolean isSelect = ConcurrentTestCommandScript.this.isSelect(sql);
                this.trace(sql);
                int i = this.threadId;
                while (i < this.nextThreadId) {
                    CommandWithTimeout cmd = isSelect ? new SelectCommand(sql) : new SqlCommand(sql);
                    ConcurrentTestCommandScript.this.addCommand(i, this.order, cmd);
                    ++i;
                }
                ++this.order;
            } else assert (false);
        }

        private boolean loadCommand(String command, String line, BufferedReader in) throws IOException {
            if (ConcurrentTestCommandScript.VAR.equals(command)) {
                String args = line.substring(VAR_LEN).trim();
                this.scriptHasVars = true;
                this.trace(ConcurrentTestCommandScript.VAR, args);
                this.defineVariables(args);
            } else if (ConcurrentTestCommandScript.LOCKSTEP.equals(command)) {
                assert (ConcurrentTestCommandScript.this.lockstep == null) : "@lockstep and @nolockstep may only appear once";
                ConcurrentTestCommandScript.this.lockstep = Boolean.TRUE;
                this.trace("lockstep");
            } else if (ConcurrentTestCommandScript.NOLOCKSTEP.equals(command)) {
                assert (ConcurrentTestCommandScript.this.lockstep == null) : "@lockstep and @nolockstep may only appear once";
                ConcurrentTestCommandScript.this.lockstep = Boolean.FALSE;
                this.trace("no lockstep");
            } else if (ConcurrentTestCommandScript.DISABLED.equals(command)) {
                assert (ConcurrentTestCommandScript.this.disabled == null) : "@disabled and @enabled may only appear once";
                ConcurrentTestCommandScript.this.disabled = Boolean.TRUE;
                this.trace("disabled");
            } else if (ConcurrentTestCommandScript.ENABLED.equals(command)) {
                assert (ConcurrentTestCommandScript.this.disabled == null) : "@disabled and @enabled may only appear once";
                ConcurrentTestCommandScript.this.disabled = Boolean.FALSE;
                this.trace("enabled");
            } else if (ConcurrentTestCommandScript.SETUP.equals(command)) {
                this.trace(ConcurrentTestCommandScript.SETUP);
            } else if (ConcurrentTestCommandScript.CLEANUP.equals(command)) {
                this.trace(ConcurrentTestCommandScript.CLEANUP);
            } else if (ConcurrentTestCommandScript.INCLUDE.equals(command)) {
                String includedFile = ConcurrentTestCommandScript.this.vars.expand(line.substring(INCLUDE_LEN).trim());
                this.trace(ConcurrentTestCommandScript.INCLUDE, includedFile);
                this.load(includedFile);
                this.trace("end @include", includedFile);
            } else if (ConcurrentTestCommandScript.THREAD.equals(command)) {
                String threadNamesStr = line.substring(THREAD_LEN).trim();
                this.trace(ConcurrentTestCommandScript.THREAD, threadNamesStr);
                StringTokenizer threadNamesTok = new StringTokenizer(threadNamesStr, ",");
                while (threadNamesTok.hasMoreTokens()) {
                    ConcurrentTestCommandScript.this.setThreadName(this.nextThreadId++, threadNamesTok.nextToken());
                }
            } else if (ConcurrentTestCommandScript.REPEAT.equals(command)) {
                String arg = line.substring(REPEAT_LEN).trim();
                this.repeatCount = Integer.parseInt(ConcurrentTestCommandScript.this.vars.expand(arg));
                this.trace("start @repeat block", this.repeatCount);
                assert (this.repeatCount > 0) : "Repeat count must be > 0";
                in.mark(65536);
            } else if (ConcurrentTestCommandScript.END.equals(command)) {
                if (ConcurrentTestCommandScript.SETUP_STATE.equals(this.state)) {
                    this.trace("end @setup");
                } else if (ConcurrentTestCommandScript.CLEANUP_STATE.equals(this.state)) {
                    this.trace("end @cleanup");
                } else if (ConcurrentTestCommandScript.THREAD_STATE.equals(this.state)) {
                    this.threadId = this.nextThreadId;
                } else if (ConcurrentTestCommandScript.REPEAT_STATE.equals(this.state)) {
                    this.trace("repeating");
                    --this.repeatCount;
                    if (this.repeatCount > 0) {
                        try {
                            in.reset();
                        }
                        catch (IOException e) {
                            throw new IllegalStateException("Unable to reset reader -- repeat contents must be less than 65536 bytes");
                        }
                        this.trace("end @repeat block");
                        return false;
                    }
                } else assert (false);
            } else if (ConcurrentTestCommandScript.SYNC.equals(command)) {
                this.trace(ConcurrentTestCommandScript.SYNC);
                int i = this.threadId;
                while (i < this.nextThreadId) {
                    ConcurrentTestCommandScript.this.addSynchronizationCommand(i, this.order);
                    ++i;
                }
                ++this.order;
            } else if (ConcurrentTestCommandScript.TIMEOUT.equals(command)) {
                String args = line.substring(TIMEOUT_LEN).trim();
                String millisStr = ConcurrentTestCommandScript.this.vars.expand(this.firstWord(args));
                long millis = Long.parseLong(millisStr);
                assert (millis >= 0L) : "Timeout must be >= 0";
                String sql = this.readSql(this.skipFirstWord(args).trim(), in);
                this.trace(ConcurrentTestCommandScript.TIMEOUT, sql);
                boolean isSelect = ConcurrentTestCommandScript.this.isSelect(sql);
                int i = this.threadId;
                while (i < this.nextThreadId) {
                    CommandWithTimeout cmd = isSelect ? new SelectCommand(sql, millis) : new SqlCommand(sql, millis);
                    ConcurrentTestCommandScript.this.addCommand(i, this.order, cmd);
                    ++i;
                }
                ++this.order;
            } else if (ConcurrentTestCommandScript.ROWLIMIT.equals(command)) {
                String args = line.substring(ROWLIMIT_LEN).trim();
                String limitStr = ConcurrentTestCommandScript.this.vars.expand(this.firstWord(args));
                int limit = Integer.parseInt(limitStr);
                assert (limit >= 0) : "Rowlimit must be >= 0";
                String sql = this.readSql(this.skipFirstWord(args).trim(), in);
                this.trace("@rowlimit ", sql);
                boolean isSelect = ConcurrentTestCommandScript.this.isSelect(sql);
                if (!isSelect) {
                    throw new IllegalStateException("Only select can be used with rowlimit");
                }
                int i = this.threadId;
                while (i < this.nextThreadId) {
                    ConcurrentTestCommandScript.this.addCommand(i, this.order, new SelectCommand(sql, 0L, limit));
                    ++i;
                }
                ++this.order;
            } else if (ConcurrentTestCommandScript.PRINT.equals(command)) {
                String spec = ConcurrentTestCommandScript.this.vars.expand(line.substring(PRINT_LEN).trim());
                this.trace(ConcurrentTestCommandScript.PRINT, spec);
                int i = this.threadId;
                while (i < this.nextThreadId) {
                    ConcurrentTestCommandScript.this.addCommand(i, this.order, new PrintCommand(ConcurrentTestCommandScript.this, spec));
                    ++i;
                }
                ++this.order;
            } else if (ConcurrentTestCommandScript.PREPARE.equals(command)) {
                String startOfSql = line.substring(PREPARE_LEN).trim();
                String sql = this.readSql(startOfSql, in);
                this.trace(ConcurrentTestCommandScript.PREPARE, sql);
                int i = this.threadId;
                while (i < this.nextThreadId) {
                    ConcurrentTestCommandScript.this.addCommand(i, this.order, new PrepareCommand(sql));
                    ++i;
                }
                ++this.order;
            } else if (ConcurrentTestCommandScript.PLUGIN.equals(command)) {
                String cmd = line.substring(PLUGIN_LEN).trim();
                String pluginName = this.readLine(cmd, in).trim();
                this.trace(ConcurrentTestCommandScript.PLUGIN, pluginName);
                this.plugin(pluginName);
            } else if (ConcurrentTestCommandScript.this.pluginForCommand.containsKey(command)) {
                String cmd = line.substring(command.length()).trim();
                cmd = this.readLine(cmd, in);
                this.trace("@" + command, cmd);
                int i = this.threadId;
                while (i < this.nextThreadId) {
                    ConcurrentTestCommandScript.this.addCommand(i, this.order, new PluginCommand(command, cmd));
                    ++i;
                }
                ++this.order;
            } else if (ConcurrentTestCommandScript.this.preSetupPluginForCommand.containsKey(command)) {
                String cmd = line.substring(command.length()).trim();
                cmd = this.readLine(cmd, in);
                this.trace("@" + command, cmd);
                ConcurrentTestPlugin plugin = (ConcurrentTestPlugin)ConcurrentTestCommandScript.this.preSetupPluginForCommand.get(command);
                plugin.preSetupFor(command, cmd);
            } else if (ConcurrentTestCommandScript.SHELL.equals(command)) {
                String cmd = line.substring(SHELL_LEN).trim();
                cmd = this.readLine(cmd, in);
                this.trace(ConcurrentTestCommandScript.SHELL, cmd);
                int i = this.threadId;
                while (i < this.nextThreadId) {
                    ConcurrentTestCommandScript.this.addCommand(i, this.order, new ShellCommand(cmd));
                    ++i;
                }
                ++this.order;
            } else if (ConcurrentTestCommandScript.ECHO.equals(command)) {
                String msg = line.substring(ECHO_LEN).trim();
                msg = this.readLine(msg, in);
                this.trace(ConcurrentTestCommandScript.ECHO, msg);
                int i = this.threadId;
                while (i < this.nextThreadId) {
                    ConcurrentTestCommandScript.this.addCommand(i, this.order, new EchoCommand(msg));
                    ++i;
                }
                ++this.order;
            } else if (ConcurrentTestCommandScript.ERR.equals(command)) {
                String startOfSql = line.substring(ERR_LEN).trim();
                String sql = this.readSql(startOfSql, in);
                this.trace("@err ", sql);
                boolean isSelect = ConcurrentTestCommandScript.this.isSelect(sql);
                int i = this.threadId;
                while (i < this.nextThreadId) {
                    CommandWithTimeout cmd = isSelect ? new SelectCommand(sql, true) : new SqlCommand(sql, true);
                    ConcurrentTestCommandScript.this.addCommand(i, this.order, cmd);
                    ++i;
                }
                ++this.order;
            } else if (ConcurrentTestCommandScript.FETCH.equals(command)) {
                String arg = ConcurrentTestCommandScript.this.vars.expand(line.substring(FETCH_LEN).trim());
                this.trace(ConcurrentTestCommandScript.FETCH, arg);
                long millis = 0L;
                if (arg.length() > 0) {
                    millis = Long.parseLong(arg);
                    assert (millis >= 0L) : "Fetch timeout must be >= 0";
                }
                int i = this.threadId;
                while (i < this.nextThreadId) {
                    ConcurrentTestCommandScript.this.addCommand(i, this.order, new FetchAndPrintCommand(millis));
                    ++i;
                }
                ++this.order;
            } else if (ConcurrentTestCommandScript.CLOSE.equals(command)) {
                this.trace(ConcurrentTestCommandScript.CLOSE);
                int i = this.threadId;
                while (i < this.nextThreadId) {
                    ConcurrentTestCommandScript.this.addCloseCommand(i, this.order);
                    ++i;
                }
                ++this.order;
            } else if (ConcurrentTestCommandScript.SLEEP.equals(command)) {
                String arg = ConcurrentTestCommandScript.this.vars.expand(line.substring(SLEEP_LEN).trim());
                this.trace(ConcurrentTestCommandScript.SLEEP, arg);
                long millis = Long.parseLong(arg);
                assert (millis >= 0L) : "Sleep timeout must be >= 0";
                int i = this.threadId;
                while (i < this.nextThreadId) {
                    ConcurrentTestCommandScript.this.addSleepCommand(i, this.order, millis);
                    ++i;
                }
                ++this.order;
            } else assert (false) : "Unknown command " + command;
            return true;
        }

        private void doEndOfState(String state) {
            if (state.equals(ConcurrentTestCommandScript.PRE_SETUP_STATE)) {
                this.applyVariableRebindings();
            }
        }

        private void defineVariables(String line) {
            Matcher varDefn = this.matchesVarDefn.matcher(line);
            if (varDefn.lookingAt()) {
                String var = varDefn.group(1);
                String val = varDefn.group(2);
                ConcurrentTestCommandScript.this.vars.define(var, val);
            } else {
                String[] words;
                String[] stringArray = words = this.splitWords.split(line);
                int n = words.length;
                int n2 = 0;
                while (n2 < n) {
                    String var = stringArray[n2];
                    String value = System.getenv(var);
                    ConcurrentTestCommandScript.this.vars.define(var, value);
                    ++n2;
                }
            }
        }

        private void plugin(String pluginName) throws IOException {
            try {
                Class<?> pluginClass = Class.forName(pluginName);
                ConcurrentTestPlugin plugin = (ConcurrentTestPlugin)pluginClass.newInstance();
                ConcurrentTestCommandScript.this.plugins.add(plugin);
                this.addExtraCommands(plugin.getSupportedThreadCommands(), ConcurrentTestCommandScript.THREAD_STATE);
                this.addExtraCommands(plugin.getSupportedThreadCommands(), ConcurrentTestCommandScript.REPEAT_STATE);
                for (String commandName : plugin.getSupportedThreadCommands()) {
                    ConcurrentTestCommandScript.this.pluginForCommand.put(commandName, plugin);
                }
                this.addExtraCommands(plugin.getSupportedPreSetupCommands(), ConcurrentTestCommandScript.PRE_SETUP_STATE);
                for (String commandName : plugin.getSupportedPreSetupCommands()) {
                    ConcurrentTestCommandScript.this.preSetupPluginForCommand.put(commandName, plugin);
                }
            }
            catch (Exception e) {
                throw new IOException(e.toString());
            }
        }

        private void addExtraCommands(Iterable<String> commands, String state) {
            assert (state != null);
            int i = 0;
            int n = STATE_TABLE.length;
            while (i < n) {
                if (state.equals(STATE_TABLE[i].state)) {
                    StateDatum[] stateData = STATE_TABLE[i].stateData;
                    ArrayList<StateDatum> stateDataList = new ArrayList<StateDatum>(Arrays.asList(stateData));
                    for (String cmd : commands) {
                        stateDataList.add(new StateDatum(cmd, state));
                    }
                    STATE_TABLE[i] = new StateAction(state, stateDataList.toArray(stateData));
                }
                ++i;
            }
        }

        private Map<String, String> lookupState(String state) {
            assert (state != null);
            int i = 0;
            int n = STATE_TABLE.length;
            while (i < n) {
                if (state.equals(STATE_TABLE[i].state)) {
                    StateDatum[] stateData = STATE_TABLE[i].stateData;
                    HashMap<String, String> result = new HashMap<String, String>();
                    int j = 0;
                    int m = stateData.length;
                    while (j < m) {
                        result.put(stateData[j].x, stateData[j].y);
                        ++j;
                    }
                    return result;
                }
                ++i;
            }
            throw new IllegalArgumentException();
        }

        private String firstWord(String trimmedLine) {
            return trimmedLine.replaceFirst("\\s.*", ConcurrentTestCommandScript.SQL);
        }

        private String skipFirstWord(String trimmedLine) {
            return trimmedLine.replaceFirst("^\\S+\\s+", ConcurrentTestCommandScript.SQL);
        }

        private String readLine(String line, BufferedReader in) throws IOException {
            boolean more = (line = line.trim()).endsWith("\\");
            if (more) {
                line = line.substring(0, line.lastIndexOf(92));
                StringBuffer buf = new StringBuffer(line);
                while (more) {
                    line = in.readLine();
                    if (line == null) break;
                    more = (line = line.trim()).endsWith("\\");
                    if (more) {
                        line = line.substring(0, line.lastIndexOf(92));
                    }
                    buf.append(' ').append(line);
                }
                line = buf.toString().trim();
            }
            if (this.scriptHasVars && line.contains("$")) {
                line = ConcurrentTestCommandScript.this.vars.expand(line);
            }
            return line;
        }

        private String readSql(String startOfSql, BufferedReader in) throws IOException {
            String line;
            StringBuffer sql = new StringBuffer(startOfSql);
            sql.append('\n');
            if (!startOfSql.trim().endsWith(";")) {
                while ((line = in.readLine()) != null) {
                    sql.append(line).append('\n');
                    if (line.trim().endsWith(";")) break;
                }
            }
            line = sql.toString().trim();
            if (this.scriptHasVars && line.contains("$")) {
                line = ConcurrentTestCommandScript.this.vars.expand(line);
            }
            return line;
        }

        private class Binding {
            public final String var;
            public final String val;

            public Binding(String var, String val) {
                this.var = var;
                this.val = val;
            }

            public Binding(String phrase) {
                String[] parts = CommandParser.this.splitBinding.split(phrase);
                assert (parts.length == 2);
                this.var = parts[0];
                this.val = parts[1];
            }
        }
    }

    private static abstract class CommandWithTimeout
    extends ConcurrentTestCommandGenerator.AbstractCommand {
        private long timeout;

        private CommandWithTimeout(long timeout) {
            this.timeout = timeout;
        }

        protected long setTimeout(Statement stmt) throws SQLException {
            assert (this.timeout >= 0L);
            if (this.timeout > 0L) {
                assert (this.timeout >= 1000L) : "timeout too short";
                int t = (int)(this.timeout / 1000L);
                stmt.setQueryTimeout(t);
                return t;
            }
            return -1L;
        }
    }

    private static abstract class CommandWithTimeoutAndRowLimit
    extends CommandWithTimeout {
        private int rowLimit;

        private CommandWithTimeoutAndRowLimit(long timeout) {
            this(timeout, 0);
        }

        private CommandWithTimeoutAndRowLimit(long timeout, int rowLimit) {
            super(timeout);
            this.rowLimit = rowLimit;
        }

        protected void setRowLimit(Statement stmt) throws SQLException {
            assert (this.rowLimit >= 0);
            if (this.rowLimit > 0) {
                stmt.setMaxRows(this.rowLimit);
            }
        }
    }

    private class EchoCommand
    extends ConcurrentTestCommandGenerator.AbstractCommand {
        private final String msg;

        private EchoCommand(String msg) {
            this.msg = msg;
        }

        protected void doExecute(ConcurrentTestCommandExecutor executor) throws SQLException {
            ConcurrentTestCommandScript.this.storeMessage(executor.getThreadId(), this.msg);
        }
    }

    private class FetchAndPrintCommand
    extends CommandWithTimeout {
        private FetchAndPrintCommand(long timeout) {
            super(timeout);
        }

        protected void doExecute(ConcurrentTestCommandExecutor executor) throws SQLException {
            PreparedStatement stmt = (PreparedStatement)executor.getStatement();
            long timeout = this.setTimeout(stmt);
            ConcurrentTestCommandScript.this.storeResults(executor.getThreadId(), stmt.executeQuery(), timeout);
        }
    }

    private class PluginCommand
    extends ConcurrentTestCommandGenerator.AbstractCommand {
        private final ConcurrentTestPluginCommand pluginCommand;

        private PluginCommand(String command, String params) throws IOException {
            ConcurrentTestPlugin plugin = (ConcurrentTestPlugin)ConcurrentTestCommandScript.this.pluginForCommand.get(command);
            this.pluginCommand = plugin.getCommandFor(command, params);
        }

        protected void doExecute(final ConcurrentTestCommandExecutor exec) throws Exception {
            ConcurrentTestPluginCommand.TestContext context = new ConcurrentTestPluginCommand.TestContext(){

                public void storeMessage(String message) {
                    ConcurrentTestCommandScript.this.storeMessage(exec.getThreadId(), message);
                }

                public Connection getConnection() {
                    return exec.getConnection();
                }

                public Statement getCurrentStatement() {
                    return exec.getStatement();
                }
            };
            this.pluginCommand.execute(context);
        }
    }

    private class PrepareCommand
    extends ConcurrentTestCommandGenerator.AbstractCommand {
        private String sql;

        private PrepareCommand(String sql) {
            this.sql = sql;
        }

        protected void doExecute(ConcurrentTestCommandExecutor executor) throws SQLException {
            String properSql = this.sql.trim();
            ConcurrentTestCommandScript.this.storeSql(executor.getThreadId(), properSql);
            if (properSql.endsWith(";")) {
                properSql = properSql.substring(0, properSql.length() - 1);
            }
            PreparedStatement stmt = executor.getConnection().prepareStatement(properSql);
            executor.setStatement(stmt);
        }
    }

    /*
     * Exception performing whole class analysis.
     */
    private class PrintCommand
    extends ConcurrentTestCommandGenerator.AbstractCommand {
        private final int nth;
        private final boolean count;
        private final boolean time;
        private final boolean total;
        final /* synthetic */ ConcurrentTestCommandScript this$0;

        /*
         * Unable to fully structure code
         */
        PrintCommand(ConcurrentTestCommandScript var1_1, String spec) {
            block6: {
                this.this$0 = var1_1;
                super();
                nth = 0;
                count = false;
                time = false;
                total = false;
                tokenizer = new StringTokenizer(spec);
                if (tokenizer.countTokens() != 0) ** GOTO lbl32
                nth = 1;
                break block6;
lbl-1000:
                // 1 sources

                {
                    token = tokenizer.nextToken();
                    if (token.equalsIgnoreCase("none")) {
                        nth = 0;
                        continue;
                    }
                    if (token.equalsIgnoreCase("all")) {
                        nth = 1;
                        continue;
                    }
                    if (token.equalsIgnoreCase("total")) {
                        total = true;
                        continue;
                    }
                    if (token.equalsIgnoreCase("count")) {
                        count = true;
                        continue;
                    }
                    if (token.equalsIgnoreCase("time")) {
                        time = true;
                        continue;
                    }
                    if (!token.equalsIgnoreCase("every")) continue;
                    nth = 1;
                    if (!tokenizer.hasMoreTokens()) continue;
                    token = tokenizer.nextToken();
                    nth = Integer.parseInt(token);
lbl32:
                    // 9 sources

                    ** while (tokenizer.hasMoreTokens())
                }
            }
            this.nth = nth;
            this.count = count;
            this.time = time;
            this.total = total;
        }

        protected void doExecute(ConcurrentTestCommandExecutor executor) throws SQLException {
            Integer threadId = executor.getThreadId();
            BufferedWriter out = (BufferedWriter)this.this$0.threadBufferedWriters.get(threadId);
            this.this$0.threadResultsReaders.put(threadId, this.this$0.new ResultsReader(out, this.nth, this.count, this.time, this.total));
        }
    }

    private class ResultsReader {
        private final PrintWriter out;
        private final int nth;
        private final boolean counted;
        private final boolean timestamped;
        private final boolean totaled;
        private long baseTime = 0L;
        private int rowCount = 0;
        private int ncols = 0;
        private int[] widths;
        private String[] labels;

        ResultsReader(BufferedWriter out) {
            this(out, 1, false, false, false);
        }

        ResultsReader(BufferedWriter out, int nth, boolean counted, boolean timestamped, boolean totaled) {
            this.out = new PrintWriter(out);
            this.nth = nth;
            this.counted = counted;
            this.timestamped = timestamped;
            this.totaled = totaled;
            this.baseTime = ConcurrentTestCommandScript.this.scriptStartTime;
        }

        void prepareFormat(ResultSet rset) throws SQLException {
            ResultSetMetaData meta = rset.getMetaData();
            this.ncols = meta.getColumnCount();
            this.widths = new int[this.ncols];
            this.labels = new String[this.ncols];
            int i = 0;
            while (i < this.ncols) {
                this.labels[i] = meta.getColumnLabel(i + 1);
                int displaySize = meta.getColumnDisplaySize(i + 1);
                if (displaySize > 4096) {
                    displaySize = 0;
                }
                this.widths[i] = Math.max(this.labels[i].length(), displaySize);
                ++i;
            }
        }

        private void printHeaders() {
            this.printSeparator();
            this.indent();
            this.printRow(this.labels);
            this.printSeparator();
        }

        /*
         * Loose catch block
         */
        void read(ResultSet rset, long timeout) throws SQLException {
            block41: {
                long endTime;
                long startTime;
                boolean timedOut;
                boolean withTimeout;
                block43: {
                    withTimeout = timeout >= 0L;
                    timedOut = false;
                    startTime = 0L;
                    endTime = 0L;
                    try {
                        this.prepareFormat(rset);
                        String[] values = new String[this.ncols];
                        int printedRowCount = 0;
                        if (this.nth > 0) {
                            this.printHeaders();
                        }
                        startTime = System.currentTimeMillis();
                        this.rowCount = 0;
                        while (rset.next()) {
                            if (this.nth != 0 && (this.nth == 1 || this.rowCount % this.nth == 0)) {
                                long time = System.currentTimeMillis();
                                if (printedRowCount > 0 && printedRowCount % 100 == 0) {
                                    this.printHeaders();
                                }
                                int i = 0;
                                while (i < this.ncols) {
                                    values[i] = rset.getString(i + 1);
                                    ++i;
                                }
                                if (this.counted) {
                                    this.printRowCount(this.rowCount);
                                }
                                if (this.timestamped) {
                                    this.printTimestamp(time);
                                }
                                this.printRow(values);
                                ++printedRowCount;
                            }
                            ++this.rowCount;
                        }
                    }
                    catch (SqlTimeoutException e) {
                        endTime = System.currentTimeMillis();
                        timedOut = true;
                        if (!withTimeout) {
                            throw e;
                        }
                        Util.swallow((Throwable)e, null);
                        if (endTime == 0L) {
                            endTime = System.currentTimeMillis();
                        }
                        rset.close();
                        if (this.nth > 0) {
                            this.printSeparator();
                            this.out.println();
                        }
                        if (ConcurrentTestCommandScript.this.verbose) {
                            this.out.printf("fetch started at %tc %d, %s at %tc %d%n", startTime, startTime, timedOut ? "timeout" : "eos", endTime, endTime);
                        }
                        if (this.totaled) {
                            long dt = endTime - startTime;
                            if (withTimeout) {
                                dt -= timeout;
                            }
                            assert (dt >= 0L);
                            this.out.printf("fetched %d rows in %d msecs %s%n", this.rowCount, dt, timedOut ? "(timeout)" : "(end)");
                        }
                        break block41;
                    }
                    catch (SQLException e) {
                        block42: {
                            endTime = System.currentTimeMillis();
                            timedOut = true;
                            String eClassName = e.getClass().getName();
                            if (eClassName.endsWith("TimeoutException")) {
                                if (!withTimeout) {
                                    throw e;
                                }
                                Util.swallow((Throwable)e, null);
                            } else {
                                Util.swallow((Throwable)e, null);
                                this.out.println(e.getMessage());
                            }
                            if (endTime != 0L) break block42;
                            endTime = System.currentTimeMillis();
                        }
                        rset.close();
                        if (this.nth > 0) {
                            this.printSeparator();
                            this.out.println();
                        }
                        if (ConcurrentTestCommandScript.this.verbose) {
                            this.out.printf("fetch started at %tc %d, %s at %tc %d%n", startTime, startTime, timedOut ? "timeout" : "eos", endTime, endTime);
                        }
                        if (this.totaled) {
                            long dt = endTime - startTime;
                            if (withTimeout) {
                                dt -= timeout;
                            }
                            assert (dt >= 0L);
                            this.out.printf("fetched %d rows in %d msecs %s%n", this.rowCount, dt, timedOut ? "(timeout)" : "(end)");
                        }
                        break block41;
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                        throw e;
                        {
                            catch (Throwable throwable) {
                                if (endTime == 0L) {
                                    endTime = System.currentTimeMillis();
                                }
                                rset.close();
                                if (this.nth > 0) {
                                    this.printSeparator();
                                    this.out.println();
                                }
                                if (ConcurrentTestCommandScript.this.verbose) {
                                    this.out.printf("fetch started at %tc %d, %s at %tc %d%n", startTime, startTime, timedOut ? "timeout" : "eos", endTime, endTime);
                                }
                                if (this.totaled) {
                                    long dt = endTime - startTime;
                                    if (withTimeout) {
                                        dt -= timeout;
                                    }
                                    assert (dt >= 0L);
                                    this.out.printf("fetched %d rows in %d msecs %s%n", this.rowCount, dt, timedOut ? "(timeout)" : "(end)");
                                }
                                throw throwable;
                            }
                        }
                    }
                    if (endTime != 0L) break block43;
                    endTime = System.currentTimeMillis();
                }
                rset.close();
                if (this.nth > 0) {
                    this.printSeparator();
                    this.out.println();
                }
                if (ConcurrentTestCommandScript.this.verbose) {
                    this.out.printf("fetch started at %tc %d, %s at %tc %d%n", startTime, startTime, timedOut ? "timeout" : "eos", endTime, endTime);
                }
                if (this.totaled) {
                    long dt = endTime - startTime;
                    if (withTimeout) {
                        dt -= timeout;
                    }
                    assert (dt >= 0L);
                    this.out.printf("fetched %d rows in %d msecs %s%n", this.rowCount, dt, timedOut ? "(timeout)" : "(end)");
                }
            }
        }

        private void printRowCount(int count) {
            this.out.printf("(%06d) ", count);
        }

        private void printTimestamp(long time) {
            this.out.printf("(% 4d.%03d) ", (time -= this.baseTime) / 1000L, time % 1000L);
        }

        private void indent() {
            if (this.counted) {
                this.out.print("         ");
            }
            if (this.timestamped) {
                this.out.print("           ");
            }
        }

        private void printSeparator() {
            this.indent();
            int i = 0;
            while (i < this.widths.length) {
                if (i > 0) {
                    this.out.write("-+-");
                } else {
                    this.out.write("+-");
                }
                int numDashes = this.widths[i];
                while (numDashes > 0) {
                    this.out.write(DASHES, 0, Math.min(numDashes, 1024));
                    numDashes -= Math.min(numDashes, 1024);
                }
                ++i;
            }
            this.out.println("-+");
        }

        private void printRow(String[] values) {
            int i = 0;
            while (i < values.length) {
                String value = values[i];
                if (value == null) {
                    value = ConcurrentTestCommandScript.SQL;
                }
                if (i > 0) {
                    this.out.write(" | ");
                } else {
                    this.out.write("| ");
                }
                this.out.write(value);
                int excess = this.widths[i] - value.length();
                while (excess > 0) {
                    this.out.write(SPACES, 0, Math.min(excess, 1024));
                    excess -= Math.min(excess, 1024);
                }
                ++i;
            }
            this.out.println(" |");
        }
    }

    private class SelectCommand
    extends CommandWithTimeoutAndRowLimit {
        private String sql;

        private SelectCommand(String sql) {
            this(sql, 0L, 0);
        }

        private SelectCommand(String sql, boolean errorExpected) {
            this(sql, 0L, 0);
            if (errorExpected) {
                this.markToFail();
            }
        }

        private SelectCommand(String sql, long timeout) {
            this(sql, timeout, 0);
        }

        private SelectCommand(String sql, long timeout, int rowLimit) {
            super(timeout, rowLimit);
            this.sql = sql;
        }

        protected void doExecute(ConcurrentTestCommandExecutor executor) throws SQLException {
            String properSql = this.sql.trim();
            ConcurrentTestCommandScript.this.storeSql(executor.getThreadId(), properSql);
            if (properSql.endsWith(";")) {
                properSql = properSql.substring(0, properSql.length() - 1);
            }
            PreparedStatement stmt = executor.getConnection().prepareStatement(properSql);
            long timeout = this.setTimeout(stmt);
            this.setRowLimit(stmt);
            try {
                ConcurrentTestCommandScript.this.storeResults(executor.getThreadId(), stmt.executeQuery(), timeout);
            }
            finally {
                stmt.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ShellCommand
    extends ConcurrentTestCommandGenerator.AbstractCommand {
        private final String command;
        private List<String> argv;

        private ShellCommand(String command) {
            this.command = command;
            boolean needShell = this.hasWildcard(command);
            if (needShell) {
                this.argv = new ArrayList<String>();
                this.argv.add("/bin/sh");
                this.argv.add("-c");
                this.argv.add(command);
            } else {
                this.argv = this.tokenize(command);
            }
        }

        private boolean hasWildcard(String command) {
            return ConcurrentTestCommandScript.this.shellWildcardPattern.matcher(command).find();
        }

        private List<String> tokenize(String s) {
            ArrayList<String> result = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(s);
            while (tokenizer.hasMoreTokens()) {
                result.add(tokenizer.nextToken());
            }
            return result;
        }

        @Override
        protected void doExecute(ConcurrentTestCommandExecutor executor) {
            Integer threadId = executor.getThreadId();
            ConcurrentTestCommandScript.this.storeMessage(threadId, this.command);
            ProcessBuilder pb = new ProcessBuilder(this.argv);
            pb.directory(ConcurrentTestCommandScript.this.scriptDirectory);
            try {
                int status = Util.runAppProcess((ProcessBuilder)pb, null, null, (Writer)ConcurrentTestCommandScript.this.getThreadWriter(threadId));
                if (status != 0) {
                    ConcurrentTestCommandScript.this.storeMessage(threadId, "command " + this.command + ": exited with status " + status);
                }
            }
            catch (Exception e) {
                ConcurrentTestCommandScript.this.storeMessage(threadId, "command " + this.command + ": failed with exception " + e.getMessage());
            }
        }
    }

    private class SqlCommand
    extends CommandWithTimeout {
        private String sql;

        private SqlCommand(String sql) {
            super(0L);
            this.sql = sql;
        }

        private SqlCommand(String sql, boolean errorExpected) {
            super(0L);
            this.sql = sql;
            if (errorExpected) {
                this.markToFail();
            }
        }

        private SqlCommand(String sql, long timeout) {
            super(timeout);
            this.sql = sql;
        }

        protected void doExecute(ConcurrentTestCommandExecutor executor) throws SQLException {
            block11: {
                String properSql = this.sql.trim();
                ConcurrentTestCommandScript.this.storeSql(executor.getThreadId(), properSql);
                if (properSql.endsWith(";")) {
                    properSql = properSql.substring(0, properSql.length() - 1);
                }
                if (properSql.equalsIgnoreCase("commit")) {
                    executor.getConnection().commit();
                    return;
                }
                if (properSql.equalsIgnoreCase("rollback")) {
                    executor.getConnection().rollback();
                    return;
                }
                PreparedStatement stmt = executor.getConnection().prepareStatement(properSql);
                long timeout = this.setTimeout(stmt);
                boolean timeoutSet = timeout >= 0L;
                try {
                    try {
                        boolean haveResults = stmt.execute();
                        if (haveResults) {
                            ConcurrentTestCommandScript.this.storeMessage(executor.getThreadId(), "0 rows affected.");
                            break block11;
                        }
                        int rows = stmt.getUpdateCount();
                        if (rows != 1) {
                            ConcurrentTestCommandScript.this.storeMessage(executor.getThreadId(), String.valueOf(String.valueOf(rows)) + " rows affected.");
                            break block11;
                        }
                        ConcurrentTestCommandScript.this.storeMessage(executor.getThreadId(), "1 row affected.");
                    }
                    catch (SqlTimeoutException e) {
                        if (!timeoutSet) {
                            throw e;
                        }
                        Util.swallow((Throwable)e, null);
                        ConcurrentTestCommandScript.this.storeMessage(executor.getThreadId(), "Timeout");
                        stmt.close();
                    }
                }
                finally {
                    stmt.close();
                }
            }
        }
    }

    private static class StateAction {
        final String state;
        final StateDatum[] stateData;

        StateAction(String state, StateDatum[] stateData) {
            this.state = state;
            this.stateData = stateData;
        }
    }

    private static class StateDatum {
        final String x;
        final String y;

        StateDatum(String x, String y) {
            this.x = x;
            this.y = y;
        }
    }

    private static class Tool {
        boolean quiet = false;
        boolean verbose = false;
        boolean debug = false;
        String server;
        String driver;
        String user;
        String password;
        List<String> bindings = new ArrayList<String>();
        List<String> files = new ArrayList<String>();

        public int run(String[] args) {
            block10: {
                if (this.parseCommand(args)) break block10;
                Tool.usage();
                return 2;
            }
            try {
                Class<?> z = Class.forName(this.driver);
                Properties jdbcProps = new Properties();
                if (this.user != null) {
                    jdbcProps.setProperty("user", this.user);
                }
                if (this.password != null) {
                    jdbcProps.setProperty("password", this.password);
                }
                BufferedWriter cout = new BufferedWriter(new OutputStreamWriter(System.out));
                for (String file : this.files) {
                    ConcurrentTestCommandScript script = new ConcurrentTestCommandScript();
                    try {
                        script.setQuiet(this.quiet);
                        script.setVerbose(this.verbose);
                        script.setDebug(this.debug);
                        script.prepare(file, this.bindings);
                        script.setDataSource(this.server, jdbcProps);
                        script.execute();
                    }
                    finally {
                        if (!this.quiet) {
                            script.printResults(cout);
                        }
                    }
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                return 1;
            }
            return 0;
        }

        static void usage() {
            System.err.println("Usage: mtsql [-vg] -u SERVER -d DRIVER [-n USER][-p PASSWORD] SCRIPT [SCRIPT]...");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean parseCommand(String[] args) {
            try {
                int i = 0;
                block12: while (i < args.length) {
                    String arg;
                    if ((arg = args[i++]).charAt(0) == '-') {
                        switch (arg.charAt(1)) {
                            case 'v': {
                                this.verbose = true;
                                continue block12;
                            }
                            case 'q': {
                                this.quiet = true;
                                continue block12;
                            }
                            case 'g': {
                                this.debug = true;
                                continue block12;
                            }
                            case 'u': {
                                this.server = args[i++];
                                continue block12;
                            }
                            case 'd': {
                                this.driver = args[i++];
                                continue block12;
                            }
                            case 'n': {
                                this.user = args[i++];
                                continue block12;
                            }
                            case 'p': {
                                this.password = args[i++];
                                continue block12;
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                    if (arg.contains("=")) {
                        if (!Character.isJavaIdentifierStart(arg.charAt(0))) return false;
                        this.bindings.add(arg);
                        continue;
                    }
                    this.files.add(arg);
                }
                if (this.server != null) {
                    if (this.driver != null) return true;
                }
            }
            finally {
                return false;
            }
        }
    }

    private class VariableTable {
        private final Map<String, String> map;
        private final Pattern symbolPattern = Pattern.compile("\\$((\\$)|([A-Za-z]\\w*)|\\{([A-Za-z]\\w*)\\})");

        public VariableTable() {
            this.map = new HashMap<String, String>();
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public boolean isDefined(String sym) {
            return this.map.containsKey(sym);
        }

        public void define(String sym, String val) {
            if (this.isDefined(sym)) {
                throw new Excn("second declaration of variable " + sym);
            }
            this.map.put(sym, val == null ? ConcurrentTestCommandScript.SQL : val);
        }

        public String get(String sym) {
            if (this.isDefined(sym)) {
                return this.map.get(sym);
            }
            return null;
        }

        public void set(String sym, String val) {
            if (this.isDefined(sym)) {
                this.map.put(sym, val);
                return;
            }
            throw new Excn("undeclared variable " + sym);
        }

        public String expand(String in) {
            if (in.contains("$")) {
                StringBuffer out = new StringBuffer();
                Matcher matcher = this.symbolPattern.matcher(in);
                int lastEnd = 0;
                while (matcher.find()) {
                    int start = matcher.start();
                    int end = matcher.end();
                    String val = null;
                    if (matcher.group(2) != null) {
                        val = "$";
                    } else {
                        String var = matcher.group(3);
                        if (var == null) {
                            var = matcher.group(4);
                        }
                        if (this.map.containsKey(var)) {
                            val = this.map.get(var);
                            val = this.expand(val);
                        } else {
                            val = matcher.group(0);
                        }
                    }
                    out.append(in.substring(lastEnd, start));
                    out.append(val);
                    lastEnd = end;
                }
                out.append(in.substring(lastEnd));
                return out.toString();
            }
            return in;
        }

        public class Excn
        extends IllegalArgumentException {
            public Excn(String msg) {
                super(msg);
            }
        }
    }
}

