/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eigenbase.util.Filterator;
import org.eigenbase.util.Util;
import org.junit.Assert;
import org.junit.Test;

public class FilteratorTest {
    @Test
    public void testOne() {
        List<String> tomDickHarry = Arrays.asList("tom", "dick", "harry");
        Filterator filterator = new Filterator(tomDickHarry.iterator(), String.class);
        Assert.assertTrue((boolean)filterator.hasNext());
        Assert.assertTrue((boolean)filterator.hasNext());
        Assert.assertEquals((Object)"tom", (Object)filterator.next());
        Assert.assertEquals((Object)"dick", (Object)filterator.next());
        Assert.assertTrue((boolean)filterator.hasNext());
        Assert.assertEquals((Object)"harry", (Object)filterator.next());
        Assert.assertFalse((boolean)filterator.hasNext());
        Assert.assertFalse((boolean)filterator.hasNext());
    }

    @Test
    public void testNulls() {
        List<String> tomDickHarry = Arrays.asList("paul", null, "ringo");
        Filterator filterator = new Filterator(tomDickHarry.iterator(), String.class);
        Assert.assertEquals((Object)"paul", (Object)filterator.next());
        Assert.assertEquals((Object)"ringo", (Object)filterator.next());
        Assert.assertFalse((boolean)filterator.hasNext());
    }

    @Test
    public void testSubtypes() {
        ArrayList arrayList = new ArrayList();
        HashSet hashSet = new HashSet();
        LinkedList linkedList = new LinkedList();
        Collection[] collectionArray = new Collection[5];
        collectionArray[1] = arrayList;
        collectionArray[2] = hashSet;
        collectionArray[3] = linkedList;
        Collection[] collections = collectionArray;
        Filterator filterator = new Filterator(Arrays.asList(collections).iterator(), List.class);
        Assert.assertTrue((boolean)filterator.hasNext());
        Assert.assertTrue((arrayList == filterator.next() ? 1 : 0) != 0);
        Assert.assertTrue((linkedList == filterator.next() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)filterator.hasNext());
    }

    @Test
    public void testBox() {
        Number[] numberArray = new Number[6];
        numberArray[0] = 1;
        numberArray[1] = 2;
        numberArray[2] = 3.14;
        numberArray[3] = 4;
        numberArray[5] = 6.0E23;
        Number[] numbers = numberArray;
        ArrayList<Integer> result = new ArrayList<Integer>();
        Iterator iterator = Util.filter(Arrays.asList(numbers), Integer.class).iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            result.add(i);
        }
        Assert.assertEquals((Object)"[1, 2, 4]", (Object)((Object)result).toString());
    }
}

