/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.tools;

import java.io.BufferedReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import net.hydromatic.optiq.test.OptiqAssert;
import net.hydromatic.optiq.tools.SqlRun;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlRunTest {
    @Test
    public void testBasic() {
        SqlRunTest.check("!use foodmart\nselect count(*) as c1 from \"foodmart\".\"days\";\n!ok\n!set outputformat mysql\nselect count(*) as c1 from \"foodmart\".\"days\";\n!ok\n\n", "!use foodmart\nselect count(*) as c1 from \"foodmart\".\"days\";\nC1\n7\n!ok\n!set outputformat mysql\nselect count(*) as c1 from \"foodmart\".\"days\";\n+----+\n| C1 |\n+----+\n| 7  |\n+----+\n(1 row)\n\n!ok\n\n");
    }

    @Test
    public void testError() {
        SqlRunTest.check("!use foodmart\nselect blah from blah;\n!ok\n\n", (Matcher<String>)CoreMatchers.containsString((String)"!use foodmart\nselect blah from blah;\njava.sql.SQLException: error while executing SQL \"select blah from blah\n\": From line 1, column 18 to line 1, column 21: Table 'BLAH' not found"));
    }

    static void check(String input, String expected) {
        SqlRunTest.check(input, (Matcher<String>)CoreMatchers.equalTo((Object)expected));
    }

    static void check(String input, Matcher<String> matcher) {
        StringWriter writer = new StringWriter();
        SqlRun run = new SqlRun(new BufferedReader(new StringReader(input)), (Writer)writer);
        run.execute(new SqlRun.ConnectionFactory(){

            public Connection connect(String name) throws Exception {
                if (name.equals("foodmart")) {
                    return OptiqAssert.that().with(OptiqAssert.Config.JDBC_FOODMART).connect();
                }
                throw new RuntimeException("unknown connection '" + name + "'");
            }
        });
        writer.flush();
        String out = writer.toString();
        Assert.assertThat((Object)out, matcher);
    }
}

